*                                                                                  ;
*    Reading in the 2003 PSID data                                                 ;
*                                                                                  ;
*            Karen Dynan 10/10/06                                                   ;
*                                                                                  ;
*    We read it all in and then output select variables to a flat                  ;
*    file to be picked up by STATA.                                                ;
*                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam03.raw' ;
 
PROC PRINTTO LOG='F:\PSID\logfiles\readfam03.log' NEW;
RUN;

PROC PRINTTO PRINT='F:\PSID\logfiles\readfam03.lst' NEW;
RUN; 

data one;
   ATTRIB 
      ER21001             FORMAT=1.   LABEL="RELEASE NUMBER"                          
      ER21002             FORMAT=5.   LABEL="2003 FAMILY INTERVIEW (ID) NUMBER"       
      ER21003             FORMAT=2.   LABEL="PSID STATE OF RESIDENCE CODE"            
      ER21004             FORMAT=2.   LABEL="CURRENT STATE"                           
      ER21005             FORMAT=1.   LABEL="SPLITOFF INDICATOR"                      
      ER21006             FORMAT=1.   LABEL="MODE OF INTERVIEW"                       
      ER21007             FORMAT=1.   LABEL="FAMILY COMPOSITION CHANGE"               
      ER21008             FORMAT=1.   LABEL="TYPE INSTITUTION"                        
      ER21009             FORMAT=4.   LABEL="1968 FAMILY IDENTIFIER"                  
      ER21010             FORMAT=1.   LABEL="WTR REINSTATED DROPPED FAMILY"           
      ER21011             FORMAT=8.   LABEL="INTERVIEWER ID"                          
      ER21012             FORMAT=2.   LABEL="MONTH  CURRENT IW"                       
      ER21013             FORMAT=2.   LABEL="DAY CURRENT IW"                          
      ER21014             FORMAT=4.   LABEL="YEAR CURRENT IW"                         
      ER21015             FORMAT=3.   LABEL="LENGTH OF IW IN MINUTES"                 
      ER21016             FORMAT=2.   LABEL="# IN FU"                                 
      ER21017             FORMAT=3.   LABEL="AGE OF HEAD"                             
      ER21018             FORMAT=1.   LABEL="SEX OF HEAD"                             
      ER21019             FORMAT=3.   LABEL="AGE OF WIFE"                             
      ER21020             FORMAT=2.   LABEL="# CHILDREN IN FU"                        
      ER21021             FORMAT=3.   LABEL="AGE YOUNGEST CHILD"                      
      ER21022             FORMAT=2.   LABEL="# NONFU SHARING HU"                      
      ER21023             FORMAT=1.   LABEL="HEAD MARITAL STATUS"                     
      ER21024             FORMAT=1.   LABEL="A4 TYPE DU"                              
      ER21025             FORMAT=1.   LABEL="A6 LIVE IN ELDERLY HSNG"                 
      ER21026             FORMAT=1.   LABEL="A7 TYPE ELDERLY HSNG"                    
      ER21027             FORMAT=1.   LABEL="A8 PROVIDE MED/INJECTION"                
      ER21028             FORMAT=1.   LABEL="A9 PROVIDE MEALS"                        
      ER21029             FORMAT=1.   LABEL="A10 PROVIDE CLEANING"                    
      ER21030             FORMAT=1.   LABEL="A11 PROVIDE OTR SERVICES"                
      ER21031             FORMAT=1.   LABEL="A12 XTRA SERVS MENTION 1"                
      ER21032             FORMAT=1.   LABEL="A12 XTRA SERVS MENTION 2"                
      ER21033             FORMAT=1.   LABEL="A12 XTRA SERVS MENTION 3"                
      ER21034             FORMAT=1.   LABEL="A12 XTRA SERVS MENTION 4"                
      ER21035             FORMAT=1.   LABEL="A14 SERVICES INCLUDED"                   
      ER21036             FORMAT=2.   LABEL="TYPE HEATING 1ST MENTION"                
      ER21037             FORMAT=2.   LABEL="TYPE HEATING 2ND MENTION"                
      ER21038             FORMAT=2.   LABEL="TYPE HEATING 3RD MENTION"                
      ER21039             FORMAT=2.   LABEL="A16 ACTUAL # ROOMS"                      
      ER21040             FORMAT=1.   LABEL="A17 RECD GOVT HTG SUBSDY"                
      ER21041             FORMAT=4.   LABEL="A18 AMT GOVT HTG SUBSDY"                 
      ER21042             FORMAT=1.   LABEL="A19 OWN/RENT OR WHAT"                    
      ER21043             FORMAT=7.   LABEL="A20 HOUSE VALUE"                         
      ER21044             FORMAT=1.   LABEL="ACCURACY OF HOUSE VALUE"                 
      ER21045             FORMAT=5.   LABEL="A21 ANNUAL PROPERTY TAX"                 
      ER21046             FORMAT=1.   LABEL="ACCURACY OF ANNUAL PROPERTY TAX"         
      ER21047             FORMAT=4.   LABEL="A22 ANNUAL OWNR INSURANC"                
      ER21048             FORMAT=1.   LABEL="A23 HAVE MORTGAGE?"                      
      ER21049             FORMAT=1.   LABEL="A23A TYPE MORTGAGE MOR 1"                
      ER21050             FORMAT=1.   LABEL="A23C WTR ORIGINAL LOAN/REFINANCED #1"    
      ER21051             FORMAT=7.   LABEL="A24 REM PRINCIPAL MOR 1"                 
      ER21052             FORMAT=1.   LABEL="ACCURACY OF REMAINING MORTGAGE PRIN #1"  
      ER21053             FORMAT=5.   LABEL="A25 MNTHLY PMTS MOR   1"                 
      ER21054             FORMAT=1.   LABEL="ACCURACY OF MONTHLY PYMNTS ON MTGE #1"   
      ER21055             FORMAT=2.   LABEL="A25A CURR INTEREST RATE WHOLE PERCENT #1"
      ER21056             FORMAT=3.   LABEL="A25A CURR INT RATE DECIMAL FRACTION #1"  
      ER21057             FORMAT=4.   LABEL="A26 YEAR OBTAINED LOAN #1"               
      ER21058             FORMAT=2.   LABEL="A27 YRS TO PAY MOR    1"                 
      ER21059             FORMAT=1.   LABEL="A28 2ND MORTGAGE"                        
      ER21060             FORMAT=1.   LABEL="A23A TYPE MORTGAGE MOR 2"                
      ER21061             FORMAT=1.   LABEL="A23C WTR ORIGINAL LOAN/REFINANCED #2"    
      ER21062             FORMAT=7.   LABEL="A24 REM PRINCIPAL MOR 2"                 
      ER21063             FORMAT=1.   LABEL="ACCURACY OF REMAINING MORTGAGE PRIN #2"  
      ER21064             FORMAT=5.   LABEL="A25 MNTHLY PMTS MOR   2"                 
      ER21065             FORMAT=1.   LABEL="ACCURACY OF MONTHLY PYMNTS ON MTGE #2"   
      ER21066             FORMAT=2.   LABEL="A25A CURR INTEREST RATE WHOLE PERCENT #2"
      ER21067             FORMAT=3.   LABEL="A25A CURR INT RATE DECIMAL FRACTION #2"  
      ER21068             FORMAT=4.   LABEL="A26 YEAR OBTAINED LOAN #2"               
      ER21069             FORMAT=2.   LABEL="A27 YRS TO PAY MOR    2"                 
      ER21070             FORMAT=1.   LABEL="A29 MTG INCL PROP TAXES"                 
      ER21071             FORMAT=1.   LABEL="A30 MTG INCL INS PREM"                   
      ER21072             FORMAT=5.   LABEL="A31 DOLLARS RENT"                        
      ER21073             FORMAT=1.   LABEL="A31 DOLLLARS PER WHAT"                   
      ER21074             FORMAT=1.   LABEL="ACCURACY OF RENT"                        
      ER21075             FORMAT=1.   LABEL="A32 FURNISHED APT/HOUSE"                 
      ER21076             FORMAT=1.   LABEL="A33 RENT INCL HEAT"                      
      ER21077             FORMAT=1.   LABEL="A34 IN PUBLIC OWND PROJ?"                
      ER21078             FORMAT=1.   LABEL="A35 GOVT PAY PART RENT?"                 
      ER21079             FORMAT=4.   LABEL="A37 DOLLARS RENT IF RENT"                
      ER21080             FORMAT=1.   LABEL="A37 DOLLARS PER WHAT"                    
      ER21081             FORMAT=1.   LABEL="ACCURACY OF VALUE IF RENTED"             
      ER21082             FORMAT=1.   LABEL="A38 IN PUBLIC OWND PROJ?"                
      ER21083             FORMAT=1.   LABEL="A39 GOVT PAY ALL RENT?"                  
      ER21084             FORMAT=1.   LABEL="A40 HAVE AIR CONDITNG"                   
      ER21085             FORMAT=1.   LABEL="A41 A/C ALL OR SOME ROOM"                
      ER21086             FORMAT=4.   LABEL="A42 ELECTRICITY EXPENSE"                 
      ER21087             FORMAT=1.   LABEL="A42 ELECTRICITY PER"                     
      ER21088             FORMAT=4.   LABEL="A43 HEATING EXPENSE"                     
      ER21089             FORMAT=1.   LABEL="A43 HEATING EXPENSE PER"                 
      ER21090             FORMAT=4.   LABEL="A44 WATER/SEWER EXPENSE"                 
      ER21091             FORMAT=1.   LABEL="A44 WATER/SEWER EXPENSE PER"             
      ER21092             FORMAT=1.   LABEL="A45 WTR OTR UTILITY EXP"                 
      ER21093             FORMAT=1.   LABEL="A46 CABLE EXPENSE"                       
      ER21094             FORMAT=1.   LABEL="A46 GARBAGE EXPENSE"                     
      ER21095             FORMAT=1.   LABEL="A46 PHONE EXPENSE"                       
      ER21096             FORMAT=1.   LABEL="A46 SEWER EXPENSE"                       
      ER21097             FORMAT=3.   LABEL="A47 TOTAL OTR UTILITIES"                 
      ER21098             FORMAT=1.   LABEL="A47 OTR UTILITY PER"                     
      ER21099             FORMAT=1.   LABEL="A47A WTR COMPUTER IN HOME-HD"            
      ER21100             FORMAT=1.   LABEL="A47B WTR USED INTERNET-HD"               
      ER21101             FORMAT=1.   LABEL="A47C WTR USED EMAIL-HD"                  
      ER21102             FORMAT=1.   LABEL="A47D HEALTH INFO ON NET-HD"              
      ER21103             FORMAT=1.   LABEL="A47E MANAGE FINANCES COMPUTER-HD"        
      ER21104             FORMAT=1.   LABEL="A47F WORD PROC COMPUTER-HD"              
      ER21105             FORMAT=1.   LABEL="A47G GAMES ON COMPUTER-HD"               
      ER21106             FORMAT=1.   LABEL="A47H JOB-RELATED WRK HOME-HD"            
      ER21107             FORMAT=1.   LABEL="A47I OTHER COMPUTER USE-HD"              
      ER21108             FORMAT=1.   LABEL="A47A WTR COMPUTER IN HOME-WF"            
      ER21109             FORMAT=1.   LABEL="A47B WTR USED INTERNET-WF"               
      ER21110             FORMAT=1.   LABEL="A47C WTR USED EMAIL-WF"                  
      ER21111             FORMAT=1.   LABEL="A47D HEALTH INFO ON NET-WF"              
      ER21112             FORMAT=1.   LABEL="A47E MANAGE FINANCES COMPUTER-WF"        
      ER21113             FORMAT=1.   LABEL="A47F WORD PROC COMPUTER-WF"              
      ER21114             FORMAT=1.   LABEL="A47G GAMES ON COMPUTER-WF"               
      ER21115             FORMAT=1.   LABEL="A47H JOB-RELATED WRK HOME-WF"            
      ER21116             FORMAT=1.   LABEL="A47I OTHER COMPUTER USE-WF"              
      ER21117             FORMAT=1.   LABEL="A49 WTR MOVED SINCE JAN 1 OF PRIOR YEAR" 
      ER21118             FORMAT=2.   LABEL="A49 MONTH MOVED"                         
      ER21119             FORMAT=4.   LABEL="A49 YEAR MOVED"                          
      ER21120             FORMAT=2.   LABEL="A50 WHY MOVED 1ST"                       
      ER21121             FORMAT=1.   LABEL="A51 WTR MIGHT MOVE"                      
      ER21122             FORMAT=1.   LABEL="A52 LIKELIHOOD OF MOVING"                
      ER21123             FORMAT=2.   LABEL="BC1 EMPLOYMENT STATUS-1ST MENTION"       
      ER21124             FORMAT=2.   LABEL="BC1 EMPLOYMENT STATUS-2ND MENTION"       
      ER21125             FORMAT=2.   LABEL="BC1 EMPLOYMENT STATUS-3RD MENTION"       
      ER21126             FORMAT=4.   LABEL="BC2 YEAR RETIRED (HD-R)"                 
      ER21127             FORMAT=1.   LABEL="BC3 WTR WORKED SINCE JAN 1 OF PRIOR YEAR"
      ER21128             FORMAT=1.   LABEL="BC16-17 MAIN JOB INDICATOR"              
      ER21129             FORMAT=2.   LABEL="BC6 BEGINNING MONTH--JOB 1"              
      ER21130             FORMAT=4.   LABEL="BC6 BEGINNING YEAR--JOB 1"               
      ER21131             FORMAT=2.   LABEL="BC6 ENDING MONTH--JOB 1"                 
      ER21132             FORMAT=4.   LABEL="BC6 ENDING YEAR--JOB 1"                  
      ER21133             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 JAN"             
      ER21134             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 FEB"             
      ER21135             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 MAR"             
      ER21136             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 APR"             
      ER21137             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 MAY"             
      ER21138             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 JUN"             
      ER21139             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 JUL"             
      ER21140             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 AUG"             
      ER21141             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 SEP"             
      ER21142             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 OCT"             
      ER21143             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 NOV"             
      ER21144             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 DEC"             
      ER21145             FORMAT=3.   LABEL="BC20 MAIN OCC FOR JOB 1: 2000 CODE (HD)" 
      ER21146             FORMAT=3.   LABEL="BC21 MAIN IND FOR JOB 1: 2000 CODE (HD)" 
      ER21147             FORMAT=1.   LABEL="BC22 WORK SELF/OTR?--JOB 1"              
      ER21148             FORMAT=1.   LABEL="BC23 CORP/UNCORP BUS--JOB 1"             
      ER21149             FORMAT=1.   LABEL="BC24 WORK FOR GOVT?--JOB 1"              
      ER21150             FORMAT=1.   LABEL="BC26 JOB NOW UNION? (H-E)"               
      ER21151             FORMAT=1.   LABEL="BC27 BELONG UNION? (HD-E)"               
      ER21152             FORMAT=1.   LABEL="BC29 SLRY/HRLY/OTR (H-E)"                
      ER21153             FORMAT=10.2 LABEL="BC30 SALARY AMOUNT"                      
      ER21154             FORMAT=1.   LABEL="BC30 SALARY PER WHAT"                    
      ER21155             FORMAT=1.   LABEL="BC31 WTR SAL PD OT (HD-E)"               
      ER21156             FORMAT=1.   LABEL="BC32 HOW PAID FOR OT"                    
      ER21157             FORMAT=10.2 LABEL="BC32A EXACT OT PAY IF SALARIED"          
      ER21158             FORMAT=1.   LABEL="BC32A EXACT OT PAY PER"                  
      ER21159             FORMAT=6.2  LABEL="BC33 HOURLY REGULAR RATE"                
      ER21160             FORMAT=1.   LABEL="BC34 OT DIFFERENTIAL 1ST"                
      ER21161             FORMAT=1.   LABEL="BC34 OT DIFFERENTIAL 2ND"                
      ER21162             FORMAT=1.   LABEL="BC34 OT DIFFERENTIAL 3RD"                
      ER21163             FORMAT=10.2 LABEL="BC34A EXACT OT PAY IF HOURLY"            
      ER21164             FORMAT=1.   LABEL="BC34A EXACT OT PAY PER"                  
      ER21165             FORMAT=8.2  LABEL="BC36 AVG TIPS/COMM"                      
      ER21166             FORMAT=1.   LABEL="BC36 TIPS/COMM PER WHAT"                 
      ER21167             FORMAT=9.   LABEL="BC37 AVG TIPS/COMM"                      
      ER21168             FORMAT=1.   LABEL="BC37 TIPS/COMM PER WHAT"                 
      ER21169             FORMAT=1.   LABEL="BC38 HOW PAID-OTR (HD-E)"                
      ER21170             FORMAT=9.2  LABEL="BC39 OT RATE"                            
      ER21171             FORMAT=2.   LABEL="BC41 YRS PRES EMP (H-E)"                 
      ER21172             FORMAT=2.   LABEL="BC41 MOS PRES EMP (H-E)"                 
      ER21173             FORMAT=2.   LABEL="BC41 WKS PRES EMP (H-E)"                 
      ER21174             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--HD JOB 1"      
      ER21175             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--HD JOB 1"     
      ER21176             FORMAT=3.   LABEL="BC43 HOURS/WEEK WORKED--JOB 1"           
      ER21177             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 1"      
      ER21178             FORMAT=1.   LABEL="BC44 WTR WORKED OT--JOB 1"               
      ER21179             FORMAT=4.   LABEL="BC45 AMT OF OT WORKED--JOB 1"            
      ER21180             FORMAT=1.   LABEL="BC45 OT TIME UNIT--JOB 1"                
      ER21181             FORMAT=1.   LABEL="ACCURACY OF OT--HD JOB 1"                
      ER21182             FORMAT=10.2 LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 1"     
      ER21183             FORMAT=1.   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 1"  
      ER21184             FORMAT=1.   LABEL="BC51 WHY LAST JOB END (HD-U)"            
      ER21185             FORMAT=2.   LABEL="BC6 BEGINNING MONTH--JOB 2"              
      ER21186             FORMAT=4.   LABEL="BC6 BEGINNING YEAR--JOB 2"               
      ER21187             FORMAT=2.   LABEL="BC6 ENDING MONTH--JOB 2"                 
      ER21188             FORMAT=4.   LABEL="BC6 ENDING YEAR--JOB 2"                  
      ER21189             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 JAN"             
      ER21190             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 FEB"             
      ER21191             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 MAR"             
      ER21192             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 APR"             
      ER21193             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 MAY"             
      ER21194             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 JUN"             
      ER21195             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 JUL"             
      ER21196             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 AUG"             
      ER21197             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 SEP"             
      ER21198             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 OCT"             
      ER21199             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 NOV"             
      ER21200             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 DEC"             
      ER21201             FORMAT=3.   LABEL="BC20 MAIN OCC FOR JOB 2: 2000 CODE (HD)" 
      ER21202             FORMAT=3.   LABEL="BC21 MAIN IND FOR JOB 2: 2000 CODE (HD)" 
      ER21203             FORMAT=1.   LABEL="BC22 WORK SELF/OTR?--JOB 2"              
      ER21204             FORMAT=1.   LABEL="BC23 CORP/UNCORP BUS--JOB 2"             
      ER21205             FORMAT=1.   LABEL="BC24 WORK FOR GOVT?--JOB 2"              
      ER21206             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--HD JOB 2"      
      ER21207             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--HD JOB 2"     
      ER21208             FORMAT=3.   LABEL="BC43 HOURS/WEEK WORKED--JOB 2"           
      ER21209             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 2"      
      ER21210             FORMAT=1.   LABEL="BC44 WTR WORKED OT--JOB 2"               
      ER21211             FORMAT=4.   LABEL="BC45 AMT OF OT WORKED--JOB 2"            
      ER21212             FORMAT=1.   LABEL="BC45 OT TIME UNIT--JOB 2"                
      ER21213             FORMAT=1.   LABEL="ACCURACY OF OT--HD JOB 2"                
      ER21214             FORMAT=10.2 LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 2"     
      ER21215             FORMAT=1.   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 2"  
      ER21216             FORMAT=1.   LABEL="BC51 WHY JOB ENDED--JOB 2"               
      ER21217             FORMAT=2.   LABEL="BC6 BEGINNING MONTH--JOB 3"              
      ER21218             FORMAT=4.   LABEL="BC6 BEGINNING YEAR--JOB 3"               
      ER21219             FORMAT=2.   LABEL="BC6 ENDING MONTH--JOB 3"                 
      ER21220             FORMAT=4.   LABEL="BC6 ENDING YEAR--JOB 3"                  
      ER21221             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 JAN"             
      ER21222             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 FEB"             
      ER21223             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 MAR"             
      ER21224             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 APR"             
      ER21225             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 MAY"             
      ER21226             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 JUN"             
      ER21227             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 JUL"             
      ER21228             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 AUG"             
      ER21229             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 SEP"             
      ER21230             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 OCT"             
      ER21231             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 NOV"             
      ER21232             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 DEC"             
      ER21233             FORMAT=3.   LABEL="BC20 MAIN OCC FOR JOB 3: 2000 CODE (HD)" 
      ER21234             FORMAT=3.   LABEL="BC21 MAIN IND FOR JOB 3: 2000 CODE (HD)" 
      ER21235             FORMAT=1.   LABEL="BC22 WORK SELF/OTR?--JOB 3"              
      ER21236             FORMAT=1.   LABEL="BC23 CORP/UNCORP BUS--JOB 3"             
      ER21237             FORMAT=1.   LABEL="BC24 WORK FOR GOVT?--JOB 3"              
      ER21238             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--HD JOB 3"      
      ER21239             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--HD JOB 3"     
      ER21240             FORMAT=3.   LABEL="BC43 HOURS/WEEK WORKED--JOB 3"           
      ER21241             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 3"      
      ER21242             FORMAT=1.   LABEL="BC44 WTR WORKED OT--JOB 3"               
      ER21243             FORMAT=4.   LABEL="BC45 AMT OF OT WORKED--JOB 3"            
      ER21244             FORMAT=1.   LABEL="BC45 OT TIME UNIT--JOB 3"                
      ER21245             FORMAT=1.   LABEL="ACCURACY OF OT--HD JOB 3"                
      ER21246             FORMAT=10.2 LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 3"     
      ER21247             FORMAT=1.   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 3"  
      ER21248             FORMAT=1.   LABEL="BC51 WHY JOB ENDED--JOB 3"               
      ER21249             FORMAT=2.   LABEL="BC6 BEGINNING MONTH--JOB 4"              
      ER21250             FORMAT=4.   LABEL="BC6 BEGINNING YEAR--JOB 4"               
      ER21251             FORMAT=2.   LABEL="BC6 ENDING MONTH--JOB 4"                 
      ER21252             FORMAT=4.   LABEL="BC6 ENDING YEAR--JOB 4"                  
      ER21253             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 JAN"             
      ER21254             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 FEB"             
      ER21255             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 MAR"             
      ER21256             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 APR"             
      ER21257             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 MAY"             
      ER21258             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 JUN"             
      ER21259             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 JUL"             
      ER21260             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 AUG"             
      ER21261             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 SEP"             
      ER21262             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 OCT"             
      ER21263             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 NOV"             
      ER21264             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 DEC"             
      ER21265             FORMAT=3.   LABEL="BC20 MAIN OCC FOR JOB 4: 2000 CODE (HD)" 
      ER21266             FORMAT=3.   LABEL="BC21 MAIN IND FOR JOB 4: 2000 CODE (HD)" 
      ER21267             FORMAT=1.   LABEL="BC22 WORK SELF/OTR?--JOB 4"              
      ER21268             FORMAT=1.   LABEL="BC23 CORP/UNCORP BUS--JOB 4"             
      ER21269             FORMAT=1.   LABEL="BC24 WORK FOR GOVT?--JOB 4"              
      ER21270             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--HD JOB 4"      
      ER21271             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--HD JOB 4"     
      ER21272             FORMAT=3.   LABEL="BC43 HOURS/WEEK WORKED--JOB 4"           
      ER21273             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 4"      
      ER21274             FORMAT=1.   LABEL="BC44 WTR WORKED OT--JOB 4"               
      ER21275             FORMAT=4.   LABEL="BC45 AMT OF OT WORKED--JOB 4"            
      ER21276             FORMAT=1.   LABEL="BC45 OT TIME UNIT--JOB 4"                
      ER21277             FORMAT=1.   LABEL="ACCURACY OF OT--HD JOB 4"                
      ER21278             FORMAT=10.2 LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 4"     
      ER21279             FORMAT=1.   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 4"  
      ER21280             FORMAT=1.   LABEL="BC51 WHY JOB ENDED--JOB 4"               
      ER21281             FORMAT=1.   LABEL="NUMBER OF ADDITIONAL JOBS--HD"           
      ER21282             FORMAT=1.   LABEL="BC10 WTR OTRS ILL (HD)"                  
      ER21283             FORMAT=3.   LABEL="BC10 DAYS OTHERS SICK"                   
      ER21284             FORMAT=1.   LABEL="ACCURACY OF DAYS OTRS SICK (HD)"         
      ER21285             FORMAT=2.   LABEL="BC10 WEEKS OTHERS SICK"                  
      ER21286             FORMAT=1.   LABEL="ACCURACY OF WEEKS OTRS SICK (HD)"        
      ER21287             FORMAT=2.   LABEL="BC10 MONTHS OTHERS SICK"                 
      ER21288             FORMAT=1.   LABEL="ACCURACY OF MONTHS OTRS SICK (HD)"       
      ER21289             FORMAT=1.   LABEL="BC11 WTR SELF ILL (HD)"                  
      ER21290             FORMAT=3.   LABEL="BC11 DAYS SELF SICK"                     
      ER21291             FORMAT=1.   LABEL="ACCURACY OF DAYS SELF ILL (HD)"          
      ER21292             FORMAT=2.   LABEL="BC11 WEEKS SELF SICK"                    
      ER21293             FORMAT=1.   LABEL="ACCURACY OF WEEKS SELF ILL (HD)"         
      ER21294             FORMAT=2.   LABEL="BC11 MONTHS SELF SICK"                   
      ER21295             FORMAT=1.   LABEL="ACCURACY OF MONTHS SELF ILL (HD)"        
      ER21296             FORMAT=1.   LABEL="BC12 WTR VACATION (HD)"                  
      ER21297             FORMAT=3.   LABEL="BC12 DAYS VACATION"                      
      ER21298             FORMAT=1.   LABEL="ACCURACY OF DAYS VACATION (HD)"          
      ER21299             FORMAT=2.   LABEL="BC12 WEEKS VACATION"                     
      ER21300             FORMAT=1.   LABEL="ACCURACY OF WEEKS VACATION (HD)"         
      ER21301             FORMAT=2.   LABEL="BC12 MONTHS VACATION"                    
      ER21302             FORMAT=1.   LABEL="ACCURACY OF MONTHS VACATION (HD)"        
      ER21303             FORMAT=1.   LABEL="BC13 WTR STRIKE (HD)"                    
      ER21304             FORMAT=3.   LABEL="BC13 DAYS STRIKE"                        
      ER21305             FORMAT=1.   LABEL="ACCURACY OF STRIKE DAYS (HD)"            
      ER21306             FORMAT=2.   LABEL="BC13 WEEKS STRIKE"                       
      ER21307             FORMAT=1.   LABEL="ACCURACY OF STRIKE WEEKS (HD)"           
      ER21308             FORMAT=2.   LABEL="BC13 MONTHS STRIKE"                      
      ER21309             FORMAT=1.   LABEL="ACCURACY OF STRIKE MONTHS (HD)"          
      ER21310             FORMAT=1.   LABEL="BC14 WTR LAID OFF (HD)"                  
      ER21311             FORMAT=3.   LABEL="BC14 DAYS LAID OFF"                      
      ER21312             FORMAT=1.   LABEL="ACCURACY OF DAYS LAID OFF (HD)"          
      ER21313             FORMAT=2.   LABEL="BC14 WEEKS LAID OFF"                     
      ER21314             FORMAT=1.   LABEL="ACCURACY OF WEEKS LAID OFF (HD)"         
      ER21315             FORMAT=2.   LABEL="BC14 MONTHS LAID OFF"                    
      ER21316             FORMAT=1.   LABEL="ACCURACY OF MONTHS LAID OFF (HD)"        
      ER21317             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED(HD)"                  
      ER21318             FORMAT=3.   LABEL="BC8 DAYS UNEMPLOYED"                     
      ER21319             FORMAT=1.   LABEL="ACCURACY OF DAYS UNEMPLOYED (HD)"        
      ER21320             FORMAT=2.   LABEL="BC8 WEEKS UNEMPLOYED"                    
      ER21321             FORMAT=1.   LABEL="ACCURACY OF WEEKS UNEMPLOYED (HD)"       
      ER21322             FORMAT=2.   LABEL="BC8 MONTHS UNEMPLOYED"                   
      ER21323             FORMAT=1.   LABEL="ACCURACY OF MONTHS UNEMPLOYED (HD)"      
      ER21324             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED JAN"                  
      ER21325             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED FEB"                  
      ER21326             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED MAR"                  
      ER21327             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED APR"                  
      ER21328             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED MAY"                  
      ER21329             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED JUN"                  
      ER21330             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED JUL"                  
      ER21331             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED AUG"                  
      ER21332             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED SEP"                  
      ER21333             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED OCT"                  
      ER21334             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED NOV"                  
      ER21335             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED DEC"                  
      ER21336             FORMAT=1.   LABEL="BC7 WTR OUT LAB FRC(H)"                  
      ER21337             FORMAT=3.   LABEL="BC7 DAYS OUT OF LAB FORCE"               
      ER21338             FORMAT=1.   LABEL="ACCURACY OF DAYS OUT OF LAB FORCE (HD)"  
      ER21339             FORMAT=2.   LABEL="BC7WEEKS OUT LABOR FORCE"                
      ER21340             FORMAT=1.   LABEL="ACCURACY OF WKS OUT OF LAB FORCE (HD)"   
      ER21341             FORMAT=2.   LABEL="BC7 MONTHS OUT LABR FORCE"               
      ER21342             FORMAT=1.   LABEL="ACCURACY OF MOS OUT OF LAB FORCE (HD)"   
      ER21343             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC JAN"                
      ER21344             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC FEB"                
      ER21345             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC MAR"                
      ER21346             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC APR"                
      ER21347             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC MAY"                
      ER21348             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC JUN"                
      ER21349             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC JUL"                
      ER21350             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC AUG"                
      ER21351             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC SEP"                
      ER21352             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC OCT"                
      ER21353             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC NOV"                
      ER21354             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC DEC"                
      ER21355             FORMAT=2.   LABEL="BC54 TOTAL WEEKS WORKED"                 
      ER21356             FORMAT=3.   LABEL="BC56 TOTAL HOURS WORKED"                 
      ER21357             FORMAT=1.   LABEL="BC62 WTR EVER WORKED"                    
      ER21358             FORMAT=2.   LABEL="BC63 MO LAST WORKED"                     
      ER21359             FORMAT=4.   LABEL="BC63 YR LAST WORKED"                     
      ER21360             FORMAT=1.   LABEL="BC64 WTR LOOKING FOR JOB"                
      ER21361             FORMAT=1.   LABEL="BC65 WTR PUBLIC EMP AGENCY (HD)"         
      ER21362             FORMAT=1.   LABEL="BC65 WTR PRIVATE EMP AGENCY (HD)"        
      ER21363             FORMAT=1.   LABEL="BC65 WTR CHKD W/CURRENT EMP (HD)"        
      ER21364             FORMAT=1.   LABEL="BC65 WTR CHKD W/OTHER EMP (HD)"          
      ER21365             FORMAT=1.   LABEL="BC65 WTR CHKD W/FRIEND OR REL (HD)"      
      ER21366             FORMAT=1.   LABEL="BC65 WTR PLACED OR ANSWERED ADS (HD)"    
      ER21367             FORMAT=1.   LABEL="BC65 WTR OTHER ACTIVITY (HD)"            
      ER21368             FORMAT=1.   LABEL="BC65 WTR DONE NOTHING (HD)"              
      ER21369             FORMAT=2.   LABEL="BC67 YRS LOOK WRK (H-U)"                 
      ER21370             FORMAT=2.   LABEL="BC67 MOS LOOK WRK (H-U)"                 
      ER21371             FORMAT=2.   LABEL="BC67 WKS LOOK WRK (H-U)"                 
      ER21372             FORMAT=1.   LABEL="DE1 CKPT: WTR WIFE IN FU"                
      ER21373             FORMAT=2.   LABEL="DE1 EMPLOYMENT STATUS-1ST MENTION"       
      ER21374             FORMAT=2.   LABEL="DE1 EMPLOYMENT STATUS-2ND MENTION"       
      ER21375             FORMAT=2.   LABEL="DE1 EMPLOYMENT STATUS-3RD MENTION"       
      ER21376             FORMAT=4.   LABEL="DE2 YEAR RETIRED (WF-R)"                 
      ER21377             FORMAT=1.   LABEL="DE3 WTR WORKED SINCE JAN 1 OF PRIOR YEAR"
      ER21378             FORMAT=1.   LABEL="DE16-17 MAIN JOB INDICATOR"              
      ER21379             FORMAT=2.   LABEL="DE6 BEGINNING MONTH--JOB 1"              
      ER21380             FORMAT=4.   LABEL="DE6 BEGINNING YEAR--JOB 1"               
      ER21381             FORMAT=2.   LABEL="DE6 ENDING MONTH--JOB 1"                 
      ER21382             FORMAT=4.   LABEL="DE6 ENDING YEAR--JOB 1"                  
      ER21383             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 JAN"             
      ER21384             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 FEB"             
      ER21385             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 MAR"             
      ER21386             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 APR"             
      ER21387             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 MAY"             
      ER21388             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 JUN"             
      ER21389             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 JUL"             
      ER21390             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 AUG"             
      ER21391             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 SEP"             
      ER21392             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 OCT"             
      ER21393             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 NOV"             
      ER21394             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 DEC"             
      ER21395             FORMAT=3.   LABEL="DE20 MAIN OCC FOR JOB 1: 2000 CODE (WF)" 
      ER21396             FORMAT=3.   LABEL="DE21 MAIN IND FOR JOB 1: 2000 CODE (WF)" 
      ER21397             FORMAT=1.   LABEL="DE22 WORK SELF/OTR?--JOB 1"              
      ER21398             FORMAT=1.   LABEL="DE23 CORP/UNCORP BUS--JOB 1"             
      ER21399             FORMAT=1.   LABEL="DE24 WORK FOR GOVT?--JOB 1"              
      ER21400             FORMAT=1.   LABEL="DE26 JOB NOW UNION? (W-E)"               
      ER21401             FORMAT=1.   LABEL="DE27 BELONG UNION? (WF-E)"               
      ER21402             FORMAT=1.   LABEL="DE29 SLRY/HRLY/OTR (W-E)"                
      ER21403             FORMAT=10.2 LABEL="DE30 SALARY AMOUNT"                      
      ER21404             FORMAT=1.   LABEL="DE30 SALARY PER WHAT"                    
      ER21405             FORMAT=1.   LABEL="DE31 WTR SAL PD OT (WF-E)"               
      ER21406             FORMAT=1.   LABEL="DE32 HOW PAID FOR OT"                    
      ER21407             FORMAT=10.2 LABEL="DE32A EXACT OT PAY IF SALARIED"          
      ER21408             FORMAT=1.   LABEL="DE32A EXACT OT PAY PER"                  
      ER21409             FORMAT=6.2  LABEL="DE33 HOURLY REGULAR RATE"                
      ER21410             FORMAT=1.   LABEL="DE34 OT DIFFERENTIAL 1ST"                
      ER21411             FORMAT=1.   LABEL="DE34 OT DIFFERENTIAL 2ND"                
      ER21412             FORMAT=1.   LABEL="DE34 OT DIFFERENTIAL 3RD"                
      ER21413             FORMAT=10.2 LABEL="DE34A EXACT OT PAY IF HOURLY"            
      ER21414             FORMAT=1.   LABEL="DE34A EXACT OT PAY PER"                  
      ER21415             FORMAT=8.2  LABEL="DE36 AVG TIPS/COMM"                      
      ER21416             FORMAT=1.   LABEL="DE36 TIPS/COMM PER WHAT"                 
      ER21417             FORMAT=9.   LABEL="DE37 AVG TIPS/COMM"                      
      ER21418             FORMAT=1.   LABEL="DE37 TIPS/COMM PER WHAT"                 
      ER21419             FORMAT=1.   LABEL="DE38 HOW PAID-OTR (WF-E)"                
      ER21420             FORMAT=9.2  LABEL="DE39 OT RATE"                            
      ER21421             FORMAT=2.   LABEL="DE41 YRS PRES EMP (W-E)"                 
      ER21422             FORMAT=2.   LABEL="DE41 MOS PRES EMP (W-E)"                 
      ER21423             FORMAT=2.   LABEL="DE41 WKS PRES EMP (W-E)"                 
      ER21424             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--WF JOB 1"      
      ER21425             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--WF JOB 1"     
      ER21426             FORMAT=3.   LABEL="DE43 HOURS/WEEK WORKED--JOB 1"           
      ER21427             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 1"      
      ER21428             FORMAT=1.   LABEL="DE44 WTR WORKED OT--JOB 1"               
      ER21429             FORMAT=4.   LABEL="DE45 AMT OF OT WORKED--JOB 1"            
      ER21430             FORMAT=1.   LABEL="DE45 OT TIME UNIT--JOB 1"                
      ER21431             FORMAT=1.   LABEL="ACCURACY OF OT--WF JOB 1"                
      ER21432             FORMAT=10.2 LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 1"     
      ER21433             FORMAT=1.   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 1"  
      ER21434             FORMAT=1.   LABEL="DE51 WHY LAST JOB END (WF-U)"            
      ER21435             FORMAT=2.   LABEL="DE6 BEGINNING MONTH--JOB 2"              
      ER21436             FORMAT=4.   LABEL="DE6 BEGINNING YEAR--JOB 2"               
      ER21437             FORMAT=2.   LABEL="DE6 ENDING MONTH--JOB 2"                 
      ER21438             FORMAT=4.   LABEL="DE6 ENDING YEAR--JOB 2"                  
      ER21439             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 JAN"             
      ER21440             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 FEB"             
      ER21441             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 MAR"             
      ER21442             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 APR"             
      ER21443             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 MAY"             
      ER21444             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 JUN"             
      ER21445             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 JUL"             
      ER21446             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 AUG"             
      ER21447             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 SEP"             
      ER21448             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 OCT"             
      ER21449             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 NOV"             
      ER21450             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 DEC"             
      ER21451             FORMAT=3.   LABEL="DE20 MAIN OCC FOR JOB 2: 2000 CODE (WF)" 
      ER21452             FORMAT=3.   LABEL="DE21 MAIN IND FOR JOB 2: 2000 CODE (WF)" 
      ER21453             FORMAT=1.   LABEL="DE22 WORK SELF/OTR?--JOB 2"              
      ER21454             FORMAT=1.   LABEL="DE23 CORP/UNCORP BUS--JOB 2"             
      ER21455             FORMAT=1.   LABEL="DE24 WORK FOR GOVT?--JOB 2"              
      ER21456             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--WF JOB 2"      
      ER21457             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--WF JOB 2"     
      ER21458             FORMAT=3.   LABEL="DE43 HOURS/WEEK WORKED--JOB 2"           
      ER21459             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 2"      
      ER21460             FORMAT=1.   LABEL="DE44 WTR WORKED OT--JOB 2"               
      ER21461             FORMAT=4.   LABEL="DE45 AMT OF OT WORKED--JOB 2"            
      ER21462             FORMAT=1.   LABEL="DE45 OT TIME UNIT--JOB 2"                
      ER21463             FORMAT=1.   LABEL="ACCURACY OF OT--WF JOB 2"                
      ER21464             FORMAT=10.2 LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 2"     
      ER21465             FORMAT=1.   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 2"  
      ER21466             FORMAT=1.   LABEL="DE51 WHY JOB ENDED--JOB 2"               
      ER21467             FORMAT=2.   LABEL="DE6 BEGINNING MONTH--JOB 3"              
      ER21468             FORMAT=4.   LABEL="DE6 BEGINNING YEAR--JOB 3"               
      ER21469             FORMAT=2.   LABEL="DE6 ENDING MONTH--JOB 3"                 
      ER21470             FORMAT=4.   LABEL="DE6 ENDING YEAR--JOB 3"                  
      ER21471             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 JAN"             
      ER21472             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 FEB"             
      ER21473             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 MAR"             
      ER21474             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 APR"             
      ER21475             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 MAY"             
      ER21476             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 JUN"             
      ER21477             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 JUL"             
      ER21478             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 AUG"             
      ER21479             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 SEP"             
      ER21480             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 OCT"             
      ER21481             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 NOV"             
      ER21482             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 DEC"             
      ER21483             FORMAT=3.   LABEL="DE20 MAIN OCC FOR JOB 3: 2000 CODE (WF)" 
      ER21484             FORMAT=3.   LABEL="DE21 MAIN IND FOR JOB 3: 2000 CODE (WF)" 
      ER21485             FORMAT=1.   LABEL="DE22 WORK SELF/OTR?--JOB 3"              
      ER21486             FORMAT=1.   LABEL="DE23 CORP/UNCORP BUS--JOB 3"             
      ER21487             FORMAT=1.   LABEL="DE24 WORK FOR GOVT?--JOB 3"              
      ER21488             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--WF JOB 3"      
      ER21489             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--WF JOB 3"     
      ER21490             FORMAT=3.   LABEL="DE43 HOURS/WEEK WORKED--JOB 3"           
      ER21491             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 3"      
      ER21492             FORMAT=1.   LABEL="DE44 WTR WORKED OT--JOB 3"               
      ER21493             FORMAT=4.   LABEL="DE45 AMT OF OT WORKED--JOB 3"            
      ER21494             FORMAT=1.   LABEL="DE45 OT TIME UNIT--JOB 3"                
      ER21495             FORMAT=1.   LABEL="ACCURACY OF OT--WF JOB 3"                
      ER21496             FORMAT=10.2 LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 3"     
      ER21497             FORMAT=1.   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 3"  
      ER21498             FORMAT=1.   LABEL="DE51 WHY JOB ENDED--JOB 3"               
      ER21499             FORMAT=2.   LABEL="DE6 BEGINNING MONTH--JOB 4"              
      ER21500             FORMAT=4.   LABEL="DE6 BEGINNING YEAR--JOB 4"               
      ER21501             FORMAT=2.   LABEL="DE6 ENDING MONTH--JOB 4"                 
      ER21502             FORMAT=4.   LABEL="DE6 ENDING YEAR--JOB 4"                  
      ER21503             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 JAN"             
      ER21504             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 FEB"             
      ER21505             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 MAR"             
      ER21506             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 APR"             
      ER21507             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 MAY"             
      ER21508             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 JUN"             
      ER21509             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 JUL"             
      ER21510             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 AUG"             
      ER21511             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 SEP"             
      ER21512             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 OCT"             
      ER21513             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 NOV"             
      ER21514             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 DEC"             
      ER21515             FORMAT=3.   LABEL="DE20 MAIN OCC FOR JOB 4: 2000 CODE (WF)" 
      ER21516             FORMAT=3.   LABEL="DE21 MAIN IND FOR JOB 4: 2000 CODE (WF)" 
      ER21517             FORMAT=1.   LABEL="DE22 WORK SELF/OTR?--JOB 4"              
      ER21518             FORMAT=1.   LABEL="DE23 CORP/UNCORP BUS--JOB 4"             
      ER21519             FORMAT=1.   LABEL="DE24 WORK FOR GOVT?--JOB 4"              
      ER21520             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--WF JOB 4"      
      ER21521             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--WF JOB 4"     
      ER21522             FORMAT=3.   LABEL="DE43 HOURS/WEEK WORKED--JOB 4"           
      ER21523             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 4"      
      ER21524             FORMAT=1.   LABEL="DE44 WTR WORKED OT--JOB 4"               
      ER21525             FORMAT=4.   LABEL="DE45 AMT OF OT WORKED--JOB 4"            
      ER21526             FORMAT=1.   LABEL="DE45 OT TIME UNIT--JOB 4"                
      ER21527             FORMAT=1.   LABEL="ACCURACY OF OT--WF JOB 4"                
      ER21528             FORMAT=10.2 LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 4"     
      ER21529             FORMAT=1.   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 4"  
      ER21530             FORMAT=1.   LABEL="DE51 WHY JOB ENDED--JOB 4"               
      ER21531             FORMAT=1.   LABEL="NUMBER OF ADDITIONAL JOBS--WF"           
      ER21532             FORMAT=1.   LABEL="DE10 WTR OTRS ILL (WF)"                  
      ER21533             FORMAT=3.   LABEL="DE10 DAYS OTHERS SICK"                   
      ER21534             FORMAT=1.   LABEL="ACCURACY OF DAYS OTRS SICK (WF)"         
      ER21535             FORMAT=2.   LABEL="DE10 WEEKS OTHERS SICK"                  
      ER21536             FORMAT=1.   LABEL="ACCURACY OF WEEKS OTRS SICK (WF)"        
      ER21537             FORMAT=2.   LABEL="DE10 MONTHS OTHERS SICK"                 
      ER21538             FORMAT=1.   LABEL="ACCURACY OF MONTHS OTRS SICK (WF)"       
      ER21539             FORMAT=1.   LABEL="DE11 WTR SELF ILL (WF)"                  
      ER21540             FORMAT=3.   LABEL="DE11 DAYS SELF SICK"                     
      ER21541             FORMAT=1.   LABEL="ACCURACY OF DAYS SELF ILL (WF)"          
      ER21542             FORMAT=2.   LABEL="DE11 WEEKS SELF SICK"                    
      ER21543             FORMAT=1.   LABEL="ACCURACY OF WEEKS SELF ILL (WF)"         
      ER21544             FORMAT=2.   LABEL="DE11 MONTHS SELF SICK"                   
      ER21545             FORMAT=1.   LABEL="ACCURACY OF MONTHS SELF ILL (WF)"        
      ER21546             FORMAT=1.   LABEL="DE12 WTR VACATION (WF)"                  
      ER21547             FORMAT=3.   LABEL="DE12 DAYS VACATION"                      
      ER21548             FORMAT=1.   LABEL="ACCURACY OF DAYS VACATION (WF)"          
      ER21549             FORMAT=2.   LABEL="DE12 WEEKS VACATION"                     
      ER21550             FORMAT=1.   LABEL="ACCURACY OF WEEKS VACATION (WF)"         
      ER21551             FORMAT=2.   LABEL="DE12 MONTHS VACATION"                    
      ER21552             FORMAT=1.   LABEL="ACCURACY OF MONTHS VACATION (WF)"        
      ER21553             FORMAT=1.   LABEL="DE13 WTR STRIKE (WF)"                    
      ER21554             FORMAT=3.   LABEL="DE13 DAYS STRIKE"                        
      ER21555             FORMAT=1.   LABEL="ACCURACY OF STRIKE DAYS (WF)"            
      ER21556             FORMAT=2.   LABEL="DE13 WEEKS STRIKE"                       
      ER21557             FORMAT=1.   LABEL="ACCURACY OF STRIKE WEEKS (WF)"           
      ER21558             FORMAT=2.   LABEL="DE13 MONTHS STRIKE"                      
      ER21559             FORMAT=1.   LABEL="ACCURACY OF STRIKE MONTHS (WF)"          
      ER21560             FORMAT=1.   LABEL="DE14 WTR LAID OFF (WF)"                  
      ER21561             FORMAT=3.   LABEL="DE14 DAYS LAID OFF"                      
      ER21562             FORMAT=1.   LABEL="ACCURACY OF DAYS LAID OFF (WF)"          
      ER21563             FORMAT=2.   LABEL="DE14 WEEKS LAID OFF"                     
      ER21564             FORMAT=1.   LABEL="ACCURACY OF WEEKS LAID OFF (WF)"         
      ER21565             FORMAT=2.   LABEL="DE14 MONTHS LAID OFF"                    
      ER21566             FORMAT=1.   LABEL="ACCURACY OF MONTHS LAID OFF (WF)"        
      ER21567             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED(WF)"                  
      ER21568             FORMAT=3.   LABEL="DE8 DAYS UNEMPLOYED"                     
      ER21569             FORMAT=1.   LABEL="ACCURACY OF DAYS UNEMPLOYED (WF)"        
      ER21570             FORMAT=2.   LABEL="DE8 WEEKS UNEMPLOYED"                    
      ER21571             FORMAT=1.   LABEL="ACCURACY OF WEEKS UNEMPLOYED (WF)"       
      ER21572             FORMAT=2.   LABEL="DE8 MONTHS UNEMPLOYED"                   
      ER21573             FORMAT=1.   LABEL="ACCURACY OF MONTHS UNEMPLOYED (WF)"      
      ER21574             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED JAN"                  
      ER21575             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED FEB"                  
      ER21576             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED MAR"                  
      ER21577             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED APR"                  
      ER21578             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED MAY"                  
      ER21579             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED JUN"                  
      ER21580             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED JUL"                  
      ER21581             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED AUG"                  
      ER21582             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED SEP"                  
      ER21583             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED OCT"                  
      ER21584             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED NOV"                  
      ER21585             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED DEC"                  
      ER21586             FORMAT=1.   LABEL="DE7 WTR OUT LAB FRC(W)"                  
      ER21587             FORMAT=3.   LABEL="DE7 DAYS OUT OF LAB FORCE"               
      ER21588             FORMAT=1.   LABEL="ACCURACY OF DAYS OUT OF LAB FORCE (WF)"  
      ER21589             FORMAT=2.   LABEL="DE7WEEKS OUT LABOR FORCE"                
      ER21590             FORMAT=1.   LABEL="ACCURACY OF WKS OUT OF LAB FORCE (WF)"   
      ER21591             FORMAT=2.   LABEL="DE7 MONTHS OUT LABR FORCE"               
      ER21592             FORMAT=1.   LABEL="ACCURACY OF MOS OUT OF LAB FORCE (WF)"   
      ER21593             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC JAN"                
      ER21594             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC FEB"                
      ER21595             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC MAR"                
      ER21596             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC APR"                
      ER21597             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC MAY"                
      ER21598             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC JUN"                
      ER21599             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC JUL"                
      ER21600             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC AUG"                
      ER21601             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC SEP"                
      ER21602             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC OCT"                
      ER21603             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC NOV"                
      ER21604             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC DEC"                
      ER21605             FORMAT=2.   LABEL="DE54 TOTAL WEEKS WORKED"                 
      ER21606             FORMAT=3.   LABEL="DE56 TOTAL HOURS WORKED"                 
      ER21607             FORMAT=1.   LABEL="DE62 WTR EVER WORKED"                    
      ER21608             FORMAT=2.   LABEL="DE63 MO LAST WORKED"                     
      ER21609             FORMAT=4.   LABEL="DE63 YR LAST WORKED"                     
      ER21610             FORMAT=1.   LABEL="DE64 WTR LOOKING FOR JOB"                
      ER21611             FORMAT=1.   LABEL="DE65 WTR PUBLIC EMP AGENCY (WF)"         
      ER21612             FORMAT=1.   LABEL="DE65 WTR PRIVATE EMP AGENCY (WF)"        
      ER21613             FORMAT=1.   LABEL="DE65 WTR CHKD W/CURRENT EMP (WF)"        
      ER21614             FORMAT=1.   LABEL="DE65 WTR CHKD W/OTHER EMP (WF)"          
      ER21615             FORMAT=1.   LABEL="DE65 WTR CHKD W/FRIEND OR REL (WF)"      
      ER21616             FORMAT=1.   LABEL="DE65 WTR PLACED OR ANSWERED ADS (WF)"    
      ER21617             FORMAT=1.   LABEL="DE65 WTR OTHER ACTIVITY (WF)"            
      ER21618             FORMAT=1.   LABEL="DE65 WTR DONE NOTHING (WF)"              
      ER21619             FORMAT=2.   LABEL="DE67 YRS LOOK WRK (W-U)"                 
      ER21620             FORMAT=2.   LABEL="DE67 MOS LOOK WRK (W-U)"                 
      ER21621             FORMAT=2.   LABEL="DE67 WKS LOOK WRK (W-U)"                 
      ER21622             FORMAT=1.   LABEL="F1 CKPT:TYPE HD+WF"                      
      ER21623             FORMAT=3.   LABEL="F2 HOUSEWORK HRS-WIFE"                   
      ER21624             FORMAT=1.   LABEL="ACCURACY OF WF HOUSEWORK HRS"            
      ER21625             FORMAT=3.   LABEL="F3 HOUSEWORK HOURS-HEAD"                 
      ER21626             FORMAT=1.   LABEL="ACCURACY OF HD HOUSEWORK HRS"            
      ER21627             FORMAT=1.   LABEL="F5 FAM TOGETHR MAIN MEAL"                
      ER21628             FORMAT=6.   LABEL="F7 COST CHILD CARE LAST YEAR"            
      ER21629             FORMAT=1.   LABEL="F7A WTR CHILD IN DAY CARE CNTR PREV YR"  
      ER21630             FORMAT=1.   LABEL="F7B WTR MEALS/SNACKS PROVIDED TO CHILD"  
      ER21631             FORMAT=1.   LABEL="F7C WTR DAY CARE IN CHILD/ADULT FOOD PGM"
      ER21632             FORMAT=1.   LABEL="F7D WTR ADULT IN ADULT DAY CARE PREV YR" 
      ER21633             FORMAT=1.   LABEL="F7E WTR MEALS/SNACKS PROVIDED TO ADULT"  
      ER21634             FORMAT=1.   LABEL="F7F WTR CENTER IN CHILD/ADULT FOOD PGM"  
      ER21635             FORMAT=6.   LABEL="F7G AMT PAID FOR ADULT DAY CARE"         
      ER21636             FORMAT=1.   LABEL="F8 WTR USED FOOD STAMPS 2 YRS AGO"       
      ER21637             FORMAT=6.   LABEL="F9 VALUE OF FOOD STAMPS 2 YRS AGO"       
      ER21638             FORMAT=1.   LABEL="F9 TIME UNIT-VALUE FOOD STAMPS 2 YRS AGO"
      ER21639             FORMAT=1.   LABEL="ACCURACY OF FOOD STAMPS 2 YEARS AGO"     
      ER21640             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS JAN 2 YRS AGO" 
      ER21641             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS FEB 2 YRS AGO" 
      ER21642             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS MAR 2 YRS AGO" 
      ER21643             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS APR 2 YRS AGO" 
      ER21644             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS MAY 2 YRS AGO" 
      ER21645             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS JUN 2 YRS AGO" 
      ER21646             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS JUL 2 YRS AGO" 
      ER21647             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS AUG 2 YRS AGO" 
      ER21648             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS SEP 2 YRS AGO" 
      ER21649             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS OCT 2 YRS AGO" 
      ER21650             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS NOV 2 YRS AGO" 
      ER21651             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS DEC 2 YRS AGO" 
      ER21652             FORMAT=1.   LABEL="F11 WTR RECEIVED FOOD STAMPS LAST YEAR"  
      ER21653             FORMAT=6.   LABEL="F12 VALUE OF FOOD STAMPS LAST YEAR"      
      ER21654             FORMAT=1.   LABEL="F12 TIME UNIT-VALUE FOOD STAMPS LAST YR" 
      ER21655             FORMAT=1.   LABEL="ACCURACY OF FOOD STAMPS LAST YEAR"       
      ER21656             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS JAN LAST YEAR" 
      ER21657             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS FEB LAST YEAR" 
      ER21658             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS MAR LAST YEAR" 
      ER21659             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS APR LAST YEAR" 
      ER21660             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS MAY LAST YEAR" 
      ER21661             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS JUN LAST YEAR" 
      ER21662             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS JUL LAST YEAR" 
      ER21663             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS AUG LAST YEAR" 
      ER21664             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS SEP LAST YEAR" 
      ER21665             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS OCT LAST YEAR" 
      ER21666             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS NOV LAST YEAR" 
      ER21667             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS DEC LAST YEAR" 
      ER21668             FORMAT=1.   LABEL="F14 WTR RECEIVED FOOD STAMPS THIS YEAR"  
      ER21669             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS JAN THIS YEAR"
      ER21670             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS FEB THIS YEAR"
      ER21671             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS MAR THIS YEAR"
      ER21672             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS APR THIS YEAR"
      ER21673             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS MAY THIS YEAR"
      ER21674             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS JUN THIS YEAR"
      ER21675             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS JUL THIS YEAR"
      ER21676             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS AUG THIS YEAR"
      ER21677             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS SEP THIS YEAR"
      ER21678             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS OCT THIS YEAR"
      ER21679             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS NOV THIS YEAR"
      ER21680             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS DEC THIS YEAR"
      ER21681             FORMAT=1.   LABEL="F15 # FU MEMBERS RECEIVED FOOD STAMPS"   
      ER21682             FORMAT=6.   LABEL="F16 VALUE OF FOOD STAMPS RECD THIS YR"   
      ER21683             FORMAT=1.   LABEL="F16 VALUE OF FOOD STAMPS PER"            
      ER21684             FORMAT=1.   LABEL="ACCURACY OF FOOD STAMPS THIS YEAR"       
      ER21685             FORMAT=1.   LABEL="F17 WTR BUY FOOD TO USE AT HOME"         
      ER21686             FORMAT=8.2  LABEL="F18 REPORTED COST OF FOOD AT HOME"       
      ER21687             FORMAT=1.   LABEL="F18 COST OF FOOD AT HOME PER"            
      ER21688             FORMAT=1.   LABEL="ACCURACY OF FOOD AT HOME-RECD FD STAMPS" 
      ER21689             FORMAT=1.   LABEL="F19 WTR FOOD DELIVERED TO HOME"          
      ER21690             FORMAT=8.2  LABEL="F20 COST OF DELIVERED FOOD"              
      ER21691             FORMAT=1.   LABEL="F20 COST OF DELIVERED FOOD PER"          
      ER21692             FORMAT=1.   LABEL="ACCURACY OF DELIVERD FOOD-RECD FD STAMPS"
      ER21693             FORMAT=8.2  LABEL="F21 COST OF FOOD EATEN OUT"              
      ER21694             FORMAT=1.   LABEL="F21 COST OF FOOD EATEN OUT PER"          
      ER21695             FORMAT=1.   LABEL="ACCURACY OF FOOD EATN OUT-RECD FD STAMPS"
      ER21696             FORMAT=8.2  LABEL="F22 REPORTED COST OF FOOD AT HOME"       
      ER21697             FORMAT=1.   LABEL="F22 COST OF FOOD AT HOME PER"            
      ER21698             FORMAT=1.   LABEL="ACCURACY OF FOOD AT HOME-NO FD STAMPS"   
      ER21699             FORMAT=1.   LABEL="F23 WTR FOOD DELIVERED TO HOME"          
      ER21700             FORMAT=8.2  LABEL="F24 COST OF DELIVERED FOOD"              
      ER21701             FORMAT=1.   LABEL="F24 COST OF DELIVERED FOOD PER"          
      ER21702             FORMAT=1.   LABEL="ACCURACY OF DELIVERED FOOD-NO FD STAMPS" 
      ER21703             FORMAT=8.2  LABEL="F25 COST OF FOOD EATEN OUT"              
      ER21704             FORMAT=1.   LABEL="F25 COST OF FOOD EATEN OUT PER"          
      ER21705             FORMAT=1.   LABEL="ACCURACY OF FOOD EATEN OUT-NO FD STAMPS" 
      ER21706             FORMAT=1.   LABEL="F26 WTR ENOUGH FOOD AND KIND WANTED"     
      ER21707             FORMAT=1.   LABEL="F27A NOT ENOUGH MONEY FOR FOOD"          
      ER21708             FORMAT=1.   LABEL="F27B UNABLE TO GET TO STORE"             
      ER21709             FORMAT=1.   LABEL="F27C WAS ON A DIET"                      
      ER21710             FORMAT=1.   LABEL="F27D HEALTH PROBS INTERFERE"             
      ER21711             FORMAT=1.   LABEL="F27E STOVE/REFRIG NOT WORKING"           
      ER21712             FORMAT=1.   LABEL="F28A WTR WORRY FOOD RUN OUT AND NO MONEY"
      ER21713             FORMAT=1.   LABEL="F28B WTR FOOD GONE AND NO MONEY FOR MORE"
      ER21714             FORMAT=1.   LABEL="F28C WTR CANNOT AFFORD BALANCED MEALS"   
      ER21715             FORMAT=1.   LABEL="F29 CKPT: WTR MONEY FOR FOOD A PROBLEM"  
      ER21716             FORMAT=1.   LABEL="F30 WTR NO MONEY SO CUT SIZE/SKIP MEAL"  
      ER21717             FORMAT=1.   LABEL="F30A FREQUENCY CUT SIZE/SKIP MEALS"      
      ER21718             FORMAT=1.   LABEL="F31 WTR ATE LESS THAN SHOULD"            
      ER21719             FORMAT=1.   LABEL="F32 HUNGRY BUT NOT AFFORD MORE FOOD"     
      ER21720             FORMAT=1.   LABEL="F33 WTR LOST WEIGHT"                     
      ER21721             FORMAT=1.   LABEL="F34 WTR DID NOT EAT FOR WHOLE DAY"       
      ER21722             FORMAT=1.   LABEL="F34A FREQUENCY NOT EAT WHOLE DAY"        
      ER21723             FORMAT=1.   LABEL="F35 WTR GOT EMERGENCY FOOD"              
      ER21724             FORMAT=1.   LABEL="F36 FREQUENCY GOT EMERGENCY FOOD"        
      ER21725             FORMAT=1.   LABEL="F37 WTR ATE AT SOUP KITCHEN"             
      ER21726             FORMAT=1.   LABEL="F38 CKPT: WTR CHILD < 18 IN FU LAST YR"  
      ER21727             FORMAT=1.   LABEL="F39A MONEY LOW SO CHEAP FOOD TO CHILD"   
      ER21728             FORMAT=1.   LABEL="F39B NOT AFFORD BALANCED MEALS FOR CHILD"
      ER21729             FORMAT=1.   LABEL="F39C NOT AFFORD ENOUGH FOOD FOR CHILD"   
      ER21730             FORMAT=1.   LABEL="F40 CKPT: WTR FOOD PROBLEMS"             
      ER21731             FORMAT=1.   LABEL="F41 MONEY LOW SO CUT SIZE OF CHILD MEALS"
      ER21732             FORMAT=1.   LABEL="F42 WTR MONEY LOW SO CHILD SKIP MEAL"    
      ER21733             FORMAT=1.   LABEL="F42A FREQUENCY CHILD SKIP MEAL"          
      ER21734             FORMAT=1.   LABEL="F43 CHLD HUNGRY BUT NOT AFFORD MORE FOOD"
      ER21735             FORMAT=1.   LABEL="F44 WTR CHILD NOT EAT FOR A WHOLE DAY"   
      ER21736             FORMAT=1.   LABEL="F45 CKPT: WTR DIFFICULTY GET ENOUGH FOOD"
      ER21737             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD JAN LAST YR" 
      ER21738             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD FEB LAST YR" 
      ER21739             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD MAR LAST YR" 
      ER21740             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD APR LAST YR" 
      ER21741             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD MAY LAST YR" 
      ER21742             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD JUN LAST YR" 
      ER21743             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD JUL LAST YR" 
      ER21744             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD AUG LAST YR" 
      ER21745             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD SEP LAST YR" 
      ER21746             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD OCT LAST YR" 
      ER21747             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD NOV LAST YR" 
      ER21748             FORMAT=1.   LABEL="F46 DIFFICULT GET ENUF FOOD DEC LAST YR" 
      ER21749             FORMAT=1.   LABEL="F47 WTR HAVE VEHICLE"                    
      ER21750             FORMAT=2.   LABEL="F48 NUMBER OF VEHICLES"                  
      ER21751             FORMAT=2.   LABEL="F49 MANUFACTURER CODE #1"                
      ER21752             FORMAT=2.   LABEL="F49 VEHICLE MAKE CODE #1"                
      ER21753             FORMAT=4.   LABEL="F49 VEHICLE MODEL YEAR #1"               
      ER21754             FORMAT=1.   LABEL="F49 VEHICLE TYPE CODE #1"                
      ER21755             FORMAT=1.   LABEL="F51 VEHICLE SIZE #1"                     
      ER21756             FORMAT=2.   LABEL="F52 CYPSN OF USUAL DRIVER #1"            
      ER21757             FORMAT=1.   LABEL="F53 HOW ACQUIRED #1"                     
      ER21758             FORMAT=1.   LABEL="F54 WTR NEW OR USED #1"                  
      ER21759             FORMAT=4.   LABEL="F55 YR ACQUIRED #1"                      
      ER21760             FORMAT=2.   LABEL="F56 MO ACQUIRED #1"                      
      ER21761             FORMAT=1.   LABEL="F57 WTR USED FOR BUSINESS #1"            
      ER21762             FORMAT=1.   LABEL="F58 WTR USED MOSTLY FOR BUSINESS #1"     
      ER21763             FORMAT=1.   LABEL="F59 WTR FOR DISABLED PERSON #1"          
      ER21764             FORMAT=1.   LABEL="F60 WTR OWN/LEASE >3 YR OLD VEHICLE #1"  
      ER21765             FORMAT=6.   LABEL="F61 TOTAL PRICE #1"                      
      ER21766             FORMAT=1.   LABEL="F62 WTR TRADE-IN #1"                     
      ER21767             FORMAT=6.   LABEL="F63 TRADE-IN AMOUNT #1"                  
      ER21768             FORMAT=6.   LABEL="F64 CASH DOWNPMT AMT #1"                 
      ER21769             FORMAT=1.   LABEL="F65 WTR GOT LOAN #1"                     
      ER21770             FORMAT=6.   LABEL="F66 LOAN AMOUNT #1"                      
      ER21771             FORMAT=6.   LABEL="F67 LOAN PAYMENT AMT #1"                 
      ER21772             FORMAT=1.   LABEL="F67 LOAN PMT AMT PER #1"                 
      ER21773             FORMAT=3.   LABEL="F69 LOAN TOTAL # PMTS #1"                
      ER21774             FORMAT=3.   LABEL="F70 LOAN # PMTS MADE #1"                 
      ER21775             FORMAT=6.   LABEL="F71 LEASE INITIAL OUTLAY #1"             
      ER21776             FORMAT=6.   LABEL="F72 LEASE PMT AMOUNT #1"                 
      ER21777             FORMAT=1.   LABEL="F72 LEASE AMOUNT PER #1"                 
      ER21778             FORMAT=3.   LABEL="F73 LEASE TOTAL # PMTS #1"               
      ER21779             FORMAT=3.   LABEL="F74 LEASE # PMTS MADE #1"                
      ER21780             FORMAT=2.   LABEL="F49 MANUFACTURER CODE #2"                
      ER21781             FORMAT=2.   LABEL="F49 VEHICLE MAKE CODE #2"                
      ER21782             FORMAT=4.   LABEL="F49 VEHICLE MODEL YEAR #2"               
      ER21783             FORMAT=1.   LABEL="F49 VEHICLE TYPE CODE #2"                
      ER21784             FORMAT=1.   LABEL="F51 VEHICLE SIZE #2"                     
      ER21785             FORMAT=2.   LABEL="F52 CYPSN OF USUAL DRIVER #2"            
      ER21786             FORMAT=1.   LABEL="F53 HOW ACQUIRED #2"                     
      ER21787             FORMAT=1.   LABEL="F54 WTR NEW OR USED #2"                  
      ER21788             FORMAT=4.   LABEL="F55 YR ACQUIRED #2"                      
      ER21789             FORMAT=2.   LABEL="F55 MO ACQUIRED #2"                      
      ER21790             FORMAT=1.   LABEL="F57 WTR USED FOR BUSINESS #2"            
      ER21791             FORMAT=1.   LABEL="F58 WTR MOSTLY FOR BUSINESS #2"          
      ER21792             FORMAT=1.   LABEL="F59 WTR FOR DISABLED PERSON #2"          
      ER21793             FORMAT=1.   LABEL="F60 CKPT: WTR OWN >3 YR OLD VEHICLE #2"  
      ER21794             FORMAT=6.   LABEL="F61 TOTAL PRICE #2"                      
      ER21795             FORMAT=1.   LABEL="F62 WTR TRADE-IN #2"                     
      ER21796             FORMAT=6.   LABEL="F63 TRADE-IN AMOUNT #2"                  
      ER21797             FORMAT=6.   LABEL="F64 CASH DOWNPMT AMT #2"                 
      ER21798             FORMAT=1.   LABEL="F65 WTR GOT LOAN #2"                     
      ER21799             FORMAT=6.   LABEL="F66 LOAN AMOUNT #2"                      
      ER21800             FORMAT=6.   LABEL="F67 LOAN PAYMENT AMT #2"                 
      ER21801             FORMAT=1.   LABEL="F67 LOAN PMT AMT PER #2"                 
      ER21802             FORMAT=3.   LABEL="F69 LOAN TOT # PMTS #2"                  
      ER21803             FORMAT=3.   LABEL="F70 LOAN # PMTS MADE #2"                 
      ER21804             FORMAT=6.   LABEL="F71 LEASE INITIAL OUTLAY #2"             
      ER21805             FORMAT=6.   LABEL="F72 LEASE PMT AMOUNT #2"                 
      ER21806             FORMAT=1.   LABEL="F72 LEASE AMOUNT PER #2"                 
      ER21807             FORMAT=3.   LABEL="F73 LEASE TOTAL # PMTS #2"               
      ER21808             FORMAT=3.   LABEL="F74 LEASE # PMTS MADE #2"                
      ER21809             FORMAT=2.   LABEL="F49 MANUFACTURER CODE #3"                
      ER21810             FORMAT=2.   LABEL="F49 VEHICLE MAKE CODE #3"                
      ER21811             FORMAT=4.   LABEL="F49 VEHICLE MODEL YEAR #3"               
      ER21812             FORMAT=1.   LABEL="F49 VEHICLE TYPE CODE #3"                
      ER21813             FORMAT=1.   LABEL="F51 VEHICLE SIZE #3"                     
      ER21814             FORMAT=2.   LABEL="F52 CYPSN OF USUAL DRIVER #3"            
      ER21815             FORMAT=1.   LABEL="F53 HOW ACQUIRED #3"                     
      ER21816             FORMAT=1.   LABEL="F54 WTR NEW OR USED #3"                  
      ER21817             FORMAT=4.   LABEL="F55 YR ACQUIRED #3"                      
      ER21818             FORMAT=2.   LABEL="F56 MO ACQUIRED #3"                      
      ER21819             FORMAT=1.   LABEL="F57 WTR USED FOR BUSINESS #3"            
      ER21820             FORMAT=1.   LABEL="F58 WTR MOSTLY FOR BUSINESS #3"          
      ER21821             FORMAT=1.   LABEL="F59 WTR FOR DISABLED PERSON #3"          
      ER21822             FORMAT=1.   LABEL="F60 CKPT: WTR OWN >3 YR OLD VEHICLE #3"  
      ER21823             FORMAT=6.   LABEL="F61 TOTAL PRICE #3"                      
      ER21824             FORMAT=1.   LABEL="F62 WTR TRADE-IN #3"                     
      ER21825             FORMAT=6.   LABEL="F63 TRADE-IN AMOUNT #3"                  
      ER21826             FORMAT=6.   LABEL="F64 CASH DOWNPMT AMT #3"                 
      ER21827             FORMAT=1.   LABEL="F65 WTR GOT LOAN #3"                     
      ER21828             FORMAT=6.   LABEL="F66 LOAN AMOUNT #3"                      
      ER21829             FORMAT=6.   LABEL="F67 LOAN PAYMENT AMT #3"                 
      ER21830             FORMAT=1.   LABEL="F67 LOAN PMT AMT PER #3"                 
      ER21831             FORMAT=3.   LABEL="F69 LOAN TOTAL # PMTS #3"                
      ER21832             FORMAT=3.   LABEL="F70 LOAN # PMTS MADE #3"                 
      ER21833             FORMAT=6.   LABEL="F71 LEASE INITIAL OUTLAY #3"             
      ER21834             FORMAT=6.   LABEL="F72 LEASE PMT AMOUNT #3"                 
      ER21835             FORMAT=1.   LABEL="F72 LEASE AMOUNT PER #3"                 
      ER21836             FORMAT=3.   LABEL="F73 LEASE TOTAL # PMTS #3"               
      ER21837             FORMAT=3.   LABEL="F74 LEASE # PMTS MADE #3"                
      ER21838             FORMAT=6.   LABEL="F77 CAR INSURANCE EXPENSE"               
      ER21839             FORMAT=1.   LABEL="F77 CAR INSURANCE PER"                   
      ER21840             FORMAT=1.   LABEL="F78CKPT WTR OTR VEHICLES"                
      ER21841             FORMAT=6.   LABEL="F79 ADDL CAR/LEASE PMTS"                 
      ER21842             FORMAT=5.   LABEL="F80A CAR REPAIR EXPENSES"                
      ER21843             FORMAT=5.   LABEL="F80B GASOLINE EXPENSES"                  
      ER21844             FORMAT=5.   LABEL="F80C PARKING EXPENSES"                   
      ER21845             FORMAT=5.   LABEL="F81A BUS/TRAIN FARES"                    
      ER21846             FORMAT=5.   LABEL="F81B CAB FARE EXPENSES"                  
      ER21847             FORMAT=5.   LABEL="F81C OTR TRANSP EXPENSES"                
      ER21848             FORMAT=1.   LABEL="F82 WTR SCHOOL EXPENSES"                 
      ER21849             FORMAT=6.   LABEL="F83 TOTAL SCHOOL EXPENSES"               
      ER21850             FORMAT=1.   LABEL="F84 WTR OTR SCHOOL EXPENSES"             
      ER21851             FORMAT=6.   LABEL="F86 TOTAL OTR SCHOOL EXPENSES"           
      ER21852             FORMAT=1.   LABEL="G1A WHETHER HEAD FARMER"                 
      ER21853             FORMAT=7.   LABEL="G2 TOTAL FARM RECEIPTS"                  
      ER21854             FORMAT=7.   LABEL="G3 PYR FARM EXPENSES"                    
      ER21855             FORMAT=7.   LABEL="G4 PYR NET FARM INCOME"                  
      ER21856             FORMAT=1.   LABEL="ACCURACY OF FARM INCOME"                 
      ER21857             FORMAT=1.   LABEL="G5 WHETHER BUSINESS"                     
      ER21858             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 1"              
      ER21859             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 1?"                 
      ER21860             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 1?"                 
      ER21861             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS1?"                
      ER21862             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS1?"                
      ER21863             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 1"                 
      ER21864             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 1"                 
      ER21865             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 1"                 
      ER21866             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 1"                 
      ER21867             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS1"                  
      ER21868             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS1"                 
      ER21869             FORMAT=7.   LABEL="G11A EXPENSES BUS 1"                     
      ER21870             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 1"                  
      ER21871             FORMAT=1.   LABEL="ACCURACY OF BUSINESS1 PROFIT/LOSS"       
      ER21872             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 2"              
      ER21873             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 2?"                 
      ER21874             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 2?"                 
      ER21875             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS2?"                
      ER21876             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS2?"                
      ER21877             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 2"                 
      ER21878             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 2"                 
      ER21879             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 2"                 
      ER21880             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 2"                 
      ER21881             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS2"                  
      ER21882             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS 2"                
      ER21883             FORMAT=7.   LABEL="G11A EXPENSES BUS 2"                     
      ER21884             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 2"                  
      ER21885             FORMAT=1.   LABEL="ACCURACY OF BUSINESS2 PROFIT/LOSS"       
      ER21886             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 3"              
      ER21887             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 3?"                 
      ER21888             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 3?"                 
      ER21889             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS3?"                
      ER21890             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS3?"                
      ER21891             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 3"                 
      ER21892             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 3"                 
      ER21893             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 3"                 
      ER21894             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 3"                 
      ER21895             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS3"                  
      ER21896             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS 3"                
      ER21897             FORMAT=7.   LABEL="G11A EXPENSES BUS 3"                     
      ER21898             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 3"                  
      ER21899             FORMAT=1.   LABEL="ACCURACY OF BUSINESS3 PROFIT/LOSS"       
      ER21900             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 4"              
      ER21901             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 4?"                 
      ER21902             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 4?"                 
      ER21903             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS4?"                
      ER21904             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS4?"                
      ER21905             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 4"                 
      ER21906             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 4"                 
      ER21907             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 4"                 
      ER21908             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 4"                 
      ER21909             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS4"                  
      ER21910             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS 4"                
      ER21911             FORMAT=7.   LABEL="G11A EXPENSES BUS 4"                     
      ER21912             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 4"                  
      ER21913             FORMAT=1.   LABEL="ACCURACY OF BUSINESS4 PROFIT/LOSS"       
      ER21914             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 5"              
      ER21915             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 5?"                 
      ER21916             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 5?"                 
      ER21917             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS5?"                
      ER21918             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS5?"                
      ER21919             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 5"                 
      ER21920             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 5"                 
      ER21921             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 5"                 
      ER21922             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 5"                 
      ER21923             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS5"                  
      ER21924             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS 5"                
      ER21925             FORMAT=7.   LABEL="G11A EXPENSES BUS 5"                     
      ER21926             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 5"                  
      ER21927             FORMAT=1.   LABEL="ACCURACY OF BUSINESS5 PROFIT/LOSS"       
      ER21928             FORMAT=1.   LABEL="G12 HEAD HAVE WAGES"                     
      ER21929             FORMAT=7.   LABEL="G13 WAGES/SALARY OF HEAD"                
      ER21930             FORMAT=1.   LABEL="ACCURACY OF WAGES/SALARY-HEAD"           
      ER21931             FORMAT=1.   LABEL="G14/16 HD BONUS/OT/COMM"                 
      ER21932             FORMAT=1.   LABEL="HEAD HAVE BONUS"                         
      ER21933             FORMAT=6.   LABEL="AMT HEAD BONUS"                          
      ER21934             FORMAT=1.   LABEL="ACCURACY OF BONUS-HEAD"                  
      ER21935             FORMAT=1.   LABEL="HEAD HAVE OVERTIME"                      
      ER21936             FORMAT=6.   LABEL="AMT HEAD OVERTIME"                       
      ER21937             FORMAT=1.   LABEL="ACCURACY OF OVERTIME-HEAD"               
      ER21938             FORMAT=1.   LABEL="HEAD HAVE TIPS"                          
      ER21939             FORMAT=6.   LABEL="AMT HEAD TIPS"                           
      ER21940             FORMAT=1.   LABEL="ACCURACY OF TIPS-HEAD"                   
      ER21941             FORMAT=1.   LABEL="HEAD HAVE COMMISSION"                    
      ER21942             FORMAT=6.   LABEL="AMT HEAD COMMISSION"                     
      ER21943             FORMAT=1.   LABEL="ACCURACY OF COMMISSION-HEAD"             
      ER21944             FORMAT=1.   LABEL="WTR OTHER LABOR Y-HEAD"                  
      ER21945             FORMAT=6.   LABEL="AMT OTHER LABOR Y-HEAD"                  
      ER21946             FORMAT=1.   LABEL="ACCURACY OF OTHER LABOR Y-HEAD"          
      ER21947             FORMAT=1.   LABEL="WTR WORK HRS FOR WAGES ETC"              
      ER21948             FORMAT=1.   LABEL="G18A WTR HEAD PROF PRACT"                
      ER21949             FORMAT=7.   LABEL="AMT PROF PRACTICE OF HD"                 
      ER21950             FORMAT=1.   LABEL="AMT PROF PRACTICE PER"                   
      ER21951             FORMAT=1.   LABEL="ACCURACY OF PROF PRACTICE-HEAD"          
      ER21952             FORMAT=1.   LABEL="PROF/TRADE INCOME H JAN"                 
      ER21953             FORMAT=1.   LABEL="PROF/TRADE INCOME H FEB"                 
      ER21954             FORMAT=1.   LABEL="PROF/TRADE INCOME H MAR"                 
      ER21955             FORMAT=1.   LABEL="PROF/TRADE INCOME H APR"                 
      ER21956             FORMAT=1.   LABEL="PROF/TRADE INCOME H MAY"                 
      ER21957             FORMAT=1.   LABEL="PROF/TRADE INCOME H JUN"                 
      ER21958             FORMAT=1.   LABEL="PROF/TRADE INCOME H JUL"                 
      ER21959             FORMAT=1.   LABEL="PROF/TRADE INCOME H AUG"                 
      ER21960             FORMAT=1.   LABEL="PROF/TRADE INCOME H SEP"                 
      ER21961             FORMAT=1.   LABEL="PROF/TRADE INCOME H OCT"                 
      ER21962             FORMAT=1.   LABEL="PROF/TRADE INCOME H NOV"                 
      ER21963             FORMAT=1.   LABEL="PROF/TRADE INCOME H DEC"                 
      ER21964             FORMAT=1.   LABEL="G21A WTR WORK HRS FOR PROF PRAC"         
      ER21965             FORMAT=1.   LABEL="G18B WTR HEAD MKT GDNING"                
      ER21966             FORMAT=7.   LABEL="AMT MKT GARDENING OF HD"                 
      ER21967             FORMAT=1.   LABEL="AMT MKT GARDENING PER"                   
      ER21968             FORMAT=1.   LABEL="ACCURACY OF MKT GARDENING-HEAD"          
      ER21969             FORMAT=1.   LABEL="GARDEN/FARM INCOME H JAN"                
      ER21970             FORMAT=1.   LABEL="GARDEN/FARM INCOME H FEB"                
      ER21971             FORMAT=1.   LABEL="GARDEN/FARM INCOME H MAR"                
      ER21972             FORMAT=1.   LABEL="GARDEN/FARM INCOME H APR"                
      ER21973             FORMAT=1.   LABEL="GARDEN/FARM INCOME H MAY"                
      ER21974             FORMAT=1.   LABEL="GARDEN/FARM INCOME H JUN"                
      ER21975             FORMAT=1.   LABEL="GARDEN/FARM INCOME H JUL"                
      ER21976             FORMAT=1.   LABEL="GARDEN/FARM INCOME H AUG"                
      ER21977             FORMAT=1.   LABEL="GARDEN/FARM INCOME H SEP"                
      ER21978             FORMAT=1.   LABEL="GARDEN/FARM INCOME H OCT"                
      ER21979             FORMAT=1.   LABEL="GARDEN/FARM INCOME H NOV"                
      ER21980             FORMAT=1.   LABEL="GARDEN/FARM INCOME H DEC"                
      ER21981             FORMAT=1.   LABEL="G21B WTR WORK HRS FOR MKT GRDNG"         
      ER21982             FORMAT=1.   LABEL="G18C WTR HEAD ROOMERS"                   
      ER21983             FORMAT=7.   LABEL="AMT ROOMERS/BOARDERS HD"                 
      ER21984             FORMAT=1.   LABEL="AMT ROOMERS/BOARDERS PER"                
      ER21985             FORMAT=1.   LABEL="ACCURACY OF ROOMERS/BOARDERS-HEAD"       
      ER21986             FORMAT=1.   LABEL="ROOM/BORD INCOME H JAN"                  
      ER21987             FORMAT=1.   LABEL="ROOM/BORD INCOME H FEB"                  
      ER21988             FORMAT=1.   LABEL="ROOM/BORD INCOME H MAR"                  
      ER21989             FORMAT=1.   LABEL="ROOM/BORD INCOME H APR"                  
      ER21990             FORMAT=1.   LABEL="ROOM/BORD INCOME H MAY"                  
      ER21991             FORMAT=1.   LABEL="ROOM/BORD INCOME H JUN"                  
      ER21992             FORMAT=1.   LABEL="ROOM/BORD INCOME H JUL"                  
      ER21993             FORMAT=1.   LABEL="ROOM/BORD INCOME H AUG"                  
      ER21994             FORMAT=1.   LABEL="ROOM/BORD INCOME H SEP"                  
      ER21995             FORMAT=1.   LABEL="ROOM/BORD INCOME H OCT"                  
      ER21996             FORMAT=1.   LABEL="ROOM/BORD INCOME H NOV"                  
      ER21997             FORMAT=1.   LABEL="ROOM/BORD INCOME H DEC"                  
      ER21998             FORMAT=1.   LABEL="G21C WTR WORK HRS FOR ROOMERS"           
      ER21999             FORMAT=1.   LABEL="G23 WTR INCL EARNINGS XTRA JOB"          
      ER22000             FORMAT=7.   LABEL="AMT FROM XTRA JOBS"                      
      ER22001             FORMAT=1.   LABEL="ACCURACY OF XTRA JOB INCOME-HEAD"        
      ER22002             FORMAT=1.   LABEL="G25A WHETHER RENT HEAD"                  
      ER22003             FORMAT=6.   LABEL="RENT OF HEAD"                            
      ER22004             FORMAT=1.   LABEL="RENT OF HEAD PER"                        
      ER22005             FORMAT=1.   LABEL="ACCURACY OF RENT-HEAD"                   
      ER22006             FORMAT=1.   LABEL="G26A2 WTR RENT JOINT WITH WIFE"          
      ER22007             FORMAT=1.   LABEL="RENT INCOME HEAD JAN"                    
      ER22008             FORMAT=1.   LABEL="RENT INCOME HEAD FEB"                    
      ER22009             FORMAT=1.   LABEL="RENT INCOME HEAD MAR"                    
      ER22010             FORMAT=1.   LABEL="RENT INCOME HEAD APR"                    
      ER22011             FORMAT=1.   LABEL="RENT INCOME HEAD MAY"                    
      ER22012             FORMAT=1.   LABEL="RENT INCOME HEAD JUN"                    
      ER22013             FORMAT=1.   LABEL="RENT INCOME HEAD JUL"                    
      ER22014             FORMAT=1.   LABEL="RENT INCOME HEAD AUG"                    
      ER22015             FORMAT=1.   LABEL="RENT INCOME HEAD SEP"                    
      ER22016             FORMAT=1.   LABEL="RENT INCOME HEAD OCT"                    
      ER22017             FORMAT=1.   LABEL="RENT INCOME HEAD NOV"                    
      ER22018             FORMAT=1.   LABEL="RENT INCOME HEAD DEC"                    
      ER22019             FORMAT=1.   LABEL="G25B WHETHER DIVIDENDS HEAD"             
      ER22020             FORMAT=6.   LABEL="DIVIDENDS OF HEAD"                       
      ER22021             FORMAT=1.   LABEL="DIVIDENDS OF HEAD PER"                   
      ER22022             FORMAT=1.   LABEL="ACCURACY OF DIVIDENDS-HEAD"              
      ER22023             FORMAT=1.   LABEL="G26B2 WTR DIVIDENDS JOINT WITH WIFE"     
      ER22024             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD JAN"                
      ER22025             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD FEB"                
      ER22026             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD MAR"                
      ER22027             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD APR"                
      ER22028             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD MAY"                
      ER22029             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD JUN"                
      ER22030             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD JUL"                
      ER22031             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD AUG"                
      ER22032             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD SEP"                
      ER22033             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD OCT"                
      ER22034             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD NOV"                
      ER22035             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD DEC"                
      ER22036             FORMAT=1.   LABEL="G25C WHETHER INTEREST HEAD"              
      ER22037             FORMAT=6.   LABEL="INTEREST OF HEAD"                        
      ER22038             FORMAT=1.   LABEL="INTEREST OF HEAD PER"                    
      ER22039             FORMAT=1.   LABEL="ACCURACY OF INTEREST-HEAD"               
      ER22040             FORMAT=1.   LABEL="G26C2 WTR INTEREST JOINT WITH WIFE"      
      ER22041             FORMAT=1.   LABEL="INTEREST INCOME HEAD JAN"                
      ER22042             FORMAT=1.   LABEL="INTEREST INCOME HEAD FEB"                
      ER22043             FORMAT=1.   LABEL="INTEREST INCOME HEAD MAR"                
      ER22044             FORMAT=1.   LABEL="INTEREST INCOME HEAD APR"                
      ER22045             FORMAT=1.   LABEL="INTEREST INCOME HEAD MAY"                
      ER22046             FORMAT=1.   LABEL="INTEREST INCOME HEAD JUN"                
      ER22047             FORMAT=1.   LABEL="INTEREST INCOME HEAD JUL"                
      ER22048             FORMAT=1.   LABEL="INTEREST INCOME HEAD AUG"                
      ER22049             FORMAT=1.   LABEL="INTEREST INCOME HEAD SEP"                
      ER22050             FORMAT=1.   LABEL="INTEREST INCOME HEAD OCT"                
      ER22051             FORMAT=1.   LABEL="INTEREST INCOME HEAD NOV"                
      ER22052             FORMAT=1.   LABEL="INTEREST INCOME HEAD DEC"                
      ER22053             FORMAT=1.   LABEL="WHETHER TRUST FUND HEAD"                 
      ER22054             FORMAT=6.   LABEL="G25D TRUST FUND OF HEAD"                 
      ER22055             FORMAT=1.   LABEL="TRUST FUND OF HEAD PER"                  
      ER22056             FORMAT=1.   LABEL="ACCURACY OF TRUST FUND-HEAD"             
      ER22057             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H JAN"                
      ER22058             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H FEB"                
      ER22059             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H MAR"                
      ER22060             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H APR"                
      ER22061             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H MAY"                
      ER22062             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H JUN"                
      ER22063             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H JUL"                
      ER22064             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H AUG"                
      ER22065             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H SEP"                
      ER22066             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H OCT"                
      ER22067             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H NOV"                
      ER22068             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H DEC"                
      ER22069             FORMAT=1.   LABEL="G25E WHETHER ADC/TANF HEAD"              
      ER22070             FORMAT=6.   LABEL="ADC/TANF OF HEAD"                        
      ER22071             FORMAT=1.   LABEL="ADC/TANF OF HEAD PER"                    
      ER22072             FORMAT=1.   LABEL="ACCURACY OF ADC/TANF-HEAD"               
      ER22073             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD JAN"                
      ER22074             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD FEB"                
      ER22075             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD MAR"                
      ER22076             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD APR"                
      ER22077             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD MAY"                
      ER22078             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD JUN"                
      ER22079             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD JUL"                
      ER22080             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD AUG"                
      ER22081             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD SEP"                
      ER22082             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD OCT"                
      ER22083             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD NOV"                
      ER22084             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD DEC"                
      ER22085             FORMAT=1.   LABEL="G25F WHETHER SSI HEAD"                   
      ER22086             FORMAT=1.   LABEL="HEAD SSI SELF/ELSE/BOTH"                 
      ER22087             FORMAT=6.   LABEL="SSI OF HEAD"                             
      ER22088             FORMAT=1.   LABEL="SSI OF HEAD PER"                         
      ER22089             FORMAT=1.   LABEL="ACCURACY OF SSI-HEAD"                    
      ER22090             FORMAT=1.   LABEL="SSI INCOME HEAD JAN"                     
      ER22091             FORMAT=1.   LABEL="SSI INCOME HEAD FEB"                     
      ER22092             FORMAT=1.   LABEL="SSI INCOME HEAD MAR"                     
      ER22093             FORMAT=1.   LABEL="SSI INCOME HEAD APR"                     
      ER22094             FORMAT=1.   LABEL="SSI INCOME HEAD MAY"                     
      ER22095             FORMAT=1.   LABEL="SSI INCOME HEAD JUN"                     
      ER22096             FORMAT=1.   LABEL="SSI INCOME HEAD JUL"                     
      ER22097             FORMAT=1.   LABEL="SSI INCOME HEAD AUG"                     
      ER22098             FORMAT=1.   LABEL="SSI INCOME HEAD SEP"                     
      ER22099             FORMAT=1.   LABEL="SSI INCOME HEAD OCT"                     
      ER22100             FORMAT=1.   LABEL="SSI INCOME HEAD NOV"                     
      ER22101             FORMAT=1.   LABEL="SSI INCOME HEAD DEC"                     
      ER22102             FORMAT=1.   LABEL="G25G WHETHER OTHER WELFARE HD"           
      ER22103             FORMAT=6.   LABEL="OTHER WELFARE OF HEAD"                   
      ER22104             FORMAT=1.   LABEL="OTHER WELFARE OF HD PER"                 
      ER22105             FORMAT=1.   LABEL="ACCURACY OF OTR WELFARE-HEAD"            
      ER22106             FORMAT=1.   LABEL="OTR WELFARE INCOME H JAN"                
      ER22107             FORMAT=1.   LABEL="OTR WELFARE INCOME H FEB"                
      ER22108             FORMAT=1.   LABEL="OTR WELFARE INCOME H MAR"                
      ER22109             FORMAT=1.   LABEL="OTR WELFARE INCOME H APR"                
      ER22110             FORMAT=1.   LABEL="OTR WELFARE INCOME H MAY"                
      ER22111             FORMAT=1.   LABEL="OTR WELFARE INCOME H JUN"                
      ER22112             FORMAT=1.   LABEL="OTR WELFARE INCOME H JUL"                
      ER22113             FORMAT=1.   LABEL="OTR WELFARE INCOME H AUG"                
      ER22114             FORMAT=1.   LABEL="OTR WELFARE INCOME H SEP"                
      ER22115             FORMAT=1.   LABEL="OTR WELFARE INCOME H OCT"                
      ER22116             FORMAT=1.   LABEL="OTR WELFARE INCOME H NOV"                
      ER22117             FORMAT=1.   LABEL="OTR WELFARE INCOME H DEC"                
      ER22118             FORMAT=1.   LABEL="G31 ANY FU MEMB GET SOCSEC"              
      ER22119             FORMAT=1.   LABEL="G37 WHETHER HEAD VA PENSION"             
      ER22120             FORMAT=6.   LABEL="VA PENSION OF HEAD AMT"                  
      ER22121             FORMAT=1.   LABEL="VA PENSION OF HEAD PER"                  
      ER22122             FORMAT=1.   LABEL="ACCURACY OF VA PENSION-HEAD"             
      ER22123             FORMAT=1.   LABEL="VA INCOME HEAD JAN"                      
      ER22124             FORMAT=1.   LABEL="VA INCOME HEAD FEB"                      
      ER22125             FORMAT=1.   LABEL="VA INCOME HEAD MAR"                      
      ER22126             FORMAT=1.   LABEL="VA INCOME HEAD APR"                      
      ER22127             FORMAT=1.   LABEL="VA INCOME HEAD MAY"                      
      ER22128             FORMAT=1.   LABEL="VA INCOME HEAD JUN"                      
      ER22129             FORMAT=1.   LABEL="VA INCOME HEAD JUL"                      
      ER22130             FORMAT=1.   LABEL="VA INCOME HEAD AUG"                      
      ER22131             FORMAT=1.   LABEL="VA INCOME HEAD SEP"                      
      ER22132             FORMAT=1.   LABEL="VA INCOME HEAD OCT"                      
      ER22133             FORMAT=1.   LABEL="VA INCOME HEAD NOV"                      
      ER22134             FORMAT=1.   LABEL="VA INCOME HEAD DEC"                      
      ER22135             FORMAT=1.   LABEL="G40A WTR NONVA RETIREMT-HEAD"            
      ER22136             FORMAT=6.   LABEL="NONVA RETIREMENT-HEAD"                   
      ER22137             FORMAT=1.   LABEL="NONVA RETIREMENT PER-HD"                 
      ER22138             FORMAT=1.   LABEL="ACCURACY OF NONVA RETIREMENT-HEAD"       
      ER22139             FORMAT=1.   LABEL="RETIREMENT INCOME H JAN"                 
      ER22140             FORMAT=1.   LABEL="RETIREMENT INCOME H FEB"                 
      ER22141             FORMAT=1.   LABEL="RETIREMENT INCOME H MAR"                 
      ER22142             FORMAT=1.   LABEL="RETIREMENT INCOME H APR"                 
      ER22143             FORMAT=1.   LABEL="RETIREMENT INCOME H MAY"                 
      ER22144             FORMAT=1.   LABEL="RETIREMENT INCOME H JUN"                 
      ER22145             FORMAT=1.   LABEL="RETIREMENT INCOME H JUL"                 
      ER22146             FORMAT=1.   LABEL="RETIREMENT INCOME H AUG"                 
      ER22147             FORMAT=1.   LABEL="RETIREMENT INCOME H SEP"                 
      ER22148             FORMAT=1.   LABEL="RETIREMENT INCOME H OCT"                 
      ER22149             FORMAT=1.   LABEL="RETIREMENT INCOME H NOV"                 
      ER22150             FORMAT=1.   LABEL="RETIREMENT INCOME H DEC"                 
      ER22151             FORMAT=1.   LABEL="G40B WHETHER HEAD ANNUITIES"             
      ER22152             FORMAT=6.   LABEL="ANNUITIES OF HEAD"                       
      ER22153             FORMAT=1.   LABEL="ANNUITIES OF HEAD PER"                   
      ER22154             FORMAT=1.   LABEL="ACCURACY OF ANNUITIES-HEAD"              
      ER22155             FORMAT=1.   LABEL="ANNUITIES INCOME JAN"                    
      ER22156             FORMAT=1.   LABEL="ANNUITIES INCOME FEB"                    
      ER22157             FORMAT=1.   LABEL="ANNUITIES INCOME MAR"                    
      ER22158             FORMAT=1.   LABEL="ANNUITIES INCOME APR"                    
      ER22159             FORMAT=1.   LABEL="ANNUITIES INCOME MAY"                    
      ER22160             FORMAT=1.   LABEL="ANNUITIES INCOME JUN"                    
      ER22161             FORMAT=1.   LABEL="ANNUITIES INCOME JUL"                    
      ER22162             FORMAT=1.   LABEL="ANNUITIES INCOME AUG"                    
      ER22163             FORMAT=1.   LABEL="ANNUITIES INCOME SEP"                    
      ER22164             FORMAT=1.   LABEL="ANNUITIES INCOME OCT"                    
      ER22165             FORMAT=1.   LABEL="ANNUITIES INCOME NOV"                    
      ER22166             FORMAT=1.   LABEL="ANNUITIES INCOME DEC"                    
      ER22167             FORMAT=1.   LABEL="G40C WHETHER HEAD OTR PENSION"           
      ER22168             FORMAT=6.   LABEL="OTHER PENSION OF HEAD"                   
      ER22169             FORMAT=1.   LABEL="OTHER PENSION OF HD PER"                 
      ER22170             FORMAT=1.   LABEL="ACCURACY OF OTR PENSION-HEAD"            
      ER22171             FORMAT=1.   LABEL="OTR PENSION HEAD JAN"                    
      ER22172             FORMAT=1.   LABEL="OTR PENSION HEAD FEB"                    
      ER22173             FORMAT=1.   LABEL="OTR PENSION HEAD MAR"                    
      ER22174             FORMAT=1.   LABEL="OTR PENSION HEAD APR"                    
      ER22175             FORMAT=1.   LABEL="OTR PENSION HEAD MAY"                    
      ER22176             FORMAT=1.   LABEL="OTR PENSION HEAD JUN"                    
      ER22177             FORMAT=1.   LABEL="OTR PENSION HEAD JUL"                    
      ER22178             FORMAT=1.   LABEL="OTR PENSION HEAD AUG"                    
      ER22179             FORMAT=1.   LABEL="OTR PENSION HEAD SEP"                    
      ER22180             FORMAT=1.   LABEL="OTR PENSION HEAD OCT"                    
      ER22181             FORMAT=1.   LABEL="OTR PENSION HEAD NOV"                    
      ER22182             FORMAT=1.   LABEL="OTR PENSION HEAD DEC"                    
      ER22183             FORMAT=1.   LABEL="G43 NUM OF HEAD NON VA PENSN"            
      ER22184             FORMAT=1.   LABEL="G44A WTR UNEMPL COMP OF HEAD"            
      ER22185             FORMAT=6.   LABEL="AMT UNEMPL COMP OF HEAD"                 
      ER22186             FORMAT=1.   LABEL="AMT UNEMPL COMP HD PER"                  
      ER22187             FORMAT=1.   LABEL="ACCURACY OF UNEMPL COMP-HEAD"            
      ER22188             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD JAN"                
      ER22189             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD FEB"                
      ER22190             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD MAR"                
      ER22191             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD APR"                
      ER22192             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD MAY"                
      ER22193             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD JUN"                
      ER22194             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD JUL"                
      ER22195             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD AUG"                
      ER22196             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD SEP"                
      ER22197             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD OCT"                
      ER22198             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD NOV"                
      ER22199             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD DEC"                
      ER22200             FORMAT=1.   LABEL="G44B WTR WORKMEN COMP OF HEAD"           
      ER22201             FORMAT=6.   LABEL="AMT WORKMEN COMP OF HEAD"                
      ER22202             FORMAT=1.   LABEL="AMT WORKMEN COMP HD PER"                 
      ER22203             FORMAT=1.   LABEL="ACCURACY OF WORKMEN COMP-HEAD"           
      ER22204             FORMAT=1.   LABEL="WORKER COMP INCOME H JAN"                
      ER22205             FORMAT=1.   LABEL="WORKER COMP INCOME H FEB"                
      ER22206             FORMAT=1.   LABEL="WORKER COMP INCOME H MAR"                
      ER22207             FORMAT=1.   LABEL="WORKER COMP INCOME H APR"                
      ER22208             FORMAT=1.   LABEL="WORKER COMP INCOME H MAY"                
      ER22209             FORMAT=1.   LABEL="WORKER COMP INCOME H JUN"                
      ER22210             FORMAT=1.   LABEL="WORKER COMP INCOME H JUL"                
      ER22211             FORMAT=1.   LABEL="WORKER COMP INCOME H AUG"                
      ER22212             FORMAT=1.   LABEL="WORKER COMP INCOME H SEP"                
      ER22213             FORMAT=1.   LABEL="WORKER COMP INCOME H OCT"                
      ER22214             FORMAT=1.   LABEL="WORKER COMP INCOME H NOV"                
      ER22215             FORMAT=1.   LABEL="WORKER COMP INCOME H DEC"                
      ER22216             FORMAT=1.   LABEL="G44C WTR CHILD SUPPORT OF HD"            
      ER22217             FORMAT=6.   LABEL="AMT CHILD SUPPORT OF HD"                 
      ER22218             FORMAT=1.   LABEL="AMT CHILD SUPPORT HD PER"                
      ER22219             FORMAT=1.   LABEL="ACCURACY OF CHILD SUPPORT-HEAD"          
      ER22220             FORMAT=1.   LABEL="CHILD SUPPORT INC H JAN"                 
      ER22221             FORMAT=1.   LABEL="CHILD SUPPORT INC H FEB"                 
      ER22222             FORMAT=1.   LABEL="CHILD SUPPORT INC H MAR"                 
      ER22223             FORMAT=1.   LABEL="CHILD SUPPORT INC H APR"                 
      ER22224             FORMAT=1.   LABEL="CHILD SUPPORT INC H MAY"                 
      ER22225             FORMAT=1.   LABEL="CHILD SUPPORT INC H JUN"                 
      ER22226             FORMAT=1.   LABEL="CHILD SUPPORT INC H JUL"                 
      ER22227             FORMAT=1.   LABEL="CHILD SUPPORT INC H AUG"                 
      ER22228             FORMAT=1.   LABEL="CHILD SUPPORT INC H SEP"                 
      ER22229             FORMAT=1.   LABEL="CHILD SUPPORT INC H OCT"                 
      ER22230             FORMAT=1.   LABEL="CHILD SUPPORT INC H NOV"                 
      ER22231             FORMAT=1.   LABEL="CHILD SUPPORT INC H DEC"                 
      ER22232             FORMAT=1.   LABEL="G44D WTR ALIMONY OF HEAD"                
      ER22233             FORMAT=6.   LABEL="AMT ALIMONY OF HEAD"                     
      ER22234             FORMAT=1.   LABEL="AMT ALIMONY OF HEAD PER"                 
      ER22235             FORMAT=1.   LABEL="ACCURACY OF ALIMONY-HEAD"                
      ER22236             FORMAT=1.   LABEL="ALIMONY INCOME HEAD JAN"                 
      ER22237             FORMAT=1.   LABEL="ALIMONY INCOME HEAD FEB"                 
      ER22238             FORMAT=1.   LABEL="ALIMONY INCOME HEAD MAR"                 
      ER22239             FORMAT=1.   LABEL="ALIMONY INCOME HEAD APR"                 
      ER22240             FORMAT=1.   LABEL="ALIMONY INCOME HEAD MAY"                 
      ER22241             FORMAT=1.   LABEL="ALIMONY INCOME HEAD JUN"                 
      ER22242             FORMAT=1.   LABEL="ALIMONY INCOME HEAD JUL"                 
      ER22243             FORMAT=1.   LABEL="ALIMONY INCOME HEAD AUG"                 
      ER22244             FORMAT=1.   LABEL="ALIMONY INCOME HEAD SEP"                 
      ER22245             FORMAT=1.   LABEL="ALIMONY INCOME HEAD OCT"                 
      ER22246             FORMAT=1.   LABEL="ALIMONY INCOME HEAD NOV"                 
      ER22247             FORMAT=1.   LABEL="ALIMONY INCOME HEAD DEC"                 
      ER22248             FORMAT=1.   LABEL="G44E WTR HELP FRM RELATIV HEAD"          
      ER22249             FORMAT=6.   LABEL="AMT HELP FRM RELATIV HD"                 
      ER22250             FORMAT=1.   LABEL="AMT HELP FRM RELATIV PER"                
      ER22251             FORMAT=1.   LABEL="ACCURACY OF HELP FRM RELATIV-HEAD"       
      ER22252             FORMAT=1.   LABEL="HELP FROM RELATIVE H JAN"                
      ER22253             FORMAT=1.   LABEL="HELP FROM RELATIVE H FEB"                
      ER22254             FORMAT=1.   LABEL="HELP FROM RELATIVE H MAR"                
      ER22255             FORMAT=1.   LABEL="HELP FROM RELATIVE H APR"                
      ER22256             FORMAT=1.   LABEL="HELP FROM RELATIVE H MAY"                
      ER22257             FORMAT=1.   LABEL="HELP FROM RELATIVE H JUN"                
      ER22258             FORMAT=1.   LABEL="HELP FROM RELATIVE H JUL"                
      ER22259             FORMAT=1.   LABEL="HELP FROM RELATIVE H AUG"                
      ER22260             FORMAT=1.   LABEL="HELP FROM RELATIVE H SEP"                
      ER22261             FORMAT=1.   LABEL="HELP FROM RELATIVE H OCT"                
      ER22262             FORMAT=1.   LABEL="HELP FROM RELATIVE H NOV"                
      ER22263             FORMAT=1.   LABEL="HELP FROM RELATIVE H DEC"                
      ER22264             FORMAT=1.   LABEL="G44F WTR HELP FRM OTHERS HEAD"           
      ER22265             FORMAT=6.   LABEL="AMT HELP FRM OTHERS HD"                  
      ER22266             FORMAT=1.   LABEL="AMT HELP FRM OTHERS PER"                 
      ER22267             FORMAT=1.   LABEL="ACCURACY OF HELP FRM OTHERS-HEAD"        
      ER22268             FORMAT=1.   LABEL="HELP FROM OTHERS H JAN"                  
      ER22269             FORMAT=1.   LABEL="HELP FROM OTHERS H FEB"                  
      ER22270             FORMAT=1.   LABEL="HELP FROM OTHERS H MAR"                  
      ER22271             FORMAT=1.   LABEL="HELP FROM OTHERS H APR"                  
      ER22272             FORMAT=1.   LABEL="HELP FROM OTHERS H MAY"                  
      ER22273             FORMAT=1.   LABEL="HELP FROM OTHERS H JUN"                  
      ER22274             FORMAT=1.   LABEL="HELP FROM OTHERS H JUL"                  
      ER22275             FORMAT=1.   LABEL="HELP FROM OTHERS H AUG"                  
      ER22276             FORMAT=1.   LABEL="HELP FROM OTHERS H SEP"                  
      ER22277             FORMAT=1.   LABEL="HELP FROM OTHERS H OCT"                  
      ER22278             FORMAT=1.   LABEL="HELP FROM OTHERS H NOV"                  
      ER22279             FORMAT=1.   LABEL="HELP FROM OTHERS H DEC"                  
      ER22280             FORMAT=1.   LABEL="G44G WTR ANYTHING ELSE OF HD"            
      ER22281             FORMAT=6.   LABEL="AMT ANYTHING ELSE OF HD"                 
      ER22282             FORMAT=1.   LABEL="AMT ANYTHING ELSE PER"                   
      ER22283             FORMAT=1.   LABEL="ACCURACY OF ANYTHING ELSE-HEAD"          
      ER22284             FORMAT=1.   LABEL="ANY OTHER INCOME H JAN"                  
      ER22285             FORMAT=1.   LABEL="ANY OTHER INCOME H FEB"                  
      ER22286             FORMAT=1.   LABEL="ANY OTHER INCOME H MAR"                  
      ER22287             FORMAT=1.   LABEL="ANY OTHER INCOME H APR"                  
      ER22288             FORMAT=1.   LABEL="ANY OTHER INCOME H MAY"                  
      ER22289             FORMAT=1.   LABEL="ANY OTHER INCOME H JUN"                  
      ER22290             FORMAT=1.   LABEL="ANY OTHER INCOME H JUL"                  
      ER22291             FORMAT=1.   LABEL="ANY OTHER INCOME H AUG"                  
      ER22292             FORMAT=1.   LABEL="ANY OTHER INCOME H SEP"                  
      ER22293             FORMAT=1.   LABEL="ANY OTHER INCOME H OCT"                  
      ER22294             FORMAT=1.   LABEL="ANY OTHER INCOME H NOV"                  
      ER22295             FORMAT=1.   LABEL="ANY OTHER INCOME H DEC"                  
      ER22296             FORMAT=1.   LABEL="G49 WTR WIFE IN FU NOW"                  
      ER22297             FORMAT=1.   LABEL="G50 WHETHER WIFE HAD INCOME"             
      ER22298             FORMAT=1.   LABEL="G51A WHETHER WIFE LABOR INC"             
      ER22299             FORMAT=1.   LABEL="G51B WHETHER WFE INC FRM WORK"           
      ER22300             FORMAT=7.   LABEL="WAGES/SALARY OF WIFE"                    
      ER22301             FORMAT=1.   LABEL="ACCURACY OF WAGES/SALARY-WIFE"           
      ER22302             FORMAT=1.   LABEL="G52B WTR WORK HOURS FOR WIFE"            
      ER22303             FORMAT=1.   LABEL="G53 WHETHER UNEMPLOYMENT WFE"            
      ER22304             FORMAT=6.   LABEL="UNEMPLOYMNT COMP OF WIFE"                
      ER22305             FORMAT=1.   LABEL="UNEMPLOYMNT COMP WFE PER"                
      ER22306             FORMAT=1.   LABEL="ACCURACY OF UNEMPLOYMENT COMP-WIFE"      
      ER22307             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE JAN"                
      ER22308             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE FEB"                
      ER22309             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE MAR"                
      ER22310             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE APR"                
      ER22311             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE MAY"                
      ER22312             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE JUN"                
      ER22313             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE JUL"                
      ER22314             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE AUG"                
      ER22315             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE SEP"                
      ER22316             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE OCT"                
      ER22317             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE NOV"                
      ER22318             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE DEC"                
      ER22319             FORMAT=1.   LABEL="G56 WHETHER WORKERS COMP WFE"            
      ER22320             FORMAT=6.   LABEL="WORKERS COMP OF WIFE"                    
      ER22321             FORMAT=1.   LABEL="WORKERS COMP OF WIFE PER"                
      ER22322             FORMAT=1.   LABEL="ACCURACY OF WORKERS COMP-WIFE"           
      ER22323             FORMAT=1.   LABEL="WORKER COMP INCOME W JAN"                
      ER22324             FORMAT=1.   LABEL="WORKER COMP INCOME W FEB"                
      ER22325             FORMAT=1.   LABEL="WORKER COMP INCOME W MAR"                
      ER22326             FORMAT=1.   LABEL="WORKER COMP INCOME W APR"                
      ER22327             FORMAT=1.   LABEL="WORKER COMP INCOME W MAY"                
      ER22328             FORMAT=1.   LABEL="WORKER COMP INCOME W JUN"                
      ER22329             FORMAT=1.   LABEL="WORKER COMP INCOME W JUL"                
      ER22330             FORMAT=1.   LABEL="WORKER COMP INCOME W AUG"                
      ER22331             FORMAT=1.   LABEL="WORKER COMP INCOME W SEP"                
      ER22332             FORMAT=1.   LABEL="WORKER COMP INCOME W OCT"                
      ER22333             FORMAT=1.   LABEL="WORKER COMP INCOME W NOV"                
      ER22334             FORMAT=1.   LABEL="WORKER COMP INCOME W DEC"                
      ER22335             FORMAT=1.   LABEL="G59A WHETHER WIFE RENT"                  
      ER22336             FORMAT=6.   LABEL="RENT OF WIFE AMT"                        
      ER22337             FORMAT=1.   LABEL="RENT OF WIFE PER"                        
      ER22338             FORMAT=1.   LABEL="ACCURACY OF RENT-WIFE"                   
      ER22339             FORMAT=1.   LABEL="G59A3 WTR RENT ADDITIONAL TO HEAD AMT"   
      ER22340             FORMAT=1.   LABEL="RENT INCOME WIFE JAN"                    
      ER22341             FORMAT=1.   LABEL="RENT INCOME WIFE FEB"                    
      ER22342             FORMAT=1.   LABEL="RENT INCOME WIFE MAR"                    
      ER22343             FORMAT=1.   LABEL="RENT INCOME WIFE APR"                    
      ER22344             FORMAT=1.   LABEL="RENT INCOME WIFE MAY"                    
      ER22345             FORMAT=1.   LABEL="RENT INCOME WIFE JUN"                    
      ER22346             FORMAT=1.   LABEL="RENT INCOME WIFE JUL"                    
      ER22347             FORMAT=1.   LABEL="RENT INCOME WIFE AUG"                    
      ER22348             FORMAT=1.   LABEL="RENT INCOME WIFE SEP"                    
      ER22349             FORMAT=1.   LABEL="RENT INCOME WIFE OCT"                    
      ER22350             FORMAT=1.   LABEL="RENT INCOME WIFE NOV"                    
      ER22351             FORMAT=1.   LABEL="RENT INCOME WIFE DEC"                    
      ER22352             FORMAT=1.   LABEL="G59B WHETHER WIFE DIVIDENDS"             
      ER22353             FORMAT=6.   LABEL="DIVIDENDS OF WIFE AMT"                   
      ER22354             FORMAT=1.   LABEL="DIVIDENDS OF WIFE PER"                   
      ER22355             FORMAT=1.   LABEL="ACCURACY OF DIVIDENDS-WIFE"              
      ER22356             FORMAT=1.   LABEL="G59B3 WTR DIVS ADDITIONAL TO HEAD AMT"   
      ER22357             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE JAN"                
      ER22358             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE FEB"                
      ER22359             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE MAR"                
      ER22360             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE APR"                
      ER22361             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE MAY"                
      ER22362             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE JUN"                
      ER22363             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE JUL"                
      ER22364             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE AUG"                
      ER22365             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE SEP"                
      ER22366             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE OCT"                
      ER22367             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE NOV"                
      ER22368             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE DEC"                
      ER22369             FORMAT=1.   LABEL="G59C WHETHER WIFE INTEREST"              
      ER22370             FORMAT=6.   LABEL="INTEREST OF WIFE AMT"                    
      ER22371             FORMAT=1.   LABEL="INTEREST OF WIFE AMT PER"                
      ER22372             FORMAT=1.   LABEL="ACCURACY OF INTEREST-WIFE"               
      ER22373             FORMAT=1.   LABEL="G59C3 WTR INTEREST ADDITNL TO HEAD AMT"  
      ER22374             FORMAT=1.   LABEL="INTEREST INCOME WIFE JAN"                
      ER22375             FORMAT=1.   LABEL="INTEREST INCOME WIFE FEB"                
      ER22376             FORMAT=1.   LABEL="INTEREST INCOME WIFE MAR"                
      ER22377             FORMAT=1.   LABEL="INTEREST INCOME WIFE APR"                
      ER22378             FORMAT=1.   LABEL="INTEREST INCOME WIFE MAY"                
      ER22379             FORMAT=1.   LABEL="INTEREST INCOME WIFE JUN"                
      ER22380             FORMAT=1.   LABEL="INTEREST INCOME WIFE JUL"                
      ER22381             FORMAT=1.   LABEL="INTEREST INCOME WIFE AUG"                
      ER22382             FORMAT=1.   LABEL="INTEREST INCOME WIFE SEP"                
      ER22383             FORMAT=1.   LABEL="INTEREST INCOME WIFE OCT"                
      ER22384             FORMAT=1.   LABEL="INTEREST INCOME WIFE NOV"                
      ER22385             FORMAT=1.   LABEL="INTEREST INCOME WIFE DEC"                
      ER22386             FORMAT=1.   LABEL="G59D WHETHER WIFE TRUST FUND"            
      ER22387             FORMAT=6.   LABEL="TRUST FUND OF WIFE AMT"                  
      ER22388             FORMAT=1.   LABEL="TRUST FUND OF WIFE PER"                  
      ER22389             FORMAT=1.   LABEL="ACCURACY OF TRUST FUND-WIFE"             
      ER22390             FORMAT=1.   LABEL="TRUST INCOME WIFE JAN"                   
      ER22391             FORMAT=1.   LABEL="TRUST INCOME WIFE FEB"                   
      ER22392             FORMAT=1.   LABEL="TRUST INCOME WIFE MAR"                   
      ER22393             FORMAT=1.   LABEL="TRUST INCOME WIFE APR"                   
      ER22394             FORMAT=1.   LABEL="TRUST INCOME WIFE MAY"                   
      ER22395             FORMAT=1.   LABEL="TRUST INCOME WIFE JUN"                   
      ER22396             FORMAT=1.   LABEL="TRUST INCOME WIFE JUL"                   
      ER22397             FORMAT=1.   LABEL="TRUST INCOME WIFE AUG"                   
      ER22398             FORMAT=1.   LABEL="TRUST INCOME WIFE SEP"                   
      ER22399             FORMAT=1.   LABEL="TRUST INCOME WIFE OCT"                   
      ER22400             FORMAT=1.   LABEL="TRUST INCOME WIFE NOV"                   
      ER22401             FORMAT=1.   LABEL="TRUST INCOME WIFE DEC"                   
      ER22402             FORMAT=1.   LABEL="G60A WHETHER WIFE RECD SSI"              
      ER22403             FORMAT=1.   LABEL="G60A1 WIFE SSI SELF/ELSE/BOTH"           
      ER22404             FORMAT=6.   LABEL="SSI OF WIFE AMT"                         
      ER22405             FORMAT=1.   LABEL="SSI OF WIFE AMT PER"                     
      ER22406             FORMAT=1.   LABEL="ACCURACY OF SSI-WIFE"                    
      ER22407             FORMAT=1.   LABEL="SSI INCOME WIFE JAN"                     
      ER22408             FORMAT=1.   LABEL="SSI INCOME WIFE FEB"                     
      ER22409             FORMAT=1.   LABEL="SSI INCOME WIFE MAR"                     
      ER22410             FORMAT=1.   LABEL="SSI INCOME WIFE APR"                     
      ER22411             FORMAT=1.   LABEL="SSI INCOME WIFE MAY"                     
      ER22412             FORMAT=1.   LABEL="SSI INCOME WIFE JUN"                     
      ER22413             FORMAT=1.   LABEL="SSI INCOME WIFE JUL"                     
      ER22414             FORMAT=1.   LABEL="SSI INCOME WIFE AUG"                     
      ER22415             FORMAT=1.   LABEL="SSI INCOME WIFE SEP"                     
      ER22416             FORMAT=1.   LABEL="SSI INCOME WIFE OCT"                     
      ER22417             FORMAT=1.   LABEL="SSI INCOME WIFE NOV"                     
      ER22418             FORMAT=1.   LABEL="SSI INCOME WIFE DEC"                     
      ER22419             FORMAT=1.   LABEL="G60B WTR WIFE RECD ADC/TANF"             
      ER22420             FORMAT=6.   LABEL="ADC/TANF OF WIFE AMT"                    
      ER22421             FORMAT=1.   LABEL="ADC/TANF OF WIFE AMT PER"                
      ER22422             FORMAT=1.   LABEL="ACCURACY OF ADC/TANF-WIFE"               
      ER22423             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE JAN"                
      ER22424             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE FEB"                
      ER22425             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE MAR"                
      ER22426             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE APR"                
      ER22427             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE MAY"                
      ER22428             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE JUN"                
      ER22429             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE JUL"                
      ER22430             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE AUG"                
      ER22431             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE SEP"                
      ER22432             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE OCT"                
      ER22433             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE NOV"                
      ER22434             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE DEC"                
      ER22435             FORMAT=1.   LABEL="G60C WTR WF RECD CHILD SUPPRT"           
      ER22436             FORMAT=6.   LABEL="CHILD SUPPORT OF WF AMT"                 
      ER22437             FORMAT=1.   LABEL="CHILD SUPPORT OF WF PER"                 
      ER22438             FORMAT=1.   LABEL="ACCURACY OF CHILD SUPPORT-WIFE"          
      ER22439             FORMAT=1.   LABEL="CHILD SUPPORT INC W JAN"                 
      ER22440             FORMAT=1.   LABEL="CHILD SUPPORT INC W FEB"                 
      ER22441             FORMAT=1.   LABEL="CHILD SUPPORT INC W MAR"                 
      ER22442             FORMAT=1.   LABEL="CHILD SUPPORT INC W APR"                 
      ER22443             FORMAT=1.   LABEL="CHILD SUPPORT INC W MAY"                 
      ER22444             FORMAT=1.   LABEL="CHILD SUPPORT INC W JUN"                 
      ER22445             FORMAT=1.   LABEL="CHILD SUPPORT INC W JUL"                 
      ER22446             FORMAT=1.   LABEL="CHILD SUPPORT INC W AUG"                 
      ER22447             FORMAT=1.   LABEL="CHILD SUPPORT INC W SEP"                 
      ER22448             FORMAT=1.   LABEL="CHILD SUPPORT INC W OCT"                 
      ER22449             FORMAT=1.   LABEL="CHILD SUPPORT INC W NOV"                 
      ER22450             FORMAT=1.   LABEL="CHILD SUPPORT INC W DEC"                 
      ER22451             FORMAT=1.   LABEL="G60D WTR WF RECD OTR WELFARE"            
      ER22452             FORMAT=6.   LABEL="OTHER WELFARE OF WF AMT"                 
      ER22453             FORMAT=1.   LABEL="OTHER WELFARE OF WF PER"                 
      ER22454             FORMAT=1.   LABEL="ACCURACY OF OTHER WELFARE-WIFE"          
      ER22455             FORMAT=1.   LABEL="OTHER WELFARE INC W JAN"                 
      ER22456             FORMAT=1.   LABEL="OTHER WELFARE INC W FEB"                 
      ER22457             FORMAT=1.   LABEL="OTHER WELFARE INC W MAR"                 
      ER22458             FORMAT=1.   LABEL="OTHER WELFARE INC W APR"                 
      ER22459             FORMAT=1.   LABEL="OTHER WELFARE INC W MAY"                 
      ER22460             FORMAT=1.   LABEL="OTHER WELFARE INC W JUN"                 
      ER22461             FORMAT=1.   LABEL="OTHER WELFARE INC W JUL"                 
      ER22462             FORMAT=1.   LABEL="OTHER WELFARE INC W AUG"                 
      ER22463             FORMAT=1.   LABEL="OTHER WELFARE INC W SEP"                 
      ER22464             FORMAT=1.   LABEL="OTHER WELFARE INC W OCT"                 
      ER22465             FORMAT=1.   LABEL="OTHER WELFARE INC W NOV"                 
      ER22466             FORMAT=1.   LABEL="OTHER WELFARE INC W DEC"                 
      ER22467             FORMAT=1.   LABEL="G61 WTR WF RECD PENS/ANNUITY"            
      ER22468             FORMAT=6.   LABEL="PENSION/ANNUITY WF AMT"                  
      ER22469             FORMAT=1.   LABEL="PENSION/ANNUITY WF PER"                  
      ER22470             FORMAT=1.   LABEL="ACCURACY OF PENSION/ANNUITY-WIFE"        
      ER22471             FORMAT=1.   LABEL="PENSION/ANNUITY W JAN"                   
      ER22472             FORMAT=1.   LABEL="PENSION/ANNUITY W FEB"                   
      ER22473             FORMAT=1.   LABEL="PENSION/ANNUITY W MAR"                   
      ER22474             FORMAT=1.   LABEL="PENSION/ANNUITY W APR"                   
      ER22475             FORMAT=1.   LABEL="PENSION/ANNUITY W MAY"                   
      ER22476             FORMAT=1.   LABEL="PENSION/ANNUITY W JUN"                   
      ER22477             FORMAT=1.   LABEL="PENSION/ANNUITY W JUL"                   
      ER22478             FORMAT=1.   LABEL="PENSION/ANNUITY W AUG"                   
      ER22479             FORMAT=1.   LABEL="PENSION/ANNUITY W SEP"                   
      ER22480             FORMAT=1.   LABEL="PENSION/ANNUITY W OCT"                   
      ER22481             FORMAT=1.   LABEL="PENSION/ANNUITY W NOV"                   
      ER22482             FORMAT=1.   LABEL="PENSION/ANNUITY W DEC"                   
      ER22483             FORMAT=1.   LABEL="G62A WTR WF HELP FR RELATIVES"           
      ER22484             FORMAT=6.   LABEL="HELP FR RELATIVES WF AMT"                
      ER22485             FORMAT=1.   LABEL="HELP FR RELS WF PER"                     
      ER22486             FORMAT=1.   LABEL="ACCURACY OF HELP FRM RELATIVES-WIFE"     
      ER22487             FORMAT=1.   LABEL="HELP FR RELATIVES WF JAN"                
      ER22488             FORMAT=1.   LABEL="HELP FR RELATIVES WF FEB"                
      ER22489             FORMAT=1.   LABEL="HELP FR RELATIVES WF MAR"                
      ER22490             FORMAT=1.   LABEL="HELP FR RELATIVES WF APR"                
      ER22491             FORMAT=1.   LABEL="HELP FR RELATIVES WF MAY"                
      ER22492             FORMAT=1.   LABEL="HELP FR RELATIVES WF JUN"                
      ER22493             FORMAT=1.   LABEL="HELP FR RELATIVES WF JUL"                
      ER22494             FORMAT=1.   LABEL="HELP FR RELATIVES WF AUG"                
      ER22495             FORMAT=1.   LABEL="HELP FR RELATIVES WF SEP"                
      ER22496             FORMAT=1.   LABEL="HELP FR RELATIVES WF OCT"                
      ER22497             FORMAT=1.   LABEL="HELP FR RELATIVES WF NOV"                
      ER22498             FORMAT=1.   LABEL="HELP FR RELATIVES WF DEC"                
      ER22499             FORMAT=1.   LABEL="G62B WTR WF HELP FROM FRIENDS"           
      ER22500             FORMAT=6.   LABEL="HELP FR FRIENDS WF AMT"                  
      ER22501             FORMAT=1.   LABEL="HELP FR FRIENDS WF PER"                  
      ER22502             FORMAT=1.   LABEL="ACCURACY OF HELP FRM FRIENDS-WIFE"       
      ER22503             FORMAT=1.   LABEL="HELP FROM FRIENDS W JAN"                 
      ER22504             FORMAT=1.   LABEL="HELP FROM FRIENDS W FEB"                 
      ER22505             FORMAT=1.   LABEL="HELP FROM FRIENDS W MAR"                 
      ER22506             FORMAT=1.   LABEL="HELP FROM FRIENDS W APR"                 
      ER22507             FORMAT=1.   LABEL="HELP FROM FRIENDS W MAY"                 
      ER22508             FORMAT=1.   LABEL="HELP FROM FRIENDS W JUN"                 
      ER22509             FORMAT=1.   LABEL="HELP FROM FRIENDS W JUL"                 
      ER22510             FORMAT=1.   LABEL="HELP FROM FRIENDS W AUG"                 
      ER22511             FORMAT=1.   LABEL="HELP FROM FRIENDS W SEP"                 
      ER22512             FORMAT=1.   LABEL="HELP FROM FRIENDS W OCT"                 
      ER22513             FORMAT=1.   LABEL="HELP FROM FRIENDS W NOV"                 
      ER22514             FORMAT=1.   LABEL="HELP FROM FRIENDS W DEC"                 
      ER22515             FORMAT=1.   LABEL="G63 WTR WFE RECD OTR INCOME"             
      ER22516             FORMAT=5.   LABEL="WIFE OTHER INCOME AMT"                   
      ER22517             FORMAT=1.   LABEL="WIFE OTHER INCOME PER"                   
      ER22518             FORMAT=1.   LABEL="ACCURACY OF OTHER INCOME-WIFE"           
      ER22519             FORMAT=1.   LABEL="ANY OTHER INCOME W JAN"                  
      ER22520             FORMAT=1.   LABEL="ANY OTHER INCOME W FEB"                  
      ER22521             FORMAT=1.   LABEL="ANY OTHER INCOME W MAR"                  
      ER22522             FORMAT=1.   LABEL="ANY OTHER INCOME W APR"                  
      ER22523             FORMAT=1.   LABEL="ANY OTHER INCOME W MAY"                  
      ER22524             FORMAT=1.   LABEL="ANY OTHER INCOME W JUN"                  
      ER22525             FORMAT=1.   LABEL="ANY OTHER INCOME W JUL"                  
      ER22526             FORMAT=1.   LABEL="ANY OTHER INCOME W AUG"                  
      ER22527             FORMAT=1.   LABEL="ANY OTHER INCOME W SEP"                  
      ER22528             FORMAT=1.   LABEL="ANY OTHER INCOME W OCT"                  
      ER22529             FORMAT=1.   LABEL="ANY OTHER INCOME W NOV"                  
      ER22530             FORMAT=1.   LABEL="ANY OTHER INCOME W DEC"                  
      ER22531             FORMAT=1.   LABEL="G99 WTR LUMP SUM PAYMNTS"                
      ER22532             FORMAT=7.   LABEL="G100 LUMP SUM PAYMENTS"                  
      ER22533             FORMAT=7.   LABEL="G101 INHERITANCE"                        
      ER22534             FORMAT=1.   LABEL="G102 WTR ITEMIZE FOR TAX"                
      ER22535             FORMAT=6.   LABEL="G102A ITEMIZED CHARITABLE CONTRIB AMT"   
      ER22536             FORMAT=6.   LABEL="G102B ITEMIZED MEDICAL EXPENSES AMT"     
      ER22537             FORMAT=1.   LABEL="G103 WTR HELP OTRS"                      
      ER22538             FORMAT=2.   LABEL="G104 # OTRS SUPPORTED"                   
      ER22539             FORMAT=2.   LABEL="G105 WHO SUPPORT      1"                 
      ER22540             FORMAT=2.   LABEL="G105 WHO SUPPORT      2"                 
      ER22541             FORMAT=2.   LABEL="G105 WHO SUPPORT      3"                 
      ER22542             FORMAT=2.   LABEL="G105 WHO SUPPORT      4"                 
      ER22543             FORMAT=2.   LABEL="G105 WHO SUPPORT      5"                 
      ER22544             FORMAT=7.   LABEL="G106 TOTAL SUPP OF OTRS"                 
      ER22545             FORMAT=1.   LABEL="G107 ANY CHILD SUPPORT"                  
      ER22546             FORMAT=7.   LABEL="AMT OF CHLD SUPPRT GIVEN"                
      ER22547             FORMAT=1.   LABEL="G109 ANY ALIMONY"                        
      ER22548             FORMAT=7.   LABEL="AMT OF ALIMONY GIVEN"                    
      ER22549             FORMAT=1.   LABEL="G112 WTR DEPNDT OTRS"                    
      ER22550             FORMAT=2.   LABEL="G113 NUMBER DEPNDT OTR"                  
      ER22551             FORMAT=1.   LABEL="G114 WTR DEPNDT OTHS"                    
      ER22552             FORMAT=1.   LABEL="W1 WTR OTR REAL ESTATE"                  
      ER22553             FORMAT=1.   LABEL="W1A WTR SECOND HOME"                     
      ER22554             FORMAT=9.   LABEL="W2 PROFIT IF SOLD OTR REAL ESTATE"       
      ER22555             FORMAT=1.   LABEL="W3 WTR PROFIT GE 50,000"                 
      ER22556             FORMAT=1.   LABEL="W4 WTR PROFIT GE 150,000"                
      ER22557             FORMAT=1.   LABEL="W5 WTR PROFIT GE 5,000"                  
      ER22558             FORMAT=9.   LABEL="W6 PROFIT IF SOLD VEHICLES"              
      ER22559             FORMAT=1.   LABEL="W7 WTR PROFIT GE 10,000"                 
      ER22560             FORMAT=1.   LABEL="W8 WTR PROFIT GE 25,000"                 
      ER22561             FORMAT=1.   LABEL="W9 WTR PROFIT GE 2,000"                  
      ER22562             FORMAT=1.   LABEL="W10 WTR OWN BUSINESS/FARM"               
      ER22563             FORMAT=9.   LABEL="W11 PROFIT IF SOLD BUSINESS/FARM"        
      ER22564             FORMAT=1.   LABEL="W12 WTR PROFIT GE 50,000"                
      ER22565             FORMAT=1.   LABEL="W13 WTR PROFIT GE 200,000"               
      ER22566             FORMAT=1.   LABEL="W14 WTR PROFIT GE 10,000"                
      ER22567             FORMAT=1.   LABEL="W15 WTR OWN NON-IRA STOCK"               
      ER22568             FORMAT=9.   LABEL="W16 PROFIT IF SOLD NON-IRA STOCK"        
      ER22569             FORMAT=1.   LABEL="W17 WTR PROFIT GE 25,000"                
      ER22570             FORMAT=1.   LABEL="W18 WTR PROFIT GE 50,000"                
      ER22571             FORMAT=1.   LABEL="W19 WTR PROFIT GE 5,000"                 
      ER22572             FORMAT=1.   LABEL="W20 WTR PROFIT GE 100,000"               
      ER22573             FORMAT=1.   LABEL="W20D WTR DIVIDEND AMT CORRECT"           
      ER22574             FORMAT=6.   LABEL="W20E REVISED DIVIDENDS"                  
      ER22575             FORMAT=1.   LABEL="W20E REVISED DIVIDENDS PER"              
      ER22576             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN JAN"       
      ER22577             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN FEB"       
      ER22578             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN MAR"       
      ER22579             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN APR"       
      ER22580             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN MAY"       
      ER22581             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN JUN"       
      ER22582             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN JUL"       
      ER22583             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN AUG"       
      ER22584             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN SEP"       
      ER22585             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN OCT"       
      ER22586             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN NOV"       
      ER22587             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN DEC"       
      ER22588             FORMAT=1.   LABEL="W21 WTR IRA/PRIVATE ANNUITY"             
      ER22589             FORMAT=1.   LABEL="W21A HOW FUNDS INVESTED"                 
      ER22590             FORMAT=9.   LABEL="W22 VALUE OF IRA/ANNUITY"                
      ER22591             FORMAT=1.   LABEL="W23 WTR VALUE GE 25,000"                 
      ER22592             FORMAT=1.   LABEL="W24 WTR VALUE GE 50,000"                 
      ER22593             FORMAT=1.   LABEL="W26 WTR VALUE GE 100,000"                
      ER22594             FORMAT=1.   LABEL="W25 WTR VALUE GE 5,000"                  
      ER22595             FORMAT=1.   LABEL="W27 WTR CK/SAVINGS/CD, ETC"              
      ER22596             FORMAT=9.   LABEL="W28 AMT ALL ACCOUNTS"                    
      ER22597             FORMAT=1.   LABEL="W29 WTR VALUE GE 5,000"                  
      ER22598             FORMAT=1.   LABEL="W30 WTR VALUE GE 10,000"                 
      ER22599             FORMAT=1.   LABEL="W31 WTR VALUE GE 50,000"                 
      ER22600             FORMAT=1.   LABEL="W31D WTR INTEREST AMT CORRECT"           
      ER22601             FORMAT=6.   LABEL="W31E REVISED INTEREST"                   
      ER22602             FORMAT=1.   LABEL="W31E REVISED INTEREST PER"               
      ER22603             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN JAN"        
      ER22604             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN FEB"        
      ER22605             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN MAR"        
      ER22606             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN APR"        
      ER22607             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN MAY"        
      ER22608             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN JUN"        
      ER22609             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN JUL"        
      ER22610             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN AUG"        
      ER22611             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN SEP"        
      ER22612             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN OCT"        
      ER22613             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN NOV"        
      ER22614             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN DEC"        
      ER22615             FORMAT=1.   LABEL="W32 WTR VALUE GE 1,000"                  
      ER22616             FORMAT=1.   LABEL="W33 WTR BONDS/INSURANCE, ETC."           
      ER22617             FORMAT=9.   LABEL="W34 PROFIT IF SOLD BONDS/INSURANCE"      
      ER22618             FORMAT=1.   LABEL="W35 WTR PROFIT GE 10,000"                
      ER22619             FORMAT=1.   LABEL="W36 WTR PROFIT GE 25,000"                
      ER22620             FORMAT=1.   LABEL="W37 WTR PROFIT GE 2,000"                 
      ER22621             FORMAT=1.   LABEL="W38 WTR OTHER DEBTS"                     
      ER22622             FORMAT=9.   LABEL="W39 VALUE ALL DEBTS"                     
      ER22623             FORMAT=1.   LABEL="W40 WTR DEBTS GE 2,000"                  
      ER22624             FORMAT=1.   LABEL="W41 WTR DEBTS GE 5,000"                  
      ER22625             FORMAT=1.   LABEL="W42 WTR DEBTS GE 1,000"                  
      ER22626             FORMAT=1.   LABEL="W43 WTR CHANGED IRA/PRIVATE ANNUITY"     
      ER22627             FORMAT=9.   LABEL="W44 AMT INVESTED IN IRA/ANNUITY"         
      ER22628             FORMAT=1.   LABEL="W45 WTR INVEST GE 10,000"                
      ER22629             FORMAT=1.   LABEL="W46 WTR INVEST GE 50,000"                
      ER22630             FORMAT=1.   LABEL="W47 WTR INVEST GE 5,000"                 
      ER22631             FORMAT=1.   LABEL="W48 WTR CASHED PNSN/ANNTY/IRA"           
      ER22632             FORMAT=9.   LABEL="W49 VALUE PENSION/ANNUITY/IRA"           
      ER22633             FORMAT=1.   LABEL="W50 WTR VALUE GE 10,000"                 
      ER22634             FORMAT=1.   LABEL="W51 WTR VALUE GE 50,000"                 
      ER22635             FORMAT=1.   LABEL="W52 WTR VALUE GE 100,000"                
      ER22636             FORMAT=1.   LABEL="W53 WTR VALUE GE 5,000"                  
      ER22637             FORMAT=1.   LABEL="W54 WTR SOLD HOME"                       
      ER22638             FORMAT=9.   LABEL="W55 HOME SELLING PRICE"                  
      ER22639             FORMAT=1.   LABEL="W56 WTR PRICE GE 60,000"                 
      ER22640             FORMAT=1.   LABEL="W57 WTR PRICE GE 120,000"                
      ER22641             FORMAT=1.   LABEL="W58 WTR PRICE GE 30,000"                 
      ER22642             FORMAT=1.   LABEL="W59 WTR BOUGHT OTR REAL ESTATE"          
      ER22643             FORMAT=9.   LABEL="W60 AMT IN REAL ESTATE"                  
      ER22644             FORMAT=1.   LABEL="W61 WTR AMT GE 60,000"                   
      ER22645             FORMAT=1.   LABEL="W62 WTR AMT GE 120,000"                  
      ER22646             FORMAT=1.   LABEL="W63 WTR AMT GE 30,000"                   
      ER22647             FORMAT=1.   LABEL="W64 WTR SOLD OTR REAL ESTATE"            
      ER22648             FORMAT=9.   LABEL="W65 AMT FROM OTR REAL ESTATE"            
      ER22649             FORMAT=1.   LABEL="W66 WTR AMT GE 60,000"                   
      ER22650             FORMAT=1.   LABEL="W67 WTR AMT GE 120,000"                  
      ER22651             FORMAT=1.   LABEL="W68 WTR AMT GE 30,000"                   
      ER22652             FORMAT=1.   LABEL="W69 WTR MADE ADDITION/REPAIRS"           
      ER22653             FORMAT=9.   LABEL="W70 COST OF ADDITION/REPAIRS"            
      ER22654             FORMAT=1.   LABEL="W71 WTR COST GE 25,000"                  
      ER22655             FORMAT=1.   LABEL="W72 WTR COST GE 75,000"                  
      ER22656             FORMAT=1.   LABEL="W73 WTR INVESTED IN BUSNES/FARM"         
      ER22657             FORMAT=9.   LABEL="W74 AMT INVESTED IN BUSINESS/FARM"       
      ER22658             FORMAT=1.   LABEL="W75 WTR AMT GE 25,000"                   
      ER22659             FORMAT=1.   LABEL="W76 WTR AMT GE 100,000"                  
      ER22660             FORMAT=1.   LABEL="W77 WTR AMT GE 10,000"                   
      ER22661             FORMAT=1.   LABEL="W78 WTR SOLD BUSINESS/FARM"              
      ER22662             FORMAT=9.   LABEL="W79 AMT FROM BUSINESS/FARM"              
      ER22663             FORMAT=1.   LABEL="W80 WTR AMT GE 25,000"                   
      ER22664             FORMAT=1.   LABEL="W81 WTR AMT GE 100,000"                  
      ER22665             FORMAT=1.   LABEL="W82 WTR AMT GE 10,000"                   
      ER22666             FORMAT=1.   LABEL="W83 WTR BOUGHT NON-IRA STOCK"            
      ER22667             FORMAT=1.   LABEL="W84 WTR ALSO SOLD STOCK"                 
      ER22668             FORMAT=1.   LABEL="W85 WTR BOUGHT MORE/SOLD MORE"           
      ER22669             FORMAT=9.   LABEL="W86 BALANCE IN/OUT STOCKS"               
      ER22670             FORMAT=1.   LABEL="W87 WTR STOCKS GE 20,000"                
      ER22671             FORMAT=1.   LABEL="W88 WTR STOCKS GE 50,000"                
      ER22672             FORMAT=1.   LABEL="W90 WTR STOCKS GE 100,000"               
      ER22673             FORMAT=1.   LABEL="W89 WTR ST0CKS GE 5,000"                 
      ER22674             FORMAT=9.   LABEL="W91 AMT INVESTED IN STOCKS"              
      ER22675             FORMAT=1.   LABEL="W92 WTR AMT GE 20,000"                   
      ER22676             FORMAT=1.   LABEL="W93 WTR AMT GE 50,000"                   
      ER22677             FORMAT=1.   LABEL="W94 WTR AMT GE 100,000"                  
      ER22678             FORMAT=1.   LABEL="W95 WTR AMT GE 5,000"                    
      ER22679             FORMAT=1.   LABEL="W96 WTR SOLD NON-IRA STOCK"              
      ER22680             FORMAT=9.   LABEL="W97 AMT NON-IRA STOCK"                   
      ER22681             FORMAT=1.   LABEL="W98 WTR AMT GE 20,000"                   
      ER22682             FORMAT=1.   LABEL="W99 WTR AMT GE 50,000"                   
      ER22683             FORMAT=1.   LABEL="W100 WTR AMT GE 100,000"                 
      ER22684             FORMAT=1.   LABEL="W101 WTR AMT GE 5,000"                   
      ER22685             FORMAT=1.   LABEL="W102 WTR MOVER OUT W/ASSETS"             
      ER22686             FORMAT=9.   LABEL="W103 VALUE ASSETS MOVED OUT"             
      ER22687             FORMAT=1.   LABEL="W104 WTR VALUE GE 10,000"                
      ER22688             FORMAT=1.   LABEL="W105 WTR VALUE GE 25,000"                
      ER22689             FORMAT=1.   LABEL="W106 WTR VALUE GE 100,000"               
      ER22690             FORMAT=1.   LABEL="W107 WTR VALUE GE 5,000"                 
      ER22691             FORMAT=9.   LABEL="W108 VALUE DEBTS MOVED OUT"              
      ER22692             FORMAT=1.   LABEL="W109 WTR VALUE GE 10,000"                
      ER22693             FORMAT=1.   LABEL="W110 WTR VALUE GE 25,000"                
      ER22694             FORMAT=1.   LABEL="W111 WTR VALUE GE 5,000"                 
      ER22695             FORMAT=1.   LABEL="W112 CKPT: FU COMPOSITION"               
      ER22696             FORMAT=1.   LABEL="W113 WTR MOVER IN ASSETS"                
      ER22697             FORMAT=9.   LABEL="W114 VALUE ASSETS MOVED IN"              
      ER22698             FORMAT=1.   LABEL="W115 WTR VALUE GE 10,000"                
      ER22699             FORMAT=1.   LABEL="W116 WTR VALUE GE 25,000"                
      ER22700             FORMAT=1.   LABEL="W117 WTR VALUE GE 100,000"               
      ER22701             FORMAT=1.   LABEL="W118 WTR VALUE GE 5,000"                 
      ER22702             FORMAT=9.   LABEL="W119 VALUE DEBTS MOVE IN"                
      ER22703             FORMAT=1.   LABEL="W120 WTR VALUE GE 10,000"                
      ER22704             FORMAT=1.   LABEL="W121 WTR VALUE GE 25,000"                
      ER22705             FORMAT=1.   LABEL="W122 WTR VALUE GE 5,000"                 
      ER22706             FORMAT=1.   LABEL="W123 WTR RECD GIFT/INHERITANCE"          
      ER22707             FORMAT=4.   LABEL="W124 YR RECD GIFT/INHERIT-#1"            
      ER22708             FORMAT=9.   LABEL="W125 VALUE GIFT/INHERIT-#1"              
      ER22709             FORMAT=1.   LABEL="W126 WTR VALUE GE 25,000"                
      ER22710             FORMAT=1.   LABEL="W127 WTR VALUE GE 75,000"                
      ER22711             FORMAT=1.   LABEL="W128 WTR GIFT/INHERITANCE-#2"            
      ER22712             FORMAT=4.   LABEL="W129 YR RECD GIFT/INHERIT-#2"            
      ER22713             FORMAT=9.   LABEL="W130 VALUE GIFT/INHERIT-#2"              
      ER22714             FORMAT=1.   LABEL="W131 WTR VALUE GE 25,000"                
      ER22715             FORMAT=1.   LABEL="W132 WTR VALUE GE 75,000"                
      ER22716             FORMAT=1.   LABEL="W133 WTR GIFT/INHERITANCE-#3"            
      ER22717             FORMAT=4.   LABEL="W133A YR REC GIFT/INHERIT-#3"            
      ER22718             FORMAT=9.   LABEL="W133B VALUE GIFT/INHERIT-#3"             
      ER22719             FORMAT=1.   LABEL="W133C WTR VALUE GE 25,000"               
      ER22720             FORMAT=1.   LABEL="W133D WTR VALUE GE 75,000"               
      ER22721             FORMAT=1.   LABEL="P0 WTR WORKING NOW"                      
      ER22722             FORMAT=1.   LABEL="P1 WTR PNSN AT CURR JOB"                 
      ER22723             FORMAT=2.   LABEL="P6 # YRS IN PENSION PLAN"                
      ER22724             FORMAT=4.   LABEL="P6 YR JOINED PENSION PLAN"               
      ER22725             FORMAT=1.   LABEL="P7 WTR EVER ELIG FOR PLAN"               
      ER22726             FORMAT=3.   LABEL="P8 # YRS TILL ELIGIBLE"                  
      ER22727             FORMAT=1.   LABEL="P9 WTR VESTED"                           
      ER22728             FORMAT=3.   LABEL="P10 # YRS TILL VESTED"                   
      ER22729             FORMAT=1.   LABEL="P11 WTR CONTRIB TO PENSION"              
      ER22730             FORMAT=1.   LABEL="P12 WTR CONTRIB REQUIRED"                
      ER22731             FORMAT=7.   LABEL="P13 REQUIRED AMT"                        
      ER22732             FORMAT=1.   LABEL="P13 REQUIRED AMT PER"                    
      ER22733             FORMAT=3.   LABEL="P13 REQUIRED PCT"                        
      ER22734             FORMAT=1.   LABEL="P14 WTR VOLUNTARY CONTRIB"               
      ER22735             FORMAT=7.   LABEL="P15 VOLUNTARY AMT"                       
      ER22736             FORMAT=1.   LABEL="P15 VOLUNTARY AMT PER"                   
      ER22737             FORMAT=3.   LABEL="P15 VOLUNTARY PCT"                       
      ER22738             FORMAT=1.   LABEL="P16 HOW BENEFIT FIGURED"                 
      ER22739             FORMAT=1.   LABEL="P17 WTR EMPLYR CONTRIB"                  
      ER22740             FORMAT=7.   LABEL="P18 AMT EMPLYR CONTRIB"                  
      ER22741             FORMAT=1.   LABEL="P18 EMPLYR AMT PER"                      
      ER22742             FORMAT=3.   LABEL="P18 PCT EMPLYR CONTRIB"                  
      ER22743             FORMAT=3.   LABEL="P19 AGE PENSION INCL EMPLYR CONTRIB"     
      ER22744             FORMAT=9.   LABEL="P20 AMT IN PENSION ACCT NOW"             
      ER22745             FORMAT=1.   LABEL="P20A HOW FUNDS INVESTED"                 
      ER22746             FORMAT=9.   LABEL="P21 AMT COULD TAKE IF LEAVE EMPLYR"      
      ER22747             FORMAT=1.   LABEL="P21 AMT PER IF LEAVE EMPLYR"             
      ER22748             FORMAT=3.   LABEL="P21 PCT COULD TAKE IF LEAVE EMPLYR"      
      ER22749             FORMAT=1.   LABEL="P22 CKPT: TYPE PENSION"                  
      ER22750             FORMAT=1.   LABEL="P23 BENEFIT FORMULA"                     
      ER22751             FORMAT=3.   LABEL="P24 AGE FULL BENEFITS"                   
      ER22752             FORMAT=3.   LABEL="P25 # YRS NEC FOR FULL BENEFITS"         
      ER22753             FORMAT=3.   LABEL="P26 AGE IF AGE+YRS"                      
      ER22754             FORMAT=3.   LABEL="P26 # YRS IF AGE+YRS"                    
      ER22755             FORMAT=1.   LABEL="P27 WTR REC PART PNSN IF RETIRE EARLY"   
      ER22756             FORMAT=1.   LABEL="P28 EARLY RETRMT FORMULA"                
      ER22757             FORMAT=3.   LABEL="P29 AGE ELIG PART BENEFITS"              
      ER22758             FORMAT=3.   LABEL="P30 # YRS ELIG PART BENEFITS"            
      ER22759             FORMAT=3.   LABEL="P31 AGE IF AGE+YRS"                      
      ER22760             FORMAT=3.   LABEL="P31 # YRS IF AGE+YRS"                    
      ER22761             FORMAT=3.   LABEL="P32 AGE EXPECT RECEIVE BENEFITS"         
      ER22762             FORMAT=1.   LABEL="P33 WTR CAN ESTIMATE BENEFIT"            
      ER22763             FORMAT=7.   LABEL="P34 ESTIMATED BENEFIT AMT"               
      ER22764             FORMAT=1.   LABEL="P34 ESTIMATED BENEFIT PER"               
      ER22765             FORMAT=3.   LABEL="P34 ESTIMATED BENEFIT PCT"               
      ER22766             FORMAT=9.   LABEL="P34 ESTIMATED LUMP SUM BENEFIT"          
      ER22767             FORMAT=1.   LABEL="P35 WTR BENEFICIARY"                     
      ER22768             FORMAT=1.   LABEL="P36 AMT BENEFICIARY RECEIVES"            
      ER22769             FORMAT=1.   LABEL="P37 WTR PNSN LESSENED BY SOC SEC"        
      ER22770             FORMAT=1.   LABEL="P38 WHEN SOC SEC CHG PNSN AMT"           
      ER22771             FORMAT=2.   LABEL="P39 USUAL RETIREMNT AGE OF OTRS"         
      ER22772             FORMAT=2.   LABEL="P39 USUAL # YRS OTRS RETIRE"             
      ER22773             FORMAT=3.   LABEL="P40 AGE PLAN STOP WORK"                  
      ER22774             FORMAT=4.   LABEL="P40 YR PLAN STOP WORK"                   
      ER22775             FORMAT=3.   LABEL="P41 AGE WILL STOP WORK"                  
      ER22776             FORMAT=4.   LABEL="P41 YR WILL STOP WORK"                   
      ER22777             FORMAT=1.   LABEL="P42 WTR TAX-DEFER PLAN"                  
      ER22778             FORMAT=1.   LABEL="P43 WTR EMPLYR CONTRIB"                  
      ER22779             FORMAT=7.   LABEL="P44 AMT EMPLYR CONTRIB"                  
      ER22780             FORMAT=1.   LABEL="P44 EMPLYR CONTRIB PER"                  
      ER22781             FORMAT=3.   LABEL="P44 PCT EMPLYR CONTRIB"                  
      ER22782             FORMAT=1.   LABEL="P45 WTR PNSN W/PREV EMPLYR"              
      ER22783             FORMAT=1.   LABEL="P46 TYPE PREV PENSION-#1"                
      ER22784             FORMAT=8.   LABEL="P47 ACCT AMT WHEN LEFT PREV EMPLYR-#1"   
      ER22785             FORMAT=1.   LABEL="P48 WHAT DID W/PREV PNSN-#1"             
      ER22786             FORMAT=8.   LABEL="P49 AMT NOW PREV PNSN ACCT-#1"           
      ER22787             FORMAT=2.   LABEL="P50 AGE REC IF ANNUITY-#1"               
      ER22788             FORMAT=7.   LABEL="P51 AMT PREV ANNUITY-#1"                 
      ER22789             FORMAT=1.   LABEL="P51 PREV ANNUITY PER-#1"                 
      ER22790             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN1-#1"            
      ER22791             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN2-#1"            
      ER22792             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN3-#1"            
      ER22793             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN4-#1"            
      ER22794             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN5-#1"            
      ER22795             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN6-#1"            
      ER22796             FORMAT=2.   LABEL="P53 MO REC PREV PNSN-#1"                 
      ER22797             FORMAT=4.   LABEL="P53 YR REC PREV PNSN-#1"                 
      ER22798             FORMAT=7.   LABEL="P54 PREV PNSN BENEFIT AMT-#1"            
      ER22799             FORMAT=1.   LABEL="P54 BENEFIT PER-#1"                      
      ER22800             FORMAT=1.   LABEL="P55 WTR BENEFITS COLA-#1"                
      ER22801             FORMAT=1.   LABEL="P56 WTR BENEFITS EVER COLA-#1"           
      ER22802             FORMAT=7.   LABEL="P57 PREV PNSN CASH SETTLEMNT AMT-#1"     
      ER22803             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN1-#1"             
      ER22804             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN2-#1"             
      ER22805             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN3-#1"             
      ER22806             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN4-#1"             
      ER22807             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN5-#1"             
      ER22808             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN6-#1"             
      ER22809             FORMAT=7.   LABEL="P59 PREV PNSN IRA AMT-#1"                
      ER22810             FORMAT=2.   LABEL="P60 # YRS IN PREV PLAN-#1"               
      ER22811             FORMAT=2.   LABEL="P61 AGE EXPECT REC PREV PNSN-#1"         
      ER22812             FORMAT=6.   LABEL="P62 AMT EXPECT REC PREV PNSN-#1"         
      ER22813             FORMAT=1.   LABEL="P62 PREV PNSN PER-#1"                    
      ER22814             FORMAT=3.   LABEL="P62 PCT EXPECT REC PREV PNSN-#1"         
      ER22815             FORMAT=8.   LABEL="P62 LUMP SUM EXPECT PREV PNSN-#1"        
      ER22816             FORMAT=7.   LABEL="P63 ACCT AMT WHEN LEFT PREV EMPLYR-#1"   
      ER22817             FORMAT=1.   LABEL="P64 WHAT DID W/PREV PNSN-#1"             
      ER22818             FORMAT=8.   LABEL="P65 ACCT AMT PREV PNSN NOW-#1"           
      ER22819             FORMAT=2.   LABEL="P66 AGE BEGAN REC ANNUITY-#1"            
      ER22820             FORMAT=7.   LABEL="P67 AMT PREV ANNUITY-#1"                 
      ER22821             FORMAT=1.   LABEL="P67 PREV ANNUITY PER-#1"                 
      ER22822             FORMAT=2.   LABEL="P68 AGE ELIG PREV PNSN-#1"               
      ER22823             FORMAT=1.   LABEL="P69 WTR SECOND PREV PENSION"             
      ER22824             FORMAT=1.   LABEL="P46 TYPE PREV PENSION-#2"                
      ER22825             FORMAT=8.   LABEL="P47 ACCT AMT WHEN LEFT PREV EMPLYR-#2"   
      ER22826             FORMAT=1.   LABEL="P48 WHAT DID W/PREV PNSN-#2"             
      ER22827             FORMAT=8.   LABEL="P49 AMT NOW PREV PNSN ACCT-#2"           
      ER22828             FORMAT=2.   LABEL="P50 AGE REC IF ANNUITY-#2"               
      ER22829             FORMAT=7.   LABEL="P51 AMT PREV ANNUITY-#2"                 
      ER22830             FORMAT=1.   LABEL="P51 PREV ANNUITY PER-#2"                 
      ER22831             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN1-#2"            
      ER22832             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN2-#2"            
      ER22833             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN3-#2"            
      ER22834             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN4-#2"            
      ER22835             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN5-#2"            
      ER22836             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN6-#2"            
      ER22837             FORMAT=2.   LABEL="P53 MO REC PREV PNSN-#2"                 
      ER22838             FORMAT=4.   LABEL="P53 YR REC PREV PNSN-#2"                 
      ER22839             FORMAT=7.   LABEL="P54 PREV PNSN BENEFIT AMT-#2"            
      ER22840             FORMAT=1.   LABEL="P54 BENEFIT PER-#2"                      
      ER22841             FORMAT=1.   LABEL="P55 WTR BENEFITS COLA-#2"                
      ER22842             FORMAT=1.   LABEL="P56 WTR BENEFITS EVER COLA-#2"           
      ER22843             FORMAT=7.   LABEL="P57 PREV PNSN CASH SETTLEMNT AMT-#2"     
      ER22844             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN1-#2"             
      ER22845             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN2-#2"             
      ER22846             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN3-#2"             
      ER22847             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN4-#2"             
      ER22848             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN5-#2"             
      ER22849             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN6-#2"             
      ER22850             FORMAT=7.   LABEL="P59 PREV PNSN IRA AMT-#2"                
      ER22851             FORMAT=2.   LABEL="P60 # YRS IN PREV PLAN-#2"               
      ER22852             FORMAT=2.   LABEL="P61 AGE EXPECT REC PREV PNSN-#2"         
      ER22853             FORMAT=6.   LABEL="P62 AMT EXPECT REC PREV PNSN-#2"         
      ER22854             FORMAT=1.   LABEL="P62 PREV PNSN PER-#2"                    
      ER22855             FORMAT=3.   LABEL="P62 PCT EXPECT REC PREV PNSN-#2"         
      ER22856             FORMAT=8.   LABEL="P62 LUMP SUM EXPECT PREV PNSN-#2"        
      ER22857             FORMAT=7.   LABEL="P63 ACCT AMT WHEN LEFT PREV EMPLYR-#2"   
      ER22858             FORMAT=1.   LABEL="P64 WHAT DID W/PREV PNSN-#2"             
      ER22859             FORMAT=8.   LABEL="P65 ACCT AMT PREV PNSN NOW-#2"           
      ER22860             FORMAT=2.   LABEL="P66 AGE BEGAN REC ANNUITY-#2"            
      ER22861             FORMAT=7.   LABEL="P67 AMT PREV ANNUITY-#2"                 
      ER22862             FORMAT=1.   LABEL="P67 PREV ANNUITY PER-#2"                 
      ER22863             FORMAT=2.   LABEL="P68 AGE ELIG PREV PNSN-#2"               
      ER22864             FORMAT=1.   LABEL="P69 WTR 3RD PREV PENSION"                
      ER22865             FORMAT=1.   LABEL="P70 WTR WORKING NOW"                     
      ER22866             FORMAT=1.   LABEL="P71 WTR PNSN AT CURR JOB"                
      ER22867             FORMAT=2.   LABEL="P76 # YRS IN PENSION PLAN"               
      ER22868             FORMAT=4.   LABEL="PY6 YR JOINED PENSION PLAN"              
      ER22869             FORMAT=1.   LABEL="P77 WTR EVER ELIG FOR PLAN"              
      ER22870             FORMAT=3.   LABEL="P78 # YRS TILL ELIGIBLE"                 
      ER22871             FORMAT=1.   LABEL="P79 WTR VESTED"                          
      ER22872             FORMAT=3.   LABEL="P80 # YRS TILL VESTED"                   
      ER22873             FORMAT=1.   LABEL="P81 WTR CONTRIB TO PENSION"              
      ER22874             FORMAT=1.   LABEL="P82 WTR CONTRIB REQUIRED"                
      ER22875             FORMAT=7.   LABEL="P83 REQUIRED AMT"                        
      ER22876             FORMAT=1.   LABEL="P83 REQUIRED AMT PER"                    
      ER22877             FORMAT=3.   LABEL="P83 REQUIRED PCT"                        
      ER22878             FORMAT=1.   LABEL="P84 WTR VOLUNTARY CONTRIB"               
      ER22879             FORMAT=7.   LABEL="P85 VOLUNTARY AMT"                       
      ER22880             FORMAT=1.   LABEL="P85 VOLUNTARY AMT PER"                   
      ER22881             FORMAT=3.   LABEL="P85 VOLUNTARY PCT"                       
      ER22882             FORMAT=1.   LABEL="P86 HOW BENEFIT FIGURED"                 
      ER22883             FORMAT=1.   LABEL="P87 WTR EMPLYR CONTRIB"                  
      ER22884             FORMAT=7.   LABEL="P88 AMT EMPLYR CONTRIB"                  
      ER22885             FORMAT=1.   LABEL="P88 EMPLYR AMT PER"                      
      ER22886             FORMAT=3.   LABEL="P88 PCT EMPLYR CONTRIB"                  
      ER22887             FORMAT=3.   LABEL="P89 AGE PENSION INCL EMPLYR CONTRIB"     
      ER22888             FORMAT=9.   LABEL="P90 AMT IN PENSION ACCT NOW"             
      ER22889             FORMAT=1.   LABEL="P90A HOW FUNDS INVESTED"                 
      ER22890             FORMAT=9.   LABEL="P91 AMT COULD TAKE IF LEAVE EMPLYR"      
      ER22891             FORMAT=1.   LABEL="P91 AMT PER IF LEAVE EMPLYR"             
      ER22892             FORMAT=3.   LABEL="P91 PCT COULD TAKE IF LEAVE EMPLYR"      
      ER22893             FORMAT=1.   LABEL="P92 CKPT: TYPE PENSION"                  
      ER22894             FORMAT=1.   LABEL="P93 BENEFIT FORMULA"                     
      ER22895             FORMAT=3.   LABEL="P94 AGE FULL BENEFITS"                   
      ER22896             FORMAT=3.   LABEL="P95 # YRS NEC FOR FULL BENEFITS"         
      ER22897             FORMAT=3.   LABEL="P96 AGE IF AGE+YRS"                      
      ER22898             FORMAT=3.   LABEL="P96 # YRS IF AGE+YRS"                    
      ER22899             FORMAT=1.   LABEL="P97 WTR REC PART PNSN IF RETIRE EARLY"   
      ER22900             FORMAT=1.   LABEL="P98 EARLY RETRMT FORMULA"                
      ER22901             FORMAT=3.   LABEL="P99 AGE ELIG PART BENEFITS"              
      ER22902             FORMAT=3.   LABEL="P100 # YRS ELIG PART BENEFITS"           
      ER22903             FORMAT=3.   LABEL="P101 AGE IF AGE+YRS"                     
      ER22904             FORMAT=3.   LABEL="P101 # YRS IF AGE+YRS"                   
      ER22905             FORMAT=3.   LABEL="P102 AGE EXPECT RECEIVE BENEFITS"        
      ER22906             FORMAT=1.   LABEL="P103 WTR CAN ESTIMATE BENEFIT"           
      ER22907             FORMAT=7.   LABEL="P104 ESTIMATED BENEFIT AMT"              
      ER22908             FORMAT=1.   LABEL="P104 ESTIMATED BENEFIT PER"              
      ER22909             FORMAT=3.   LABEL="P104 ESTIMATED BENEFIT PCT"              
      ER22910             FORMAT=9.   LABEL="P104 ESTIMATED LUMP SUM BENEFIT"         
      ER22911             FORMAT=1.   LABEL="P105 WTR BENEFICIARY"                    
      ER22912             FORMAT=1.   LABEL="P106 AMT BENEFICIARY RECEIVES"           
      ER22913             FORMAT=1.   LABEL="P107 WTR PNSN LESSENED BY SOC SEC"       
      ER22914             FORMAT=1.   LABEL="P108 WHEN SOC SEC CHG PNSN AMT"          
      ER22915             FORMAT=2.   LABEL="P109 USUAL RETIRMNT AGE OF OTRS"         
      ER22916             FORMAT=2.   LABEL="P109 USUAL # YRS OTRS RETIRE"            
      ER22917             FORMAT=3.   LABEL="P110 AGE PLAN STOP WORK"                 
      ER22918             FORMAT=4.   LABEL="P110 YR PLAN STOP WORK"                  
      ER22919             FORMAT=3.   LABEL="P111 AGE WILL STOP WORK"                 
      ER22920             FORMAT=4.   LABEL="P111 YR WILL STOP WORK"                  
      ER22921             FORMAT=1.   LABEL="P112 WTR TAX-DEFER PLAN"                 
      ER22922             FORMAT=1.   LABEL="P113 WTR EMPLYR CONTRIB"                 
      ER22923             FORMAT=7.   LABEL="P114 AMT EMPLYR CONTRIB"                 
      ER22924             FORMAT=1.   LABEL="P114 EMPLYR CONTRIB PER"                 
      ER22925             FORMAT=3.   LABEL="P114 PCT EMPLYR CONTRIB"                 
      ER22926             FORMAT=1.   LABEL="P115 WTR PNSN W/PREV EMPLYR"             
      ER22927             FORMAT=1.   LABEL="P116 TYPE PREV PENSION-#1"               
      ER22928             FORMAT=8.   LABEL="P117 ACCT AMT WHEN LEFT PREV EMPLYR-#1"  
      ER22929             FORMAT=1.   LABEL="P118 WHAT DID W/PREV PNSN-#1"            
      ER22930             FORMAT=8.   LABEL="P119 AMT NOW PREV PNSN ACCT-#1"          
      ER22931             FORMAT=2.   LABEL="P120 AGE REC IF ANNUITY-#1"              
      ER22932             FORMAT=7.   LABEL="P121 AMT PREV ANNUITY-#1"                
      ER22933             FORMAT=1.   LABEL="P121 PREV ANNUITY PER-#1"                
      ER22934             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN1-#1"           
      ER22935             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN2-#1"           
      ER22936             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN3-#1"           
      ER22937             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN4-#1"           
      ER22938             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN5-#1"           
      ER22939             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN6-#1"           
      ER22940             FORMAT=2.   LABEL="P123 MO REC PREV PNSN-#1"                
      ER22941             FORMAT=4.   LABEL="P123 YR REC PREV PNSN-#1"                
      ER22942             FORMAT=7.   LABEL="P124 PREV PNSN BENEFIT AMT-#1"           
      ER22943             FORMAT=1.   LABEL="P124 BENEFIT PER-#1"                     
      ER22944             FORMAT=1.   LABEL="P125 WTR BENEFITS COLA-#1"               
      ER22945             FORMAT=1.   LABEL="P126 WTR BENEFITS EVER COLA-#1"          
      ER22946             FORMAT=7.   LABEL="P127 PREV PNSN CASH SETTLEMNT AMT-#1"    
      ER22947             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN1-#1"            
      ER22948             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN2-#1"            
      ER22949             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN3-#1"            
      ER22950             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN4-#1"            
      ER22951             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN5-#1"            
      ER22952             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN6-#1"            
      ER22953             FORMAT=7.   LABEL="P129 PREV PNSN IRA AMT-#1"               
      ER22954             FORMAT=2.   LABEL="P130 # YRS IN PREV PLAN-#1"              
      ER22955             FORMAT=2.   LABEL="P131 AGE EXPECT REC PREV PNSN-#1"        
      ER22956             FORMAT=6.   LABEL="P132 AMT EXPECT REC PREV PNSN-#1"        
      ER22957             FORMAT=1.   LABEL="P132 PREV PNSN PER-#1"                   
      ER22958             FORMAT=3.   LABEL="P132 PCT EXPECT REC PREV PNSN-#1"        
      ER22959             FORMAT=8.   LABEL="P132 LUMP SUM EXPECT PREV PNSN-#1"       
      ER22960             FORMAT=7.   LABEL="P133 ACCT AMT WHEN LEFT PREV EMPLYR-#1"  
      ER22961             FORMAT=1.   LABEL="P134 WHAT DID W/PREV PNSN-#1"            
      ER22962             FORMAT=8.   LABEL="P135 ACCT AMT PREV PNSN NOW-#1"          
      ER22963             FORMAT=2.   LABEL="P136 AGE BEGAN REC ANNUITY-#1"           
      ER22964             FORMAT=7.   LABEL="P137 AMT PREV ANNUITY-#1"                
      ER22965             FORMAT=1.   LABEL="P137 PREV ANNUITY PER-#1"                
      ER22966             FORMAT=2.   LABEL="P138 AGE ELIG PREV PNSN-#1"              
      ER22967             FORMAT=1.   LABEL="P139 WTR SECOND PREV PENSION"            
      ER22968             FORMAT=1.   LABEL="P116 TYPE PREV PENSION-#2"               
      ER22969             FORMAT=8.   LABEL="P117 ACCT AMT WHEN LEFT PREV EMPLYR-#2"  
      ER22970             FORMAT=1.   LABEL="P118 WHAT DID W/PREV PNSN-#2"            
      ER22971             FORMAT=8.   LABEL="P119 AMT NOW PREV PNSN ACCT-#2"          
      ER22972             FORMAT=2.   LABEL="P120 AGE REC IF ANNUITY-#2"              
      ER22973             FORMAT=7.   LABEL="P121 AMT PREV ANNUITY-#2"                
      ER22974             FORMAT=1.   LABEL="P121 PREV ANNUITY PER-#2"                
      ER22975             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN1-#2"           
      ER22976             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN2-#2"           
      ER22977             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN3-#2"           
      ER22978             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN4-#2"           
      ER22979             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN5-#2"           
      ER22980             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN6-#2"           
      ER22981             FORMAT=2.   LABEL="P123 MO REC PREV PNSN-#2"                
      ER22982             FORMAT=4.   LABEL="P123 YR REC PREV PNSN-#2"                
      ER22983             FORMAT=7.   LABEL="P124 PREV PNSN BENEFIT AMT-#2"           
      ER22984             FORMAT=1.   LABEL="P124 BENEFIT PER-#2"                     
      ER22985             FORMAT=1.   LABEL="P125 WTR BENEFITS COLA-#2"               
      ER22986             FORMAT=1.   LABEL="P126 WTR BENEFITS EVER COLA-#2"          
      ER22987             FORMAT=7.   LABEL="P127 PREV PNSN CASH SETTLEMNT AMT-#2"    
      ER22988             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN1-#2"            
      ER22989             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN2-#2"            
      ER22990             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN3-#2"            
      ER22991             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN4-#2"            
      ER22992             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN5-#2"            
      ER22993             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN6-#2"            
      ER22994             FORMAT=7.   LABEL="P129 PREV PNSN IRA AMT-#2"               
      ER22995             FORMAT=2.   LABEL="P130 # YRS IN PREV PLAN-#2"              
      ER22996             FORMAT=2.   LABEL="P131 AGE EXPECT REC PREV PNSN-#2"        
      ER22997             FORMAT=6.   LABEL="P132 AMT EXPECT REC PREV PNSN-#2"        
      ER22998             FORMAT=1.   LABEL="P132 PREV PNSN PER-#2"                   
      ER22999             FORMAT=3.   LABEL="P132 PCT EXPECT REC PREV PNSN-#2"        
      ER23000             FORMAT=8.   LABEL="P132 LUMP SUM EXPECT PREV PNSN-#2"       
      ER23001             FORMAT=7.   LABEL="P133 ACCT AMT WHEN LEFT PREV EMPLYR-#2"  
      ER23002             FORMAT=1.   LABEL="P134 WHAT DID W/PREV PNSN-#2"            
      ER23003             FORMAT=8.   LABEL="P135 ACCT AMT PREV PNSN NOW-#2"          
      ER23004             FORMAT=2.   LABEL="P136 AGE BEGAN REC ANNUITY-#2"           
      ER23005             FORMAT=7.   LABEL="P137 AMT PREV ANNUITY-#2"                
      ER23006             FORMAT=1.   LABEL="P137 PREV ANNUITY PER-#2"                
      ER23007             FORMAT=2.   LABEL="P138 AGE ELIG PREV PNSN-#2"              
      ER23008             FORMAT=1.   LABEL="P139 WTR 3RD PREV PENSION"               
      ER23009             FORMAT=1.   LABEL="H1 HEALTH STATUS-HEAD"                   
      ER23010             FORMAT=1.   LABEL="H1A WTR HLTH BETTER/WORSE"               
      ER23011             FORMAT=1.   LABEL="H1B HEALTH HOW MUCH BETTER?"             
      ER23012             FORMAT=1.   LABEL="H1C HEALTH HOW MUCH WORSE?"              
      ER23013             FORMAT=1.   LABEL="H1D HEALTH STATUS, BIRTH TO AGE 16"      
      ER23014             FORMAT=1.   LABEL="H2 LIMIT TYPE/AMT WRK H"                 
      ER23015             FORMAT=1.   LABEL="H3 NOT DO CERTAIN WRK H"                 
      ER23016             FORMAT=1.   LABEL="H4 LIMIT AMT WRK DO H"                   
      ER23017             FORMAT=1.   LABEL="H5A WTR HAD STROKE"                      
      ER23018             FORMAT=2.   LABEL="H6A # DAYS STROKE"                       
      ER23019             FORMAT=2.   LABEL="H6A # MOS STROKE"                        
      ER23020             FORMAT=2.   LABEL="H6A # WKS STROKE"                        
      ER23021             FORMAT=2.   LABEL="H6A # YRS STROKE"                        
      ER23022             FORMAT=1.   LABEL="H7A LIMIT DAILY ACTIVITY"                
      ER23023             FORMAT=1.   LABEL="H5B WTR HIGH BLOOD PRESSURE"             
      ER23024             FORMAT=2.   LABEL="H6B # DAYS HIGH BLOOD PRESSURE"          
      ER23025             FORMAT=2.   LABEL="H6B # MOS HIGH BLOOD PRESSURE"           
      ER23026             FORMAT=2.   LABEL="H6B # WKS HIGH BLOOD PRESSURE"           
      ER23027             FORMAT=2.   LABEL="H6B # YRS HIGH BLOOD PRESSURE"           
      ER23028             FORMAT=1.   LABEL="H7B LIMIT DAILY ACTIVITY"                
      ER23029             FORMAT=1.   LABEL="H5C WTR DIABETES"                        
      ER23030             FORMAT=2.   LABEL="H6C # DAYS DIABETES"                     
      ER23031             FORMAT=2.   LABEL="H6C # MOS DIABETES"                      
      ER23032             FORMAT=2.   LABEL="H6C # WKS DIABETES"                      
      ER23033             FORMAT=2.   LABEL="H6C # YRS DIABETES"                      
      ER23034             FORMAT=1.   LABEL="H7C LIMIT DAILY ACTIVITY"                
      ER23035             FORMAT=1.   LABEL="H5D WTR CANCER"                          
      ER23036             FORMAT=2.   LABEL="H6D # DAYS CANCER"                       
      ER23037             FORMAT=2.   LABEL="H6D # MOS CANCER"                        
      ER23038             FORMAT=2.   LABEL="H6D # WKS CANCER"                        
      ER23039             FORMAT=2.   LABEL="H6D # YRS CANCER"                        
      ER23040             FORMAT=1.   LABEL="H7D LIMIT DAILY ACTIVITY"                
      ER23041             FORMAT=1.   LABEL="H5E WTR LUNG DISEASE"                    
      ER23042             FORMAT=2.   LABEL="H6E # DAYS LUNG DISEASE"                 
      ER23043             FORMAT=2.   LABEL="H6E # MOS LUNG DISEASE"                  
      ER23044             FORMAT=2.   LABEL="H6E # WKS LUNG DISEASE"                  
      ER23045             FORMAT=2.   LABEL="H6E # YRS LUNG DISEASE"                  
      ER23046             FORMAT=1.   LABEL="H7E LIMIT DAILY ACTIVITY"                
      ER23047             FORMAT=1.   LABEL="H5F WTR HEART ATTACK"                    
      ER23048             FORMAT=2.   LABEL="H6F # DAYS HEART ATTACK"                 
      ER23049             FORMAT=2.   LABEL="H6F # MOS HEART ATTACK"                  
      ER23050             FORMAT=2.   LABEL="H6F # WKS HEART ATTACK"                  
      ER23051             FORMAT=2.   LABEL="H6F # YRS HEART ATTACK"                  
      ER23052             FORMAT=1.   LABEL="H7F LIMIT DAILY ACTIVITY"                
      ER23053             FORMAT=1.   LABEL="H5G WTR HEART DISEASE"                   
      ER23054             FORMAT=2.   LABEL="H6G # DAYS HEART DISEASE"                
      ER23055             FORMAT=2.   LABEL="H6G # MOS HEART DISEASE"                 
      ER23056             FORMAT=2.   LABEL="H6G # WKS HEART DISEASE"                 
      ER23057             FORMAT=2.   LABEL="H6G # YRS HEART DISEASE"                 
      ER23058             FORMAT=1.   LABEL="H7G LIMIT DAILY ACTIVITY"                
      ER23059             FORMAT=1.   LABEL="H5H WTR EMOTIONAL PROB"                  
      ER23060             FORMAT=2.   LABEL="H6H # DAYS EMOTIONAL PR"                 
      ER23061             FORMAT=2.   LABEL="H6H # MOS EMOTIONAL PROB"                
      ER23062             FORMAT=2.   LABEL="H6H # WKS EMOTIONAL PROB"                
      ER23063             FORMAT=2.   LABEL="H6H # YRS EMOTIONAL PROB"                
      ER23064             FORMAT=1.   LABEL="H7H LIMIT DAILY ACTIVITY"                
      ER23065             FORMAT=1.   LABEL="H5I WTR ARTHRITIS"                       
      ER23066             FORMAT=2.   LABEL="H6I # DAYS ARTHRITIS"                    
      ER23067             FORMAT=2.   LABEL="H6I # MOS ARTHRITIS"                     
      ER23068             FORMAT=2.   LABEL="H6I # WKS ARTHRITIS"                     
      ER23069             FORMAT=2.   LABEL="H6I # YRS ARTHRITIS"                     
      ER23070             FORMAT=1.   LABEL="H7I LIMIT DAILY ACTIVITY"                
      ER23071             FORMAT=1.   LABEL="H5J WTR ASTHMA"                          
      ER23072             FORMAT=2.   LABEL="H6J # DAYS ASTHMA"                       
      ER23073             FORMAT=2.   LABEL="H6J # MOS ASTHMA"                        
      ER23074             FORMAT=2.   LABEL="H6J # WKS ASTHMA"                        
      ER23075             FORMAT=2.   LABEL="H6J # YRS ASTHMA"                        
      ER23076             FORMAT=1.   LABEL="H7J LIMIT DAILY ACTIVITY"                
      ER23077             FORMAT=1.   LABEL="H5K WTR MENTAL LOSS"                     
      ER23078             FORMAT=2.   LABEL="H6K # DAYS MENTAL LOSS"                  
      ER23079             FORMAT=2.   LABEL="H6K # MOS MENTAL LOSS"                   
      ER23080             FORMAT=2.   LABEL="H6K # WKS MENTAL LOSS"                   
      ER23081             FORMAT=2.   LABEL="H6K # YRS MENTAL LOSS"                   
      ER23082             FORMAT=1.   LABEL="H7K LIMIT DAILY ACTIVITY"                
      ER23083             FORMAT=1.   LABEL="H5L WTR LEARNING DISORDER"               
      ER23084             FORMAT=2.   LABEL="H6L # DAYS LEARNING DISORDER"            
      ER23085             FORMAT=2.   LABEL="H6L # MOS LEARNING DISORDER"             
      ER23086             FORMAT=2.   LABEL="H6L # WKS LEARNING DISORDER"             
      ER23087             FORMAT=2.   LABEL="H6L # YRS LEARNING DISORDER"             
      ER23088             FORMAT=1.   LABEL="H7L LIMIT DAILY ACTIVITY"                
      ER23089             FORMAT=1.   LABEL="H8 WTR HOSPITALIZED IN 2002"             
      ER23090             FORMAT=3.   LABEL="H8 # NIGHTS IN HOSPITAL"                 
      ER23091             FORMAT=2.   LABEL="H8 # WEEKS IN HOSPITAL"                  
      ER23092             FORMAT=1.   LABEL="H9A WTR PROBLEM BATHING"                 
      ER23093             FORMAT=1.   LABEL="H10A WTR SOMEONE HELPS"                  
      ER23094             FORMAT=1.   LABEL="H9B WTR PROBLEM DRESSING"                
      ER23095             FORMAT=1.   LABEL="H10B WTR SOMEONE HELPS"                  
      ER23096             FORMAT=1.   LABEL="H9C WTR PROBLEM EATING"                  
      ER23097             FORMAT=1.   LABEL="H10C WTR SOMEONE HELPS"                  
      ER23098             FORMAT=1.   LABEL="H9D WTR PROB GETTING IN/OUT BED/CHAIR"   
      ER23099             FORMAT=1.   LABEL="H10D WTR SOMEONE HELPS"                  
      ER23100             FORMAT=1.   LABEL="H9E WTR PROBLEM WALKING"                 
      ER23101             FORMAT=1.   LABEL="H10E WTR SOMEONE HELPS"                  
      ER23102             FORMAT=1.   LABEL="H9F WTR PROBLEM GETTING OUTSIDE"         
      ER23103             FORMAT=1.   LABEL="H10F WTR SOMEONE HELPS"                  
      ER23104             FORMAT=1.   LABEL="H9G WTR PROBLEM USE/GET TO TOILET"       
      ER23105             FORMAT=1.   LABEL="H10G WTR SOMEONE HELPS"                  
      ER23106             FORMAT=1.   LABEL="H11A WTR DIFFICULT PREPARE MEALS"        
      ER23107             FORMAT=1.   LABEL="H11B HEALTH/PHYSICAL PROBLEM?"           
      ER23108             FORMAT=1.   LABEL="H11C WTR DIFFICULT SHOPPING"             
      ER23109             FORMAT=1.   LABEL="H11D HEALTH/PHYSICAL PROBLEM?"           
      ER23110             FORMAT=1.   LABEL="H11E WTR DIFFICULT MANAGE MONEY"         
      ER23111             FORMAT=1.   LABEL="H11F HEALTH/PHYSICAL PROBLEM?"           
      ER23112             FORMAT=1.   LABEL="H11G WTR TELEPHONE DIFFICULT"            
      ER23113             FORMAT=1.   LABEL="H11H HEALTH/PHYSICAL PROBLEM?"           
      ER23114             FORMAT=1.   LABEL="H11J WTR HEAVY HSWRK DIFFICULT"          
      ER23115             FORMAT=1.   LABEL="H11K HEALTH/PHYSICAL PROBLEM?"           
      ER23116             FORMAT=1.   LABEL="H11L WTR LIGHT HSWRK DIFFICULT"          
      ER23117             FORMAT=1.   LABEL="H11M HEALTH/PHYSICAL PROBLEM?"           
      ER23118             FORMAT=3.   LABEL="H11 FREQ OF LIGHT PHYSICAL ACTIVITY"     
      ER23119             FORMAT=1.   LABEL="H11 LIGHT PHYSICAL ACTIVITY PER"         
      ER23120             FORMAT=3.   LABEL="H12 FREQ OF HEAVY PHYSICAL ACTIVITY"     
      ER23121             FORMAT=1.   LABEL="H12 HEAVY PHYSICAL ACTIVITY PER"         
      ER23122             FORMAT=1.   LABEL="H12B RUSHED/PRESSED FOR TIME"            
      ER23123             FORMAT=1.   LABEL="H13 WTR SMOKE CIGARETTES"                
      ER23124             FORMAT=3.   LABEL="H14 # CIGARETTES PER DAY"                
      ER23125             FORMAT=2.   LABEL="H15 AGE WHEN FIRST SMOKED"               
      ER23126             FORMAT=1.   LABEL="H16 WTR EVER SMOKED CIGARETTES"          
      ER23127             FORMAT=3.   LABEL="H17 # CIGARETTES PER DAY"                
      ER23128             FORMAT=2.   LABEL="H18 AGE LAST SMOKED REGULARLY"           
      ER23129             FORMAT=2.   LABEL="H19 AGE FIRST SMOKED REGULARLY"          
      ER23130             FORMAT=1.   LABEL="H20 WTR DRINK ALCOHOL"                   
      ER23131             FORMAT=1.   LABEL="H21 # ALCOHOLIC DRINKS PER DAY"          
      ER23132             FORMAT=3.   LABEL="H22 WEIGHT"                              
      ER23133             FORMAT=1.   LABEL="H23 HEIGHT-FEET"                         
      ER23134             FORMAT=2.   LABEL="H23 HEIGHT-INCHES"                       
      ER23135             FORMAT=1.   LABEL="H24 WTR WIFE IN FU NOW"                  
      ER23136             FORMAT=1.   LABEL="H25 HEALTH STATUS-WIFE"                  
      ER23137             FORMAT=1.   LABEL="H25A WTR HLTH BETTER/WORSE"              
      ER23138             FORMAT=1.   LABEL="H25B HEALTH HOW MUCH BETTER?"            
      ER23139             FORMAT=1.   LABEL="H25C HEALTH HOW MUCH WORSE?"             
      ER23140             FORMAT=1.   LABEL="H25D HEALTH STATUS, BIRTH TO AGE 16"     
      ER23141             FORMAT=1.   LABEL="H26 WTR TYPE/AMT WORK LIMITED"           
      ER23142             FORMAT=1.   LABEL="H27 WTR UNABLE TO DO SOME TYPES WORK"    
      ER23143             FORMAT=1.   LABEL="H28 WTR LIMITED IN WORK CAN DO"          
      ER23144             FORMAT=1.   LABEL="H29A WTR HAD STROKE"                     
      ER23145             FORMAT=2.   LABEL="H30A # DAYS STROKE"                      
      ER23146             FORMAT=2.   LABEL="H30A # MOS STROKE"                       
      ER23147             FORMAT=2.   LABEL="H30A # WKS STROKE"                       
      ER23148             FORMAT=2.   LABEL="H30A # YRS STROKE"                       
      ER23149             FORMAT=1.   LABEL="H31A LIMIT DAILY ACTIVITY"               
      ER23150             FORMAT=1.   LABEL="H29B WTR HIGH BLOOD PRESSURE"            
      ER23151             FORMAT=2.   LABEL="H30B # DAYS HIGH BLOOD PRESSURE"         
      ER23152             FORMAT=2.   LABEL="H30B # MOS HIGH BLOOD PRESSURE"          
      ER23153             FORMAT=2.   LABEL="H30B # WKS HIGH BLOOD PRESSURE"          
      ER23154             FORMAT=2.   LABEL="H30B # YRS HIGH BLOOD PRESSURE"          
      ER23155             FORMAT=1.   LABEL="H31B LIMIT DAILY ACTIVITY"               
      ER23156             FORMAT=1.   LABEL="H29C WTR DIABETES"                       
      ER23157             FORMAT=2.   LABEL="H30C # DAYS DIABETES"                    
      ER23158             FORMAT=2.   LABEL="H30C # MOS DIABETES"                     
      ER23159             FORMAT=2.   LABEL="H30C # WKS DIABETES"                     
      ER23160             FORMAT=2.   LABEL="H30C # YRS DIABETES"                     
      ER23161             FORMAT=1.   LABEL="H31C LIMIT DAILY ACTIVITY"               
      ER23162             FORMAT=1.   LABEL="H29D WTR CANCER"                         
      ER23163             FORMAT=2.   LABEL="H30D # DAYS CANCER"                      
      ER23164             FORMAT=2.   LABEL="H30D # MOS CANCER"                       
      ER23165             FORMAT=2.   LABEL="H30D # WKS CANCER"                       
      ER23166             FORMAT=2.   LABEL="H30D # YRS CANCER"                       
      ER23167             FORMAT=1.   LABEL="H31D LIMIT DAILY ACTIVITY"               
      ER23168             FORMAT=1.   LABEL="H29E WTR LUNG DISEASE"                   
      ER23169             FORMAT=2.   LABEL="H30E # DAYS LUNG DISEASE"                
      ER23170             FORMAT=2.   LABEL="H30E # MOS LUNG DISEASE"                 
      ER23171             FORMAT=2.   LABEL="H30E # WKS LUNG DISEASE"                 
      ER23172             FORMAT=2.   LABEL="H30E # YRS LUNG DISEASE"                 
      ER23173             FORMAT=1.   LABEL="H31E LIMIT DAILY ACTIVITY"               
      ER23174             FORMAT=1.   LABEL="H29F WTR HEART ATTACK"                   
      ER23175             FORMAT=2.   LABEL="H30F # DAYS HEART ATTACK"                
      ER23176             FORMAT=2.   LABEL="H30F # MOS HEART ATTACK"                 
      ER23177             FORMAT=2.   LABEL="H30F # WKS HEART ATTACK"                 
      ER23178             FORMAT=2.   LABEL="H30F # YRS HEART ATTACK"                 
      ER23179             FORMAT=1.   LABEL="H31F LIMIT DAILY ACTIVITY"               
      ER23180             FORMAT=1.   LABEL="H29G WTR HEART DISEASE"                  
      ER23181             FORMAT=2.   LABEL="H30G # DAYS HEART DISEASE"               
      ER23182             FORMAT=2.   LABEL="H30G # MOS HEART DISEASE"                
      ER23183             FORMAT=2.   LABEL="H30G # WKS HEART DISEASE"                
      ER23184             FORMAT=2.   LABEL="H30G # YRS HEART DISEASE"                
      ER23185             FORMAT=1.   LABEL="H31G LIMIT DAILY ACTIVITY"               
      ER23186             FORMAT=1.   LABEL="H29H WTR EMOTIONAL PROB"                 
      ER23187             FORMAT=2.   LABEL="H30H # DAYS EMOTIONAL PR"                
      ER23188             FORMAT=2.   LABEL="H30H # MOS EMOTIONAL PROB"               
      ER23189             FORMAT=2.   LABEL="H30H # WKS EMOTIONAL PROB"               
      ER23190             FORMAT=2.   LABEL="H30H # YRS EMOTIONAL PROB"               
      ER23191             FORMAT=1.   LABEL="H31H LIMIT DAILY ACTIVITY"               
      ER23192             FORMAT=1.   LABEL="H29I WTR ARTHRITIS"                      
      ER23193             FORMAT=2.   LABEL="H30I # DAYS ARTHRITIS"                   
      ER23194             FORMAT=2.   LABEL="H30I # MOS ARTHRITIS"                    
      ER23195             FORMAT=2.   LABEL="H30I # WKS ARTHRITIS"                    
      ER23196             FORMAT=2.   LABEL="H30I # YRS ARTHRITIS"                    
      ER23197             FORMAT=1.   LABEL="H31I LIMIT DAILY ACTIVITY"               
      ER23198             FORMAT=1.   LABEL="H29J WTR ASTHMA"                         
      ER23199             FORMAT=2.   LABEL="H30J # DAYS ASTHMA"                      
      ER23200             FORMAT=2.   LABEL="H30J # MOS ASTHMA"                       
      ER23201             FORMAT=2.   LABEL="H30J # WKS ASTHMA"                       
      ER23202             FORMAT=2.   LABEL="H30J # YRS ASTHMA"                       
      ER23203             FORMAT=1.   LABEL="H31J LIMIT DAILY ACTIVITY"               
      ER23204             FORMAT=1.   LABEL="H29K WTR MENTAL LOSS"                    
      ER23205             FORMAT=2.   LABEL="H30K # DAYS MENTAL LOSS"                 
      ER23206             FORMAT=2.   LABEL="H30K # MOS MENTAL LOSS"                  
      ER23207             FORMAT=2.   LABEL="H30K # WKS MENTAL LOSS"                  
      ER23208             FORMAT=2.   LABEL="H30K # YRS MENTAL LOSS"                  
      ER23209             FORMAT=1.   LABEL="H31K LIMIT DAILY ACTIVITY"               
      ER23210             FORMAT=1.   LABEL="H29L WTR LEARNING DISORDER"              
      ER23211             FORMAT=2.   LABEL="H30L # DAYS LEARNING DISORDER"           
      ER23212             FORMAT=2.   LABEL="H30L # MOS LEARNING DISORDER"            
      ER23213             FORMAT=2.   LABEL="H30L # WKS LEARNING DISORDER"            
      ER23214             FORMAT=2.   LABEL="H30L # YRS LEARNING DISORDER"            
      ER23215             FORMAT=1.   LABEL="H31L LIMIT DAILY ACTIVITY"               
      ER23216             FORMAT=1.   LABEL="H32 WTR HOSPITALIZED IN 2002"            
      ER23217             FORMAT=3.   LABEL="H32A # NIGHTS HOSPITALIZED"              
      ER23218             FORMAT=2.   LABEL="H32A # WEEKS HOSPITALIZED"               
      ER23219             FORMAT=1.   LABEL="H33A WTR PROBLEM BATHING"                
      ER23220             FORMAT=1.   LABEL="H34A WTR SOMEONE HELPS"                  
      ER23221             FORMAT=1.   LABEL="H33B WTR PROBLEM DRESSING"               
      ER23222             FORMAT=1.   LABEL="H34B WTR SOMEONE HELPS"                  
      ER23223             FORMAT=1.   LABEL="H33 WTR PROBLEM EATING"                  
      ER23224             FORMAT=1.   LABEL="H34C WTR SOMEONE HELPS"                  
      ER23225             FORMAT=1.   LABEL="H33D WTR PROB GETTING IN/OUT BED/CHAIR"  
      ER23226             FORMAT=1.   LABEL="H34D WTR SOMEONE HELPS"                  
      ER23227             FORMAT=1.   LABEL="H33E WTR PROBLEM WALKING"                
      ER23228             FORMAT=1.   LABEL="H34E WTR SOMEONE HELPS"                  
      ER23229             FORMAT=1.   LABEL="H33F WTR PROBLEM GETTING OUTSIDE"        
      ER23230             FORMAT=1.   LABEL="H34F WTR SOMEONE HELPS"                  
      ER23231             FORMAT=1.   LABEL="H33G WTR PROBLEM USE/GET TO TOILET"      
      ER23232             FORMAT=1.   LABEL="H34G WTR SOMEONE HELPS"                  
      ER23233             FORMAT=1.   LABEL="H35A WTR DIFFICULT PREPARE MEALS"        
      ER23234             FORMAT=1.   LABEL="H35B HEALTH/PHYSICAL PROBLEM?"           
      ER23235             FORMAT=1.   LABEL="H35C WTR DIFFICULT SHOPPING"             
      ER23236             FORMAT=1.   LABEL="H35D HEALTH/PHYSICAL PROBLEM?"           
      ER23237             FORMAT=1.   LABEL="H35E WTR DIFFICULT MANAGE MONEY"         
      ER23238             FORMAT=1.   LABEL="H35F HEALTH/PHYSICAL PROBLEM?"           
      ER23239             FORMAT=1.   LABEL="H35G WTR TELEPHONE DIFFICULT"            
      ER23240             FORMAT=1.   LABEL="H35H HEALTH/PHYSICAL PROBLEM?"           
      ER23241             FORMAT=1.   LABEL="H35J WTR HEAVY HSWRK DIFFICULT"          
      ER23242             FORMAT=1.   LABEL="H35K HEALTH/PHYSICAL PROBLEM?"           
      ER23243             FORMAT=1.   LABEL="H35L WTR LIGHT HSWRK DIFFICULT"          
      ER23244             FORMAT=1.   LABEL="H35M HEALTH/PHYSCIAL PROBLEM?"           
      ER23245             FORMAT=3.   LABEL="H35 FREQ OF LIGHT PHYSICAL ACTIVITY"     
      ER23246             FORMAT=1.   LABEL="H35 LIGHT PHYSICAL ACTIVITY PER"         
      ER23247             FORMAT=3.   LABEL="H36 FREQ OF HEAVY PHYSICAL ACTIVITY"     
      ER23248             FORMAT=1.   LABEL="H36 HEAVY PHYSICAL ACTIVITY PER"         
      ER23249             FORMAT=1.   LABEL="H36B RUSHED/PRESSED FOR TIME"            
      ER23250             FORMAT=1.   LABEL="H37 WTR SMOKE CIGARETTES"                
      ER23251             FORMAT=3.   LABEL="H38 # CIGARETTES PER DAY"                
      ER23252             FORMAT=2.   LABEL="H39 AGE WHEN FIRST SMOKED"               
      ER23253             FORMAT=1.   LABEL="H40 WTR EVER SMOKED CIGARETTES"          
      ER23254             FORMAT=3.   LABEL="H41 # CIGARETTES PER DAY"                
      ER23255             FORMAT=2.   LABEL="H42 AGE LAST SMOKED REGULARLY"           
      ER23256             FORMAT=2.   LABEL="H43 AGE FIRST SMOKED REGULARLY"          
      ER23257             FORMAT=1.   LABEL="H44 WTR DRINK ALCOHOL"                   
      ER23258             FORMAT=1.   LABEL="H45 # ALCOHOLIC DRINKS PER DAY"          
      ER23259             FORMAT=3.   LABEL="H46 WEIGHT"                              
      ER23260             FORMAT=1.   LABEL="H47 HEIGHT-FEET"                         
      ER23261             FORMAT=2.   LABEL="H47 HEIGHT-INCHES"                       
      ER23262             FORMAT=1.   LABEL="H59A SADNESS IN PAST 30 DAYS"            
      ER23263             FORMAT=1.   LABEL="H59B NERVOUS IN PAST 30 DAYS"            
      ER23264             FORMAT=1.   LABEL="H59C RESTLESS IN PAST 30 DAYS"           
      ER23265             FORMAT=1.   LABEL="H59D HOPELESS IN PAST 30 DAYS"           
      ER23266             FORMAT=1.   LABEL="H59E EVERYTHING EFFORT IN PAST 30 DAYS"  
      ER23267             FORMAT=1.   LABEL="H59F WORTHLESS IN PAST 30 DAYS"          
      ER23268             FORMAT=2.   LABEL="K-6 NON-SPEC PSYCHOL DISTRESS SCALE"     
      ER23269             FORMAT=1.   LABEL="H59G MORE/LESS OFTEN THAN USUAL"         
      ER23270             FORMAT=1.   LABEL="H59H LOT/SOMEWHAT/LITTLE MORE THAN USUAL"
      ER23271             FORMAT=1.   LABEL="H59I LOT/SOMEWHAT/LITTLE LESS THAN USUAL"
      ER23272             FORMAT=1.   LABEL="H59J HOW MUCH FEELINGS INTERFERE W/LIFE" 
      ER23273             FORMAT=2.   LABEL="H59K NUMBER OF DAYS UNABLE TO WORK"      
      ER23274             FORMAT=2.   LABEL="H59L NUMBER OF DAYS REDUCED WORK"        
      ER23275             FORMAT=1.   LABEL="H59M SAD MOST OF DAY 2 WKS OR MORE"      
      ER23276             FORMAT=1.   LABEL="H59N LOSS OF INTEREST 2 WKS OR MORE"     
      ER23277             FORMAT=1.   LABEL="H60 WTR FU MEMBER W/HLTH INS LAST 2 YRS" 
      ER23278             FORMAT=6.   LABEL="H63 TOTAL PAID FOR HLTH INS LAST 2 YRS"  
      ER23279             FORMAT=6.   LABEL="H64 TOTAL HOSPITAL/NURSNG HOME EXPENSES" 
      ER23280             FORMAT=1.   LABEL="H65 WTR TOTAL EXPENSE GE 10,000"         
      ER23281             FORMAT=1.   LABEL="H66 WTR TOTAL EXPENSE GE 20,000"         
      ER23282             FORMAT=1.   LABEL="H67 WTR TOTAL EXPENSE GE 50,000"         
      ER23283             FORMAT=1.   LABEL="H68 WTR TOTAL EXPENSE GE 5,000"          
      ER23284             FORMAT=1.   LABEL="H69 WTR TOTAL EXPENSE GE 500"            
      ER23285             FORMAT=7.   LABEL="H70 TOT DR/OUTPT SURGRY/DENTAL EXPENSES" 
      ER23286             FORMAT=1.   LABEL="H71 WTR TOTAL EXPENSE GE 1,000"          
      ER23287             FORMAT=1.   LABEL="H72 WTR TOTAL EXPENSE GE 5,000"          
      ER23288             FORMAT=1.   LABEL="H73 WTR TOTAL EXPENSE GE 20,000"         
      ER23289             FORMAT=1.   LABEL="H74 WTR TOTAL EXPENSE GE 500"            
      ER23290             FORMAT=1.   LABEL="H75 WTR TOTAL EXPENSE GE 200"            
      ER23291             FORMAT=7.   LABEL="H76 TOTAL PRESCRIPTN/OTR SVCS EXPENSES"  
      ER23292             FORMAT=1.   LABEL="H77 WTR TOTAL EXPENSE GE 5,000"          
      ER23293             FORMAT=1.   LABEL="H78 WTR TOTAL EXPENSE GE 10,000"         
      ER23294             FORMAT=1.   LABEL="H79 WTR TOTAL EXPENSE GE 20,000"         
      ER23295             FORMAT=1.   LABEL="H80 WTR TOTAL EXPENSE GE 1,000"          
      ER23296             FORMAT=1.   LABEL="H81 WTR TOTAL EXPENSE GE 500"            
      ER23297             FORMAT=8.   LABEL="H82 TOTAL COST ALL MEDICAL CARE"         
      ER23298             FORMAT=1.   LABEL="H83 WTR TOTAL COST GE 25,000"            
      ER23299             FORMAT=1.   LABEL="H84 WTR TOTAL COST GE 100,000"           
      ER23300             FORMAT=1.   LABEL="H85 WTR TOTAL COST GE 500,000"           
      ER23301             FORMAT=1.   LABEL="H86 WTR TOTAL COST GE 5,000"             
      ER23302             FORMAT=1.   LABEL="H87 WTR TOTAL COST GE 1,000"             
      ER23303             FORMAT=1.   LABEL="K1 CKPT: WTR WIFE"                       
      ER23304             FORMAT=2.   LABEL="K2/67 ST FATHER BORN-WF"                 
      ER23305             FORMAT=2.   LABEL="K3/68 ST FTH GREW UP-WF"                 
      ER23306             FORMAT=1.   LABEL="K4/69 FTH EDUC IN US-WF"                 
      ER23307             FORMAT=2.   LABEL="K5/70 EDUC OF FTHR US-WF"                
      ER23308             FORMAT=1.   LABEL="K6/71 FTHR READ/WRITE-WF"                
      ER23309             FORMAT=1.   LABEL="K7/72 CKPT FTH ED OUT US"                
      ER23310             FORMAT=2.   LABEL="K8/73 YRS ED FTHR OUT US"                
      ER23311             FORMAT=3.   LABEL="K10-10A OCCUPATION OF FATHER"            
      ER23312             FORMAT=3.   LABEL="K11 INDUSTRY OF FATHER"                  
      ER23313             FORMAT=2.   LABEL="K12/77 ST MOTHER BORN-WF"                
      ER23314             FORMAT=2.   LABEL="K13/78 ST MTHR GREW UP-W"                
      ER23315             FORMAT=1.   LABEL="K14/79 MTHR EDUC IN US-W"                
      ER23316             FORMAT=2.   LABEL="K15/80 ED OF MTH IN US-W"                
      ER23317             FORMAT=1.   LABEL="K16/81 MTH READ/WRITE-WF"                
      ER23318             FORMAT=1.   LABEL="K17/82 CKP MTH ED OUT US"                
      ER23319             FORMAT=2.   LABEL="K18/83 YRS  ED MTH  OUT"                 
      ER23320             FORMAT=3.   LABEL="K20-20A OCCUPATION OF MOTHER"            
      ER23321             FORMAT=3.   LABEL="K21 INDUSTRY OF MOTHER"                  
      ER23322             FORMAT=1.   LABEL="K22 WHETHER BROTHERS WF"                 
      ER23323             FORMAT=2.   LABEL="K23 # BROTHERS WIFE"                     
      ER23324             FORMAT=1.   LABEL="K24 ONLY BRO STILL ALIVE"                
      ER23325             FORMAT=1.   LABEL="K25 ONLY BRO OLDR THAN W"                
      ER23326             FORMAT=2.   LABEL="K26 # BRO STILL ALIVE"                   
      ER23327             FORMAT=1.   LABEL="K27 ANY BRO OLDR THAN WF"                
      ER23328             FORMAT=1.   LABEL="K28 WHETHER SISTERS WF"                  
      ER23329             FORMAT=2.   LABEL="K29 # SISTERS WIFE"                      
      ER23330             FORMAT=1.   LABEL="K30 ONLY SIS STILL ALIVE"                
      ER23331             FORMAT=1.   LABEL="K31 ONLY SIS OLDR THAN W"                
      ER23332             FORMAT=2.   LABEL="K32 # SIS STILL ALIVE WF"                
      ER23333             FORMAT=1.   LABEL="K33 ANY SIS OLDR THAN WF"                
      ER23334             FORMAT=1.   LABEL="K34/87 RACE OF WIFE 1"                   
      ER23335             FORMAT=1.   LABEL="K34/87 RACE OF WIFE 2"                   
      ER23336             FORMAT=1.   LABEL="K34/87 RACE OF WIFE 3"                   
      ER23337             FORMAT=1.   LABEL="K34/87 RACE OF WIFE 4"                   
      ER23338             FORMAT=1.   LABEL="K34A PRIMARY ETHNIC GROUP"               
      ER23339             FORMAT=2.   LABEL="K34A 2ND PRIMARY ETHNIC GROUP MEN 1"     
      ER23340             FORMAT=2.   LABEL="K34A 2ND PRIMARY ETHNIC GROUP MEN 2"     
      ER23341             FORMAT=1.   LABEL="K35 WTR IN MILIT SERV WF"                
      ER23342             FORMAT=1.   LABEL="K36 WTR WIFE EDUC IN US"                 
      ER23343             FORMAT=1.   LABEL="K37 WTR GRADUATED HS WF"                 
      ER23344             FORMAT=2.   LABEL="K38 MO GRADUATED HS WF"                  
      ER23345             FORMAT=4.   LABEL="K38 YR GRADUATED HS WF"                  
      ER23346             FORMAT=2.   LABEL="K39 GRADE LEVEL IF GED-W"                
      ER23347             FORMAT=2.   LABEL="K40 MO LAST IN SCH-GED-W"                
      ER23348             FORMAT=4.   LABEL="K40 YR LAST IN SCH GED-W"                
      ER23349             FORMAT=2.   LABEL="K41 MO RECEIVED GED-WF"                  
      ER23350             FORMAT=4.   LABEL="K41 YR RECEIVED GED-WF"                  
      ER23351             FORMAT=2.   LABEL="K42 GRD OF SCH FINISH-W"                 
      ER23352             FORMAT=2.   LABEL="K43 MO LAST IN SCH-WF"                   
      ER23353             FORMAT=4.   LABEL="K43 YR LAST IN SCH-WF"                   
      ER23354             FORMAT=1.   LABEL="K44 WTR ATTEND COLLEGE"                  
      ER23355             FORMAT=2.   LABEL="K45 MO LAST ATTEND COLL"                 
      ER23356             FORMAT=4.   LABEL="K45 YR LAST ATTEND COLL"                 
      ER23357             FORMAT=1.   LABEL="K46 HGHST YR COLL COMP"                  
      ER23358             FORMAT=1.   LABEL="K47 WTR RECD COLL DEG-W"                 
      ER23359             FORMAT=2.   LABEL="K48 HGHST COLL DEG REC-W"                
      ER23360             FORMAT=2.   LABEL="K51 MO RECD COLL DEG-W"                  
      ER23361             FORMAT=4.   LABEL="K51 YR RECD COLL DEG-W"                  
      ER23362             FORMAT=2.   LABEL="K53/90 YRS SCHL OUT US"                  
      ER23363             FORMAT=1.   LABEL="K55 WTR REC OTR DEG/CER"                 
      ER23364             FORMAT=1.   LABEL="K56 TYPE OTR DEG/CERT 1"                 
      ER23365             FORMAT=2.   LABEL="K57 FIELD OTR DEG/CERT 1"                
      ER23366             FORMAT=2.   LABEL="K58 INST/ORG DEG/CERT 1"                 
      ER23367             FORMAT=2.   LABEL="K59 MO RECD DEG/CERT 1"                  
      ER23368             FORMAT=4.   LABEL="K59 YR RECD DEG/CERT 1"                  
      ER23369             FORMAT=1.   LABEL="K60 OTHER TRAINING 1"                    
      ER23370             FORMAT=1.   LABEL="K56 TYPE OTR DEG/CERT 2"                 
      ER23371             FORMAT=2.   LABEL="K57 FIELD OTR DEG/CERT 2"                
      ER23372             FORMAT=2.   LABEL="K58 INST/ORG DEG/CERT 2"                 
      ER23373             FORMAT=2.   LABEL="K59 MO RECD DEG/CERT 2"                  
      ER23374             FORMAT=4.   LABEL="K59 YR RECD DEG/CERT 2"                  
      ER23375             FORMAT=1.   LABEL="K60 OTHER TRAINING 2"                    
      ER23376             FORMAT=1.   LABEL="K56 TYPE OTR DEG/CERT 3"                 
      ER23377             FORMAT=2.   LABEL="K57 FIELD OTR DEG/CERT 3"                
      ER23378             FORMAT=2.   LABEL="K58 INST/ORG DEG/CERT 3"                 
      ER23379             FORMAT=2.   LABEL="K59 MO RECD DEG/CERT 3"                  
      ER23380             FORMAT=4.   LABEL="K59 YR RECD DEG/CERT 3"                  
      ER23381             FORMAT=1.   LABEL="K60 OTHER TRAINING 3"                    
      ER23382             FORMAT=2.   LABEL="K61 RELIGIOUS PREF-WF"                   
      ER23383             FORMAT=2.   LABEL="K62 RELIG DENOMINTN-WF"                  
      ER23384             FORMAT=2.   LABEL="K63 #YRS WRKD SINCE 18-W"                
      ER23385             FORMAT=2.   LABEL="K64 #YR WRKED FULLTIME-W"                
      ER23386             FORMAT=3.   LABEL="K65-65A OCCUPATION 1ST FULL-TIME JOB"    
      ER23387             FORMAT=3.   LABEL="K66 INDUSTRY 1ST FULL-TIME JOB"          
      ER23388             FORMAT=1.   LABEL="L1 CKPT: WTR NEW HEAD"                   
      ER23389             FORMAT=2.   LABEL="L2/75 ST FATHER BORN-HD"                 
      ER23390             FORMAT=2.   LABEL="L3/76 ST FTH GREW UP-HD"                 
      ER23391             FORMAT=1.   LABEL="L4/77 FTH EDUC IN US-HD"                 
      ER23392             FORMAT=2.   LABEL="L5/78 EDUC OF FTHR US-HD"                
      ER23393             FORMAT=1.   LABEL="L6/79 FTHR READ/WRITE-HD"                
      ER23394             FORMAT=1.   LABEL="L7/80 CKPT FTH ED OUT US"                
      ER23395             FORMAT=2.   LABEL="L8/81 YRS ED FTHR OUT US"                
      ER23396             FORMAT=3.   LABEL="L10-10A OCCUPATION OF FATHER"            
      ER23397             FORMAT=3.   LABEL="L11 INDUSTRY OF FATHER"                  
      ER23398             FORMAT=2.   LABEL="L12/85 ST MOTHER BORN-HD"                
      ER23399             FORMAT=2.   LABEL="L13/86 ST MTHR GREW UP-H"                
      ER23400             FORMAT=1.   LABEL="L14/87 MTHR EDUC IN US-H"                
      ER23401             FORMAT=2.   LABEL="L15/88 ED OF MTH IN US-H"                
      ER23402             FORMAT=1.   LABEL="L16/89 MTH READ/WRITE-HD"                
      ER23403             FORMAT=1.   LABEL="L17/90 CKP MTH ED OUT US"                
      ER23404             FORMAT=2.   LABEL="L18/91 YRS  ED MTH  OUT"                 
      ER23405             FORMAT=3.   LABEL="L20-20A OCCUPATION OF MOTHER"            
      ER23406             FORMAT=3.   LABEL="L21 INDUSTRY OF MOTHER"                  
      ER23407             FORMAT=1.   LABEL="L22 WHETHER BROTHERS HD"                 
      ER23408             FORMAT=2.   LABEL="L23 # BROTHERS HEAD"                     
      ER23409             FORMAT=1.   LABEL="L24 ONLY BRO STILL ALIVE"                
      ER23410             FORMAT=1.   LABEL="L25 ONLY BRO OLDR THAN H"                
      ER23411             FORMAT=2.   LABEL="L26 # BRO STILL ALIVE"                   
      ER23412             FORMAT=1.   LABEL="L27 ANY BRO OLDR THAN HD"                
      ER23413             FORMAT=1.   LABEL="L28 WHETHER SISTERS HD"                  
      ER23414             FORMAT=2.   LABEL="L29 # SISTERS HEAD"                      
      ER23415             FORMAT=1.   LABEL="L30 ONLY SIS STILL ALIVE"                
      ER23416             FORMAT=1.   LABEL="L31 ONLY SIS OLDR THAN H"                
      ER23417             FORMAT=2.   LABEL="L32 # SIS STILL ALIVE HD"                
      ER23418             FORMAT=1.   LABEL="L33 ANY SIS OLDR THAN HD"                
      ER23419             FORMAT=1.   LABEL="L34 GREW UP FARM OR? HD"                 
      ER23420             FORMAT=2.   LABEL="L34 STATE HD GREW UP"                    
      ER23421             FORMAT=1.   LABEL="L35 EVER LIVE OTHER ST"                  
      ER23422             FORMAT=1.   LABEL="L36 EVER MOVE FOR JOB?"                  
      ER23423             FORMAT=1.   LABEL="L37 NOT MOVED FOR JOB?"                  
      ER23424             FORMAT=1.   LABEL="L38 PARENTS POOR OR? HD"                 
      ER23425             FORMAT=1.   LABEL="L39 LIVE W/BOTH PARENTS"                 
      ER23426             FORMAT=1.   LABEL="L40/95 RACE OF HEAD 1"                   
      ER23427             FORMAT=1.   LABEL="L40/95 RACE OF HEAD 2"                   
      ER23428             FORMAT=1.   LABEL="L40/95 RACE OF HEAD 3"                   
      ER23429             FORMAT=1.   LABEL="L40/95 RACE OF HEAD 4"                   
      ER23430             FORMAT=1.   LABEL="L41 PRIMARY ETHNIC GROUP"                
      ER23431             FORMAT=2.   LABEL="L41 2ND PRIMARY ETHNIC GROUP MEN 1"      
      ER23432             FORMAT=2.   LABEL="L41 2ND PRIMARY ETHNIC GROUP MEN 2"      
      ER23433             FORMAT=1.   LABEL="L42 WTR IN MILIT SERV-HD"                
      ER23434             FORMAT=1.   LABEL="L43 WTR HEAD EDUC IN US"                 
      ER23435             FORMAT=1.   LABEL="L44 WTR GRADUATED HS HD"                 
      ER23436             FORMAT=2.   LABEL="L45 MO GRADUATED HS HD"                  
      ER23437             FORMAT=4.   LABEL="L45 YR GRADUATED HS HD"                  
      ER23438             FORMAT=2.   LABEL="L46 GRADE LEVEL IF GED-H"                
      ER23439             FORMAT=2.   LABEL="L47 MO LAST IN SCH-GED-H"                
      ER23440             FORMAT=4.   LABEL="L47 YR LAST IN SCH GED-H"                
      ER23441             FORMAT=2.   LABEL="L48 MO RECEIVED GED-HD"                  
      ER23442             FORMAT=4.   LABEL="L48 YR RECEIVED GED-HD"                  
      ER23443             FORMAT=2.   LABEL="L49 GRD OF SCH FINISH-HD"                
      ER23444             FORMAT=2.   LABEL="L50 MO LAST IN SCHL-HD"                  
      ER23445             FORMAT=4.   LABEL="L50 YR LAST IN SCHL-HD"                  
      ER23446             FORMAT=1.   LABEL="L51 WTR ATTEND COLLEGE"                  
      ER23447             FORMAT=2.   LABEL="L52 MO LAST ATTEND COLL"                 
      ER23448             FORMAT=4.   LABEL="L52 YR LAST ATTEND COLL"                 
      ER23449             FORMAT=1.   LABEL="L53 HGHST YR COLL COMP"                  
      ER23450             FORMAT=1.   LABEL="L54 WTR RECD COLL DEG-HD"                
      ER23451             FORMAT=2.   LABEL="L55 HGHST COLL DEG REC-H"                
      ER23452             FORMAT=2.   LABEL="L58 MO RECD COLL DEG-HD"                 
      ER23453             FORMAT=4.   LABEL="L58 YR RECD COLL DEG-HD"                 
      ER23454             FORMAT=2.   LABEL="L60/98 YRS SCHL OUT US"                  
      ER23455             FORMAT=1.   LABEL="L62 WTR REC OTR DEG/CER"                 
      ER23456             FORMAT=1.   LABEL="L63 TYPE OTR DEG/CERT 1"                 
      ER23457             FORMAT=2.   LABEL="L64 FIELD OTR DEG/CERT 1"                
      ER23458             FORMAT=2.   LABEL="L65 INST/ORG DEG/CERT 1"                 
      ER23459             FORMAT=2.   LABEL="L66 MO RECD DEG/CERT 1"                  
      ER23460             FORMAT=4.   LABEL="L66 YR RECD DEG/CERT 1"                  
      ER23461             FORMAT=1.   LABEL="L67 OTHER TRAINING 1"                    
      ER23462             FORMAT=1.   LABEL="L63 TYPE OTR DEG/CERT 2"                 
      ER23463             FORMAT=2.   LABEL="L64 FIELD OTR DEG/CERT 2"                
      ER23464             FORMAT=2.   LABEL="L65 INST/ORG DEG/CERT 2"                 
      ER23465             FORMAT=2.   LABEL="L66 MO RECD DEG/CERT 2"                  
      ER23466             FORMAT=4.   LABEL="L66 YR RECD DEG/CERT 2"                  
      ER23467             FORMAT=1.   LABEL="L67 OTHER TRAINING 2"                    
      ER23468             FORMAT=1.   LABEL="L63 TYPE OTR DEG/CERT 3"                 
      ER23469             FORMAT=2.   LABEL="L64 FIELD OTR DEG/CERT 3"                
      ER23470             FORMAT=2.   LABEL="L65 INST/ORG DEG/CERT 3"                 
      ER23471             FORMAT=2.   LABEL="L66 MO RECD DEG/CERT 3"                  
      ER23472             FORMAT=4.   LABEL="L66 YR RECD DEG/CERT 3"                  
      ER23473             FORMAT=1.   LABEL="L67 OTHER TRAINING 3"                    
      ER23474             FORMAT=2.   LABEL="L68 RELIGIOUS PREF-HD"                   
      ER23475             FORMAT=2.   LABEL="L69 RELIG DENOMINTN-HD"                  
      ER23476             FORMAT=2.   LABEL="L70 #YRS WRKD SINCE 18-H"                
      ER23477             FORMAT=2.   LABEL="L71 #YR WRKED FULLTIME-H"                
      ER23478             FORMAT=3.   LABEL="L72-72A OCCUPATION 1ST FULL-TIME JOB"    
      ER23479             FORMAT=3.   LABEL="L73 INDUSTRY 1ST FULL-TIME JOB"          
      ER23480             FORMAT=1.   LABEL="L72 # DIFF JOBS OR? HD"                  
      ER23481             FORMAT=1.   LABEL="M1 WTR DONATION>25 TO CHARITY LAST YEAR" 
      ER23482             FORMAT=1.   LABEL="M2 WTR DONATED TO RELIGIOUS ORGANIZATION"
      ER23483             FORMAT=6.   LABEL="M2A DOLLAR AMT OF RELIGIOUS DONATIONS"   
      ER23484             FORMAT=1.   LABEL="M2B WTR RELIGIOUS DONATIONS GE 300"      
      ER23485             FORMAT=1.   LABEL="M2C WTR RELIGIOUS DONATIONS GE 1,000"    
      ER23486             FORMAT=1.   LABEL="M2D WTR RELIGIOUS DONATIONS GE 2,500"    
      ER23487             FORMAT=1.   LABEL="M2E WTR RELIGIOUS DONATIONS GE 100"      
      ER23488             FORMAT=1.   LABEL="M3 WTR DONATD TO COMBO PURPOSE ORGANIZTN"
      ER23489             FORMAT=6.   LABEL="M3A DOLLAR AMT OF COMBO DONATIONS"       
      ER23490             FORMAT=1.   LABEL="M3B WTR COMBO DONATIONS GE 200"          
      ER23491             FORMAT=1.   LABEL="M3C WTR COMBO DONATIONS GE 500"          
      ER23492             FORMAT=1.   LABEL="M3D WTR COMBO DONATIONS GE 1,000"        
      ER23493             FORMAT=1.   LABEL="M3E WTR COMBO DONATIONS GE 100"          
      ER23494             FORMAT=1.   LABEL="M4 WTR DONATED TO ORGANIZATION FOR NEEDY"
      ER23495             FORMAT=5.   LABEL="M4A DOLLAR AMT OF NEEDY DONATIONS"       
      ER23496             FORMAT=1.   LABEL="M4B WTR NEEDY DONATIONS GE 200"          
      ER23497             FORMAT=1.   LABEL="M4C WTR NEEDY DONATIONS GE 500"          
      ER23498             FORMAT=1.   LABEL="M4D WTR NEEDY DONATIONS GE 1,000"        
      ER23499             FORMAT=1.   LABEL="M4E WTR NEEDY DONATIONS GE 100"          
      ER23500             FORMAT=1.   LABEL="M5 WTR DONATED TO ORGANIZATN FOR HEALTH" 
      ER23501             FORMAT=5.   LABEL="M5A DOLLAR AMT OF HEALTH DONATIONS"      
      ER23502             FORMAT=1.   LABEL="M5B WTR HEALTH DONATIONS GE 200"         
      ER23503             FORMAT=1.   LABEL="M5C WTR HEALTH DONATIONS GE 500"         
      ER23504             FORMAT=1.   LABEL="M5D WTR HEALTH DONATIONS GE 1,000"       
      ER23505             FORMAT=1.   LABEL="M5E WTR HEALTH DONATIONS GE 100"         
      ER23506             FORMAT=1.   LABEL="M6 WTR DONATED TO ORGANZTION FOR EDUCATN"
      ER23507             FORMAT=5.   LABEL="M6A DOLLAR AMT OF EDUCATION DONATIONS"   
      ER23508             FORMAT=1.   LABEL="M6B WTR EDUCATION DONATIONS GE 200"      
      ER23509             FORMAT=1.   LABEL="M6C WTR EDUCATION DONATIONS GE 500"      
      ER23510             FORMAT=1.   LABEL="M6D WTR EDUCATION DONATIONS GE 1,000"    
      ER23511             FORMAT=1.   LABEL="M6E WTR EDUCATION DONATIONS GE 100"      
      ER23512             FORMAT=1.   LABEL="M7 WTR DONATED TO YOUTH ORGANIZATIONS"   
      ER23513             FORMAT=5.   LABEL="M7A DOLLAR AMT OF YOUTH ORG DONATIONS"   
      ER23514             FORMAT=1.   LABEL="M7B WTR YOUTH ORG DONATIONS GE 200"      
      ER23515             FORMAT=1.   LABEL="M7C WTR YOUTH ORG DONATIONS GE 500"      
      ER23516             FORMAT=1.   LABEL="M7D WTR YOUTH ORG DONATIONS GE 1,000"    
      ER23517             FORMAT=1.   LABEL="M7E WTR YOUTH ORG DONATIONS GE 100"      
      ER23518             FORMAT=1.   LABEL="M8 WTR DONATED TO CULTURAL ORGS"         
      ER23519             FORMAT=5.   LABEL="M8A DOLLAR AMT OF CULTURAL DONATIONS"    
      ER23520             FORMAT=1.   LABEL="M8B WTR CULTURAL DONATIONS GE 200"       
      ER23521             FORMAT=1.   LABEL="M8C WTR CULTURAL DONATIONS GE 500"       
      ER23522             FORMAT=1.   LABEL="M8D WTR CULTURAL DONATIONS GE 1,000"     
      ER23523             FORMAT=1.   LABEL="M8E WTR CULTURAL DONATIONS GE 100"       
      ER23524             FORMAT=1.   LABEL="M9 WTR DONATED TO COMMUNITY ORGS"        
      ER23525             FORMAT=5.   LABEL="M9A DOLLAR AMT OF COMMUNITY DONATIONS"   
      ER23526             FORMAT=1.   LABEL="M9B WTR COMMUNITY DONATIONS GE 200"      
      ER23527             FORMAT=1.   LABEL="M9C WTR COMMUNITY DONATIONS GE 500"      
      ER23528             FORMAT=1.   LABEL="M9D WTR COMMUNITY DONATIONS GE 1,000"    
      ER23529             FORMAT=1.   LABEL="M9E WTR COMMUNITY DONATIONS GE 100"      
      ER23530             FORMAT=1.   LABEL="M10 WTR DONATED TO ENVIRONMENT ORGS"     
      ER23531             FORMAT=5.   LABEL="M10A DOLLAR AMT OF ENVIRONMENT DONATION" 
      ER23532             FORMAT=1.   LABEL="M10B WTR ENVIRONMENT DONATIONS GE 200"   
      ER23533             FORMAT=1.   LABEL="M10C WTR ENVIRONMENT DONATIONS GE 500"   
      ER23534             FORMAT=1.   LABEL="M10D WTR ENVIRONMENT DONATIONS GE 1,000" 
      ER23535             FORMAT=1.   LABEL="M10E WTR ENVIRONMENT DONATIONS GE 100"   
      ER23536             FORMAT=1.   LABEL="M11 WTR DONATED TO INTERNATL/PEACE ORG"  
      ER23537             FORMAT=5.   LABEL="M11A DOLLAR AMT OF INTERNATL/PEACE DNTN" 
      ER23538             FORMAT=1.   LABEL="M11B WTR INTERNATL/PEACE DNTNS GE 200"   
      ER23539             FORMAT=1.   LABEL="M11C WTR INTERNATL/PEACE DNTNS GE 500"   
      ER23540             FORMAT=1.   LABEL="M11D WTR INTERNATL/PEACE DNTNS GE 1,000" 
      ER23541             FORMAT=1.   LABEL="M11E WTR INTERNATL/PEACE DNTNS GE 100"   
      ER23542             FORMAT=1.   LABEL="M12 WTR DONATED TO OTHER ORGANIZATIONS"  
      ER23543             FORMAT=5.   LABEL="M12B DOLLAR AMT OF OTHER DONATIONS"      
      ER23544             FORMAT=1.   LABEL="M12C WTR OTHER DONATIONS GE 200"         
      ER23545             FORMAT=1.   LABEL="M12D WTR OTHER DONATIONS GE 500"         
      ER23546             FORMAT=1.   LABEL="M12E WTR OTHER DONATIONS GE 1,000"       
      ER23547             FORMAT=1.   LABEL="M12F WTR OTHER DONATIONS GE 100"         
      ER23548             FORMAT=1.   LABEL="M13A WHO DECIDED CHARITABLE SUPPORT"     
      ER23549             FORMAT=1.   LABEL="M13B AQSN OF MAJOR DECISION MAKER"       
      ER23550             FORMAT=1.   LABEL="M14 WTR HEAD VOLUNTEERED PAST MONTH"     
      ER23551             FORMAT=1.   LABEL="M14A WTR HEAD VOLUNTEERED LAST YEAR"     
      ER23552             FORMAT=1.   LABEL="M14B WTR HD/WF VOLUNTEERED PAST MONTH"   
      ER23553             FORMAT=1.   LABEL="M14C WTR HD/WF VOLUNTEERED LAST YR"      
      ER23554             FORMAT=2.   LABEL="M15A HOW OFTEN HD RELIG VLNTEER LAST YR" 
      ER23555             FORMAT=1.   LABEL="M15A HOW OFTEN HD RELIG VOLUNTEER PER"   
      ER23556             FORMAT=1.   LABEL="M15C HD NAME FOR PLACE OF WORSHIP"       
      ER23557             FORMAT=2.   LABEL="M15D HD HOURS VOLUNTEER EACH TIME"       
      ER23558             FORMAT=2.   LABEL="M15D HD MINUTES VOLUNTEER EACH TIME"     
      ER23559             FORMAT=5.   LABEL="M15E HD ANNUAL HRS RELIG VOLUNTEER"      
      ER23560             FORMAT=1.   LABEL="M15F WTR HD MORE/FEWER HRS THAN M15E"    
      ER23561             FORMAT=5.   LABEL="M15G HD ESTIMATE RELIG VLNTEER ANN HRS"  
      ER23562             FORMAT=1.   LABEL="M15H WTR M15G INCLUDES EXTRA VOLUNTEER"  
      ER23563             FORMAT=5.   LABEL="M15I ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23564             FORMAT=2.   LABEL="M18A HOW OFTEN WF RELIG VLNTEER LAST YR" 
      ER23565             FORMAT=1.   LABEL="M18A HOW OFTEN WF RELIG VOLUNTEER PER"   
      ER23566             FORMAT=1.   LABEL="M18C WF NAME FOR PLACE OF WORSHIP"       
      ER23567             FORMAT=2.   LABEL="M18D WF HOURS  VOLUNTEER EACH TIME"      
      ER23568             FORMAT=2.   LABEL="M18D WF MINUTES VOLUNTEER EACH TIME"     
      ER23569             FORMAT=5.   LABEL="M18E WF ANNUAL HRS RELIG VOLUNTEER"      
      ER23570             FORMAT=1.   LABEL="M18F WTR WF MORE/FEWER HRS THAN M18E"    
      ER23571             FORMAT=5.   LABEL="M18G WF ESTIMATE RELIG VLNTEER ANN HRS"  
      ER23572             FORMAT=1.   LABEL="M18H WTR M18G INCLUDES EXTRA VOLUNTEER"  
      ER23573             FORMAT=5.   LABEL="M18I ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23574             FORMAT=2.   LABEL="M21A HOW OFTEN HD YOUTH VLNTEER LAST YR" 
      ER23575             FORMAT=1.   LABEL="M21A HOW OFTEN HD YOUTH VOLUNTEER PER"   
      ER23576             FORMAT=2.   LABEL="M21C HD HOURS VOLUNTEER EACH TIME"       
      ER23577             FORMAT=2.   LABEL="M21C HD MINUTES VOLUNTEER EACH TIME"     
      ER23578             FORMAT=5.   LABEL="M21D HD ANNUAL HRS YOUTH VOLUNTEER"      
      ER23579             FORMAT=1.   LABEL="M21E WTR HD MORE/FEWER HRS THAN M21D"    
      ER23580             FORMAT=5.   LABEL="M21F HD ESTIMATE YOUTH VLNTEER ANN HRS"  
      ER23581             FORMAT=1.   LABEL="M21G WTR M21F INCLUDES EXTRA VOLUNTEER"  
      ER23582             FORMAT=5.   LABEL="M21H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23583             FORMAT=2.   LABEL="M23A HOW OFTEN WF YOUTH VLNTEER LAST YR" 
      ER23584             FORMAT=1.   LABEL="M23A HOW OFTEN WF YOUTH VOLUNTEER PER"   
      ER23585             FORMAT=2.   LABEL="M23C WF HOURS VOLUNTEER EACH TIME"       
      ER23586             FORMAT=2.   LABEL="M23C WF MINUTES VOLUNTEER EACH TIME"     
      ER23587             FORMAT=5.   LABEL="M23D WF ANNUAL HRS YOUTH VOLUNTEER"      
      ER23588             FORMAT=1.   LABEL="M23E WTR WF MORE/FEWER HRS THAN M23D"    
      ER23589             FORMAT=5.   LABEL="M23F HD ESTIMATE YOUTH VLNTEER ANN HRS"  
      ER23590             FORMAT=1.   LABEL="M23G WTR M23F INCLUDES EXTRA VOLUNTEER"  
      ER23591             FORMAT=5.   LABEL="M23H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23592             FORMAT=2.   LABEL="M25A HOW OFTEN HD SENIOR VLNTEER LAST YR"
      ER23593             FORMAT=1.   LABEL="M25A HOW OFTEN HD SENIOR VOLUNTEER PER"  
      ER23594             FORMAT=2.   LABEL="M25C HD HOURS VOLUNTEER EACH TIME"       
      ER23595             FORMAT=2.   LABEL="M25C HD MINUTES VOLUNTEER EACH TIME"     
      ER23596             FORMAT=5.   LABEL="M25D HD ANNUAL HRS SENIOR VOLUNTEER"     
      ER23597             FORMAT=1.   LABEL="M25E WTR HD MORE/FEWER HRS THAN M25D"    
      ER23598             FORMAT=5.   LABEL="M25F HD ESTIMATE SENIOR VLNTEER ANN HRS" 
      ER23599             FORMAT=1.   LABEL="M25G WTR M25F INCLUDES EXTRA VOLUNTEER"  
      ER23600             FORMAT=5.   LABEL="M25H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23601             FORMAT=2.   LABEL="M27A HOW OFTEN WF SENIOR VLNTEER LAST YR"
      ER23602             FORMAT=1.   LABEL="M27A HOW OFTEN WF SENIOR VOLUNTEER PER"  
      ER23603             FORMAT=2.   LABEL="M27C WF HOURS VOLUNTEER EACH TIME"       
      ER23604             FORMAT=2.   LABEL="M27C WF MINUTES VOLUNTEER EACH TIME"     
      ER23605             FORMAT=5.   LABEL="M27D WF ANNUAL HRS SENIOR VOLUNTEER"     
      ER23606             FORMAT=1.   LABEL="M27E WTR WF MORE/FEWER HRS THAN M27D"    
      ER23607             FORMAT=5.   LABEL="M27F WF ESTIMATE SENIOR VLNTEER ANN HRS" 
      ER23608             FORMAT=1.   LABEL="M27G WTR M27F INCLUDES EXTRA VOLUNTEER"  
      ER23609             FORMAT=5.   LABEL="M27H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23610             FORMAT=2.   LABEL="M29A HOW OFTEN HD HEALTH VLNTEER LAST YR"
      ER23611             FORMAT=1.   LABEL="M29A HOW OFTEN HD HEALTH VOLUNTEER PER"  
      ER23612             FORMAT=2.   LABEL="M29C HD HOURS VOLUNTEER EACH TIME"       
      ER23613             FORMAT=2.   LABEL="M29C HD MINUTES VOLUNTEER EACH TIME"     
      ER23614             FORMAT=5.   LABEL="M29D HD ANNUAL HRS HEALTH VOLUNTEER"     
      ER23615             FORMAT=1.   LABEL="M29E WTR HD MORE/FEWER HRS THAN M29D"    
      ER23616             FORMAT=5.   LABEL="M29F HD ESTIMATE HEALTH VLNTEER ANN HRS" 
      ER23617             FORMAT=1.   LABEL="M29G WTR M29F INCLUDES EXTRA VOLUNTEER"  
      ER23618             FORMAT=5.   LABEL="M29H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23619             FORMAT=2.   LABEL="M31A HOW OFTEN WF HEALTH VLNTEER LAST YR"
      ER23620             FORMAT=1.   LABEL="M31A HOW OFTEN WF HEALTH VOLUNTEER PER"  
      ER23621             FORMAT=2.   LABEL="M31C WF HOURS VOLUNTEER EACH TIME"       
      ER23622             FORMAT=2.   LABEL="M31C WF MINUTES VOLUNTEER EACH TIME"     
      ER23623             FORMAT=5.   LABEL="M31D WF ANNUAL HRS HEALTH VOLUNTEER"     
      ER23624             FORMAT=1.   LABEL="M31E WTR WF MORE/FEWER HRS THAN M31D"    
      ER23625             FORMAT=5.   LABEL="M31F WF ESTIMATE HEALTH VLNTEER ANN HRS" 
      ER23626             FORMAT=1.   LABEL="M31G WTR M31F INCLUDES EXTRA VOLUNTEER"  
      ER23627             FORMAT=5.   LABEL="M31H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23628             FORMAT=2.   LABEL="M33A HOW OFTEN HD VLNTEER NEEDY LAST YR" 
      ER23629             FORMAT=1.   LABEL="M33A HOW OFTEN HD VOLUNTEER NEEDY PER"   
      ER23630             FORMAT=2.   LABEL="M33C HD HOURS VOLUNTEER EACH TIME"       
      ER23631             FORMAT=2.   LABEL="M33C HD MINUTES VOLUNTEER EACH TIME"     
      ER23632             FORMAT=5.   LABEL="M33D HD ANNUAL HRS VOLUNTEER FOR NEEDY"  
      ER23633             FORMAT=1.   LABEL="M33E WTR HD MORE/FEWER HRS THAN M33D"    
      ER23634             FORMAT=5.   LABEL="M33F HD ESTIMATE VLNTEER NEEDY ANN HRS"  
      ER23635             FORMAT=1.   LABEL="M33G WTR M33F INCLUDES EXTRA VOLUNTEER"  
      ER23636             FORMAT=5.   LABEL="M33H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23637             FORMAT=2.   LABEL="M35A HOW OFTEN WF VLNTEER NEEDY LAST YR" 
      ER23638             FORMAT=1.   LABEL="M35A HOW OFTEN WF VOLUNTEER NEEDY PER"   
      ER23639             FORMAT=2.   LABEL="M35C WF HOURS VOLUNTEER EACH TIME"       
      ER23640             FORMAT=2.   LABEL="M35C WF MINUTES VOLUNTEER EACH TIME"     
      ER23641             FORMAT=5.   LABEL="M35D WF ANNUAL HRS VOLUNTEER FOR NEEDY"  
      ER23642             FORMAT=1.   LABEL="M35E WTR WF MORE/FEWER HRS THAN M35D"    
      ER23643             FORMAT=5.   LABEL="M35F WF ESTIMATE VLNTEER NEEDY ANN HRS"  
      ER23644             FORMAT=1.   LABEL="M35G WTR M35F INCLUDES EXTRA VOLUNTEER"  
      ER23645             FORMAT=5.   LABEL="M35H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23646             FORMAT=2.   LABEL="M37A HOW OFTEN HD VLNTEER CHANGE LST YR" 
      ER23647             FORMAT=1.   LABEL="M37A HOW OFTEN HD VOLUNTEER CHANGE PER"  
      ER23648             FORMAT=2.   LABEL="M37C HD HOURS VOLUNTEER EACH TIME"       
      ER23649             FORMAT=2.   LABEL="M37C HD MINUTES VOLUNTEER EACH TIME"     
      ER23650             FORMAT=5.   LABEL="M37D HD ANNUAL HRS VLNTEER FOR CHANGE"   
      ER23651             FORMAT=1.   LABEL="M37E WTR HD MORE/FEWER HRS THAN M37D"    
      ER23652             FORMAT=5.   LABEL="M37F HD ESTIMATE VLNTEER CHANGE ANN HRS" 
      ER23653             FORMAT=1.   LABEL="M37G WTR M37F INCLUDES EXTRA VOLUNTEER"  
      ER23654             FORMAT=5.   LABEL="M37H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23655             FORMAT=2.   LABEL="M39A HOW OFTEN WF VLNTEER CHANGE LST YR" 
      ER23656             FORMAT=1.   LABEL="M39A HOW OFTEN WF VOLUNTEER CHANGE PER"  
      ER23657             FORMAT=2.   LABEL="M39C WF HOURS VOLUNTEER EACH TIME"       
      ER23658             FORMAT=2.   LABEL="M39C WF MINUTES VOLUNTEER EACH TIME"     
      ER23659             FORMAT=5.   LABEL="M39D WF ANNUAL HRS VLNTEER FOR CHANGE"   
      ER23660             FORMAT=1.   LABEL="M39E WTR WF MORE/FEWER HRS THAN M39D"    
      ER23661             FORMAT=5.   LABEL="M39F WF ESTIMATE VLNTEER CHANGE ANN HRS" 
      ER23662             FORMAT=1.   LABEL="M39G WTR M39F INCLUDES EXTRA VOLUNTEER"  
      ER23663             FORMAT=5.   LABEL="M39H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23664             FORMAT=1.   LABEL="M41 WTR HD OTHER VLNTEER LAST YR"        
      ER23665             FORMAT=2.   LABEL="M41B HOW OFTEN HD OTHER VLNTEER"         
      ER23666             FORMAT=1.   LABEL="M41B HOW OFTEN HD OTHER VLNTEER PER"     
      ER23667             FORMAT=2.   LABEL="M41C HD HOURS VOLUNTEER EACH TIME"       
      ER23668             FORMAT=2.   LABEL="M41C HD MINUTES VOLUNTEER EACH TIME"     
      ER23669             FORMAT=5.   LABEL="M41D HD ANNURAL HRS OTHER VOLUNTEER"     
      ER23670             FORMAT=1.   LABEL="M41E WTR HD MORE/FEWER HRS THAN M41D"    
      ER23671             FORMAT=5.   LABEL="M41F HD ESTIMATE OTHER VLNTEER ANN HRS"  
      ER23672             FORMAT=1.   LABEL="M41G WTR M41F INCLUDES EXTRA VOLUNTEER"  
      ER23673             FORMAT=5.   LABEL="M41H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23674             FORMAT=1.   LABEL="M43 WTR WF OTHER VLNTEER LAST YR"        
      ER23675             FORMAT=2.   LABEL="M43B HOW OFTEN WF OTHER VLNTEER"         
      ER23676             FORMAT=1.   LABEL="M43B HOW OFTEN WF OTHER VLNTEER PER"     
      ER23677             FORMAT=2.   LABEL="M43C WF HOURS VOLUNTEER EACH TIME"       
      ER23678             FORMAT=2.   LABEL="M43C WF MINUTES VOLUNTEER EACH TIME"     
      ER23679             FORMAT=5.   LABEL="M43D WF ANNURAL HRS OTHER VOLUNTEER"     
      ER23680             FORMAT=1.   LABEL="M43E WTR WF MORE/FEWER HRS THAN M43D"    
      ER23681             FORMAT=5.   LABEL="M43F WF ESTIMATE OTHER VLNTEER ANN HRS"  
      ER23682             FORMAT=1.   LABEL="M43G WTR M43F INCLUDES EXTRA VOLUNTEER"  
      ER23683             FORMAT=5.   LABEL="M43H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER23684             FORMAT=1.   LABEL="M45 WTR VOLUNTEER THRU ORGS"             
      ER23685             FORMAT=1.   LABEL="M46 WTR THRU PLACE OF WORSHIP"           
      ER23686             FORMAT=5.   LABEL="M46A HRS THRU PLACE OF WORSHIP"          
      ER23687             FORMAT=1.   LABEL="M47 WTR THRU ORGS FOR KIDS"              
      ER23688             FORMAT=5.   LABEL="M47A HRS THRU ORGS FOR KIDS"             
      ER23689             FORMAT=1.   LABEL="M48 WTR THRU ORGS FOR SENIORS"           
      ER23690             FORMAT=5.   LABEL="M48A HRS THRU ORGS FOR SENIORS"          
      ER23691             FORMAT=1.   LABEL="M49 WTR THRU HEALTH ORGS"                
      ER23692             FORMAT=5.   LABEL="M49A HRS THRU HEALTH ORGS"               
      ER23693             FORMAT=1.   LABEL="M50 WTR THRU ORGS FOR POOR"              
      ER23694             FORMAT=5.   LABEL="M50A HRS THRU ORGS FOR POOR"             
      ER23695             FORMAT=1.   LABEL="M51 WTR THRU ORGS FOR SOC CHANGE"        
      ER23696             FORMAT=5.   LABEL="M51A HRS THRU ORGS FOR SOC CHANGE"       
      ER23697             FORMAT=1.   LABEL="M52 WTR THRU ORGS FOR OTR PURPOSES"      
      ER23698             FORMAT=5.   LABEL="M52A  HRS THRU ORGS FOR OTR PURPOSES"    
      ER23699             FORMAT=2.   LABEL="M53A HOW OFTEN ATTEND RELIGIOUS SVCS"    
      ER23700             FORMAT=1.   LABEL="M53A HOW OFTEN RELIGIOUS SERVICES PER"   
      ER23701             FORMAT=2.   LABEL="M54A FREQ ATTENDNCE RELIG SVCS"          
      ER23702             FORMAT=1.   LABEL="M54A FREQ ATTENDNCE RELIG SVCS PER"      
      ER23703             FORMAT=1.   LABEL="R1 WTR RECD ST/LOCL WELFARE YR B4 LAST"  
      ER23704             FORMAT=7.   LABEL="R5 WELFARE  AMT"                         
      ER23705             FORMAT=1.   LABEL="R5 WELFARE PER"                          
      ER23706             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC JAN YR BEFORE LAST"  
      ER23707             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC FEB YR BEFORE LAST"  
      ER23708             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC MAR YR BEFORE LAST"  
      ER23709             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC APR YR BEFORE LAST"  
      ER23710             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC MAY YR BEFORE LAST"  
      ER23711             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC JUN YR BEFORE LAST"  
      ER23712             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC JUL YR BEFORE LAST"  
      ER23713             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC AUG YR BEFORE LAST"  
      ER23714             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC SEP YR BEFORE LAST"  
      ER23715             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC OCT YR BEFORE LAST"  
      ER23716             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC NOV YR BEFORE LAST"  
      ER23717             FORMAT=1.   LABEL="R6 WTR RECEIVED ADC DEC YR BEFORE LAST"  
      ER23718             FORMAT=1.   LABEL="R7 WTR RECEIVED SSI YR BEFORE LAST"      
      ER23719             FORMAT=1.   LABEL="R11 WTR REC CHILD SUPPORT YR BEFORE LAST"
      ER23720             FORMAT=7.   LABEL="R13 CHILD SUPPORT AMT"                   
      ER23721             FORMAT=1.   LABEL="R13 CHILD SUPPORT PER"                   
      ER23722             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT JAN YR B4 LAST"  
      ER23723             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT FEB YR B4 LAST"  
      ER23724             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT MAR YR B4 LAST"  
      ER23725             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT APR YR B4 LAST"  
      ER23726             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT MAY YR B4 LAST"  
      ER23727             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT JUN YR B4 LAST"  
      ER23728             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT JUL YR B4 LAST"  
      ER23729             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT AUG YR B4 LAST"  
      ER23730             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT SEP YR B4 LAST"  
      ER23731             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT OCT YR B4 LAST"  
      ER23732             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT NOV YR B4 LAST"  
      ER23733             FORMAT=1.   LABEL="R14 WTR RECD CH SUPPORT DEC YR B4 LAST"  
      ER23734             FORMAT=1.   LABEL="R15 WTR REC HELP FROM RELS YR B4 LAST"   
      ER23735             FORMAT=7.   LABEL="R17 HELP FROM RELS AMT"                  
      ER23736             FORMAT=1.   LABEL="R17 HELP FROM RELS PER"                  
      ER23737             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS JAN YR B4 LAST"
      ER23738             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS FEB YR B4 LAST"
      ER23739             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS MAR YR B4 LAST"
      ER23740             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS APR YR B4 LAST"
      ER23741             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS MAY YR B4 LAST"
      ER23742             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS JUN YR B4 LAST"
      ER23743             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS JUL YR B4 LAST"
      ER23744             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS AUG YR B4 LAST"
      ER23745             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS SEP YR B4 LAST"
      ER23746             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS OCT YR B4 LAST"
      ER23747             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS NOV YR B4 LAST"
      ER23748             FORMAT=1.   LABEL="R18 WTR REC HELP FRM RELS DEC YR B4 LAST"
      ER23749             FORMAT=1.   LABEL="R19 WTR HELP FROM NONRELS YR BEFORE LAST"
      ER23750             FORMAT=7.   LABEL="R21 HELP FROM NONRELATIVES AMT"          
      ER23751             FORMAT=1.   LABEL="R21 HELP FROM NONRELATIVES PER"          
      ER23752             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS JAN"      
      ER23753             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS FEB"      
      ER23754             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS MAR"      
      ER23755             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS APR"      
      ER23756             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS MAY"      
      ER23757             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS JUN"      
      ER23758             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS JUL"      
      ER23759             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS AUG"      
      ER23760             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS SEP"      
      ER23761             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS OCT"      
      ER23762             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS NOV"      
      ER23763             FORMAT=1.   LABEL="R22 WTR RECD HELP FROM NONRELS DEC"      
      ER23764             FORMAT=9.   LABEL="R23 TOTAL INCOME YR BEFORE LAST"         
      ER23765             FORMAT=1.   LABEL="R24A WTR AMT GE 40,000"                  
      ER23766             FORMAT=1.   LABEL="R24B WTR AMT GE 65,000"                  
      ER23767             FORMAT=1.   LABEL="R24C WTR AMT GE 25,000"                  
      ER23768             FORMAT=1.   LABEL="R47 WTR REC PUBLIC ASST IN LAST 2 YRS"   
      ER23769             FORMAT=1.   LABEL="R48 WELFARE STOP>1 MO SINCE JAN 2 YR AGO"
      ER23770             FORMAT=1.   LABEL="R49 WTR GVT OFFICE ENDED ASSISTANCE"     
      ER23771             FORMAT=1.   LABEL="R50 GOT JOB SO LEFT WELFARE"             
      ER23772             FORMAT=1.   LABEL="R50 MORE WORK/MONEY SO LEFT WELFARE"     
      ER23773             FORMAT=1.   LABEL="R50 GOT BETTER JOB SO LEFT WELFARE"      
      ER23774             FORMAT=1.   LABEL="R50 GOT MARRIED SO LEFT WELFARE"         
      ER23775             FORMAT=1.   LABEL="R50 MOVED IN W/FAMILY SO LEFT WELFARE"   
      ER23776             FORMAT=1.   LABEL="R50 MOVD TO DIFF ST/CNTY SO LEFT WELFARE"
      ER23777             FORMAT=1.   LABEL="R50 LEFT WELFARE FOR OTHER REASON"       
      ER23778             FORMAT=1.   LABEL="R51 WAGE INCREASE SO GVT ENDED WELFARE"  
      ER23779             FORMAT=1.   LABEL="R51 ASSETS TOO HIGH SO GVT ENDED WELF"   
      ER23780             FORMAT=1.   LABEL="R51 BROKE RULES SO GVT ENDED WELFARE"    
      ER23781             FORMAT=1.   LABEL="R51 TIME LIMIT UP SO GVT ENDED WELFARE"  
      ER23782             FORMAT=1.   LABEL="R51 NOT US CITIZEN SO GVT ENDED WELF"    
      ER23783             FORMAT=1.   LABEL="R51 OTHER REASON GVT ENDED WELFARE"      
      ER23784             FORMAT=1.   LABEL="R52 WTR REAPPLIED SINCE WELFARE ENDED"   
      ER23785             FORMAT=1.   LABEL="R53 NO NEED SO DID NOT REAPPLY"          
      ER23786             FORMAT=1.   LABEL="R53 NOT ELIGIBLE SO DID NOT REAPPLY"     
      ER23787             FORMAT=1.   LABEL="R53 NOT ENTITLED SO DID NOT REAPPLY"     
      ER23788             FORMAT=1.   LABEL="R53 DID NOT KNOW IF COULD SO DID NOT"    
      ER23789             FORMAT=1.   LABEL="R53 TOO MUCH HASSLE SO DID NOT REAPPLY"  
      ER23790             FORMAT=1.   LABEL="R53 NO TRANSPORTATION SO DID NOT REAPPLY"
      ER23791             FORMAT=1.   LABEL="R53 REFUSES GVT AID SO DID NOT REAPPLY"  
      ER23792             FORMAT=1.   LABEL="R53 MONEY NOT WORTH IT SO DIDNT REAPPLY" 
      ER23793             FORMAT=1.   LABEL="R53 NOT YET BUT PLAN TO REAPPLY"         
      ER23794             FORMAT=1.   LABEL="R53 OTHER REASON HAS NOT REAPPLIED"      
      ER23795             FORMAT=1.   LABEL="R54 WTR RECEIVE PUBLIC ASST NOW"         
      ER23796             FORMAT=1.   LABEL="R55 WTR REQUIREMENTS FOR PUBLIC ASST"    
      ER23797             FORMAT=1.   LABEL="R56 REQUIRED TO LOOK FOR JOB"            
      ER23798             FORMAT=1.   LABEL="R56 REQUIRED TO HAVE PAYING JOB"         
      ER23799             FORMAT=1.   LABEL="R56 REQUIRED TO HAVE UNPAID JOB"         
      ER23800             FORMAT=1.   LABEL="R56 REQUIRED TO GO TO SCHOOL/TRAINING"   
      ER23801             FORMAT=1.   LABEL="R56 OTHER REQUIREMENT"                   
      ER23802             FORMAT=1.   LABEL="R57 CKPT: WTR RECEIVED FOOD STAMPS"      
      ER23803             FORMAT=1.   LABEL="R58 FD STMPS STOP>1 MO SNCE JAN 2 YR AGO"
      ER23804             FORMAT=1.   LABEL="R59 WTR GVT OFFICE ENDED FOOD STAMPS"    
      ER23805             FORMAT=1.   LABEL="R60 GOT JOB SO QUIT FOOD STAMPS"         
      ER23806             FORMAT=1.   LABEL="R60 MORE WORK/MONEY SO QUIT FOOD STAMPS" 
      ER23807             FORMAT=1.   LABEL="R60 GOT BETTER JOB SO QUIT FOOD STAMPS"  
      ER23808             FORMAT=1.   LABEL="R60 GOT MARRIED SO QUIT FOOD STAMPS"     
      ER23809             FORMAT=1.   LABEL="R60 MOVD IN W/FAMILY SO QUIT FOOD STAMPS"
      ER23810             FORMAT=1.   LABEL="R60 MOVD TO DIFF STE/CNTY SO QUIT FD STP"
      ER23811             FORMAT=1.   LABEL="R60 THOUGHT INELIGIBLE SO QUIT FOOD STMP"
      ER23812             FORMAT=1.   LABEL="R60 QUIT FOOD STAMPS FOR OTHER REASON"   
      ER23813             FORMAT=1.   LABEL="R61 WAGE INCREASE SO GVT ENDED FOOD STMP"
      ER23814             FORMAT=1.   LABEL="R61 ASSETS TOO HIGH SO GVT ENDED FD STMP"
      ER23815             FORMAT=1.   LABEL="R61 BROKE RULES SO GVT ENDED FOOD STAMPS"
      ER23816             FORMAT=1.   LABEL="R61 TIME LIMIT UP SO GVT ENDED FOOD STMP"
      ER23817             FORMAT=1.   LABEL="R61 NOT US CITIZEN SO GVT ENDED FD STMPS"
      ER23818             FORMAT=1.   LABEL="R61 OTHER REASON GVT ENDED FOOD STAMPS"  
      ER23819             FORMAT=1.   LABEL="R62 WTR REAPPLIED SINCE FD STMPS STOPPED"
      ER23820             FORMAT=1.   LABEL="R63 NO NEED SO DID NOT REAPPLY"          
      ER23821             FORMAT=1.   LABEL="R63 NOT ELIGIBLE SO DID NOT REAPPLY"     
      ER23822             FORMAT=1.   LABEL="R63 NOT ENTITLED SO DID NOT REAPPLY"     
      ER23823             FORMAT=1.   LABEL="R63 DID NOT KNOW IF COULD SO DID NOT"    
      ER23824             FORMAT=1.   LABEL="R63 TRY TO MAKE IT ON OWN SO DID NOT"    
      ER23825             FORMAT=1.   LABEL="R63 GAVE UP TRYING SO DID NOT REAPPLY"   
      ER23826             FORMAT=1.   LABEL="R63 TOO MUCH HASSLE SO DID NOT REAPPLY"  
      ER23827             FORMAT=1.   LABEL="R63 NO TRANSPORTATION SO DID NOT REAPPLY"
      ER23828             FORMAT=1.   LABEL="R63 REFUSES GVT AID SO DID NOT REAPPLY"  
      ER23829             FORMAT=1.   LABEL="R63 MONEY NOT WORTH IT SO DIDNT REAPPLY" 
      ER23830             FORMAT=1.   LABEL="R63 NOT YET BUT PLAN TO REAPPLY"         
      ER23831             FORMAT=1.   LABEL="R63 OTHER REASON HAS NOT REAPPLIED"      
      ER23832             FORMAT=1.   LABEL="R64 WTR RECEIVE FOOD STAMPS NOW"         
      ER23833             FORMAT=1.   LABEL="R65 WTR REQUIREMENTS FOR FOOD STAMPS"    
      ER23834             FORMAT=1.   LABEL="R66 REQUIRED TO LOOK FOR JOB"            
      ER23835             FORMAT=1.   LABEL="R66 REQUIRED TO HAVE PAYING JOB"         
      ER23836             FORMAT=1.   LABEL="R66 REQUIRED TO HAVE UNPAID JOB"         
      ER23837             FORMAT=1.   LABEL="R66 REQUIRED TO GO TO SCHOOL/TRAINING"   
      ER23838             FORMAT=1.   LABEL="R66 OTHER REQUIREMENT"                   
      ER23839             FORMAT=1.   LABEL="R67 CKPT: WTR REC GVT ASSISTANCE"        
      ER23840             FORMAT=1.   LABEL="R68 APPLD GOV ASSIST SINCE JAN 2YR AGO"  
      ER23841             FORMAT=1.   LABEL="R69 WTR APPLIED FOR ADC/AFDC"            
      ER23842             FORMAT=1.   LABEL="R69 WTR APPLIED FOR GENERAL ASSISTANCE"  
      ER23843             FORMAT=1.   LABEL="R69 WTR APPLIED FOR SSI"                 
      ER23844             FORMAT=1.   LABEL="R69 WTR APPLIED FOR FOOD STAMPS"         
      ER23845             FORMAT=1.   LABEL="R69 WTR APPLIED FOR MEDICAID"            
      ER23846             FORMAT=1.   LABEL="R69 WTR APPLIED FOR WIC"                 
      ER23847             FORMAT=1.   LABEL="R69 WTR APPLIED FOR UNEMPLOYMENT COMP"   
      ER23848             FORMAT=1.   LABEL="R69 WTR APPLIED FOR PUBLIC HOUSING"      
      ER23849             FORMAT=1.   LABEL="R69 WTR APPLIED FOR ENERGY ASSISTANCE"   
      ER23850             FORMAT=1.   LABEL="R69 WTR APPLIED FOR CHILD CARE ASSIST"   
      ER23851             FORMAT=1.   LABEL="R69 WTR APPLIED FOR SCHOOL MEALS"        
      ER23852             FORMAT=1.   LABEL="R69 WTR APPLIED FOR OTHER ASSISTANCE"    
      ER23853             FORMAT=1.   LABEL="R69A NO NEED SO DID NOT REAPPLY"         
      ER23854             FORMAT=1.   LABEL="R69A NOT ELIGIBLE SO DID NOT REAPPLY"    
      ER23855             FORMAT=1.   LABEL="R69A NOT ENTITLED SO DID NOT REAPPLY"    
      ER23856             FORMAT=1.   LABEL="R69A DID NOT KNOW IF COULD SO DID NOT"   
      ER23857             FORMAT=1.   LABEL="R69A TRY TO MAKE IT ON OWN SO DID NOT"   
      ER23858             FORMAT=1.   LABEL="R69A GAVE UP TRYING SO DID NOT REAPPLY"  
      ER23859             FORMAT=1.   LABEL="R69A TOO MUCH HASSLE SO DID NOT REAPPLY" 
      ER23860             FORMAT=1.   LABEL="R69A NO TRANSPORTATN SO DID NOT REAPPLY" 
      ER23861             FORMAT=1.   LABEL="R69A REFUSES GVT AID SO DID NOT REAPPLY" 
      ER23862             FORMAT=1.   LABEL="R69A MONEY NOT WORTH IT SO DIDNT REAPPLY"
      ER23863             FORMAT=1.   LABEL="R69A NOT YET BUT PLAN TO REAPPLY"        
      ER23864             FORMAT=1.   LABEL="R69A OTHER REASON HAS NOT REAPPLIED"     
      ER23865             FORMAT=1.   LABEL="R70A STATUS OF APPLICATION"              
      ER23866             FORMAT=1.   LABEL="R71A REASON NOT REC BENEFITS"            
      ER23867             FORMAT=1.   LABEL="R72A INCOME/ASSETS TOO HIGH"             
      ER23868             FORMAT=1.   LABEL="R72A PENALTY FROM PREV PROGRAM"          
      ER23869             FORMAT=1.   LABEL="R72A FAILED HLTH/DISABILITY REQ"         
      ER23870             FORMAT=1.   LABEL="R72A IMMIGRATION STATUS PROB"            
      ER23871             FORMAT=1.   LABEL="R72A OTR OR NONSPEC REASON"              
      ER23872             FORMAT=1.   LABEL="R72A FAILED TO GIVE REQUESTED INFO"      
      ER23873             FORMAT=1.   LABEL="R72A FAILED TO MEET WORK REQ"            
      ER23874             FORMAT=1.   LABEL="R72A FAILED CHILD SUPPORT REQ"           
      ER23875             FORMAT=1.   LABEL="R72A NOT LIVING IN ADULT SUPERVISED HU"  
      ER23876             FORMAT=1.   LABEL="R72A FAILED SUBSTANCE ABUSE REQ"         
      ER23877             FORMAT=1.   LABEL="R72A ALREADY RECD MAX BENEFITS"          
      ER23878             FORMAT=1.   LABEL="R72A LACK OF PROGRAM FINDING"            
      ER23879             FORMAT=1.   LABEL="R72A OTHER"                              
      ER23880             FORMAT=1.   LABEL="R70B STATUS OF APPLICATION"              
      ER23881             FORMAT=1.   LABEL="R71B REASON NOT REC BENEFITS"            
      ER23882             FORMAT=1.   LABEL="R72B INCOME/ASSETS TOO HIGH"             
      ER23883             FORMAT=1.   LABEL="R72B PENALTY FROM PREV PROGRAM"          
      ER23884             FORMAT=1.   LABEL="R72B FAILED HLTH/DISABILITY REQ"         
      ER23885             FORMAT=1.   LABEL="R72B IMMIGRATION STATUS PROB"            
      ER23886             FORMAT=1.   LABEL="R72B OTR OR NONSPEC REASON"              
      ER23887             FORMAT=1.   LABEL="R72B FAILED TO GIVE REQUESTED INFO"      
      ER23888             FORMAT=1.   LABEL="R72B FAILED TO MEET WORK REQ"            
      ER23889             FORMAT=1.   LABEL="R72B FAILED CHILD SUPPORT REQ"           
      ER23890             FORMAT=1.   LABEL="R72B NOT LIVING IN ADULT SUPERVISED HU"  
      ER23891             FORMAT=1.   LABEL="R72B FAILED SUBSTANCE ABUSE REQ"         
      ER23892             FORMAT=1.   LABEL="R72B ALREADY RECD MAX BENEFITS"          
      ER23893             FORMAT=1.   LABEL="R72B LACK OF PROGRAM FINDING"            
      ER23894             FORMAT=1.   LABEL="R72B OTHER"                              
      ER23895             FORMAT=1.   LABEL="R70C STATUS OF APPLICATION"              
      ER23896             FORMAT=1.   LABEL="R71C REASON NOT REC BENEFITS"            
      ER23897             FORMAT=1.   LABEL="R72C INCOME/ASSETS TOO HIGH"             
      ER23898             FORMAT=1.   LABEL="R72C PENALTY FROM PREV PROGRAM"          
      ER23899             FORMAT=1.   LABEL="R72C FAILED HLTH/DISABILITY REQ"         
      ER23900             FORMAT=1.   LABEL="R72C IMMIGRATION STATUS PROB"            
      ER23901             FORMAT=1.   LABEL="R72C OTR OR NONSPEC REASON"              
      ER23902             FORMAT=1.   LABEL="R72C FAILED TO GIVE REQUESTED INFO"      
      ER23903             FORMAT=1.   LABEL="R72C FAILED TO MEET WORK REQ"            
      ER23904             FORMAT=1.   LABEL="R72C FAILED CHILD SUPPORT REQ"           
      ER23905             FORMAT=1.   LABEL="R72C NOT LIVING IN ADULT SUPERVISED HU"  
      ER23906             FORMAT=1.   LABEL="R72C FAILED SUBSTANCE ABUSE REQ"         
      ER23907             FORMAT=1.   LABEL="R72C ALREADY RECD MAX BENEFITS"          
      ER23908             FORMAT=1.   LABEL="R72C LACK OF PROGRAM FINDING"            
      ER23909             FORMAT=1.   LABEL="R72C OTHER"                              
      ER23910             FORMAT=1.   LABEL="R70D STATUS OF APPLICATION"              
      ER23911             FORMAT=1.   LABEL="R71D REASON NOT REC BENEFITS"            
      ER23912             FORMAT=1.   LABEL="R72D INCOME/ASSETS TOO HIGH"             
      ER23913             FORMAT=1.   LABEL="R72D PENALTY FROM PREV PROGRAM"          
      ER23914             FORMAT=1.   LABEL="R72D FAILED HLTH/DISABILITY REQ"         
      ER23915             FORMAT=1.   LABEL="R72D IMMIGRATION STATUS PROB"            
      ER23916             FORMAT=1.   LABEL="R72D OTR OR NONSPEC REASON"              
      ER23917             FORMAT=1.   LABEL="R72D FAILED TO GIVE REQUESTED INFO"      
      ER23918             FORMAT=1.   LABEL="R72D FAILED TO MEET WORK REQ"            
      ER23919             FORMAT=1.   LABEL="R72D FAILED CHILD SUPPORT REQ"           
      ER23920             FORMAT=1.   LABEL="R72D NOT LIVING IN ADULT SUPERVISED HU"  
      ER23921             FORMAT=1.   LABEL="R72D FAILED SUBSTANCE ABUSE REQ"         
      ER23922             FORMAT=1.   LABEL="R72D ALREADY RECD MAX BENEFITS"          
      ER23923             FORMAT=1.   LABEL="R72D LACK OF PROGRAM FINDING"            
      ER23924             FORMAT=1.   LABEL="R72D OTHER"                              
      ER23925             FORMAT=1.   LABEL="R70E STATUS OF APPLICATION"              
      ER23926             FORMAT=1.   LABEL="R71E REASON NOT REC BENEFITS"            
      ER23927             FORMAT=1.   LABEL="R72E INCOME/ASSETS TOO HIGH"             
      ER23928             FORMAT=1.   LABEL="R72E PENALTY FROM PREV PROGRAM"          
      ER23929             FORMAT=1.   LABEL="R72E FAILED HLTH/DISABILITY REQ"         
      ER23930             FORMAT=1.   LABEL="R72E IMMIGRATION STATUS PROB"            
      ER23931             FORMAT=1.   LABEL="R72E OTR OR NONSPEC REASON"              
      ER23932             FORMAT=1.   LABEL="R72E FAILED TO GIVE REQUESTED INFO"      
      ER23933             FORMAT=1.   LABEL="R72E FAILED TO MEET WORK REQ"            
      ER23934             FORMAT=1.   LABEL="R72E FAILED CHILD SUPPORT REQ"           
      ER23935             FORMAT=1.   LABEL="R72E NOT LIVING IN ADULT SUPERVISED HU"  
      ER23936             FORMAT=1.   LABEL="R72E FAILED SUBSTANCE ABUSE REQ"         
      ER23937             FORMAT=1.   LABEL="R72E ALREADY RECD MAX BENEFITS"          
      ER23938             FORMAT=1.   LABEL="R72E LACK OF PROGRAM FINDING"            
      ER23939             FORMAT=1.   LABEL="R72E OTHER"                              
      ER23940             FORMAT=1.   LABEL="R70F STATUS OF APPLICATION"              
      ER23941             FORMAT=1.   LABEL="R71F REASON NOT REC BENEFITS"            
      ER23942             FORMAT=1.   LABEL="R72F INCOME/ASSETS TOO HIGH"             
      ER23943             FORMAT=1.   LABEL="R72F PENALTY FROM PREV PROGRAM"          
      ER23944             FORMAT=1.   LABEL="R72F FAILED HLTH/DISABILITY REQ"         
      ER23945             FORMAT=1.   LABEL="R72F IMMIGRATION STATUS PROB"            
      ER23946             FORMAT=1.   LABEL="R72F OTR OR NONSPEC REASON"              
      ER23947             FORMAT=1.   LABEL="R72F FAILED TO GIVE REQUESTED INFO"      
      ER23948             FORMAT=1.   LABEL="R72F FAILED TO MEET WORK REQ"            
      ER23949             FORMAT=1.   LABEL="R72F FAILED CHILD SUPPORT REQ"           
      ER23950             FORMAT=1.   LABEL="R72F NOT LIVING IN ADULT SUPERVISED HU"  
      ER23951             FORMAT=1.   LABEL="R72F FAILED SUBSTANCE ABUSE REQ"         
      ER23952             FORMAT=1.   LABEL="R72F ALREADY RECD MAX BENEFITS"          
      ER23953             FORMAT=1.   LABEL="R72F LACK OF PROGRAM FINDING"            
      ER23954             FORMAT=1.   LABEL="R72F OTHER"                              
      ER23955             FORMAT=1.   LABEL="R70G STATUS OF APPLICATION"              
      ER23956             FORMAT=1.   LABEL="R71G REASON NOT REC BENEFITS"            
      ER23957             FORMAT=1.   LABEL="R72G INCOME/ASSETS TOO HIGH"             
      ER23958             FORMAT=1.   LABEL="R72G PENALTY FROM PREV PROGRAM"          
      ER23959             FORMAT=1.   LABEL="R72G FAILED HLTH/DISABILITY REQ"         
      ER23960             FORMAT=1.   LABEL="R72G IMMIGRATION STATUS PROB"            
      ER23961             FORMAT=1.   LABEL="R72G OTR OR NONSPEC REASON"              
      ER23962             FORMAT=1.   LABEL="R72G FAILED TO GIVE REQUESTED INFO"      
      ER23963             FORMAT=1.   LABEL="R72G FAILED TO MEET WORK REQ"            
      ER23964             FORMAT=1.   LABEL="R72G FAILED CHILD SUPPORT REQ"           
      ER23965             FORMAT=1.   LABEL="R72G NOT LIVING IN ADULT SUPERVISED HU"  
      ER23966             FORMAT=1.   LABEL="R72G FAILED SUBSTANCE ABUSE REQ"         
      ER23967             FORMAT=1.   LABEL="R72G ALREADY RECD MAX BENEFITS"          
      ER23968             FORMAT=1.   LABEL="R72G LACK OF PROGRAM FINDING"            
      ER23969             FORMAT=1.   LABEL="R72G OTHER"                              
      ER23970             FORMAT=1.   LABEL="R70H STATUS OF APPLICATION"              
      ER23971             FORMAT=1.   LABEL="R71H REASON NOT REC BENEFITS"            
      ER23972             FORMAT=1.   LABEL="R72H INCOME/ASSETS TOO HIGH"             
      ER23973             FORMAT=1.   LABEL="R72H PENALTY FROM PREV PROGRAM"          
      ER23974             FORMAT=1.   LABEL="R72H FAILED HLTH/DISABILITY REQ"         
      ER23975             FORMAT=1.   LABEL="R72H IMMIGRATION STATUS PROB"            
      ER23976             FORMAT=1.   LABEL="R72H OTR OR NONSPEC REASON"              
      ER23977             FORMAT=1.   LABEL="R72H FAILED TO GIVE REQUESTED INFO"      
      ER23978             FORMAT=1.   LABEL="R72H FAILED TO MEET WORK REQ"            
      ER23979             FORMAT=1.   LABEL="R72H FAILED CHILD SUPPORT REQ"           
      ER23980             FORMAT=1.   LABEL="R72H NOT LIVING IN ADULT SUPERVISED HU"  
      ER23981             FORMAT=1.   LABEL="R72H FAILED SUBSTANCE ABUSE REQ"         
      ER23982             FORMAT=1.   LABEL="R72H ALREADY RECD MAX BENEFITS"          
      ER23983             FORMAT=1.   LABEL="R72H LACK OF PROGRAM FINDING"            
      ER23984             FORMAT=1.   LABEL="R72H OTHER"                              
      ER23985             FORMAT=1.   LABEL="R70I STATUS OF APPLICATION"              
      ER23986             FORMAT=1.   LABEL="R71I REASON NOT REC BENEFITS"            
      ER23987             FORMAT=1.   LABEL="R72I INCOME/ASSETS TOO HIGH"             
      ER23988             FORMAT=1.   LABEL="R72I PENALTY FROM PREV PROGRAM"          
      ER23989             FORMAT=1.   LABEL="R72I FAILED HLTH/DISABILITY REQ"         
      ER23990             FORMAT=1.   LABEL="R72I IMMIGRATION STATUS PROB"            
      ER23991             FORMAT=1.   LABEL="R72I OTR OR NONSPEC REASON"              
      ER23992             FORMAT=1.   LABEL="R72I FAILED TO GIVE REQUESTED INFO"      
      ER23993             FORMAT=1.   LABEL="R72I FAILED TO MEET WORK REQ"            
      ER23994             FORMAT=1.   LABEL="R72I FAILED CHILD SUPPORT REQ"           
      ER23995             FORMAT=1.   LABEL="R72I NOT LIVING IN ADULT SUPERVISED HU"  
      ER23996             FORMAT=1.   LABEL="R72I FAILED SUBSTANCE ABUSE REQ"         
      ER23997             FORMAT=1.   LABEL="R72I ALREADY RECD MAX BENEFITS"          
      ER23998             FORMAT=1.   LABEL="R72I LACK OF PROGRAM FINDING"            
      ER23999             FORMAT=1.   LABEL="R72I OTHER"                              
      ER24000             FORMAT=1.   LABEL="R70J STATUS OF APPLICATION"              
      ER24001             FORMAT=1.   LABEL="R71J REASON NOT REC BENEFITS"            
      ER24002             FORMAT=1.   LABEL="R72J INCOME/ASSETS TOO HIGH"             
      ER24003             FORMAT=1.   LABEL="R72J PENALTY FROM PREV PROGRAM"          
      ER24004             FORMAT=1.   LABEL="R72J FAILED HLTH/DISABILITY REQ"         
      ER24005             FORMAT=1.   LABEL="R72J IMMIGRATION STATUS PROB"            
      ER24006             FORMAT=1.   LABEL="R72J OTR OR NONSPEC REASON"              
      ER24007             FORMAT=1.   LABEL="R72J FAILED TO GIVE REQUESTED INFO"      
      ER24008             FORMAT=1.   LABEL="R72J FAILED TO MEET WORK REQ"            
      ER24009             FORMAT=1.   LABEL="R72J FAILED CHILD SUPPORT REQ"           
      ER24010             FORMAT=1.   LABEL="R72J NOT LIVING IN ADULT SUPERVISED HU"  
      ER24011             FORMAT=1.   LABEL="R72J FAILED SUBSTANCE ABUSE REQ"         
      ER24012             FORMAT=1.   LABEL="R72J ALREADY RECD MAX BENEFITS"          
      ER24013             FORMAT=1.   LABEL="R72J LACK OF PROGRAM FINDING"            
      ER24014             FORMAT=1.   LABEL="R72J OTHER"                              
      ER24015             FORMAT=1.   LABEL="R70K STATUS OF APPLICATION"              
      ER24016             FORMAT=1.   LABEL="R71K REASON NOT REC BENEFITS"            
      ER24017             FORMAT=1.   LABEL="R72K INCOME/ASSETS TOO HIGH"             
      ER24018             FORMAT=1.   LABEL="R72K PENALTY FROM PREV PROGRAM"          
      ER24019             FORMAT=1.   LABEL="R72K FAILED HLTH/DISABILITY REQ"         
      ER24020             FORMAT=1.   LABEL="R72K IMMIGRATION STATUS PROB"            
      ER24021             FORMAT=1.   LABEL="R72K OTR OR NONSPEC REASON"              
      ER24022             FORMAT=1.   LABEL="R72K FAILED TO GIVE REQUESTED INFO"      
      ER24023             FORMAT=1.   LABEL="R72K FAILED TO MEET WORK REQ"            
      ER24024             FORMAT=1.   LABEL="R72K FAILED CHILD SUPPORT REQ"           
      ER24025             FORMAT=1.   LABEL="R72K NOT LIVING IN ADULT SUPERVISED HU"  
      ER24026             FORMAT=1.   LABEL="R72K FAILED SUBSTANCE ABUSE REQ"         
      ER24027             FORMAT=1.   LABEL="R72K ALREADY RECD MAX BENEFITS"          
      ER24028             FORMAT=1.   LABEL="R72K LACK OF PROGRAM FINDING"            
      ER24029             FORMAT=1.   LABEL="R72K OTHER"                              
      ER24030             FORMAT=1.   LABEL="R70L STATUS OF APPLICATION"              
      ER24031             FORMAT=1.   LABEL="R71L REASON NOT REC BENEFITS"            
      ER24032             FORMAT=1.   LABEL="R72L INCOME/ASSETS TOO HIGH"             
      ER24033             FORMAT=1.   LABEL="R72L PENALTY FROM PREV PROGRAM"          
      ER24034             FORMAT=1.   LABEL="R72L FAILED HLTH/DISABILITY REQ"         
      ER24035             FORMAT=1.   LABEL="R72L IMMIGRATION STATUS PROB"            
      ER24036             FORMAT=1.   LABEL="R72L OTR OR NONSPEC REASON"              
      ER24037             FORMAT=1.   LABEL="R72L FAILED TO GIVE REQUESTED INFO"      
      ER24038             FORMAT=1.   LABEL="R72L FAILED TO MEET WORK REQ"            
      ER24039             FORMAT=1.   LABEL="R72L FAILED CHILD SUPPORT REQ"           
      ER24040             FORMAT=1.   LABEL="R72L NOT LIVING IN ADULT SUPERVISED HU"  
      ER24041             FORMAT=1.   LABEL="R72L FAILED SUBSTANCE ABUSE REQ"         
      ER24042             FORMAT=1.   LABEL="R72L ALREADY RECD MAX BENEFITS"          
      ER24043             FORMAT=1.   LABEL="R72L LACK OF PROGRAM FINDING"            
      ER24044             FORMAT=1.   LABEL="R72L OTHER"                              
      ER24045             FORMAT=1.   LABEL="R74A WTR REC OTR GVT ASST LAST 2 YEARS"  
      ER24046             FORMAT=1.   LABEL="R74B WTR REC OTR GVT ASST LAST 2 YEARS"  
      ER24047             FORMAT=1.   LABEL="R74C WTR REC OTR GVT ASST LAST 2 YEARS"  
      ER24048             FORMAT=1.   LABEL="R74D WTR REC OTR GVT ASST LAST 2 YEARS"  
      ER24049             FORMAT=1.   LABEL="R74E WTR REC OTR GVT ASST LAST 2 YEARS"  
      ER24050             FORMAT=1.   LABEL="R74F WTR REC OTR GVT ASST LAST 2 YEARS"  
      ER24051             FORMAT=1.   LABEL="R74G WTR REC OTR GVT ASST LAST 2 YEARS"  
      ER24052             FORMAT=1.   LABEL="R74H WTR REC OTR GVT ASST LAST 2 YEARS"  
      ER24053             FORMAT=1.   LABEL="R75A WTR REC HELP FROM OTRS LAST 2 YEARS"
      ER24054             FORMAT=1.   LABEL="R75B WTR REC HELP FROM OTRS LAST 2 YEARS"
      ER24055             FORMAT=1.   LABEL="R75C WTR REC HELP FROM OTRS LAST 2 YEARS"
      ER24056             FORMAT=1.   LABEL="R75D WTR REC HELP FROM OTRS LAST 2 YEARS"
      ER24057             FORMAT=1.   LABEL="R75E WTR REC HELP FROM OTRS LAST 2 YEARS"
      ER24058             FORMAT=1.   LABEL="R75F WTR REC HELP FROM OTRS LAST 2 YEARS"
      ER24059             FORMAT=1.   LABEL="R75G WTR REC HELP FROM OTRS LAST 2 YEARS"
      ER24060             FORMAT=1.   LABEL="R75H WTR REC HELP FROM OTRS LAST 2 YEARS"
      ER24061             FORMAT=1.   LABEL="R75J CKPT: WTR REC SOME TYPE OF HELP"    
      ER24062             FORMAT=1.   LABEL="R76 WTR RECEIVED HELP FROM CHURCH"       
      ER24063             FORMAT=1.   LABEL="R76 WTR RECEIVED HELP FROM FAMILY"       
      ER24064             FORMAT=1.   LABEL="R76 WTR RECD HELP FROM COMMUNITY GROUP"  
      ER24065             FORMAT=1.   LABEL="R76 WTR RECEIVED HELP FROM OTHER SOURCE" 
      ER24066             FORMAT=1.   LABEL="R77 WTR FU MEMBER 60+ YR BEFORE LAST"    
      ER24067             FORMAT=1.   LABEL="R78 WTR RECD FREE/REDUCD MEAL YR B4 LAST"
      ER24068             FORMAT=1.   LABEL="R79 CKPT: WTR CHILD 5-18 IN FU"          
      ER24069             FORMAT=1.   LABEL="R80 WTR CH REC FREE/LOW LUNCH YR B4 LAST"
      ER24070             FORMAT=1.   LABEL="R81 WTR CH REC FREE/LOW BKFST YR B4 LAST"
      ER24071             FORMAT=1.   LABEL="R82 FU FEMALE 15-45/CHILD <5 YR B4 LAST" 
      ER24072             FORMAT=1.   LABEL="R83 WTR RECD FOOD THROUGH WIC PROGRAM"   
      ER24073             FORMAT=1.   LABEL="WHO WAS RESPONDENT"                      
      ER24074             FORMAT=3.   LABEL="# CALLS FOR IW"                          
      ER24075             FORMAT=1.   LABEL="LANGUAGE OF INTERVIEW"                   
      ER24076             FORMAT=2.   LABEL="# OF INDIVIDUAL RECORDS"                 
      ER24077             FORMAT=4.1  LABEL="HEAD WORK WEEKS LAST YEAR"               
      ER24078             FORMAT=3.   LABEL="HEAD WEEKLY WORK HOURS LAST YEAR"        
      ER24079             FORMAT=4.   LABEL="HD OVERTIME WORK HOURS LAST YEAR"        
      ER24080             FORMAT=4.   LABEL="HEAD TOTAL HOURS OF WORK LAST YEAR"      
      ER24081             FORMAT=4.1  LABEL="HD WEEKS MISSED FOR ILLNESS OF OTRS"     
      ER24082             FORMAT=4.1  LABEL="HD WEEKS MISSED FOR OWN ILLNESS"         
      ER24083             FORMAT=4.1  LABEL="HEAD WEEKS OFF FOR VACATION LAST YEAR"   
      ER24084             FORMAT=4.1  LABEL="HEAD STRIKE WEEKS LAST YEAR"             
      ER24085             FORMAT=4.1  LABEL="HEAD WEEKS LAID OFF LAST YEAR"           
      ER24086             FORMAT=4.1  LABEL="HEAD UNEMPLOYMENT WEEKS LAST YEAR"       
      ER24087             FORMAT=4.1  LABEL="HEAD WEEKS OUT OF LABOR FORCE LAST YEAR" 
      ER24088             FORMAT=4.1  LABEL="WIFE WORK WEEKS LAST YEAR"               
      ER24089             FORMAT=3.   LABEL="WIFE WEEKLY WORK HOURS LAST YEAR"        
      ER24090             FORMAT=4.   LABEL="WF OVERTIME WORK HOURS LAST YEAR"        
      ER24091             FORMAT=4.   LABEL="WIFE TOTAL HOURS OF WORK LAST YEAR"      
      ER24092             FORMAT=4.1  LABEL="WF WEEKS MISSED FOR ILLNESS OF OTRS"     
      ER24093             FORMAT=4.1  LABEL="WF WEEKS MISSED FOR OWN ILLNESS"         
      ER24094             FORMAT=4.1  LABEL="WIFE WEEKS OFF FOR VACATION LAST YEAR"   
      ER24095             FORMAT=4.1  LABEL="WIFE STRIKE WEEKS LAST YEAR"             
      ER24096             FORMAT=4.1  LABEL="WIFE WEEKS LAID OFF LAST YEAR"           
      ER24097             FORMAT=4.1  LABEL="WIFE UNEMPLOYMENT WEEKS LAST YEAR"       
      ER24098             FORMAT=4.1  LABEL="WIFE WEEKS OUT OF LABOR FORCE LAST YEAR" 
      ER24099             FORMAT=7.   LABEL="TOTAL FAMILY INCOME LAST YEAR"           
      ER24100             FORMAT=7.   LABEL="HEAD AND TAXABLE INCOME WIFE LAST YEAR"  
      ER24101             FORMAT=7.   LABEL="HEAD AND WIFE TRANSFER INCOME LAST YEAR" 
      ER24102             FORMAT=7.   LABEL="TAXABLE INCOME OF OTHER FU MEMBERS"      
      ER24103             FORMAT=6.   LABEL="TRANSFER INCOME OF OTHER FU MEMBER"      
      ER24104             FORMAT=6.   LABEL="SOCIAL SECURITY INCOME LAST YEAR"        
      ER24105             FORMAT=6.   LABEL="FARM INCOME OF HEAD LAST YEAR"           
      ER24106             FORMAT=1.   LABEL="ACC FARM INCOME OF HEAD LAST YEAR"       
      ER24107             FORMAT=7.   LABEL="BUSINESS INCOME LAST YEAR"               
      ER24108             FORMAT=1.   LABEL="ACC BUSINESS INCOME LAST YEAR"           
      ER24109             FORMAT=6.   LABEL="HD LABOR INCOME FROM BUSINESS LAST YEAR" 
      ER24110             FORMAT=7.   LABEL="HD ASSET INCOME FROM BUSINESS LAST YEAR" 
      ER24111             FORMAT=6.   LABEL="WF LABOR INCOME FROM BUSINESS LAST YEAR" 
      ER24112             FORMAT=7.   LABEL="WF ASSET INCOME FROM BUSINESS LAST YEAR" 
      ER24113             FORMAT=1.   LABEL="NUMBER OF BUSINESSES OWNED BY FU"        
      ER24114             FORMAT=1.   LABEL="NUMBER OF BUSINESSES OWNED BY HEAD"      
      ER24115             FORMAT=1.   LABEL="NUMBER OF BUSINESSES OWNED BY WIFE"      
      ER24116             FORMAT=7.   LABEL="LABOR INCOME OF HEAD LAST YEAR"          
      ER24117             FORMAT=7.   LABEL="WAGES AND SALARIES OF HEAD LAST YEAR"    
      ER24118             FORMAT=1.   LABEL="ACC WAGES AND SALARIES OF HEAD LAST YEAR"
      ER24119             FORMAT=6.   LABEL="BONUS INCOME OF HEAD LAST YEAR"          
      ER24120             FORMAT=1.   LABEL="ACC BONUS INCOME OF HEAD LAST YEAR"      
      ER24121             FORMAT=6.   LABEL="OVERTIME INCOME OF HEAD LAST YEAR"       
      ER24122             FORMAT=1.   LABEL="ACC OVERTIME INCOME OF HEAD LAST YEAR"   
      ER24123             FORMAT=6.   LABEL="TIPS OF HEAD LAST YEAR"                  
      ER24124             FORMAT=1.   LABEL="ACC TIPS OF HEAD LAST YEAR"              
      ER24125             FORMAT=6.   LABEL="COMMISSION INCOME OF HEAD LAST YEAR"     
      ER24126             FORMAT=1.   LABEL="ACC COMMISSION INCOME OF HEAD LAST YEAR" 
      ER24127             FORMAT=7.   LABEL="PROFESSIONAL PRACTICE OF HEAD LAST YEAR" 
      ER24128             FORMAT=1.   LABEL="ACC PROFESSIONL PRACTICE OF HD LAST YEAR"
      ER24129             FORMAT=7.   LABEL="MARKET GARDENING INCOME OF HD LAST YEAR" 
      ER24130             FORMAT=1.   LABEL="ACC MARKET GARDENING INCOME OF HEAD"     
      ER24131             FORMAT=7.   LABEL="HEAD ADDITIONAL JOB INCOME LAST YEAR"    
      ER24132             FORMAT=1.   LABEL="ACC OF HEAD ADDITIONAL JOB INCOME"       
      ER24133             FORMAT=6.   LABEL="MISC LABOR INCOME OF HEAD LAST YEAR"     
      ER24134             FORMAT=1.   LABEL="ACC MISC LABOR INCOME OF HEAD LAST YEAR" 
      ER24135             FORMAT=7.   LABEL="LABOR INCOME OF WIFE LAST YEAR"          
      ER24136             FORMAT=1.   LABEL="ACC LABOR INCOME OF WIFE LAST YEAR"      
      ER24137             FORMAT=6.2  LABEL="HEAD WAGE RATE LAST YEAR"                
      ER24138             FORMAT=6.2  LABEL="WIFE WAGE RATE LAST YEAR"                
      ER24139             FORMAT=5.   LABEL="USDA NEEDS STANDARD-PREVIOUS YR"         
      ER24140             FORMAT=5.   LABEL="CENSUS NEEDS STANDARD-PREVIOUS YR"       
      ER24141             FORMAT=5.   LABEL="USDA NEEDS STANDARD-YR PRIOR TO PREV YR" 
      ER24142             FORMAT=5.   LABEL="CENSUS NEEDS STANDARD-YR PRIOR TO PREV"  
      ER24143             FORMAT=1.   LABEL="CURRENT REGION"                          
      ER24144             FORMAT=2.   LABEL="BEALE RURAL-URBAN CODE"                  
      ER24145             FORMAT=1.   LABEL="SIZE LARGEST CITY IN COUNTY"             
      ER24146             FORMAT=1.   LABEL="REGION HD GREW UP"                       
      ER24147             FORMAT=1.   LABEL="HD GEOGRAPHIC MOBILITY"                  
      ER24148             FORMAT=2.   LABEL="COMPLETED ED-HD"                         
      ER24149             FORMAT=2.   LABEL="COMPLETED ED-WF"                         
      ER24150             FORMAT=1.   LABEL="MARITAL STATUS-GENERATED"                
      ER24151             FORMAT=1.   LABEL="CHANGE IN MARITAL STATUS"                
      ER24152             FORMAT=1.   LABEL="COUPLE STATUS OF HEAD"                   
      ER24153             FORMAT=4.   LABEL="YEAR NEW HEAD IN FU"                     
      ER24154             FORMAT=4.   LABEL="YEAR NEW WIFE IN FU"                     
      ER24155             FORMAT=1.   LABEL="HEAD-SPOUSE SAMPLE STATUS"               
      ER24156             FORMAT=1.   LABEL="NUMBER OF SPLITOFFS FROM MAIN FAM"       
      ER24157             FORMAT=5.   LABEL="MAIN FAMILY ID FOR SPLITOFF"             
      ER24158             FORMAT=5.   LABEL="CURRENT YR ID OF 1ST OTHER FU IN HU"     
      ER24159             FORMAT=1.   LABEL="REL OF 1ST OTHER FU"                     
      ER24160             FORMAT=2.   LABEL="SIZE OF 1ST OTHER FU"                    
      ER24161             FORMAT=5.   LABEL="CURRENT YR ID OF 2ND OTHER FU IN HU"     
      ER24162             FORMAT=1.   LABEL="REL OF 2ND OTHER FU"                     
      ER24163             FORMAT=2.   LABEL="SIZE OF 2ND OTHER FU"                    
      ER24164             FORMAT=5.   LABEL="CURRENT YR ID OF 3RD OTHER FU IN HU"     
      ER24165             FORMAT=1.   LABEL="REL OF 3RD OTHER FU"                     
      ER24166             FORMAT=2.   LABEL="SIZE OF 3RD OTHER FU"                    
      ER24167             FORMAT=5.   LABEL="CURRENT YR ID OF 4TH OTHER FU IN HU"     
      ER24168             FORMAT=1.   LABEL="REL OF 4TH OTHER FU"                     
      ER24169             FORMAT=2.   LABEL="SIZE OF 4TH OTHER FU"                    
      ER24170             FORMAT=5.   LABEL="HOUSEHOLD ID #"                          
      ER24171             FORMAT=1.   LABEL="BIRTHS TO HEAD ONLY LAST YEAR"           
      ER24172             FORMAT=1.   LABEL="BIRTHS TO WIFE ONLY LAST YEAR"           
      ER24173             FORMAT=1.   LABEL="BIRTHS TO HEAD AND WIFE LAST YEAR"       
      ER24174             FORMAT=1.   LABEL="BIRTHS TO OFUMS ONLY LAST YEAR"          
      ER24175             FORMAT=1.   LABEL="BIRTHS TO HEAD ONLY TWO YEARS AGO"       
      ER24176             FORMAT=1.   LABEL="BIRTHS TO WIFE ONLY TWO YEARS AGO"       
      ER24177             FORMAT=1.   LABEL="BIRTHS TO HEAD AND WIFE TWO YEARS AGO"   
      ER24178             FORMAT=1.   LABEL="BIRTHS TO OFUMS ONLY TWO YEARS AGO"      
      ER24179             FORMAT=6.3  LABEL="CORE/IMMIGRANT FAMILY WEIGHT NUMBER 1"   
   ;
   
   infile 'F:\PSID\FAM2003ER.txt'  lrecl=6038 missover; 
   INPUT 
      ER21001      1 - 1      ER21002      2 - 6      ER21003      7 - 8    
      ER21004      9 - 10     ER21005     11 - 11     ER21006     12 - 12   
      ER21007     13 - 13     ER21008     14 - 14     ER21009     15 - 18   
      ER21010     19 - 19     ER21011     20 - 27     ER21012     28 - 29   
      ER21013     30 - 31     ER21014     32 - 35     ER21015     36 - 38   
      ER21016     39 - 40     ER21017     41 - 43     ER21018     44 - 44   
      ER21019     45 - 47     ER21020     48 - 49     ER21021     50 - 52   
      ER21022     53 - 54     ER21023     55 - 55     ER21024     56 - 56   
      ER21025     57 - 57     ER21026     58 - 58     ER21027     59 - 59   
      ER21028     60 - 60     ER21029     61 - 61     ER21030     62 - 62   
      ER21031     63 - 63     ER21032     64 - 64     ER21033     65 - 65   
      ER21034     66 - 66     ER21035     67 - 67     ER21036     68 - 69   
      ER21037     70 - 71     ER21038     72 - 73     ER21039     74 - 75   
      ER21040     76 - 76     ER21041     77 - 80     ER21042     81 - 81   
      ER21043     82 - 88     ER21044     89 - 89     ER21045     90 - 94   
      ER21046     95 - 95     ER21047     96 - 99     ER21048    100 - 100  
      ER21049    101 - 101    ER21050    102 - 102    ER21051    103 - 109  
      ER21052    110 - 110    ER21053    111 - 115    ER21054    116 - 116  
      ER21055    117 - 118    ER21056    119 - 121    ER21057    122 - 125  
      ER21058    126 - 127    ER21059    128 - 128    ER21060    129 - 129  
      ER21061    130 - 130    ER21062    131 - 137    ER21063    138 - 138  
      ER21064    139 - 143    ER21065    144 - 144    ER21066    145 - 146  
      ER21067    147 - 149    ER21068    150 - 153    ER21069    154 - 155  
      ER21070    156 - 156    ER21071    157 - 157    ER21072    158 - 162  
      ER21073    163 - 163    ER21074    164 - 164    ER21075    165 - 165  
      ER21076    166 - 166    ER21077    167 - 167    ER21078    168 - 168  
      ER21079    169 - 172    ER21080    173 - 173    ER21081    174 - 174  
      ER21082    175 - 175    ER21083    176 - 176    ER21084    177 - 177  
      ER21085    178 - 178    ER21086    179 - 182    ER21087    183 - 183  
      ER21088    184 - 187    ER21089    188 - 188    ER21090    189 - 192  
      ER21091    193 - 193    ER21092    194 - 194    ER21093    195 - 195  
      ER21094    196 - 196    ER21095    197 - 197    ER21096    198 - 198  
      ER21097    199 - 201    ER21098    202 - 202    ER21099    203 - 203  
      ER21100    204 - 204    ER21101    205 - 205    ER21102    206 - 206  
      ER21103    207 - 207    ER21104    208 - 208    ER21105    209 - 209  
      ER21106    210 - 210    ER21107    211 - 211    ER21108    212 - 212  
      ER21109    213 - 213    ER21110    214 - 214    ER21111    215 - 215  
      ER21112    216 - 216    ER21113    217 - 217    ER21114    218 - 218  
      ER21115    219 - 219    ER21116    220 - 220    ER21117    221 - 221  
      ER21118    222 - 223    ER21119    224 - 227    ER21120    228 - 229  
      ER21121    230 - 230    ER21122    231 - 231    ER21123    232 - 233  
      ER21124    234 - 235    ER21125    236 - 237    ER21126    238 - 241  
      ER21127    242 - 242    ER21128    243 - 243    ER21129    244 - 245  
      ER21130    246 - 249    ER21131    250 - 251    ER21132    252 - 255  
      ER21133    256 - 256    ER21134    257 - 257    ER21135    258 - 258  
      ER21136    259 - 259    ER21137    260 - 260    ER21138    261 - 261  
      ER21139    262 - 262    ER21140    263 - 263    ER21141    264 - 264  
      ER21142    265 - 265    ER21143    266 - 266    ER21144    267 - 267  
      ER21145    268 - 270    ER21146    271 - 273    ER21147    274 - 274  
      ER21148    275 - 275    ER21149    276 - 276    ER21150    277 - 277  
      ER21151    278 - 278    ER21152    279 - 279    ER21153    280 - 289  
      ER21154    290 - 290    ER21155    291 - 291    ER21156    292 - 292  
      ER21157    293 - 302    ER21158    303 - 303    ER21159    304 - 309  
      ER21160    310 - 310    ER21161    311 - 311    ER21162    312 - 312  
      ER21163    313 - 322    ER21164    323 - 323    ER21165    324 - 331  
      ER21166    332 - 332    ER21167    333 - 341    ER21168    342 - 342  
      ER21169    343 - 343    ER21170    344 - 352    ER21171    353 - 354  
      ER21172    355 - 356    ER21173    357 - 358    ER21174    359 - 360  
      ER21175    361 - 361    ER21176    362 - 364    ER21177    365 - 365  
      ER21178    366 - 366    ER21179    367 - 370    ER21180    371 - 371  
      ER21181    372 - 372    ER21182    373 - 382    ER21183    383 - 383  
      ER21184    384 - 384    ER21185    385 - 386    ER21186    387 - 390  
      ER21187    391 - 392    ER21188    393 - 396    ER21189    397 - 397  
      ER21190    398 - 398    ER21191    399 - 399    ER21192    400 - 400  
      ER21193    401 - 401    ER21194    402 - 402    ER21195    403 - 403  
      ER21196    404 - 404    ER21197    405 - 405    ER21198    406 - 406  
      ER21199    407 - 407    ER21200    408 - 408    ER21201    409 - 411  
      ER21202    412 - 414    ER21203    415 - 415    ER21204    416 - 416  
      ER21205    417 - 417    ER21206    418 - 419    ER21207    420 - 420  
      ER21208    421 - 423    ER21209    424 - 424    ER21210    425 - 425  
      ER21211    426 - 429    ER21212    430 - 430    ER21213    431 - 431  
      ER21214    432 - 441    ER21215    442 - 442    ER21216    443 - 443  
      ER21217    444 - 445    ER21218    446 - 449    ER21219    450 - 451  
      ER21220    452 - 455    ER21221    456 - 456    ER21222    457 - 457  
      ER21223    458 - 458    ER21224    459 - 459    ER21225    460 - 460  
      ER21226    461 - 461    ER21227    462 - 462    ER21228    463 - 463  
      ER21229    464 - 464    ER21230    465 - 465    ER21231    466 - 466  
      ER21232    467 - 467    ER21233    468 - 470    ER21234    471 - 473  
      ER21235    474 - 474    ER21236    475 - 475    ER21237    476 - 476  
      ER21238    477 - 478    ER21239    479 - 479    ER21240    480 - 482  
      ER21241    483 - 483    ER21242    484 - 484    ER21243    485 - 488  
      ER21244    489 - 489    ER21245    490 - 490    ER21246    491 - 500  
      ER21247    501 - 501    ER21248    502 - 502    ER21249    503 - 504  
      ER21250    505 - 508    ER21251    509 - 510    ER21252    511 - 514  
      ER21253    515 - 515    ER21254    516 - 516    ER21255    517 - 517  
      ER21256    518 - 518    ER21257    519 - 519    ER21258    520 - 520  
      ER21259    521 - 521    ER21260    522 - 522    ER21261    523 - 523  
      ER21262    524 - 524    ER21263    525 - 525    ER21264    526 - 526  
      ER21265    527 - 529    ER21266    530 - 532    ER21267    533 - 533  
      ER21268    534 - 534    ER21269    535 - 535    ER21270    536 - 537  
      ER21271    538 - 538    ER21272    539 - 541    ER21273    542 - 542  
      ER21274    543 - 543    ER21275    544 - 547    ER21276    548 - 548  
      ER21277    549 - 549    ER21278    550 - 559    ER21279    560 - 560  
      ER21280    561 - 561    ER21281    562 - 562    ER21282    563 - 563  
      ER21283    564 - 566    ER21284    567 - 567    ER21285    568 - 569  
      ER21286    570 - 570    ER21287    571 - 572    ER21288    573 - 573  
      ER21289    574 - 574    ER21290    575 - 577    ER21291    578 - 578  
      ER21292    579 - 580    ER21293    581 - 581    ER21294    582 - 583  
      ER21295    584 - 584    ER21296    585 - 585    ER21297    586 - 588  
      ER21298    589 - 589    ER21299    590 - 591    ER21300    592 - 592  
      ER21301    593 - 594    ER21302    595 - 595    ER21303    596 - 596  
      ER21304    597 - 599    ER21305    600 - 600    ER21306    601 - 602  
      ER21307    603 - 603    ER21308    604 - 605    ER21309    606 - 606  
      ER21310    607 - 607    ER21311    608 - 610    ER21312    611 - 611  
      ER21313    612 - 613    ER21314    614 - 614    ER21315    615 - 616  
      ER21316    617 - 617    ER21317    618 - 618    ER21318    619 - 621  
      ER21319    622 - 622    ER21320    623 - 624    ER21321    625 - 625  
      ER21322    626 - 627    ER21323    628 - 628    ER21324    629 - 629  
      ER21325    630 - 630    ER21326    631 - 631    ER21327    632 - 632  
      ER21328    633 - 633    ER21329    634 - 634    ER21330    635 - 635  
      ER21331    636 - 636    ER21332    637 - 637    ER21333    638 - 638  
      ER21334    639 - 639    ER21335    640 - 640    ER21336    641 - 641  
      ER21337    642 - 644    ER21338    645 - 645    ER21339    646 - 647  
      ER21340    648 - 648    ER21341    649 - 650    ER21342    651 - 651  
      ER21343    652 - 652    ER21344    653 - 653    ER21345    654 - 654  
      ER21346    655 - 655    ER21347    656 - 656    ER21348    657 - 657  
      ER21349    658 - 658    ER21350    659 - 659    ER21351    660 - 660  
      ER21352    661 - 661    ER21353    662 - 662    ER21354    663 - 663  
      ER21355    664 - 665    ER21356    666 - 668    ER21357    669 - 669  
      ER21358    670 - 671    ER21359    672 - 675    ER21360    676 - 676  
      ER21361    677 - 677    ER21362    678 - 678    ER21363    679 - 679  
      ER21364    680 - 680    ER21365    681 - 681    ER21366    682 - 682  
      ER21367    683 - 683    ER21368    684 - 684    ER21369    685 - 686  
      ER21370    687 - 688    ER21371    689 - 690    ER21372    691 - 691  
      ER21373    692 - 693    ER21374    694 - 695    ER21375    696 - 697  
      ER21376    698 - 701    ER21377    702 - 702    ER21378    703 - 703  
      ER21379    704 - 705    ER21380    706 - 709    ER21381    710 - 711  
      ER21382    712 - 715    ER21383    716 - 716    ER21384    717 - 717  
      ER21385    718 - 718    ER21386    719 - 719    ER21387    720 - 720  
      ER21388    721 - 721    ER21389    722 - 722    ER21390    723 - 723  
      ER21391    724 - 724    ER21392    725 - 725    ER21393    726 - 726  
      ER21394    727 - 727    ER21395    728 - 730    ER21396    731 - 733  
      ER21397    734 - 734    ER21398    735 - 735    ER21399    736 - 736  
      ER21400    737 - 737    ER21401    738 - 738    ER21402    739 - 739  
      ER21403    740 - 749    ER21404    750 - 750    ER21405    751 - 751  
      ER21406    752 - 752    ER21407    753 - 762    ER21408    763 - 763  
      ER21409    764 - 769    ER21410    770 - 770    ER21411    771 - 771  
      ER21412    772 - 772    ER21413    773 - 782    ER21414    783 - 783  
      ER21415    784 - 791    ER21416    792 - 792    ER21417    793 - 801  
      ER21418    802 - 802    ER21419    803 - 803    ER21420    804 - 812  
      ER21421    813 - 814    ER21422    815 - 816    ER21423    817 - 818  
      ER21424    819 - 820    ER21425    821 - 821    ER21426    822 - 824  
      ER21427    825 - 825    ER21428    826 - 826    ER21429    827 - 830  
      ER21430    831 - 831    ER21431    832 - 832    ER21432    833 - 842  
      ER21433    843 - 843    ER21434    844 - 844    ER21435    845 - 846  
      ER21436    847 - 850    ER21437    851 - 852    ER21438    853 - 856  
      ER21439    857 - 857    ER21440    858 - 858    ER21441    859 - 859  
      ER21442    860 - 860    ER21443    861 - 861    ER21444    862 - 862  
      ER21445    863 - 863    ER21446    864 - 864    ER21447    865 - 865  
      ER21448    866 - 866    ER21449    867 - 867    ER21450    868 - 868  
      ER21451    869 - 871    ER21452    872 - 874    ER21453    875 - 875  
      ER21454    876 - 876    ER21455    877 - 877    ER21456    878 - 879  
      ER21457    880 - 880    ER21458    881 - 883    ER21459    884 - 884  
      ER21460    885 - 885    ER21461    886 - 889    ER21462    890 - 890  
      ER21463    891 - 891    ER21464    892 - 901    ER21465    902 - 902  
      ER21466    903 - 903    ER21467    904 - 905    ER21468    906 - 909  
      ER21469    910 - 911    ER21470    912 - 915    ER21471    916 - 916  
      ER21472    917 - 917    ER21473    918 - 918    ER21474    919 - 919  
      ER21475    920 - 920    ER21476    921 - 921    ER21477    922 - 922  
      ER21478    923 - 923    ER21479    924 - 924    ER21480    925 - 925  
      ER21481    926 - 926    ER21482    927 - 927    ER21483    928 - 930  
      ER21484    931 - 933    ER21485    934 - 934    ER21486    935 - 935  
      ER21487    936 - 936    ER21488    937 - 938    ER21489    939 - 939  
      ER21490    940 - 942    ER21491    943 - 943    ER21492    944 - 944  
      ER21493    945 - 948    ER21494    949 - 949    ER21495    950 - 950  
      ER21496    951 - 960    ER21497    961 - 961    ER21498    962 - 962  
      ER21499    963 - 964    ER21500    965 - 968    ER21501    969 - 970  
      ER21502    971 - 974    ER21503    975 - 975    ER21504    976 - 976  
      ER21505    977 - 977    ER21506    978 - 978    ER21507    979 - 979  
      ER21508    980 - 980    ER21509    981 - 981    ER21510    982 - 982  
      ER21511    983 - 983    ER21512    984 - 984    ER21513    985 - 985  
      ER21514    986 - 986    ER21515    987 - 989    ER21516    990 - 992  
      ER21517    993 - 993    ER21518    994 - 994    ER21519    995 - 995  
      ER21520    996 - 997    ER21521    998 - 998    ER21522    999 - 1001 
      ER21523   1002 - 1002   ER21524   1003 - 1003   ER21525   1004 - 1007 
      ER21526   1008 - 1008   ER21527   1009 - 1009   ER21528   1010 - 1019 
      ER21529   1020 - 1020   ER21530   1021 - 1021   ER21531   1022 - 1022 
      ER21532   1023 - 1023   ER21533   1024 - 1026   ER21534   1027 - 1027 
      ER21535   1028 - 1029   ER21536   1030 - 1030   ER21537   1031 - 1032 
      ER21538   1033 - 1033   ER21539   1034 - 1034   ER21540   1035 - 1037 
      ER21541   1038 - 1038   ER21542   1039 - 1040   ER21543   1041 - 1041 
      ER21544   1042 - 1043   ER21545   1044 - 1044   ER21546   1045 - 1045 
      ER21547   1046 - 1048   ER21548   1049 - 1049   ER21549   1050 - 1051 
      ER21550   1052 - 1052   ER21551   1053 - 1054   ER21552   1055 - 1055 
      ER21553   1056 - 1056   ER21554   1057 - 1059   ER21555   1060 - 1060 
      ER21556   1061 - 1062   ER21557   1063 - 1063   ER21558   1064 - 1065 
      ER21559   1066 - 1066   ER21560   1067 - 1067   ER21561   1068 - 1070 
      ER21562   1071 - 1071   ER21563   1072 - 1073   ER21564   1074 - 1074 
      ER21565   1075 - 1076   ER21566   1077 - 1077   ER21567   1078 - 1078 
      ER21568   1079 - 1081   ER21569   1082 - 1082   ER21570   1083 - 1084 
      ER21571   1085 - 1085   ER21572   1086 - 1087   ER21573   1088 - 1088 
      ER21574   1089 - 1089   ER21575   1090 - 1090   ER21576   1091 - 1091 
      ER21577   1092 - 1092   ER21578   1093 - 1093   ER21579   1094 - 1094 
      ER21580   1095 - 1095   ER21581   1096 - 1096   ER21582   1097 - 1097 
      ER21583   1098 - 1098   ER21584   1099 - 1099   ER21585   1100 - 1100 
      ER21586   1101 - 1101   ER21587   1102 - 1104   ER21588   1105 - 1105 
      ER21589   1106 - 1107   ER21590   1108 - 1108   ER21591   1109 - 1110 
      ER21592   1111 - 1111   ER21593   1112 - 1112   ER21594   1113 - 1113 
      ER21595   1114 - 1114   ER21596   1115 - 1115   ER21597   1116 - 1116 
      ER21598   1117 - 1117   ER21599   1118 - 1118   ER21600   1119 - 1119 
      ER21601   1120 - 1120   ER21602   1121 - 1121   ER21603   1122 - 1122 
      ER21604   1123 - 1123   ER21605   1124 - 1125   ER21606   1126 - 1128 
      ER21607   1129 - 1129   ER21608   1130 - 1131   ER21609   1132 - 1135 
      ER21610   1136 - 1136   ER21611   1137 - 1137   ER21612   1138 - 1138 
      ER21613   1139 - 1139   ER21614   1140 - 1140   ER21615   1141 - 1141 
      ER21616   1142 - 1142   ER21617   1143 - 1143   ER21618   1144 - 1144 
      ER21619   1145 - 1146   ER21620   1147 - 1148   ER21621   1149 - 1150 
      ER21622   1151 - 1151   ER21623   1152 - 1154   ER21624   1155 - 1155 
      ER21625   1156 - 1158   ER21626   1159 - 1159   ER21627   1160 - 1160 
      ER21628   1161 - 1166   ER21629   1167 - 1167   ER21630   1168 - 1168 
      ER21631   1169 - 1169   ER21632   1170 - 1170   ER21633   1171 - 1171 
      ER21634   1172 - 1172   ER21635   1173 - 1178   ER21636   1179 - 1179 
      ER21637   1180 - 1185   ER21638   1186 - 1186   ER21639   1187 - 1187 
      ER21640   1188 - 1188   ER21641   1189 - 1189   ER21642   1190 - 1190 
      ER21643   1191 - 1191   ER21644   1192 - 1192   ER21645   1193 - 1193 
      ER21646   1194 - 1194   ER21647   1195 - 1195   ER21648   1196 - 1196 
      ER21649   1197 - 1197   ER21650   1198 - 1198   ER21651   1199 - 1199 
      ER21652   1200 - 1200   ER21653   1201 - 1206   ER21654   1207 - 1207 
      ER21655   1208 - 1208   ER21656   1209 - 1209   ER21657   1210 - 1210 
      ER21658   1211 - 1211   ER21659   1212 - 1212   ER21660   1213 - 1213 
      ER21661   1214 - 1214   ER21662   1215 - 1215   ER21663   1216 - 1216 
      ER21664   1217 - 1217   ER21665   1218 - 1218   ER21666   1219 - 1219 
      ER21667   1220 - 1220   ER21668   1221 - 1221   ER21669   1222 - 1222 
      ER21670   1223 - 1223   ER21671   1224 - 1224   ER21672   1225 - 1225 
      ER21673   1226 - 1226   ER21674   1227 - 1227   ER21675   1228 - 1228 
      ER21676   1229 - 1229   ER21677   1230 - 1230   ER21678   1231 - 1231 
      ER21679   1232 - 1232   ER21680   1233 - 1233   ER21681   1234 - 1234 
      ER21682   1235 - 1240   ER21683   1241 - 1241   ER21684   1242 - 1242 
      ER21685   1243 - 1243   ER21686   1244 - 1251   ER21687   1252 - 1252 
      ER21688   1253 - 1253   ER21689   1254 - 1254   ER21690   1255 - 1262 
      ER21691   1263 - 1263   ER21692   1264 - 1264   ER21693   1265 - 1272 
      ER21694   1273 - 1273   ER21695   1274 - 1274   ER21696   1275 - 1282 
      ER21697   1283 - 1283   ER21698   1284 - 1284   ER21699   1285 - 1285 
      ER21700   1286 - 1293   ER21701   1294 - 1294   ER21702   1295 - 1295 
      ER21703   1296 - 1303   ER21704   1304 - 1304   ER21705   1305 - 1305 
      ER21706   1306 - 1306   ER21707   1307 - 1307   ER21708   1308 - 1308 
      ER21709   1309 - 1309   ER21710   1310 - 1310   ER21711   1311 - 1311 
      ER21712   1312 - 1312   ER21713   1313 - 1313   ER21714   1314 - 1314 
      ER21715   1315 - 1315   ER21716   1316 - 1316   ER21717   1317 - 1317 
      ER21718   1318 - 1318   ER21719   1319 - 1319   ER21720   1320 - 1320 
      ER21721   1321 - 1321   ER21722   1322 - 1322   ER21723   1323 - 1323 
      ER21724   1324 - 1324   ER21725   1325 - 1325   ER21726   1326 - 1326 
      ER21727   1327 - 1327   ER21728   1328 - 1328   ER21729   1329 - 1329 
      ER21730   1330 - 1330   ER21731   1331 - 1331   ER21732   1332 - 1332 
      ER21733   1333 - 1333   ER21734   1334 - 1334   ER21735   1335 - 1335 
      ER21736   1336 - 1336   ER21737   1337 - 1337   ER21738   1338 - 1338 
      ER21739   1339 - 1339   ER21740   1340 - 1340   ER21741   1341 - 1341 
      ER21742   1342 - 1342   ER21743   1343 - 1343   ER21744   1344 - 1344 
      ER21745   1345 - 1345   ER21746   1346 - 1346   ER21747   1347 - 1347 
      ER21748   1348 - 1348   ER21749   1349 - 1349   ER21750   1350 - 1351 
      ER21751   1352 - 1353   ER21752   1354 - 1355   ER21753   1356 - 1359 
      ER21754   1360 - 1360   ER21755   1361 - 1361   ER21756   1362 - 1363 
      ER21757   1364 - 1364   ER21758   1365 - 1365   ER21759   1366 - 1369 
      ER21760   1370 - 1371   ER21761   1372 - 1372   ER21762   1373 - 1373 
      ER21763   1374 - 1374   ER21764   1375 - 1375   ER21765   1376 - 1381 
      ER21766   1382 - 1382   ER21767   1383 - 1388   ER21768   1389 - 1394 
      ER21769   1395 - 1395   ER21770   1396 - 1401   ER21771   1402 - 1407 
      ER21772   1408 - 1408   ER21773   1409 - 1411   ER21774   1412 - 1414 
      ER21775   1415 - 1420   ER21776   1421 - 1426   ER21777   1427 - 1427 
      ER21778   1428 - 1430   ER21779   1431 - 1433   ER21780   1434 - 1435 
      ER21781   1436 - 1437   ER21782   1438 - 1441   ER21783   1442 - 1442 
      ER21784   1443 - 1443   ER21785   1444 - 1445   ER21786   1446 - 1446 
      ER21787   1447 - 1447   ER21788   1448 - 1451   ER21789   1452 - 1453 
      ER21790   1454 - 1454   ER21791   1455 - 1455   ER21792   1456 - 1456 
      ER21793   1457 - 1457   ER21794   1458 - 1463   ER21795   1464 - 1464 
      ER21796   1465 - 1470   ER21797   1471 - 1476   ER21798   1477 - 1477 
      ER21799   1478 - 1483   ER21800   1484 - 1489   ER21801   1490 - 1490 
      ER21802   1491 - 1493   ER21803   1494 - 1496   ER21804   1497 - 1502 
      ER21805   1503 - 1508   ER21806   1509 - 1509   ER21807   1510 - 1512 
      ER21808   1513 - 1515   ER21809   1516 - 1517   ER21810   1518 - 1519 
      ER21811   1520 - 1523   ER21812   1524 - 1524   ER21813   1525 - 1525 
      ER21814   1526 - 1527   ER21815   1528 - 1528   ER21816   1529 - 1529 
      ER21817   1530 - 1533   ER21818   1534 - 1535   ER21819   1536 - 1536 
      ER21820   1537 - 1537   ER21821   1538 - 1538   ER21822   1539 - 1539 
      ER21823   1540 - 1545   ER21824   1546 - 1546   ER21825   1547 - 1552 
      ER21826   1553 - 1558   ER21827   1559 - 1559   ER21828   1560 - 1565 
      ER21829   1566 - 1571   ER21830   1572 - 1572   ER21831   1573 - 1575 
      ER21832   1576 - 1578   ER21833   1579 - 1584   ER21834   1585 - 1590 
      ER21835   1591 - 1591   ER21836   1592 - 1594   ER21837   1595 - 1597 
      ER21838   1598 - 1603   ER21839   1604 - 1604   ER21840   1605 - 1605 
      ER21841   1606 - 1611   ER21842   1612 - 1616   ER21843   1617 - 1621 
      ER21844   1622 - 1626   ER21845   1627 - 1631   ER21846   1632 - 1636 
      ER21847   1637 - 1641   ER21848   1642 - 1642   ER21849   1643 - 1648 
      ER21850   1649 - 1649   ER21851   1650 - 1655   ER21852   1656 - 1656 
      ER21853   1657 - 1663   ER21854   1664 - 1670   ER21855   1671 - 1677 
      ER21856   1678 - 1678   ER21857   1679 - 1679   ER21858   1680 - 1681 
      ER21859   1682 - 1682   ER21860   1683 - 1683   ER21861   1684 - 1684 
      ER21862   1685 - 1685   ER21863   1686 - 1687   ER21864   1688 - 1689 
      ER21865   1690 - 1691   ER21866   1692 - 1693   ER21867   1694 - 1694 
      ER21868   1695 - 1701   ER21869   1702 - 1708   ER21870   1709 - 1715 
      ER21871   1716 - 1716   ER21872   1717 - 1718   ER21873   1719 - 1719 
      ER21874   1720 - 1720   ER21875   1721 - 1721   ER21876   1722 - 1722 
      ER21877   1723 - 1724   ER21878   1725 - 1726   ER21879   1727 - 1728 
      ER21880   1729 - 1730   ER21881   1731 - 1731   ER21882   1732 - 1738 
      ER21883   1739 - 1745   ER21884   1746 - 1752   ER21885   1753 - 1753 
      ER21886   1754 - 1755   ER21887   1756 - 1756   ER21888   1757 - 1757 
      ER21889   1758 - 1758   ER21890   1759 - 1759   ER21891   1760 - 1761 
      ER21892   1762 - 1763   ER21893   1764 - 1765   ER21894   1766 - 1767 
      ER21895   1768 - 1768   ER21896   1769 - 1775   ER21897   1776 - 1782 
      ER21898   1783 - 1789   ER21899   1790 - 1790   ER21900   1791 - 1792 
      ER21901   1793 - 1793   ER21902   1794 - 1794   ER21903   1795 - 1795 
      ER21904   1796 - 1796   ER21905   1797 - 1798   ER21906   1799 - 1800 
      ER21907   1801 - 1802   ER21908   1803 - 1804   ER21909   1805 - 1805 
      ER21910   1806 - 1812   ER21911   1813 - 1819   ER21912   1820 - 1826 
      ER21913   1827 - 1827   ER21914   1828 - 1829   ER21915   1830 - 1830 
      ER21916   1831 - 1831   ER21917   1832 - 1832   ER21918   1833 - 1833 
      ER21919   1834 - 1835   ER21920   1836 - 1837   ER21921   1838 - 1839 
      ER21922   1840 - 1841   ER21923   1842 - 1842   ER21924   1843 - 1849 
      ER21925   1850 - 1856   ER21926   1857 - 1863   ER21927   1864 - 1864 
      ER21928   1865 - 1865   ER21929   1866 - 1872   ER21930   1873 - 1873 
      ER21931   1874 - 1874   ER21932   1875 - 1875   ER21933   1876 - 1881 
      ER21934   1882 - 1882   ER21935   1883 - 1883   ER21936   1884 - 1889 
      ER21937   1890 - 1890   ER21938   1891 - 1891   ER21939   1892 - 1897 
      ER21940   1898 - 1898   ER21941   1899 - 1899   ER21942   1900 - 1905 
      ER21943   1906 - 1906   ER21944   1907 - 1907   ER21945   1908 - 1913 
      ER21946   1914 - 1914   ER21947   1915 - 1915   ER21948   1916 - 1916 
      ER21949   1917 - 1923   ER21950   1924 - 1924   ER21951   1925 - 1925 
      ER21952   1926 - 1926   ER21953   1927 - 1927   ER21954   1928 - 1928 
      ER21955   1929 - 1929   ER21956   1930 - 1930   ER21957   1931 - 1931 
      ER21958   1932 - 1932   ER21959   1933 - 1933   ER21960   1934 - 1934 
      ER21961   1935 - 1935   ER21962   1936 - 1936   ER21963   1937 - 1937 
      ER21964   1938 - 1938   ER21965   1939 - 1939   ER21966   1940 - 1946 
      ER21967   1947 - 1947   ER21968   1948 - 1948   ER21969   1949 - 1949 
      ER21970   1950 - 1950   ER21971   1951 - 1951   ER21972   1952 - 1952 
      ER21973   1953 - 1953   ER21974   1954 - 1954   ER21975   1955 - 1955 
      ER21976   1956 - 1956   ER21977   1957 - 1957   ER21978   1958 - 1958 
      ER21979   1959 - 1959   ER21980   1960 - 1960   ER21981   1961 - 1961 
      ER21982   1962 - 1962   ER21983   1963 - 1969   ER21984   1970 - 1970 
      ER21985   1971 - 1971   ER21986   1972 - 1972   ER21987   1973 - 1973 
      ER21988   1974 - 1974   ER21989   1975 - 1975   ER21990   1976 - 1976 
      ER21991   1977 - 1977   ER21992   1978 - 1978   ER21993   1979 - 1979 
      ER21994   1980 - 1980   ER21995   1981 - 1981   ER21996   1982 - 1982 
      ER21997   1983 - 1983   ER21998   1984 - 1984   ER21999   1985 - 1985 
      ER22000   1986 - 1992   ER22001   1993 - 1993   ER22002   1994 - 1994 
      ER22003   1995 - 2000   ER22004   2001 - 2001   ER22005   2002 - 2002 
      ER22006   2003 - 2003   ER22007   2004 - 2004   ER22008   2005 - 2005 
      ER22009   2006 - 2006   ER22010   2007 - 2007   ER22011   2008 - 2008 
      ER22012   2009 - 2009   ER22013   2010 - 2010   ER22014   2011 - 2011 
      ER22015   2012 - 2012   ER22016   2013 - 2013   ER22017   2014 - 2014 
      ER22018   2015 - 2015   ER22019   2016 - 2016   ER22020   2017 - 2022 
      ER22021   2023 - 2023   ER22022   2024 - 2024   ER22023   2025 - 2025 
      ER22024   2026 - 2026   ER22025   2027 - 2027   ER22026   2028 - 2028 
      ER22027   2029 - 2029   ER22028   2030 - 2030   ER22029   2031 - 2031 
      ER22030   2032 - 2032   ER22031   2033 - 2033   ER22032   2034 - 2034 
      ER22033   2035 - 2035   ER22034   2036 - 2036   ER22035   2037 - 2037 
      ER22036   2038 - 2038   ER22037   2039 - 2044   ER22038   2045 - 2045 
      ER22039   2046 - 2046   ER22040   2047 - 2047   ER22041   2048 - 2048 
      ER22042   2049 - 2049   ER22043   2050 - 2050   ER22044   2051 - 2051 
      ER22045   2052 - 2052   ER22046   2053 - 2053   ER22047   2054 - 2054 
      ER22048   2055 - 2055   ER22049   2056 - 2056   ER22050   2057 - 2057 
      ER22051   2058 - 2058   ER22052   2059 - 2059   ER22053   2060 - 2060 
      ER22054   2061 - 2066   ER22055   2067 - 2067   ER22056   2068 - 2068 
      ER22057   2069 - 2069   ER22058   2070 - 2070   ER22059   2071 - 2071 
      ER22060   2072 - 2072   ER22061   2073 - 2073   ER22062   2074 - 2074 
      ER22063   2075 - 2075   ER22064   2076 - 2076   ER22065   2077 - 2077 
      ER22066   2078 - 2078   ER22067   2079 - 2079   ER22068   2080 - 2080 
      ER22069   2081 - 2081   ER22070   2082 - 2087   ER22071   2088 - 2088 
      ER22072   2089 - 2089   ER22073   2090 - 2090   ER22074   2091 - 2091 
      ER22075   2092 - 2092   ER22076   2093 - 2093   ER22077   2094 - 2094 
      ER22078   2095 - 2095   ER22079   2096 - 2096   ER22080   2097 - 2097 
      ER22081   2098 - 2098   ER22082   2099 - 2099   ER22083   2100 - 2100 
      ER22084   2101 - 2101   ER22085   2102 - 2102   ER22086   2103 - 2103 
      ER22087   2104 - 2109   ER22088   2110 - 2110   ER22089   2111 - 2111 
      ER22090   2112 - 2112   ER22091   2113 - 2113   ER22092   2114 - 2114 
      ER22093   2115 - 2115   ER22094   2116 - 2116   ER22095   2117 - 2117 
      ER22096   2118 - 2118   ER22097   2119 - 2119   ER22098   2120 - 2120 
      ER22099   2121 - 2121   ER22100   2122 - 2122   ER22101   2123 - 2123 
      ER22102   2124 - 2124   ER22103   2125 - 2130   ER22104   2131 - 2131 
      ER22105   2132 - 2132   ER22106   2133 - 2133   ER22107   2134 - 2134 
      ER22108   2135 - 2135   ER22109   2136 - 2136   ER22110   2137 - 2137 
      ER22111   2138 - 2138   ER22112   2139 - 2139   ER22113   2140 - 2140 
      ER22114   2141 - 2141   ER22115   2142 - 2142   ER22116   2143 - 2143 
      ER22117   2144 - 2144   ER22118   2145 - 2145   ER22119   2146 - 2146 
      ER22120   2147 - 2152   ER22121   2153 - 2153   ER22122   2154 - 2154 
      ER22123   2155 - 2155   ER22124   2156 - 2156   ER22125   2157 - 2157 
      ER22126   2158 - 2158   ER22127   2159 - 2159   ER22128   2160 - 2160 
      ER22129   2161 - 2161   ER22130   2162 - 2162   ER22131   2163 - 2163 
      ER22132   2164 - 2164   ER22133   2165 - 2165   ER22134   2166 - 2166 
      ER22135   2167 - 2167   ER22136   2168 - 2173   ER22137   2174 - 2174 
      ER22138   2175 - 2175   ER22139   2176 - 2176   ER22140   2177 - 2177 
      ER22141   2178 - 2178   ER22142   2179 - 2179   ER22143   2180 - 2180 
      ER22144   2181 - 2181   ER22145   2182 - 2182   ER22146   2183 - 2183 
      ER22147   2184 - 2184   ER22148   2185 - 2185   ER22149   2186 - 2186 
      ER22150   2187 - 2187   ER22151   2188 - 2188   ER22152   2189 - 2194 
      ER22153   2195 - 2195   ER22154   2196 - 2196   ER22155   2197 - 2197 
      ER22156   2198 - 2198   ER22157   2199 - 2199   ER22158   2200 - 2200 
      ER22159   2201 - 2201   ER22160   2202 - 2202   ER22161   2203 - 2203 
      ER22162   2204 - 2204   ER22163   2205 - 2205   ER22164   2206 - 2206 
      ER22165   2207 - 2207   ER22166   2208 - 2208   ER22167   2209 - 2209 
      ER22168   2210 - 2215   ER22169   2216 - 2216   ER22170   2217 - 2217 
      ER22171   2218 - 2218   ER22172   2219 - 2219   ER22173   2220 - 2220 
      ER22174   2221 - 2221   ER22175   2222 - 2222   ER22176   2223 - 2223 
      ER22177   2224 - 2224   ER22178   2225 - 2225   ER22179   2226 - 2226 
      ER22180   2227 - 2227   ER22181   2228 - 2228   ER22182   2229 - 2229 
      ER22183   2230 - 2230   ER22184   2231 - 2231   ER22185   2232 - 2237 
      ER22186   2238 - 2238   ER22187   2239 - 2239   ER22188   2240 - 2240 
      ER22189   2241 - 2241   ER22190   2242 - 2242   ER22191   2243 - 2243 
      ER22192   2244 - 2244   ER22193   2245 - 2245   ER22194   2246 - 2246 
      ER22195   2247 - 2247   ER22196   2248 - 2248   ER22197   2249 - 2249 
      ER22198   2250 - 2250   ER22199   2251 - 2251   ER22200   2252 - 2252 
      ER22201   2253 - 2258   ER22202   2259 - 2259   ER22203   2260 - 2260 
      ER22204   2261 - 2261   ER22205   2262 - 2262   ER22206   2263 - 2263 
      ER22207   2264 - 2264   ER22208   2265 - 2265   ER22209   2266 - 2266 
      ER22210   2267 - 2267   ER22211   2268 - 2268   ER22212   2269 - 2269 
      ER22213   2270 - 2270   ER22214   2271 - 2271   ER22215   2272 - 2272 
      ER22216   2273 - 2273   ER22217   2274 - 2279   ER22218   2280 - 2280 
      ER22219   2281 - 2281   ER22220   2282 - 2282   ER22221   2283 - 2283 
      ER22222   2284 - 2284   ER22223   2285 - 2285   ER22224   2286 - 2286 
      ER22225   2287 - 2287   ER22226   2288 - 2288   ER22227   2289 - 2289 
      ER22228   2290 - 2290   ER22229   2291 - 2291   ER22230   2292 - 2292 
      ER22231   2293 - 2293   ER22232   2294 - 2294   ER22233   2295 - 2300 
      ER22234   2301 - 2301   ER22235   2302 - 2302   ER22236   2303 - 2303 
      ER22237   2304 - 2304   ER22238   2305 - 2305   ER22239   2306 - 2306 
      ER22240   2307 - 2307   ER22241   2308 - 2308   ER22242   2309 - 2309 
      ER22243   2310 - 2310   ER22244   2311 - 2311   ER22245   2312 - 2312 
      ER22246   2313 - 2313   ER22247   2314 - 2314   ER22248   2315 - 2315 
      ER22249   2316 - 2321   ER22250   2322 - 2322   ER22251   2323 - 2323 
      ER22252   2324 - 2324   ER22253   2325 - 2325   ER22254   2326 - 2326 
      ER22255   2327 - 2327   ER22256   2328 - 2328   ER22257   2329 - 2329 
      ER22258   2330 - 2330   ER22259   2331 - 2331   ER22260   2332 - 2332 
      ER22261   2333 - 2333   ER22262   2334 - 2334   ER22263   2335 - 2335 
      ER22264   2336 - 2336   ER22265   2337 - 2342   ER22266   2343 - 2343 
      ER22267   2344 - 2344   ER22268   2345 - 2345   ER22269   2346 - 2346 
      ER22270   2347 - 2347   ER22271   2348 - 2348   ER22272   2349 - 2349 
      ER22273   2350 - 2350   ER22274   2351 - 2351   ER22275   2352 - 2352 
      ER22276   2353 - 2353   ER22277   2354 - 2354   ER22278   2355 - 2355 
      ER22279   2356 - 2356   ER22280   2357 - 2357   ER22281   2358 - 2363 
      ER22282   2364 - 2364   ER22283   2365 - 2365   ER22284   2366 - 2366 
      ER22285   2367 - 2367   ER22286   2368 - 2368   ER22287   2369 - 2369 
      ER22288   2370 - 2370   ER22289   2371 - 2371   ER22290   2372 - 2372 
      ER22291   2373 - 2373   ER22292   2374 - 2374   ER22293   2375 - 2375 
      ER22294   2376 - 2376   ER22295   2377 - 2377   ER22296   2378 - 2378 
      ER22297   2379 - 2379   ER22298   2380 - 2380   ER22299   2381 - 2381 
      ER22300   2382 - 2388   ER22301   2389 - 2389   ER22302   2390 - 2390 
      ER22303   2391 - 2391   ER22304   2392 - 2397   ER22305   2398 - 2398 
      ER22306   2399 - 2399   ER22307   2400 - 2400   ER22308   2401 - 2401 
      ER22309   2402 - 2402   ER22310   2403 - 2403   ER22311   2404 - 2404 
      ER22312   2405 - 2405   ER22313   2406 - 2406   ER22314   2407 - 2407 
      ER22315   2408 - 2408   ER22316   2409 - 2409   ER22317   2410 - 2410 
      ER22318   2411 - 2411   ER22319   2412 - 2412   ER22320   2413 - 2418 
      ER22321   2419 - 2419   ER22322   2420 - 2420   ER22323   2421 - 2421 
      ER22324   2422 - 2422   ER22325   2423 - 2423   ER22326   2424 - 2424 
      ER22327   2425 - 2425   ER22328   2426 - 2426   ER22329   2427 - 2427 
      ER22330   2428 - 2428   ER22331   2429 - 2429   ER22332   2430 - 2430 
      ER22333   2431 - 2431   ER22334   2432 - 2432   ER22335   2433 - 2433 
      ER22336   2434 - 2439   ER22337   2440 - 2440   ER22338   2441 - 2441 
      ER22339   2442 - 2442   ER22340   2443 - 2443   ER22341   2444 - 2444 
      ER22342   2445 - 2445   ER22343   2446 - 2446   ER22344   2447 - 2447 
      ER22345   2448 - 2448   ER22346   2449 - 2449   ER22347   2450 - 2450 
      ER22348   2451 - 2451   ER22349   2452 - 2452   ER22350   2453 - 2453 
      ER22351   2454 - 2454   ER22352   2455 - 2455   ER22353   2456 - 2461 
      ER22354   2462 - 2462   ER22355   2463 - 2463   ER22356   2464 - 2464 
      ER22357   2465 - 2465   ER22358   2466 - 2466   ER22359   2467 - 2467 
      ER22360   2468 - 2468   ER22361   2469 - 2469   ER22362   2470 - 2470 
      ER22363   2471 - 2471   ER22364   2472 - 2472   ER22365   2473 - 2473 
      ER22366   2474 - 2474   ER22367   2475 - 2475   ER22368   2476 - 2476 
      ER22369   2477 - 2477   ER22370   2478 - 2483   ER22371   2484 - 2484 
      ER22372   2485 - 2485   ER22373   2486 - 2486   ER22374   2487 - 2487 
      ER22375   2488 - 2488   ER22376   2489 - 2489   ER22377   2490 - 2490 
      ER22378   2491 - 2491   ER22379   2492 - 2492   ER22380   2493 - 2493 
      ER22381   2494 - 2494   ER22382   2495 - 2495   ER22383   2496 - 2496 
      ER22384   2497 - 2497   ER22385   2498 - 2498   ER22386   2499 - 2499 
      ER22387   2500 - 2505   ER22388   2506 - 2506   ER22389   2507 - 2507 
      ER22390   2508 - 2508   ER22391   2509 - 2509   ER22392   2510 - 2510 
      ER22393   2511 - 2511   ER22394   2512 - 2512   ER22395   2513 - 2513 
      ER22396   2514 - 2514   ER22397   2515 - 2515   ER22398   2516 - 2516 
      ER22399   2517 - 2517   ER22400   2518 - 2518   ER22401   2519 - 2519 
      ER22402   2520 - 2520   ER22403   2521 - 2521   ER22404   2522 - 2527 
      ER22405   2528 - 2528   ER22406   2529 - 2529   ER22407   2530 - 2530 
      ER22408   2531 - 2531   ER22409   2532 - 2532   ER22410   2533 - 2533 
      ER22411   2534 - 2534   ER22412   2535 - 2535   ER22413   2536 - 2536 
      ER22414   2537 - 2537   ER22415   2538 - 2538   ER22416   2539 - 2539 
      ER22417   2540 - 2540   ER22418   2541 - 2541   ER22419   2542 - 2542 
      ER22420   2543 - 2548   ER22421   2549 - 2549   ER22422   2550 - 2550 
      ER22423   2551 - 2551   ER22424   2552 - 2552   ER22425   2553 - 2553 
      ER22426   2554 - 2554   ER22427   2555 - 2555   ER22428   2556 - 2556 
      ER22429   2557 - 2557   ER22430   2558 - 2558   ER22431   2559 - 2559 
      ER22432   2560 - 2560   ER22433   2561 - 2561   ER22434   2562 - 2562 
      ER22435   2563 - 2563   ER22436   2564 - 2569   ER22437   2570 - 2570 
      ER22438   2571 - 2571   ER22439   2572 - 2572   ER22440   2573 - 2573 
      ER22441   2574 - 2574   ER22442   2575 - 2575   ER22443   2576 - 2576 
      ER22444   2577 - 2577   ER22445   2578 - 2578   ER22446   2579 - 2579 
      ER22447   2580 - 2580   ER22448   2581 - 2581   ER22449   2582 - 2582 
      ER22450   2583 - 2583   ER22451   2584 - 2584   ER22452   2585 - 2590 
      ER22453   2591 - 2591   ER22454   2592 - 2592   ER22455   2593 - 2593 
      ER22456   2594 - 2594   ER22457   2595 - 2595   ER22458   2596 - 2596 
      ER22459   2597 - 2597   ER22460   2598 - 2598   ER22461   2599 - 2599 
      ER22462   2600 - 2600   ER22463   2601 - 2601   ER22464   2602 - 2602 
      ER22465   2603 - 2603   ER22466   2604 - 2604   ER22467   2605 - 2605 
      ER22468   2606 - 2611   ER22469   2612 - 2612   ER22470   2613 - 2613 
      ER22471   2614 - 2614   ER22472   2615 - 2615   ER22473   2616 - 2616 
      ER22474   2617 - 2617   ER22475   2618 - 2618   ER22476   2619 - 2619 
      ER22477   2620 - 2620   ER22478   2621 - 2621   ER22479   2622 - 2622 
      ER22480   2623 - 2623   ER22481   2624 - 2624   ER22482   2625 - 2625 
      ER22483   2626 - 2626   ER22484   2627 - 2632   ER22485   2633 - 2633 
      ER22486   2634 - 2634   ER22487   2635 - 2635   ER22488   2636 - 2636 
      ER22489   2637 - 2637   ER22490   2638 - 2638   ER22491   2639 - 2639 
      ER22492   2640 - 2640   ER22493   2641 - 2641   ER22494   2642 - 2642 
      ER22495   2643 - 2643   ER22496   2644 - 2644   ER22497   2645 - 2645 
      ER22498   2646 - 2646   ER22499   2647 - 2647   ER22500   2648 - 2653 
      ER22501   2654 - 2654   ER22502   2655 - 2655   ER22503   2656 - 2656 
      ER22504   2657 - 2657   ER22505   2658 - 2658   ER22506   2659 - 2659 
      ER22507   2660 - 2660   ER22508   2661 - 2661   ER22509   2662 - 2662 
      ER22510   2663 - 2663   ER22511   2664 - 2664   ER22512   2665 - 2665 
      ER22513   2666 - 2666   ER22514   2667 - 2667   ER22515   2668 - 2668 
      ER22516   2669 - 2673   ER22517   2674 - 2674   ER22518   2675 - 2675 
      ER22519   2676 - 2676   ER22520   2677 - 2677   ER22521   2678 - 2678 
      ER22522   2679 - 2679   ER22523   2680 - 2680   ER22524   2681 - 2681 
      ER22525   2682 - 2682   ER22526   2683 - 2683   ER22527   2684 - 2684 
      ER22528   2685 - 2685   ER22529   2686 - 2686   ER22530   2687 - 2687 
      ER22531   2688 - 2688   ER22532   2689 - 2695   ER22533   2696 - 2702 
      ER22534   2703 - 2703   ER22535   2704 - 2709   ER22536   2710 - 2715 
      ER22537   2716 - 2716   ER22538   2717 - 2718   ER22539   2719 - 2720 
      ER22540   2721 - 2722   ER22541   2723 - 2724   ER22542   2725 - 2726 
      ER22543   2727 - 2728   ER22544   2729 - 2735   ER22545   2736 - 2736 
      ER22546   2737 - 2743   ER22547   2744 - 2744   ER22548   2745 - 2751 
      ER22549   2752 - 2752   ER22550   2753 - 2754   ER22551   2755 - 2755 
      ER22552   2756 - 2756   ER22553   2757 - 2757   ER22554   2758 - 2766 
      ER22555   2767 - 2767   ER22556   2768 - 2768   ER22557   2769 - 2769 
      ER22558   2770 - 2778   ER22559   2779 - 2779   ER22560   2780 - 2780 
      ER22561   2781 - 2781   ER22562   2782 - 2782   ER22563   2783 - 2791 
      ER22564   2792 - 2792   ER22565   2793 - 2793   ER22566   2794 - 2794 
      ER22567   2795 - 2795   ER22568   2796 - 2804   ER22569   2805 - 2805 
      ER22570   2806 - 2806   ER22571   2807 - 2807   ER22572   2808 - 2808 
      ER22573   2809 - 2809   ER22574   2810 - 2815   ER22575   2816 - 2816 
      ER22576   2817 - 2817   ER22577   2818 - 2818   ER22578   2819 - 2819 
      ER22579   2820 - 2820   ER22580   2821 - 2821   ER22581   2822 - 2822 
      ER22582   2823 - 2823   ER22583   2824 - 2824   ER22584   2825 - 2825 
      ER22585   2826 - 2826   ER22586   2827 - 2827   ER22587   2828 - 2828 
      ER22588   2829 - 2829   ER22589   2830 - 2830   ER22590   2831 - 2839 
      ER22591   2840 - 2840   ER22592   2841 - 2841   ER22593   2842 - 2842 
      ER22594   2843 - 2843   ER22595   2844 - 2844   ER22596   2845 - 2853 
      ER22597   2854 - 2854   ER22598   2855 - 2855   ER22599   2856 - 2856 
      ER22600   2857 - 2857   ER22601   2858 - 2863   ER22602   2864 - 2864 
      ER22603   2865 - 2865   ER22604   2866 - 2866   ER22605   2867 - 2867 
      ER22606   2868 - 2868   ER22607   2869 - 2869   ER22608   2870 - 2870 
      ER22609   2871 - 2871   ER22610   2872 - 2872   ER22611   2873 - 2873 
      ER22612   2874 - 2874   ER22613   2875 - 2875   ER22614   2876 - 2876 
      ER22615   2877 - 2877   ER22616   2878 - 2878   ER22617   2879 - 2887 
      ER22618   2888 - 2888   ER22619   2889 - 2889   ER22620   2890 - 2890 
      ER22621   2891 - 2891   ER22622   2892 - 2900   ER22623   2901 - 2901 
      ER22624   2902 - 2902   ER22625   2903 - 2903   ER22626   2904 - 2904 
      ER22627   2905 - 2913   ER22628   2914 - 2914   ER22629   2915 - 2915 
      ER22630   2916 - 2916   ER22631   2917 - 2917   ER22632   2918 - 2926 
      ER22633   2927 - 2927   ER22634   2928 - 2928   ER22635   2929 - 2929 
      ER22636   2930 - 2930   ER22637   2931 - 2931   ER22638   2932 - 2940 
      ER22639   2941 - 2941   ER22640   2942 - 2942   ER22641   2943 - 2943 
      ER22642   2944 - 2944   ER22643   2945 - 2953   ER22644   2954 - 2954 
      ER22645   2955 - 2955   ER22646   2956 - 2956   ER22647   2957 - 2957 
      ER22648   2958 - 2966   ER22649   2967 - 2967   ER22650   2968 - 2968 
      ER22651   2969 - 2969   ER22652   2970 - 2970   ER22653   2971 - 2979 
      ER22654   2980 - 2980   ER22655   2981 - 2981   ER22656   2982 - 2982 
      ER22657   2983 - 2991   ER22658   2992 - 2992   ER22659   2993 - 2993 
      ER22660   2994 - 2994   ER22661   2995 - 2995   ER22662   2996 - 3004 
      ER22663   3005 - 3005   ER22664   3006 - 3006   ER22665   3007 - 3007 
      ER22666   3008 - 3008   ER22667   3009 - 3009   ER22668   3010 - 3010 
      ER22669   3011 - 3019   ER22670   3020 - 3020   ER22671   3021 - 3021 
      ER22672   3022 - 3022   ER22673   3023 - 3023   ER22674   3024 - 3032 
      ER22675   3033 - 3033   ER22676   3034 - 3034   ER22677   3035 - 3035 
      ER22678   3036 - 3036   ER22679   3037 - 3037   ER22680   3038 - 3046 
      ER22681   3047 - 3047   ER22682   3048 - 3048   ER22683   3049 - 3049 
      ER22684   3050 - 3050   ER22685   3051 - 3051   ER22686   3052 - 3060 
      ER22687   3061 - 3061   ER22688   3062 - 3062   ER22689   3063 - 3063 
      ER22690   3064 - 3064   ER22691   3065 - 3073   ER22692   3074 - 3074 
      ER22693   3075 - 3075   ER22694   3076 - 3076   ER22695   3077 - 3077 
      ER22696   3078 - 3078   ER22697   3079 - 3087   ER22698   3088 - 3088 
      ER22699   3089 - 3089   ER22700   3090 - 3090   ER22701   3091 - 3091 
      ER22702   3092 - 3100   ER22703   3101 - 3101   ER22704   3102 - 3102 
      ER22705   3103 - 3103   ER22706   3104 - 3104   ER22707   3105 - 3108 
      ER22708   3109 - 3117   ER22709   3118 - 3118   ER22710   3119 - 3119 
      ER22711   3120 - 3120   ER22712   3121 - 3124   ER22713   3125 - 3133 
      ER22714   3134 - 3134   ER22715   3135 - 3135   ER22716   3136 - 3136 
      ER22717   3137 - 3140   ER22718   3141 - 3149   ER22719   3150 - 3150 
      ER22720   3151 - 3151   ER22721   3152 - 3152   ER22722   3153 - 3153 
      ER22723   3154 - 3155   ER22724   3156 - 3159   ER22725   3160 - 3160 
      ER22726   3161 - 3163   ER22727   3164 - 3164   ER22728   3165 - 3167 
      ER22729   3168 - 3168   ER22730   3169 - 3169   ER22731   3170 - 3176 
      ER22732   3177 - 3177   ER22733   3178 - 3180   ER22734   3181 - 3181 
      ER22735   3182 - 3188   ER22736   3189 - 3189   ER22737   3190 - 3192 
      ER22738   3193 - 3193   ER22739   3194 - 3194   ER22740   3195 - 3201 
      ER22741   3202 - 3202   ER22742   3203 - 3205   ER22743   3206 - 3208 
      ER22744   3209 - 3217   ER22745   3218 - 3218   ER22746   3219 - 3227 
      ER22747   3228 - 3228   ER22748   3229 - 3231   ER22749   3232 - 3232 
      ER22750   3233 - 3233   ER22751   3234 - 3236   ER22752   3237 - 3239 
      ER22753   3240 - 3242   ER22754   3243 - 3245   ER22755   3246 - 3246 
      ER22756   3247 - 3247   ER22757   3248 - 3250   ER22758   3251 - 3253 
      ER22759   3254 - 3256   ER22760   3257 - 3259   ER22761   3260 - 3262 
      ER22762   3263 - 3263   ER22763   3264 - 3270   ER22764   3271 - 3271 
      ER22765   3272 - 3274   ER22766   3275 - 3283   ER22767   3284 - 3284 
      ER22768   3285 - 3285   ER22769   3286 - 3286   ER22770   3287 - 3287 
      ER22771   3288 - 3289   ER22772   3290 - 3291   ER22773   3292 - 3294 
      ER22774   3295 - 3298   ER22775   3299 - 3301   ER22776   3302 - 3305 
      ER22777   3306 - 3306   ER22778   3307 - 3307   ER22779   3308 - 3314 
      ER22780   3315 - 3315   ER22781   3316 - 3318   ER22782   3319 - 3319 
      ER22783   3320 - 3320   ER22784   3321 - 3328   ER22785   3329 - 3329 
      ER22786   3330 - 3337   ER22787   3338 - 3339   ER22788   3340 - 3346 
      ER22789   3347 - 3347   ER22790   3348 - 3348   ER22791   3349 - 3349 
      ER22792   3350 - 3350   ER22793   3351 - 3351   ER22794   3352 - 3352 
      ER22795   3353 - 3353   ER22796   3354 - 3355   ER22797   3356 - 3359 
      ER22798   3360 - 3366   ER22799   3367 - 3367   ER22800   3368 - 3368 
      ER22801   3369 - 3369   ER22802   3370 - 3376   ER22803   3377 - 3377 
      ER22804   3378 - 3378   ER22805   3379 - 3379   ER22806   3380 - 3380 
      ER22807   3381 - 3381   ER22808   3382 - 3382   ER22809   3383 - 3389 
      ER22810   3390 - 3391   ER22811   3392 - 3393   ER22812   3394 - 3399 
      ER22813   3400 - 3400   ER22814   3401 - 3403   ER22815   3404 - 3411 
      ER22816   3412 - 3418   ER22817   3419 - 3419   ER22818   3420 - 3427 
      ER22819   3428 - 3429   ER22820   3430 - 3436   ER22821   3437 - 3437 
      ER22822   3438 - 3439   ER22823   3440 - 3440   ER22824   3441 - 3441 
      ER22825   3442 - 3449   ER22826   3450 - 3450   ER22827   3451 - 3458 
      ER22828   3459 - 3460   ER22829   3461 - 3467   ER22830   3468 - 3468 
      ER22831   3469 - 3469   ER22832   3470 - 3470   ER22833   3471 - 3471 
      ER22834   3472 - 3472   ER22835   3473 - 3473   ER22836   3474 - 3474 
      ER22837   3475 - 3476   ER22838   3477 - 3480   ER22839   3481 - 3487 
      ER22840   3488 - 3488   ER22841   3489 - 3489   ER22842   3490 - 3490 
      ER22843   3491 - 3497   ER22844   3498 - 3498   ER22845   3499 - 3499 
      ER22846   3500 - 3500   ER22847   3501 - 3501   ER22848   3502 - 3502 
      ER22849   3503 - 3503   ER22850   3504 - 3510   ER22851   3511 - 3512 
      ER22852   3513 - 3514   ER22853   3515 - 3520   ER22854   3521 - 3521 
      ER22855   3522 - 3524   ER22856   3525 - 3532   ER22857   3533 - 3539 
      ER22858   3540 - 3540   ER22859   3541 - 3548   ER22860   3549 - 3550 
      ER22861   3551 - 3557   ER22862   3558 - 3558   ER22863   3559 - 3560 
      ER22864   3561 - 3561   ER22865   3562 - 3562   ER22866   3563 - 3563 
      ER22867   3564 - 3565   ER22868   3566 - 3569   ER22869   3570 - 3570 
      ER22870   3571 - 3573   ER22871   3574 - 3574   ER22872   3575 - 3577 
      ER22873   3578 - 3578   ER22874   3579 - 3579   ER22875   3580 - 3586 
      ER22876   3587 - 3587   ER22877   3588 - 3590   ER22878   3591 - 3591 
      ER22879   3592 - 3598   ER22880   3599 - 3599   ER22881   3600 - 3602 
      ER22882   3603 - 3603   ER22883   3604 - 3604   ER22884   3605 - 3611 
      ER22885   3612 - 3612   ER22886   3613 - 3615   ER22887   3616 - 3618 
      ER22888   3619 - 3627   ER22889   3628 - 3628   ER22890   3629 - 3637 
      ER22891   3638 - 3638   ER22892   3639 - 3641   ER22893   3642 - 3642 
      ER22894   3643 - 3643   ER22895   3644 - 3646   ER22896   3647 - 3649 
      ER22897   3650 - 3652   ER22898   3653 - 3655   ER22899   3656 - 3656 
      ER22900   3657 - 3657   ER22901   3658 - 3660   ER22902   3661 - 3663 
      ER22903   3664 - 3666   ER22904   3667 - 3669   ER22905   3670 - 3672 
      ER22906   3673 - 3673   ER22907   3674 - 3680   ER22908   3681 - 3681 
      ER22909   3682 - 3684   ER22910   3685 - 3693   ER22911   3694 - 3694 
      ER22912   3695 - 3695   ER22913   3696 - 3696   ER22914   3697 - 3697 
      ER22915   3698 - 3699   ER22916   3700 - 3701   ER22917   3702 - 3704 
      ER22918   3705 - 3708   ER22919   3709 - 3711   ER22920   3712 - 3715 
      ER22921   3716 - 3716   ER22922   3717 - 3717   ER22923   3718 - 3724 
      ER22924   3725 - 3725   ER22925   3726 - 3728   ER22926   3729 - 3729 
      ER22927   3730 - 3730   ER22928   3731 - 3738   ER22929   3739 - 3739 
      ER22930   3740 - 3747   ER22931   3748 - 3749   ER22932   3750 - 3756 
      ER22933   3757 - 3757   ER22934   3758 - 3758   ER22935   3759 - 3759 
      ER22936   3760 - 3760   ER22937   3761 - 3761   ER22938   3762 - 3762 
      ER22939   3763 - 3763   ER22940   3764 - 3765   ER22941   3766 - 3769 
      ER22942   3770 - 3776   ER22943   3777 - 3777   ER22944   3778 - 3778 
      ER22945   3779 - 3779   ER22946   3780 - 3786   ER22947   3787 - 3787 
      ER22948   3788 - 3788   ER22949   3789 - 3789   ER22950   3790 - 3790 
      ER22951   3791 - 3791   ER22952   3792 - 3792   ER22953   3793 - 3799 
      ER22954   3800 - 3801   ER22955   3802 - 3803   ER22956   3804 - 3809 
      ER22957   3810 - 3810   ER22958   3811 - 3813   ER22959   3814 - 3821 
      ER22960   3822 - 3828   ER22961   3829 - 3829   ER22962   3830 - 3837 
      ER22963   3838 - 3839   ER22964   3840 - 3846   ER22965   3847 - 3847 
      ER22966   3848 - 3849   ER22967   3850 - 3850   ER22968   3851 - 3851 
      ER22969   3852 - 3859   ER22970   3860 - 3860   ER22971   3861 - 3868 
      ER22972   3869 - 3870   ER22973   3871 - 3877   ER22974   3878 - 3878 
      ER22975   3879 - 3879   ER22976   3880 - 3880   ER22977   3881 - 3881 
      ER22978   3882 - 3882   ER22979   3883 - 3883   ER22980   3884 - 3884 
      ER22981   3885 - 3886   ER22982   3887 - 3890   ER22983   3891 - 3897 
      ER22984   3898 - 3898   ER22985   3899 - 3899   ER22986   3900 - 3900 
      ER22987   3901 - 3907   ER22988   3908 - 3908   ER22989   3909 - 3909 
      ER22990   3910 - 3910   ER22991   3911 - 3911   ER22992   3912 - 3912 
      ER22993   3913 - 3913   ER22994   3914 - 3920   ER22995   3921 - 3922 
      ER22996   3923 - 3924   ER22997   3925 - 3930   ER22998   3931 - 3931 
      ER22999   3932 - 3934   ER23000   3935 - 3942   ER23001   3943 - 3949 
      ER23002   3950 - 3950   ER23003   3951 - 3958   ER23004   3959 - 3960 
      ER23005   3961 - 3967   ER23006   3968 - 3968   ER23007   3969 - 3970 
      ER23008   3971 - 3971   ER23009   3972 - 3972   ER23010   3973 - 3973 
      ER23011   3974 - 3974   ER23012   3975 - 3975   ER23013   3976 - 3976 
      ER23014   3977 - 3977   ER23015   3978 - 3978   ER23016   3979 - 3979 
      ER23017   3980 - 3980   ER23018   3981 - 3982   ER23019   3983 - 3984 
      ER23020   3985 - 3986   ER23021   3987 - 3988   ER23022   3989 - 3989 
      ER23023   3990 - 3990   ER23024   3991 - 3992   ER23025   3993 - 3994 
      ER23026   3995 - 3996   ER23027   3997 - 3998   ER23028   3999 - 3999 
      ER23029   4000 - 4000   ER23030   4001 - 4002   ER23031   4003 - 4004 
      ER23032   4005 - 4006   ER23033   4007 - 4008   ER23034   4009 - 4009 
      ER23035   4010 - 4010   ER23036   4011 - 4012   ER23037   4013 - 4014 
      ER23038   4015 - 4016   ER23039   4017 - 4018   ER23040   4019 - 4019 
      ER23041   4020 - 4020   ER23042   4021 - 4022   ER23043   4023 - 4024 
      ER23044   4025 - 4026   ER23045   4027 - 4028   ER23046   4029 - 4029 
      ER23047   4030 - 4030   ER23048   4031 - 4032   ER23049   4033 - 4034 
      ER23050   4035 - 4036   ER23051   4037 - 4038   ER23052   4039 - 4039 
      ER23053   4040 - 4040   ER23054   4041 - 4042   ER23055   4043 - 4044 
      ER23056   4045 - 4046   ER23057   4047 - 4048   ER23058   4049 - 4049 
      ER23059   4050 - 4050   ER23060   4051 - 4052   ER23061   4053 - 4054 
      ER23062   4055 - 4056   ER23063   4057 - 4058   ER23064   4059 - 4059 
      ER23065   4060 - 4060   ER23066   4061 - 4062   ER23067   4063 - 4064 
      ER23068   4065 - 4066   ER23069   4067 - 4068   ER23070   4069 - 4069 
      ER23071   4070 - 4070   ER23072   4071 - 4072   ER23073   4073 - 4074 
      ER23074   4075 - 4076   ER23075   4077 - 4078   ER23076   4079 - 4079 
      ER23077   4080 - 4080   ER23078   4081 - 4082   ER23079   4083 - 4084 
      ER23080   4085 - 4086   ER23081   4087 - 4088   ER23082   4089 - 4089 
      ER23083   4090 - 4090   ER23084   4091 - 4092   ER23085   4093 - 4094 
      ER23086   4095 - 4096   ER23087   4097 - 4098   ER23088   4099 - 4099 
      ER23089   4100 - 4100   ER23090   4101 - 4103   ER23091   4104 - 4105 
      ER23092   4106 - 4106   ER23093   4107 - 4107   ER23094   4108 - 4108 
      ER23095   4109 - 4109   ER23096   4110 - 4110   ER23097   4111 - 4111 
      ER23098   4112 - 4112   ER23099   4113 - 4113   ER23100   4114 - 4114 
      ER23101   4115 - 4115   ER23102   4116 - 4116   ER23103   4117 - 4117 
      ER23104   4118 - 4118   ER23105   4119 - 4119   ER23106   4120 - 4120 
      ER23107   4121 - 4121   ER23108   4122 - 4122   ER23109   4123 - 4123 
      ER23110   4124 - 4124   ER23111   4125 - 4125   ER23112   4126 - 4126 
      ER23113   4127 - 4127   ER23114   4128 - 4128   ER23115   4129 - 4129 
      ER23116   4130 - 4130   ER23117   4131 - 4131   ER23118   4132 - 4134 
      ER23119   4135 - 4135   ER23120   4136 - 4138   ER23121   4139 - 4139 
      ER23122   4140 - 4140   ER23123   4141 - 4141   ER23124   4142 - 4144 
      ER23125   4145 - 4146   ER23126   4147 - 4147   ER23127   4148 - 4150 
      ER23128   4151 - 4152   ER23129   4153 - 4154   ER23130   4155 - 4155 
      ER23131   4156 - 4156   ER23132   4157 - 4159   ER23133   4160 - 4160 
      ER23134   4161 - 4162   ER23135   4163 - 4163   ER23136   4164 - 4164 
      ER23137   4165 - 4165   ER23138   4166 - 4166   ER23139   4167 - 4167 
      ER23140   4168 - 4168   ER23141   4169 - 4169   ER23142   4170 - 4170 
      ER23143   4171 - 4171   ER23144   4172 - 4172   ER23145   4173 - 4174 
      ER23146   4175 - 4176   ER23147   4177 - 4178   ER23148   4179 - 4180 
      ER23149   4181 - 4181   ER23150   4182 - 4182   ER23151   4183 - 4184 
      ER23152   4185 - 4186   ER23153   4187 - 4188   ER23154   4189 - 4190 
      ER23155   4191 - 4191   ER23156   4192 - 4192   ER23157   4193 - 4194 
      ER23158   4195 - 4196   ER23159   4197 - 4198   ER23160   4199 - 4200 
      ER23161   4201 - 4201   ER23162   4202 - 4202   ER23163   4203 - 4204 
      ER23164   4205 - 4206   ER23165   4207 - 4208   ER23166   4209 - 4210 
      ER23167   4211 - 4211   ER23168   4212 - 4212   ER23169   4213 - 4214 
      ER23170   4215 - 4216   ER23171   4217 - 4218   ER23172   4219 - 4220 
      ER23173   4221 - 4221   ER23174   4222 - 4222   ER23175   4223 - 4224 
      ER23176   4225 - 4226   ER23177   4227 - 4228   ER23178   4229 - 4230 
      ER23179   4231 - 4231   ER23180   4232 - 4232   ER23181   4233 - 4234 
      ER23182   4235 - 4236   ER23183   4237 - 4238   ER23184   4239 - 4240 
      ER23185   4241 - 4241   ER23186   4242 - 4242   ER23187   4243 - 4244 
      ER23188   4245 - 4246   ER23189   4247 - 4248   ER23190   4249 - 4250 
      ER23191   4251 - 4251   ER23192   4252 - 4252   ER23193   4253 - 4254 
      ER23194   4255 - 4256   ER23195   4257 - 4258   ER23196   4259 - 4260 
      ER23197   4261 - 4261   ER23198   4262 - 4262   ER23199   4263 - 4264 
      ER23200   4265 - 4266   ER23201   4267 - 4268   ER23202   4269 - 4270 
      ER23203   4271 - 4271   ER23204   4272 - 4272   ER23205   4273 - 4274 
      ER23206   4275 - 4276   ER23207   4277 - 4278   ER23208   4279 - 4280 
      ER23209   4281 - 4281   ER23210   4282 - 4282   ER23211   4283 - 4284 
      ER23212   4285 - 4286   ER23213   4287 - 4288   ER23214   4289 - 4290 
      ER23215   4291 - 4291   ER23216   4292 - 4292   ER23217   4293 - 4295 
      ER23218   4296 - 4297   ER23219   4298 - 4298   ER23220   4299 - 4299 
      ER23221   4300 - 4300   ER23222   4301 - 4301   ER23223   4302 - 4302 
      ER23224   4303 - 4303   ER23225   4304 - 4304   ER23226   4305 - 4305 
      ER23227   4306 - 4306   ER23228   4307 - 4307   ER23229   4308 - 4308 
      ER23230   4309 - 4309   ER23231   4310 - 4310   ER23232   4311 - 4311 
      ER23233   4312 - 4312   ER23234   4313 - 4313   ER23235   4314 - 4314 
      ER23236   4315 - 4315   ER23237   4316 - 4316   ER23238   4317 - 4317 
      ER23239   4318 - 4318   ER23240   4319 - 4319   ER23241   4320 - 4320 
      ER23242   4321 - 4321   ER23243   4322 - 4322   ER23244   4323 - 4323 
      ER23245   4324 - 4326   ER23246   4327 - 4327   ER23247   4328 - 4330 
      ER23248   4331 - 4331   ER23249   4332 - 4332   ER23250   4333 - 4333 
      ER23251   4334 - 4336   ER23252   4337 - 4338   ER23253   4339 - 4339 
      ER23254   4340 - 4342   ER23255   4343 - 4344   ER23256   4345 - 4346 
      ER23257   4347 - 4347   ER23258   4348 - 4348   ER23259   4349 - 4351 
      ER23260   4352 - 4352   ER23261   4353 - 4354   ER23262   4355 - 4355 
      ER23263   4356 - 4356   ER23264   4357 - 4357   ER23265   4358 - 4358 
      ER23266   4359 - 4359   ER23267   4360 - 4360   ER23268   4361 - 4362 
      ER23269   4363 - 4363   ER23270   4364 - 4364   ER23271   4365 - 4365 
      ER23272   4366 - 4366   ER23273   4367 - 4368   ER23274   4369 - 4370 
      ER23275   4371 - 4371   ER23276   4372 - 4372   ER23277   4373 - 4373 
      ER23278   4374 - 4379   ER23279   4380 - 4385   ER23280   4386 - 4386 
      ER23281   4387 - 4387   ER23282   4388 - 4388   ER23283   4389 - 4389 
      ER23284   4390 - 4390   ER23285   4391 - 4397   ER23286   4398 - 4398 
      ER23287   4399 - 4399   ER23288   4400 - 4400   ER23289   4401 - 4401 
      ER23290   4402 - 4402   ER23291   4403 - 4409   ER23292   4410 - 4410 
      ER23293   4411 - 4411   ER23294   4412 - 4412   ER23295   4413 - 4413 
      ER23296   4414 - 4414   ER23297   4415 - 4422   ER23298   4423 - 4423 
      ER23299   4424 - 4424   ER23300   4425 - 4425   ER23301   4426 - 4426 
      ER23302   4427 - 4427   ER23303   4428 - 4428   ER23304   4429 - 4430 
      ER23305   4431 - 4432   ER23306   4433 - 4433   ER23307   4434 - 4435 
      ER23308   4436 - 4436   ER23309   4437 - 4437   ER23310   4438 - 4439 
      ER23311   4440 - 4442   ER23312   4443 - 4445   ER23313   4446 - 4447 
      ER23314   4448 - 4449   ER23315   4450 - 4450   ER23316   4451 - 4452 
      ER23317   4453 - 4453   ER23318   4454 - 4454   ER23319   4455 - 4456 
      ER23320   4457 - 4459   ER23321   4460 - 4462   ER23322   4463 - 4463 
      ER23323   4464 - 4465   ER23324   4466 - 4466   ER23325   4467 - 4467 
      ER23326   4468 - 4469   ER23327   4470 - 4470   ER23328   4471 - 4471 
      ER23329   4472 - 4473   ER23330   4474 - 4474   ER23331   4475 - 4475 
      ER23332   4476 - 4477   ER23333   4478 - 4478   ER23334   4479 - 4479 
      ER23335   4480 - 4480   ER23336   4481 - 4481   ER23337   4482 - 4482 
      ER23338   4483 - 4483   ER23339   4484 - 4485   ER23340   4486 - 4487 
      ER23341   4488 - 4488   ER23342   4489 - 4489   ER23343   4490 - 4490 
      ER23344   4491 - 4492   ER23345   4493 - 4496   ER23346   4497 - 4498 
      ER23347   4499 - 4500   ER23348   4501 - 4504   ER23349   4505 - 4506 
      ER23350   4507 - 4510   ER23351   4511 - 4512   ER23352   4513 - 4514 
      ER23353   4515 - 4518   ER23354   4519 - 4519   ER23355   4520 - 4521 
      ER23356   4522 - 4525   ER23357   4526 - 4526   ER23358   4527 - 4527 
      ER23359   4528 - 4529   ER23360   4530 - 4531   ER23361   4532 - 4535 
      ER23362   4536 - 4537   ER23363   4538 - 4538   ER23364   4539 - 4539 
      ER23365   4540 - 4541   ER23366   4542 - 4543   ER23367   4544 - 4545 
      ER23368   4546 - 4549   ER23369   4550 - 4550   ER23370   4551 - 4551 
      ER23371   4552 - 4553   ER23372   4554 - 4555   ER23373   4556 - 4557 
      ER23374   4558 - 4561   ER23375   4562 - 4562   ER23376   4563 - 4563 
      ER23377   4564 - 4565   ER23378   4566 - 4567   ER23379   4568 - 4569 
      ER23380   4570 - 4573   ER23381   4574 - 4574   ER23382   4575 - 4576 
      ER23383   4577 - 4578   ER23384   4579 - 4580   ER23385   4581 - 4582 
      ER23386   4583 - 4585   ER23387   4586 - 4588   ER23388   4589 - 4589 
      ER23389   4590 - 4591   ER23390   4592 - 4593   ER23391   4594 - 4594 
      ER23392   4595 - 4596   ER23393   4597 - 4597   ER23394   4598 - 4598 
      ER23395   4599 - 4600   ER23396   4601 - 4603   ER23397   4604 - 4606 
      ER23398   4607 - 4608   ER23399   4609 - 4610   ER23400   4611 - 4611 
      ER23401   4612 - 4613   ER23402   4614 - 4614   ER23403   4615 - 4615 
      ER23404   4616 - 4617   ER23405   4618 - 4620   ER23406   4621 - 4623 
      ER23407   4624 - 4624   ER23408   4625 - 4626   ER23409   4627 - 4627 
      ER23410   4628 - 4628   ER23411   4629 - 4630   ER23412   4631 - 4631 
      ER23413   4632 - 4632   ER23414   4633 - 4634   ER23415   4635 - 4635 
      ER23416   4636 - 4636   ER23417   4637 - 4638   ER23418   4639 - 4639 
      ER23419   4640 - 4640   ER23420   4641 - 4642   ER23421   4643 - 4643 
      ER23422   4644 - 4644   ER23423   4645 - 4645   ER23424   4646 - 4646 
      ER23425   4647 - 4647   ER23426   4648 - 4648   ER23427   4649 - 4649 
      ER23428   4650 - 4650   ER23429   4651 - 4651   ER23430   4652 - 4652 
      ER23431   4653 - 4654   ER23432   4655 - 4656   ER23433   4657 - 4657 
      ER23434   4658 - 4658   ER23435   4659 - 4659   ER23436   4660 - 4661 
      ER23437   4662 - 4665   ER23438   4666 - 4667   ER23439   4668 - 4669 
      ER23440   4670 - 4673   ER23441   4674 - 4675   ER23442   4676 - 4679 
      ER23443   4680 - 4681   ER23444   4682 - 4683   ER23445   4684 - 4687 
      ER23446   4688 - 4688   ER23447   4689 - 4690   ER23448   4691 - 4694 
      ER23449   4695 - 4695   ER23450   4696 - 4696   ER23451   4697 - 4698 
      ER23452   4699 - 4700   ER23453   4701 - 4704   ER23454   4705 - 4706 
      ER23455   4707 - 4707   ER23456   4708 - 4708   ER23457   4709 - 4710 
      ER23458   4711 - 4712   ER23459   4713 - 4714   ER23460   4715 - 4718 
      ER23461   4719 - 4719   ER23462   4720 - 4720   ER23463   4721 - 4722 
      ER23464   4723 - 4724   ER23465   4725 - 4726   ER23466   4727 - 4730 
      ER23467   4731 - 4731   ER23468   4732 - 4732   ER23469   4733 - 4734 
      ER23470   4735 - 4736   ER23471   4737 - 4738   ER23472   4739 - 4742 
      ER23473   4743 - 4743   ER23474   4744 - 4745   ER23475   4746 - 4747 
      ER23476   4748 - 4749   ER23477   4750 - 4751   ER23478   4752 - 4754 
      ER23479   4755 - 4757   ER23480   4758 - 4758   ER23481   4759 - 4759 
      ER23482   4760 - 4760   ER23483   4761 - 4766   ER23484   4767 - 4767 
      ER23485   4768 - 4768   ER23486   4769 - 4769   ER23487   4770 - 4770 
      ER23488   4771 - 4771   ER23489   4772 - 4777   ER23490   4778 - 4778 
      ER23491   4779 - 4779   ER23492   4780 - 4780   ER23493   4781 - 4781 
      ER23494   4782 - 4782   ER23495   4783 - 4787   ER23496   4788 - 4788 
      ER23497   4789 - 4789   ER23498   4790 - 4790   ER23499   4791 - 4791 
      ER23500   4792 - 4792   ER23501   4793 - 4797   ER23502   4798 - 4798 
      ER23503   4799 - 4799   ER23504   4800 - 4800   ER23505   4801 - 4801 
      ER23506   4802 - 4802   ER23507   4803 - 4807   ER23508   4808 - 4808 
      ER23509   4809 - 4809   ER23510   4810 - 4810   ER23511   4811 - 4811 
      ER23512   4812 - 4812   ER23513   4813 - 4817   ER23514   4818 - 4818 
      ER23515   4819 - 4819   ER23516   4820 - 4820   ER23517   4821 - 4821 
      ER23518   4822 - 4822   ER23519   4823 - 4827   ER23520   4828 - 4828 
      ER23521   4829 - 4829   ER23522   4830 - 4830   ER23523   4831 - 4831 
      ER23524   4832 - 4832   ER23525   4833 - 4837   ER23526   4838 - 4838 
      ER23527   4839 - 4839   ER23528   4840 - 4840   ER23529   4841 - 4841 
      ER23530   4842 - 4842   ER23531   4843 - 4847   ER23532   4848 - 4848 
      ER23533   4849 - 4849   ER23534   4850 - 4850   ER23535   4851 - 4851 
      ER23536   4852 - 4852   ER23537   4853 - 4857   ER23538   4858 - 4858 
      ER23539   4859 - 4859   ER23540   4860 - 4860   ER23541   4861 - 4861 
      ER23542   4862 - 4862   ER23543   4863 - 4867   ER23544   4868 - 4868 
      ER23545   4869 - 4869   ER23546   4870 - 4870   ER23547   4871 - 4871 
      ER23548   4872 - 4872   ER23549   4873 - 4873   ER23550   4874 - 4874 
      ER23551   4875 - 4875   ER23552   4876 - 4876   ER23553   4877 - 4877 
      ER23554   4878 - 4879   ER23555   4880 - 4880   ER23556   4881 - 4881 
      ER23557   4882 - 4883   ER23558   4884 - 4885   ER23559   4886 - 4890 
      ER23560   4891 - 4891   ER23561   4892 - 4896   ER23562   4897 - 4897 
      ER23563   4898 - 4902   ER23564   4903 - 4904   ER23565   4905 - 4905 
      ER23566   4906 - 4906   ER23567   4907 - 4908   ER23568   4909 - 4910 
      ER23569   4911 - 4915   ER23570   4916 - 4916   ER23571   4917 - 4921 
      ER23572   4922 - 4922   ER23573   4923 - 4927   ER23574   4928 - 4929 
      ER23575   4930 - 4930   ER23576   4931 - 4932   ER23577   4933 - 4934 
      ER23578   4935 - 4939   ER23579   4940 - 4940   ER23580   4941 - 4945 
      ER23581   4946 - 4946   ER23582   4947 - 4951   ER23583   4952 - 4953 
      ER23584   4954 - 4954   ER23585   4955 - 4956   ER23586   4957 - 4958 
      ER23587   4959 - 4963   ER23588   4964 - 4964   ER23589   4965 - 4969 
      ER23590   4970 - 4970   ER23591   4971 - 4975   ER23592   4976 - 4977 
      ER23593   4978 - 4978   ER23594   4979 - 4980   ER23595   4981 - 4982 
      ER23596   4983 - 4987   ER23597   4988 - 4988   ER23598   4989 - 4993 
      ER23599   4994 - 4994   ER23600   4995 - 4999   ER23601   5000 - 5001 
      ER23602   5002 - 5002   ER23603   5003 - 5004   ER23604   5005 - 5006 
      ER23605   5007 - 5011   ER23606   5012 - 5012   ER23607   5013 - 5017 
      ER23608   5018 - 5018   ER23609   5019 - 5023   ER23610   5024 - 5025 
      ER23611   5026 - 5026   ER23612   5027 - 5028   ER23613   5029 - 5030 
      ER23614   5031 - 5035   ER23615   5036 - 5036   ER23616   5037 - 5041 
      ER23617   5042 - 5042   ER23618   5043 - 5047   ER23619   5048 - 5049 
      ER23620   5050 - 5050   ER23621   5051 - 5052   ER23622   5053 - 5054 
      ER23623   5055 - 5059   ER23624   5060 - 5060   ER23625   5061 - 5065 
      ER23626   5066 - 5066   ER23627   5067 - 5071   ER23628   5072 - 5073 
      ER23629   5074 - 5074   ER23630   5075 - 5076   ER23631   5077 - 5078 
      ER23632   5079 - 5083   ER23633   5084 - 5084   ER23634   5085 - 5089 
      ER23635   5090 - 5090   ER23636   5091 - 5095   ER23637   5096 - 5097 
      ER23638   5098 - 5098   ER23639   5099 - 5100   ER23640   5101 - 5102 
      ER23641   5103 - 5107   ER23642   5108 - 5108   ER23643   5109 - 5113 
      ER23644   5114 - 5114   ER23645   5115 - 5119   ER23646   5120 - 5121 
      ER23647   5122 - 5122   ER23648   5123 - 5124   ER23649   5125 - 5126 
      ER23650   5127 - 5131   ER23651   5132 - 5132   ER23652   5133 - 5137 
      ER23653   5138 - 5138   ER23654   5139 - 5143   ER23655   5144 - 5145 
      ER23656   5146 - 5146   ER23657   5147 - 5148   ER23658   5149 - 5150 
      ER23659   5151 - 5155   ER23660   5156 - 5156   ER23661   5157 - 5161 
      ER23662   5162 - 5162   ER23663   5163 - 5167   ER23664   5168 - 5168 
      ER23665   5169 - 5170   ER23666   5171 - 5171   ER23667   5172 - 5173 
      ER23668   5174 - 5175   ER23669   5176 - 5180   ER23670   5181 - 5181 
      ER23671   5182 - 5186   ER23672   5187 - 5187   ER23673   5188 - 5192 
      ER23674   5193 - 5193   ER23675   5194 - 5195   ER23676   5196 - 5196 
      ER23677   5197 - 5198   ER23678   5199 - 5200   ER23679   5201 - 5205 
      ER23680   5206 - 5206   ER23681   5207 - 5211   ER23682   5212 - 5212 
      ER23683   5213 - 5217   ER23684   5218 - 5218   ER23685   5219 - 5219 
      ER23686   5220 - 5224   ER23687   5225 - 5225   ER23688   5226 - 5230 
      ER23689   5231 - 5231   ER23690   5232 - 5236   ER23691   5237 - 5237 
      ER23692   5238 - 5242   ER23693   5243 - 5243   ER23694   5244 - 5248 
      ER23695   5249 - 5249   ER23696   5250 - 5254   ER23697   5255 - 5255 
      ER23698   5256 - 5260   ER23699   5261 - 5262   ER23700   5263 - 5263 
      ER23701   5264 - 5265   ER23702   5266 - 5266   ER23703   5267 - 5267 
      ER23704   5268 - 5274   ER23705   5275 - 5275   ER23706   5276 - 5276 
      ER23707   5277 - 5277   ER23708   5278 - 5278   ER23709   5279 - 5279 
      ER23710   5280 - 5280   ER23711   5281 - 5281   ER23712   5282 - 5282 
      ER23713   5283 - 5283   ER23714   5284 - 5284   ER23715   5285 - 5285 
      ER23716   5286 - 5286   ER23717   5287 - 5287   ER23718   5288 - 5288 
      ER23719   5289 - 5289   ER23720   5290 - 5296   ER23721   5297 - 5297 
      ER23722   5298 - 5298   ER23723   5299 - 5299   ER23724   5300 - 5300 
      ER23725   5301 - 5301   ER23726   5302 - 5302   ER23727   5303 - 5303 
      ER23728   5304 - 5304   ER23729   5305 - 5305   ER23730   5306 - 5306 
      ER23731   5307 - 5307   ER23732   5308 - 5308   ER23733   5309 - 5309 
      ER23734   5310 - 5310   ER23735   5311 - 5317   ER23736   5318 - 5318 
      ER23737   5319 - 5319   ER23738   5320 - 5320   ER23739   5321 - 5321 
      ER23740   5322 - 5322   ER23741   5323 - 5323   ER23742   5324 - 5324 
      ER23743   5325 - 5325   ER23744   5326 - 5326   ER23745   5327 - 5327 
      ER23746   5328 - 5328   ER23747   5329 - 5329   ER23748   5330 - 5330 
      ER23749   5331 - 5331   ER23750   5332 - 5338   ER23751   5339 - 5339 
      ER23752   5340 - 5340   ER23753   5341 - 5341   ER23754   5342 - 5342 
      ER23755   5343 - 5343   ER23756   5344 - 5344   ER23757   5345 - 5345 
      ER23758   5346 - 5346   ER23759   5347 - 5347   ER23760   5348 - 5348 
      ER23761   5349 - 5349   ER23762   5350 - 5350   ER23763   5351 - 5351 
      ER23764   5352 - 5360   ER23765   5361 - 5361   ER23766   5362 - 5362 
      ER23767   5363 - 5363   ER23768   5364 - 5364   ER23769   5365 - 5365 
      ER23770   5366 - 5366   ER23771   5367 - 5367   ER23772   5368 - 5368 
      ER23773   5369 - 5369   ER23774   5370 - 5370   ER23775   5371 - 5371 
      ER23776   5372 - 5372   ER23777   5373 - 5373   ER23778   5374 - 5374 
      ER23779   5375 - 5375   ER23780   5376 - 5376   ER23781   5377 - 5377 
      ER23782   5378 - 5378   ER23783   5379 - 5379   ER23784   5380 - 5380 
      ER23785   5381 - 5381   ER23786   5382 - 5382   ER23787   5383 - 5383 
      ER23788   5384 - 5384   ER23789   5385 - 5385   ER23790   5386 - 5386 
      ER23791   5387 - 5387   ER23792   5388 - 5388   ER23793   5389 - 5389 
      ER23794   5390 - 5390   ER23795   5391 - 5391   ER23796   5392 - 5392 
      ER23797   5393 - 5393   ER23798   5394 - 5394   ER23799   5395 - 5395 
      ER23800   5396 - 5396   ER23801   5397 - 5397   ER23802   5398 - 5398 
      ER23803   5399 - 5399   ER23804   5400 - 5400   ER23805   5401 - 5401 
      ER23806   5402 - 5402   ER23807   5403 - 5403   ER23808   5404 - 5404 
      ER23809   5405 - 5405   ER23810   5406 - 5406   ER23811   5407 - 5407 
      ER23812   5408 - 5408   ER23813   5409 - 5409   ER23814   5410 - 5410 
      ER23815   5411 - 5411   ER23816   5412 - 5412   ER23817   5413 - 5413 
      ER23818   5414 - 5414   ER23819   5415 - 5415   ER23820   5416 - 5416 
      ER23821   5417 - 5417   ER23822   5418 - 5418   ER23823   5419 - 5419 
      ER23824   5420 - 5420   ER23825   5421 - 5421   ER23826   5422 - 5422 
      ER23827   5423 - 5423   ER23828   5424 - 5424   ER23829   5425 - 5425 
      ER23830   5426 - 5426   ER23831   5427 - 5427   ER23832   5428 - 5428 
      ER23833   5429 - 5429   ER23834   5430 - 5430   ER23835   5431 - 5431 
      ER23836   5432 - 5432   ER23837   5433 - 5433   ER23838   5434 - 5434 
      ER23839   5435 - 5435   ER23840   5436 - 5436   ER23841   5437 - 5437 
      ER23842   5438 - 5438   ER23843   5439 - 5439   ER23844   5440 - 5440 
      ER23845   5441 - 5441   ER23846   5442 - 5442   ER23847   5443 - 5443 
      ER23848   5444 - 5444   ER23849   5445 - 5445   ER23850   5446 - 5446 
      ER23851   5447 - 5447   ER23852   5448 - 5448   ER23853   5449 - 5449 
      ER23854   5450 - 5450   ER23855   5451 - 5451   ER23856   5452 - 5452 
      ER23857   5453 - 5453   ER23858   5454 - 5454   ER23859   5455 - 5455 
      ER23860   5456 - 5456   ER23861   5457 - 5457   ER23862   5458 - 5458 
      ER23863   5459 - 5459   ER23864   5460 - 5460   ER23865   5461 - 5461 
      ER23866   5462 - 5462   ER23867   5463 - 5463   ER23868   5464 - 5464 
      ER23869   5465 - 5465   ER23870   5466 - 5466   ER23871   5467 - 5467 
      ER23872   5468 - 5468   ER23873   5469 - 5469   ER23874   5470 - 5470 
      ER23875   5471 - 5471   ER23876   5472 - 5472   ER23877   5473 - 5473 
      ER23878   5474 - 5474   ER23879   5475 - 5475   ER23880   5476 - 5476 
      ER23881   5477 - 5477   ER23882   5478 - 5478   ER23883   5479 - 5479 
      ER23884   5480 - 5480   ER23885   5481 - 5481   ER23886   5482 - 5482 
      ER23887   5483 - 5483   ER23888   5484 - 5484   ER23889   5485 - 5485 
      ER23890   5486 - 5486   ER23891   5487 - 5487   ER23892   5488 - 5488 
      ER23893   5489 - 5489   ER23894   5490 - 5490   ER23895   5491 - 5491 
      ER23896   5492 - 5492   ER23897   5493 - 5493   ER23898   5494 - 5494 
      ER23899   5495 - 5495   ER23900   5496 - 5496   ER23901   5497 - 5497 
      ER23902   5498 - 5498   ER23903   5499 - 5499   ER23904   5500 - 5500 
      ER23905   5501 - 5501   ER23906   5502 - 5502   ER23907   5503 - 5503 
      ER23908   5504 - 5504   ER23909   5505 - 5505   ER23910   5506 - 5506 
      ER23911   5507 - 5507   ER23912   5508 - 5508   ER23913   5509 - 5509 
      ER23914   5510 - 5510   ER23915   5511 - 5511   ER23916   5512 - 5512 
      ER23917   5513 - 5513   ER23918   5514 - 5514   ER23919   5515 - 5515 
      ER23920   5516 - 5516   ER23921   5517 - 5517   ER23922   5518 - 5518 
      ER23923   5519 - 5519   ER23924   5520 - 5520   ER23925   5521 - 5521 
      ER23926   5522 - 5522   ER23927   5523 - 5523   ER23928   5524 - 5524 
      ER23929   5525 - 5525   ER23930   5526 - 5526   ER23931   5527 - 5527 
      ER23932   5528 - 5528   ER23933   5529 - 5529   ER23934   5530 - 5530 
      ER23935   5531 - 5531   ER23936   5532 - 5532   ER23937   5533 - 5533 
      ER23938   5534 - 5534   ER23939   5535 - 5535   ER23940   5536 - 5536 
      ER23941   5537 - 5537   ER23942   5538 - 5538   ER23943   5539 - 5539 
      ER23944   5540 - 5540   ER23945   5541 - 5541   ER23946   5542 - 5542 
      ER23947   5543 - 5543   ER23948   5544 - 5544   ER23949   5545 - 5545 
      ER23950   5546 - 5546   ER23951   5547 - 5547   ER23952   5548 - 5548 
      ER23953   5549 - 5549   ER23954   5550 - 5550   ER23955   5551 - 5551 
      ER23956   5552 - 5552   ER23957   5553 - 5553   ER23958   5554 - 5554 
      ER23959   5555 - 5555   ER23960   5556 - 5556   ER23961   5557 - 5557 
      ER23962   5558 - 5558   ER23963   5559 - 5559   ER23964   5560 - 5560 
      ER23965   5561 - 5561   ER23966   5562 - 5562   ER23967   5563 - 5563 
      ER23968   5564 - 5564   ER23969   5565 - 5565   ER23970   5566 - 5566 
      ER23971   5567 - 5567   ER23972   5568 - 5568   ER23973   5569 - 5569 
      ER23974   5570 - 5570   ER23975   5571 - 5571   ER23976   5572 - 5572 
      ER23977   5573 - 5573   ER23978   5574 - 5574   ER23979   5575 - 5575 
      ER23980   5576 - 5576   ER23981   5577 - 5577   ER23982   5578 - 5578 
      ER23983   5579 - 5579   ER23984   5580 - 5580   ER23985   5581 - 5581 
      ER23986   5582 - 5582   ER23987   5583 - 5583   ER23988   5584 - 5584 
      ER23989   5585 - 5585   ER23990   5586 - 5586   ER23991   5587 - 5587 
      ER23992   5588 - 5588   ER23993   5589 - 5589   ER23994   5590 - 5590 
      ER23995   5591 - 5591   ER23996   5592 - 5592   ER23997   5593 - 5593 
      ER23998   5594 - 5594   ER23999   5595 - 5595   ER24000   5596 - 5596 
      ER24001   5597 - 5597   ER24002   5598 - 5598   ER24003   5599 - 5599 
      ER24004   5600 - 5600   ER24005   5601 - 5601   ER24006   5602 - 5602 
      ER24007   5603 - 5603   ER24008   5604 - 5604   ER24009   5605 - 5605 
      ER24010   5606 - 5606   ER24011   5607 - 5607   ER24012   5608 - 5608 
      ER24013   5609 - 5609   ER24014   5610 - 5610   ER24015   5611 - 5611 
      ER24016   5612 - 5612   ER24017   5613 - 5613   ER24018   5614 - 5614 
      ER24019   5615 - 5615   ER24020   5616 - 5616   ER24021   5617 - 5617 
      ER24022   5618 - 5618   ER24023   5619 - 5619   ER24024   5620 - 5620 
      ER24025   5621 - 5621   ER24026   5622 - 5622   ER24027   5623 - 5623 
      ER24028   5624 - 5624   ER24029   5625 - 5625   ER24030   5626 - 5626 
      ER24031   5627 - 5627   ER24032   5628 - 5628   ER24033   5629 - 5629 
      ER24034   5630 - 5630   ER24035   5631 - 5631   ER24036   5632 - 5632 
      ER24037   5633 - 5633   ER24038   5634 - 5634   ER24039   5635 - 5635 
      ER24040   5636 - 5636   ER24041   5637 - 5637   ER24042   5638 - 5638 
      ER24043   5639 - 5639   ER24044   5640 - 5640   ER24045   5641 - 5641 
      ER24046   5642 - 5642   ER24047   5643 - 5643   ER24048   5644 - 5644 
      ER24049   5645 - 5645   ER24050   5646 - 5646   ER24051   5647 - 5647 
      ER24052   5648 - 5648   ER24053   5649 - 5649   ER24054   5650 - 5650 
      ER24055   5651 - 5651   ER24056   5652 - 5652   ER24057   5653 - 5653 
      ER24058   5654 - 5654   ER24059   5655 - 5655   ER24060   5656 - 5656 
      ER24061   5657 - 5657   ER24062   5658 - 5658   ER24063   5659 - 5659 
      ER24064   5660 - 5660   ER24065   5661 - 5661   ER24066   5662 - 5662 
      ER24067   5663 - 5663   ER24068   5664 - 5664   ER24069   5665 - 5665 
      ER24070   5666 - 5666   ER24071   5667 - 5667   ER24072   5668 - 5668 
      ER24073   5669 - 5669   ER24074   5670 - 5672   ER24075   5673 - 5673 
      ER24076   5674 - 5675   ER24077   5676 - 5679   ER24078   5680 - 5682 
      ER24079   5683 - 5686   ER24080   5687 - 5690   ER24081   5691 - 5694 
      ER24082   5695 - 5698   ER24083   5699 - 5702   ER24084   5703 - 5706 
      ER24085   5707 - 5710   ER24086   5711 - 5714   ER24087   5715 - 5718 
      ER24088   5719 - 5722   ER24089   5723 - 5725   ER24090   5726 - 5729 
      ER24091   5730 - 5733   ER24092   5734 - 5737   ER24093   5738 - 5741 
      ER24094   5742 - 5745   ER24095   5746 - 5749   ER24096   5750 - 5753 
      ER24097   5754 - 5757   ER24098   5758 - 5761   ER24099   5762 - 5768 
      ER24100   5769 - 5775   ER24101   5776 - 5782   ER24102   5783 - 5789 
      ER24103   5790 - 5795   ER24104   5796 - 5801   ER24105   5802 - 5807 
      ER24106   5808 - 5808   ER24107   5809 - 5815   ER24108   5816 - 5816 
      ER24109   5817 - 5822   ER24110   5823 - 5829   ER24111   5830 - 5835 
      ER24112   5836 - 5842   ER24113   5843 - 5843   ER24114   5844 - 5844 
      ER24115   5845 - 5845   ER24116   5846 - 5852   ER24117   5853 - 5859 
      ER24118   5860 - 5860   ER24119   5861 - 5866   ER24120   5867 - 5867 
      ER24121   5868 - 5873   ER24122   5874 - 5874   ER24123   5875 - 5880 
      ER24124   5881 - 5881   ER24125   5882 - 5887   ER24126   5888 - 5888 
      ER24127   5889 - 5895   ER24128   5896 - 5896   ER24129   5897 - 5903 
      ER24130   5904 - 5904   ER24131   5905 - 5911   ER24132   5912 - 5912 
      ER24133   5913 - 5918   ER24134   5919 - 5919   ER24135   5920 - 5926 
      ER24136   5927 - 5927   ER24137   5928 - 5933   ER24138   5934 - 5939 
      ER24139   5940 - 5944   ER24140   5945 - 5949   ER24141   5950 - 5954 
      ER24142   5955 - 5959   ER24143   5960 - 5960   ER24144   5961 - 5962 
      ER24145   5963 - 5963   ER24146   5964 - 5964   ER24147   5965 - 5965 
      ER24148   5966 - 5967   ER24149   5968 - 5969   ER24150   5970 - 5970 
      ER24151   5971 - 5971   ER24152   5972 - 5972   ER24153   5973 - 5976 
      ER24154   5977 - 5980   ER24155   5981 - 5981   ER24156   5982 - 5982 
      ER24157   5983 - 5987   ER24158   5988 - 5992   ER24159   5993 - 5993 
      ER24160   5994 - 5995   ER24161   5996 - 6000   ER24162   6001 - 6001 
      ER24163   6002 - 6003   ER24164   6004 - 6008   ER24165   6009 - 6009 
      ER24166   6010 - 6011   ER24167   6012 - 6016   ER24168   6017 - 6017 
      ER24169   6018 - 6019   ER24170   6020 - 6024   ER24171   6025 - 6025 
      ER24172   6026 - 6026   ER24173   6027 - 6027   ER24174   6028 - 6028 
      ER24175   6029 - 6029   ER24176   6030 - 6030   ER24177   6031 - 6031 
      ER24178   6032 - 6032   ER24179   6033 - 6038 
   ;
* Missing values statement.;

  IF ER21001 GE 8 OR ER21001 EQ 0 then ER21001=.;
  IF ER21002 GE 99997 OR ER21002 EQ 0 THEN ER21002=.;
  IF ER21003 GE 97 OR ER21003 EQ 0 THEN ER21003=.;
  IF ER21004 GE 97 OR ER21004 EQ 0 THEN ER21004=.;
  IF ER21005 GE 8 OR ER21005 EQ 0 then ER21005=.;
  IF ER21006 GE 8 OR ER21006 EQ 0 then ER21006=.;
  IF ER21007 GE 8 OR ER21007 EQ 0 then ER21007=.;
  IF ER21008 GE 8 OR ER21008 EQ 0 then ER21008=.;
  IF ER21009 GE 9997 OR ER21009 EQ 0 THEN ER21009=.;
  IF ER21010 GE 8 OR ER21010 EQ 0 then ER21010=.;
  IF ER21011 GE 99999997 OR ER21011 EQ 0 THEN ER21011=.;
  IF ER21012 GE 97 OR ER21012 EQ 0 THEN ER21012=.;
  IF ER21013 GE 97 OR ER21013 EQ 0 THEN ER21013=.;
  IF ER21014 GE 9997 OR ER21014 EQ 0 THEN ER21014=.;
  IF ER21015 GE 997 OR ER21015 EQ 0 THEN ER21015=.;
  IF ER21016 GE 97 OR ER21016 EQ 0 THEN ER21016=.;
  IF ER21017 GE 997 OR ER21017 EQ 0 THEN ER21017=.;
  IF ER21018 GE 8 OR ER21018 EQ 0 then ER21018=.;
  IF ER21019 GE 997 OR ER21019 EQ 0 THEN ER21019=.;
  IF ER21020 GE 97 OR ER21020 EQ 0 THEN ER21020=.;
  IF ER21021 GE 997 OR ER21021 EQ 0 THEN ER21021=.;
  IF ER21022 GE 97 OR ER21022 EQ 0 THEN ER21022=.;
  IF ER21023 GE 8 OR ER21023 EQ 0 then ER21023=.;
  IF ER21024 GE 8 OR ER21024 EQ 0 then ER21024=.;
  IF ER21025 GE 8 OR ER21025 EQ 0 then ER21025=.;
  IF ER21026 GE 8 OR ER21026 EQ 0 then ER21026=.;
  IF ER21027 GE 8 OR ER21027 EQ 0 then ER21027=.;
  IF ER21028 GE 8 OR ER21028 EQ 0 then ER21028=.;
  IF ER21029 GE 8 OR ER21029 EQ 0 then ER21029=.;
  IF ER21030 GE 8 OR ER21030 EQ 0 then ER21030=.;
  IF ER21031 GE 8 OR ER21031 EQ 0 then ER21031=.;
  IF ER21032 GE 8 OR ER21032 EQ 0 then ER21032=.;
  IF ER21033 GE 8 OR ER21033 EQ 0 then ER21033=.;
  IF ER21034 GE 8 OR ER21034 EQ 0 then ER21034=.;
  IF ER21035 GE 8 OR ER21035 EQ 0 then ER21035=.;
  IF ER21036 GE 97 OR ER21036 EQ 0 THEN ER21036=.;
  IF ER21037 GE 97 OR ER21037 EQ 0 THEN ER21037=.;
  IF ER21038 GE 97 OR ER21038 EQ 0 THEN ER21038=.;
  IF ER21039 GE 97 OR ER21039 EQ 0 THEN ER21039=.;
  IF ER21040 GE 8 OR ER21040 EQ 0 then ER21040=.;
  IF ER21041 GE 9997 OR ER21041 EQ 0 THEN ER21041=.;
  IF ER21042 GE 8 OR ER21042 EQ 0 then ER21042=.;
  IF ER21043 GE 9999997 OR ER21043 EQ 0 THEN ER21043=.;
  IF ER21044 GE 8 OR ER21044 EQ 0 then ER21044=.;
  IF ER21045 GE 99997 OR ER21045 EQ 0 THEN ER21045=.;
  IF ER21046 GE 8 OR ER21046 EQ 0 then ER21046=.;
  IF ER21047 GE 9997 OR ER21047 EQ 0 THEN ER21047=.;
  IF ER21048 GE 8 OR ER21048 EQ 0 then ER21048=.;
  IF ER21049 GE 8 OR ER21049 EQ 0 then ER21049=.;
  IF ER21050 GE 8 OR ER21050 EQ 0 then ER21050=.;
  IF ER21051 GE 9999997 OR ER21051 EQ 0 THEN ER21051=.;
  IF ER21052 GE 8 OR ER21052 EQ 0 then ER21052=.;
  IF ER21053 GE 99997 OR ER21053 EQ 0 THEN ER21053=.;
  IF ER21054 GE 8 OR ER21054 EQ 0 then ER21054=.;
  IF ER21055 GE 97 OR ER21055 EQ 0 THEN ER21055=.;
  IF ER21056 GE 997 OR ER21056 EQ 0 THEN ER21056=.;
  IF ER21057 GE 9997 OR ER21057 EQ 0 THEN ER21057=.;
  IF ER21058 GE 97 OR ER21058 EQ 0 THEN ER21058=.;
  IF ER21059 GE 8 OR ER21059 EQ 0 then ER21059=.;
  IF ER21060 GE 8 OR ER21060 EQ 0 then ER21060=.;
  IF ER21061 GE 8 OR ER21061 EQ 0 then ER21061=.;
  IF ER21062 GE 9999997 OR ER21062 EQ 0 THEN ER21062=.;
  IF ER21063 GE 8 OR ER21063 EQ 0 then ER21063=.;
  IF ER21064 GE 99997 OR ER21064 EQ 0 THEN ER21064=.;
  IF ER21065 GE 8 OR ER21065 EQ 0 then ER21065=.;
  IF ER21066 GE 97 OR ER21066 EQ 0 THEN ER21066=.;
  IF ER21067 GE 997 OR ER21067 EQ 0 THEN ER21067=.;
  IF ER21068 GE 9997 OR ER21068 EQ 0 THEN ER21068=.;
  IF ER21069 GE 97 OR ER21069 EQ 0 THEN ER21069=.;
  IF ER21070 GE 8 OR ER21070 EQ 0 then ER21070=.;
  IF ER21071 GE 8 OR ER21071 EQ 0 then ER21071=.;
  IF ER21072 GE 99997 OR ER21072 EQ 0 THEN ER21072=.;
  IF ER21073 GE 8 OR ER21073 EQ 0 then ER21073=.;
  IF ER21074 GE 8 OR ER21074 EQ 0 then ER21074=.;
  IF ER21075 GE 8 OR ER21075 EQ 0 then ER21075=.;
  IF ER21076 GE 8 OR ER21076 EQ 0 then ER21076=.;
  IF ER21077 GE 8 OR ER21077 EQ 0 then ER21077=.;
  IF ER21078 GE 8 OR ER21078 EQ 0 then ER21078=.;
  IF ER21079 GE 9997 OR ER21079 EQ 0 THEN ER21079=.;
  IF ER21080 GE 8 OR ER21080 EQ 0 then ER21080=.;
  IF ER21081 GE 8 OR ER21081 EQ 0 then ER21081=.;
  IF ER21082 GE 8 OR ER21082 EQ 0 then ER21082=.;
  IF ER21083 GE 8 OR ER21083 EQ 0 then ER21083=.;
  IF ER21084 GE 8 OR ER21084 EQ 0 then ER21084=.;
  IF ER21085 GE 8 OR ER21085 EQ 0 then ER21085=.;
  IF ER21086 GE 9997 OR ER21086 EQ 0 THEN ER21086=.;
  IF ER21087 GE 8 OR ER21087 EQ 0 then ER21087=.;
  IF ER21088 GE 9997 OR ER21088 EQ 0 THEN ER21088=.;
  IF ER21089 GE 8 OR ER21089 EQ 0 then ER21089=.;
  IF ER21090 GE 9997 OR ER21090 EQ 0 THEN ER21090=.;
  IF ER21091 GE 8 OR ER21091 EQ 0 then ER21091=.;
  IF ER21092 GE 8 OR ER21092 EQ 0 then ER21092=.;
  IF ER21093 GE 8 OR ER21093 EQ 0 then ER21093=.;
  IF ER21094 GE 8 OR ER21094 EQ 0 then ER21094=.;
  IF ER21095 GE 8 OR ER21095 EQ 0 then ER21095=.;
  IF ER21096 GE 8 OR ER21096 EQ 0 then ER21096=.;
  IF ER21097 GE 997 OR ER21097 EQ 0 THEN ER21097=.;
  IF ER21098 GE 8 OR ER21098 EQ 0 then ER21098=.;
  IF ER21099 GE 8 OR ER21099 EQ 0 then ER21099=.;
  IF ER21100 GE 8 OR ER21100 EQ 0 then ER21100=.;
  IF ER21101 GE 8 OR ER21101 EQ 0 then ER21101=.;
  IF ER21102 GE 8 OR ER21102 EQ 0 then ER21102=.;
  IF ER21103 GE 8 OR ER21103 EQ 0 then ER21103=.;
  IF ER21104 GE 8 OR ER21104 EQ 0 then ER21104=.;
  IF ER21105 GE 8 OR ER21105 EQ 0 then ER21105=.;
  IF ER21106 GE 8 OR ER21106 EQ 0 then ER21106=.;
  IF ER21107 GE 8 OR ER21107 EQ 0 then ER21107=.;
  IF ER21108 GE 8 OR ER21108 EQ 0 then ER21108=.;
  IF ER21109 GE 8 OR ER21109 EQ 0 then ER21109=.;
  IF ER21110 GE 8 OR ER21110 EQ 0 then ER21110=.;
  IF ER21111 GE 8 OR ER21111 EQ 0 then ER21111=.;
  IF ER21112 GE 8 OR ER21112 EQ 0 then ER21112=.;
  IF ER21113 GE 8 OR ER21113 EQ 0 then ER21113=.;
  IF ER21114 GE 8 OR ER21114 EQ 0 then ER21114=.;
  IF ER21115 GE 8 OR ER21115 EQ 0 then ER21115=.;
  IF ER21116 GE 8 OR ER21116 EQ 0 then ER21116=.;
  IF ER21117 GE 8 OR ER21117 EQ 0 then ER21117=.;
  IF ER21118 GE 97 OR ER21118 EQ 0 THEN ER21118=.;
  IF ER21119 GE 9997 OR ER21119 EQ 0 THEN ER21119=.;
  IF ER21120 GE 97 OR ER21120 EQ 0 THEN ER21120=.;
  IF ER21121 GE 8 OR ER21121 EQ 0 then ER21121=.;
  IF ER21122 GE 8 OR ER21122 EQ 0 then ER21122=.;
  IF ER21123 GE 97 OR ER21123 EQ 0 THEN ER21123=.;
  IF ER21124 GE 97 OR ER21124 EQ 0 THEN ER21124=.;
  IF ER21125 GE 97 OR ER21125 EQ 0 THEN ER21125=.;
  IF ER21126 GE 9997 OR ER21126 EQ 0 THEN ER21126=.;
  IF ER21127 GE 8 OR ER21127 EQ 0 then ER21127=.;
  IF ER21128 GE 8 OR ER21128 EQ 0 then ER21128=.;
  IF ER21129 GE 97 OR ER21129 EQ 0 THEN ER21129=.;
  IF ER21130 GE 9997 OR ER21130 EQ 0 THEN ER21130=.;
  IF ER21131 GE 97 OR ER21131 EQ 0 THEN ER21131=.;
  IF ER21132 GE 9997 OR ER21132 EQ 0 THEN ER21132=.;
  IF ER21133 GE 8 OR ER21133 EQ 0 then ER21133=.;
  IF ER21134 GE 8 OR ER21134 EQ 0 then ER21134=.;
  IF ER21135 GE 8 OR ER21135 EQ 0 then ER21135=.;
  IF ER21136 GE 8 OR ER21136 EQ 0 then ER21136=.;
  IF ER21137 GE 8 OR ER21137 EQ 0 then ER21137=.;
  IF ER21138 GE 8 OR ER21138 EQ 0 then ER21138=.;
  IF ER21139 GE 8 OR ER21139 EQ 0 then ER21139=.;
  IF ER21140 GE 8 OR ER21140 EQ 0 then ER21140=.;
  IF ER21141 GE 8 OR ER21141 EQ 0 then ER21141=.;
  IF ER21142 GE 8 OR ER21142 EQ 0 then ER21142=.;
  IF ER21143 GE 8 OR ER21143 EQ 0 then ER21143=.;
  IF ER21144 GE 8 OR ER21144 EQ 0 then ER21144=.;
  IF ER21145 GE 997 OR ER21145 EQ 0 THEN ER21145=.;
  IF ER21146 GE 997 OR ER21146 EQ 0 THEN ER21146=.;
  IF ER21147 GE 8 OR ER21147 EQ 0 then ER21147=.;
  IF ER21148 GE 8 OR ER21148 EQ 0 then ER21148=.;
  IF ER21149 GE 8 OR ER21149 EQ 0 then ER21149=.;
  IF ER21150 GE 8 OR ER21150 EQ 0 then ER21150=.;
  IF ER21151 GE 8 OR ER21151 EQ 0 then ER21151=.;
  IF ER21152 GE 8 OR ER21152 EQ 0 then ER21152=.;
  IF ER21153 GE 9999997 OR ER21153 EQ 0 THEN ER21153=.;
  IF ER21154 GE 8 OR ER21154 EQ 0 then ER21154=.;
  IF ER21155 GE 8 OR ER21155 EQ 0 then ER21155=.;
  IF ER21156 GE 8 OR ER21156 EQ 0 then ER21156=.;
  IF ER21157 GE 9999997 OR ER21157 EQ 0 THEN ER21157=.;
  IF ER21158 GE 8 OR ER21158 EQ 0 then ER21158=.;
  IF ER21159 GE 997 OR ER21159 EQ 0 THEN ER21159=.;
  IF ER21160 GE 8 OR ER21160 EQ 0 then ER21160=.;
  IF ER21161 GE 8 OR ER21161 EQ 0 then ER21161=.;
  IF ER21162 GE 8 OR ER21162 EQ 0 then ER21162=.;
  IF ER21163 GE 9999997 OR ER21163 EQ 0 THEN ER21163=.;
  IF ER21164 GE 8 OR ER21164 EQ 0 then ER21164=.;
  IF ER21165 GE 99997 OR ER21165 EQ 0 THEN ER21165=.;
  IF ER21166 GE 8 OR ER21166 EQ 0 then ER21166=.;
  IF ER21167 GE 999999997 OR ER21167 EQ 0 THEN ER21167=.;
  IF ER21168 GE 8 OR ER21168 EQ 0 then ER21168=.;
  IF ER21169 GE 8 OR ER21169 EQ 0 then ER21169=.;
  IF ER21170 GE 999997 OR ER21170 EQ 0 THEN ER21170=.;
  IF ER21171 GE 97 OR ER21171 EQ 0 THEN ER21171=.;
  IF ER21172 GE 97 OR ER21172 EQ 0 THEN ER21172=.;
  IF ER21173 GE 97 OR ER21173 EQ 0 THEN ER21173=.;
  IF ER21174 GE 97 OR ER21174 EQ 0 THEN ER21174=.;
  IF ER21175 GE 8 OR ER21175 EQ 0 then ER21175=.;
  IF ER21176 GE 997 OR ER21176 EQ 0 THEN ER21176=.;
  IF ER21177 GE 8 OR ER21177 EQ 0 then ER21177=.;
  IF ER21178 GE 8 OR ER21178 EQ 0 then ER21178=.;
  IF ER21179 GE 9997 OR ER21179 EQ 0 THEN ER21179=.;
  IF ER21180 GE 8 OR ER21180 EQ 0 then ER21180=.;
  IF ER21181 GE 8 OR ER21181 EQ 0 then ER21181=.;
  IF ER21182 GE 9999997 OR ER21182 EQ 0 THEN ER21182=.;
  IF ER21183 GE 8 OR ER21183 EQ 0 then ER21183=.;
  IF ER21184 GE 8 OR ER21184 EQ 0 then ER21184=.;
  IF ER21185 GE 97 OR ER21185 EQ 0 THEN ER21185=.;
  IF ER21186 GE 9997 OR ER21186 EQ 0 THEN ER21186=.;
  IF ER21187 GE 97 OR ER21187 EQ 0 THEN ER21187=.;
  IF ER21188 GE 9997 OR ER21188 EQ 0 THEN ER21188=.;
  IF ER21189 GE 8 OR ER21189 EQ 0 then ER21189=.;
  IF ER21190 GE 8 OR ER21190 EQ 0 then ER21190=.;
  IF ER21191 GE 8 OR ER21191 EQ 0 then ER21191=.;
  IF ER21192 GE 8 OR ER21192 EQ 0 then ER21192=.;
  IF ER21193 GE 8 OR ER21193 EQ 0 then ER21193=.;
  IF ER21194 GE 8 OR ER21194 EQ 0 then ER21194=.;
  IF ER21195 GE 8 OR ER21195 EQ 0 then ER21195=.;
  IF ER21196 GE 8 OR ER21196 EQ 0 then ER21196=.;
  IF ER21197 GE 8 OR ER21197 EQ 0 then ER21197=.;
  IF ER21198 GE 8 OR ER21198 EQ 0 then ER21198=.;
  IF ER21199 GE 8 OR ER21199 EQ 0 then ER21199=.;
  IF ER21200 GE 8 OR ER21200 EQ 0 then ER21200=.;
  IF ER21201 GE 997 OR ER21201 EQ 0 THEN ER21201=.;
  IF ER21202 GE 997 OR ER21202 EQ 0 THEN ER21202=.;
  IF ER21203 GE 8 OR ER21203 EQ 0 then ER21203=.;
  IF ER21204 GE 8 OR ER21204 EQ 0 then ER21204=.;
  IF ER21205 GE 8 OR ER21205 EQ 0 then ER21205=.;
  IF ER21206 GE 97 OR ER21206 EQ 0 THEN ER21206=.;
  IF ER21207 GE 8 OR ER21207 EQ 0 then ER21207=.;
  IF ER21208 GE 997 OR ER21208 EQ 0 THEN ER21208=.;
  IF ER21209 GE 8 OR ER21209 EQ 0 then ER21209=.;
  IF ER21210 GE 8 OR ER21210 EQ 0 then ER21210=.;
  IF ER21211 GE 9997 OR ER21211 EQ 0 THEN ER21211=.;
  IF ER21212 GE 8 OR ER21212 EQ 0 then ER21212=.;
  IF ER21213 GE 8 OR ER21213 EQ 0 then ER21213=.;
  IF ER21214 GE 9999997 OR ER21214 EQ 0 THEN ER21214=.;
  IF ER21215 GE 8 OR ER21215 EQ 0 then ER21215=.;
  IF ER21216 GE 8 OR ER21216 EQ 0 then ER21216=.;
  IF ER21217 GE 97 OR ER21217 EQ 0 THEN ER21217=.;
  IF ER21218 GE 9997 OR ER21218 EQ 0 THEN ER21218=.;
  IF ER21219 GE 97 OR ER21219 EQ 0 THEN ER21219=.;
  IF ER21220 GE 9997 OR ER21220 EQ 0 THEN ER21220=.;
  IF ER21221 GE 8 OR ER21221 EQ 0 then ER21221=.;
  IF ER21222 GE 8 OR ER21222 EQ 0 then ER21222=.;
  IF ER21223 GE 8 OR ER21223 EQ 0 then ER21223=.;
  IF ER21224 GE 8 OR ER21224 EQ 0 then ER21224=.;
  IF ER21225 GE 8 OR ER21225 EQ 0 then ER21225=.;
  IF ER21226 GE 8 OR ER21226 EQ 0 then ER21226=.;
  IF ER21227 GE 8 OR ER21227 EQ 0 then ER21227=.;
  IF ER21228 GE 8 OR ER21228 EQ 0 then ER21228=.;
  IF ER21229 GE 8 OR ER21229 EQ 0 then ER21229=.;
  IF ER21230 GE 8 OR ER21230 EQ 0 then ER21230=.;
  IF ER21231 GE 8 OR ER21231 EQ 0 then ER21231=.;
  IF ER21232 GE 8 OR ER21232 EQ 0 then ER21232=.;
  IF ER21233 GE 997 OR ER21233 EQ 0 THEN ER21233=.;
  IF ER21234 GE 997 OR ER21234 EQ 0 THEN ER21234=.;
  IF ER21235 GE 8 OR ER21235 EQ 0 then ER21235=.;
  IF ER21236 GE 8 OR ER21236 EQ 0 then ER21236=.;
  IF ER21237 GE 8 OR ER21237 EQ 0 then ER21237=.;
  IF ER21238 GE 97 OR ER21238 EQ 0 THEN ER21238=.;
  IF ER21239 GE 8 OR ER21239 EQ 0 then ER21239=.;
  IF ER21240 GE 997 OR ER21240 EQ 0 THEN ER21240=.;
  IF ER21241 GE 8 OR ER21241 EQ 0 then ER21241=.;
  IF ER21242 GE 8 OR ER21242 EQ 0 then ER21242=.;
  IF ER21243 GE 9997 OR ER21243 EQ 0 THEN ER21243=.;
  IF ER21244 GE 8 OR ER21244 EQ 0 then ER21244=.;
  IF ER21245 GE 8 OR ER21245 EQ 0 then ER21245=.;
  IF ER21246 GE 9999997 OR ER21246 EQ 0 THEN ER21246=.;
  IF ER21247 GE 8 OR ER21247 EQ 0 then ER21247=.;
  IF ER21248 GE 8 OR ER21248 EQ 0 then ER21248=.;
  IF ER21249 GE 97 OR ER21249 EQ 0 THEN ER21249=.;
  IF ER21250 GE 9997 OR ER21250 EQ 0 THEN ER21250=.;
  IF ER21251 GE 97 OR ER21251 EQ 0 THEN ER21251=.;
  IF ER21252 GE 9997 OR ER21252 EQ 0 THEN ER21252=.;
  IF ER21253 GE 8 OR ER21253 EQ 0 then ER21253=.;
  IF ER21254 GE 8 OR ER21254 EQ 0 then ER21254=.;
  IF ER21255 GE 8 OR ER21255 EQ 0 then ER21255=.;
  IF ER21256 GE 8 OR ER21256 EQ 0 then ER21256=.;
  IF ER21257 GE 8 OR ER21257 EQ 0 then ER21257=.;
  IF ER21258 GE 8 OR ER21258 EQ 0 then ER21258=.;
  IF ER21259 GE 8 OR ER21259 EQ 0 then ER21259=.;
  IF ER21260 GE 8 OR ER21260 EQ 0 then ER21260=.;
  IF ER21261 GE 8 OR ER21261 EQ 0 then ER21261=.;
  IF ER21262 GE 8 OR ER21262 EQ 0 then ER21262=.;
  IF ER21263 GE 8 OR ER21263 EQ 0 then ER21263=.;
  IF ER21264 GE 8 OR ER21264 EQ 0 then ER21264=.;
  IF ER21265 GE 997 OR ER21265 EQ 0 THEN ER21265=.;
  IF ER21266 GE 997 OR ER21266 EQ 0 THEN ER21266=.;
  IF ER21267 GE 8 OR ER21267 EQ 0 then ER21267=.;
  IF ER21268 GE 8 OR ER21268 EQ 0 then ER21268=.;
  IF ER21269 GE 8 OR ER21269 EQ 0 then ER21269=.;
  IF ER21270 GE 97 OR ER21270 EQ 0 THEN ER21270=.;
  IF ER21271 GE 8 OR ER21271 EQ 0 then ER21271=.;
  IF ER21272 GE 997 OR ER21272 EQ 0 THEN ER21272=.;
  IF ER21273 GE 8 OR ER21273 EQ 0 then ER21273=.;
  IF ER21274 GE 8 OR ER21274 EQ 0 then ER21274=.;
  IF ER21275 GE 9997 OR ER21275 EQ 0 THEN ER21275=.;
  IF ER21276 GE 8 OR ER21276 EQ 0 then ER21276=.;
  IF ER21277 GE 8 OR ER21277 EQ 0 then ER21277=.;
  IF ER21278 GE 9999997 OR ER21278 EQ 0 THEN ER21278=.;
  IF ER21279 GE 8 OR ER21279 EQ 0 then ER21279=.;
  IF ER21280 GE 8 OR ER21280 EQ 0 then ER21280=.;
  IF ER21281 GE 8 OR ER21281 EQ 0 then ER21281=.;
  IF ER21282 GE 8 OR ER21282 EQ 0 then ER21282=.;
  IF ER21283 GE 997 OR ER21283 EQ 0 THEN ER21283=.;
  IF ER21284 GE 8 OR ER21284 EQ 0 then ER21284=.;
  IF ER21285 GE 97 OR ER21285 EQ 0 THEN ER21285=.;
  IF ER21286 GE 8 OR ER21286 EQ 0 then ER21286=.;
  IF ER21287 GE 97 OR ER21287 EQ 0 THEN ER21287=.;
  IF ER21288 GE 8 OR ER21288 EQ 0 then ER21288=.;
  IF ER21289 GE 8 OR ER21289 EQ 0 then ER21289=.;
  IF ER21290 GE 997 OR ER21290 EQ 0 THEN ER21290=.;
  IF ER21291 GE 8 OR ER21291 EQ 0 then ER21291=.;
  IF ER21292 GE 97 OR ER21292 EQ 0 THEN ER21292=.;
  IF ER21293 GE 8 OR ER21293 EQ 0 then ER21293=.;
  IF ER21294 GE 97 OR ER21294 EQ 0 THEN ER21294=.;
  IF ER21295 GE 8 OR ER21295 EQ 0 then ER21295=.;
  IF ER21296 GE 8 OR ER21296 EQ 0 then ER21296=.;
  IF ER21297 GE 997 OR ER21297 EQ 0 THEN ER21297=.;
  IF ER21298 GE 8 OR ER21298 EQ 0 then ER21298=.;
  IF ER21299 GE 97 OR ER21299 EQ 0 THEN ER21299=.;
  IF ER21300 GE 8 OR ER21300 EQ 0 then ER21300=.;
  IF ER21301 GE 97 OR ER21301 EQ 0 THEN ER21301=.;
  IF ER21302 GE 8 OR ER21302 EQ 0 then ER21302=.;
  IF ER21303 GE 8 OR ER21303 EQ 0 then ER21303=.;
  IF ER21304 GE 997 OR ER21304 EQ 0 THEN ER21304=.;
  IF ER21305 GE 8 OR ER21305 EQ 0 then ER21305=.;
  IF ER21306 GE 97 OR ER21306 EQ 0 THEN ER21306=.;
  IF ER21307 GE 8 OR ER21307 EQ 0 then ER21307=.;
  IF ER21308 GE 97 OR ER21308 EQ 0 THEN ER21308=.;
  IF ER21309 GE 8 OR ER21309 EQ 0 then ER21309=.;
  IF ER21310 GE 8 OR ER21310 EQ 0 then ER21310=.;
  IF ER21311 GE 997 OR ER21311 EQ 0 THEN ER21311=.;
  IF ER21312 GE 8 OR ER21312 EQ 0 then ER21312=.;
  IF ER21313 GE 97 OR ER21313 EQ 0 THEN ER21313=.;
  IF ER21314 GE 8 OR ER21314 EQ 0 then ER21314=.;
  IF ER21315 GE 97 OR ER21315 EQ 0 THEN ER21315=.;
  IF ER21316 GE 8 OR ER21316 EQ 0 then ER21316=.;
  IF ER21317 GE 8 OR ER21317 EQ 0 then ER21317=.;
  IF ER21318 GE 997 OR ER21318 EQ 0 THEN ER21318=.;
  IF ER21319 GE 8 OR ER21319 EQ 0 then ER21319=.;
  IF ER21320 GE 97 OR ER21320 EQ 0 THEN ER21320=.;
  IF ER21321 GE 8 OR ER21321 EQ 0 then ER21321=.;
  IF ER21322 GE 97 OR ER21322 EQ 0 THEN ER21322=.;
  IF ER21323 GE 8 OR ER21323 EQ 0 then ER21323=.;
  IF ER21324 GE 8 OR ER21324 EQ 0 then ER21324=.;
  IF ER21325 GE 8 OR ER21325 EQ 0 then ER21325=.;
  IF ER21326 GE 8 OR ER21326 EQ 0 then ER21326=.;
  IF ER21327 GE 8 OR ER21327 EQ 0 then ER21327=.;
  IF ER21328 GE 8 OR ER21328 EQ 0 then ER21328=.;
  IF ER21329 GE 8 OR ER21329 EQ 0 then ER21329=.;
  IF ER21330 GE 8 OR ER21330 EQ 0 then ER21330=.;
  IF ER21331 GE 8 OR ER21331 EQ 0 then ER21331=.;
  IF ER21332 GE 8 OR ER21332 EQ 0 then ER21332=.;
  IF ER21333 GE 8 OR ER21333 EQ 0 then ER21333=.;
  IF ER21334 GE 8 OR ER21334 EQ 0 then ER21334=.;
  IF ER21335 GE 8 OR ER21335 EQ 0 then ER21335=.;
  IF ER21336 GE 8 OR ER21336 EQ 0 then ER21336=.;
  IF ER21337 GE 997 OR ER21337 EQ 0 THEN ER21337=.;
  IF ER21338 GE 8 OR ER21338 EQ 0 then ER21338=.;
  IF ER21339 GE 97 OR ER21339 EQ 0 THEN ER21339=.;
  IF ER21340 GE 8 OR ER21340 EQ 0 then ER21340=.;
  IF ER21341 GE 97 OR ER21341 EQ 0 THEN ER21341=.;
  IF ER21342 GE 8 OR ER21342 EQ 0 then ER21342=.;
  IF ER21343 GE 8 OR ER21343 EQ 0 then ER21343=.;
  IF ER21344 GE 8 OR ER21344 EQ 0 then ER21344=.;
  IF ER21345 GE 8 OR ER21345 EQ 0 then ER21345=.;
  IF ER21346 GE 8 OR ER21346 EQ 0 then ER21346=.;
  IF ER21347 GE 8 OR ER21347 EQ 0 then ER21347=.;
  IF ER21348 GE 8 OR ER21348 EQ 0 then ER21348=.;
  IF ER21349 GE 8 OR ER21349 EQ 0 then ER21349=.;
  IF ER21350 GE 8 OR ER21350 EQ 0 then ER21350=.;
  IF ER21351 GE 8 OR ER21351 EQ 0 then ER21351=.;
  IF ER21352 GE 8 OR ER21352 EQ 0 then ER21352=.;
  IF ER21353 GE 8 OR ER21353 EQ 0 then ER21353=.;
  IF ER21354 GE 8 OR ER21354 EQ 0 then ER21354=.;
  IF ER21355 GE 97 OR ER21355 EQ 0 THEN ER21355=.;
  IF ER21356 GE 997 OR ER21356 EQ 0 THEN ER21356=.;
  IF ER21357 GE 8 OR ER21357 EQ 0 then ER21357=.;
  IF ER21358 GE 97 OR ER21358 EQ 0 THEN ER21358=.;
  IF ER21359 GE 9997 OR ER21359 EQ 0 THEN ER21359=.;
  IF ER21360 GE 8 OR ER21360 EQ 0 then ER21360=.;
  IF ER21361 GE 8 OR ER21361 EQ 0 then ER21361=.;
  IF ER21362 GE 8 OR ER21362 EQ 0 then ER21362=.;
  IF ER21363 GE 8 OR ER21363 EQ 0 then ER21363=.;
  IF ER21364 GE 8 OR ER21364 EQ 0 then ER21364=.;
  IF ER21365 GE 8 OR ER21365 EQ 0 then ER21365=.;
  IF ER21366 GE 8 OR ER21366 EQ 0 then ER21366=.;
  IF ER21367 GE 8 OR ER21367 EQ 0 then ER21367=.;
  IF ER21368 GE 8 OR ER21368 EQ 0 then ER21368=.;
  IF ER21369 GE 97 OR ER21369 EQ 0 THEN ER21369=.;
  IF ER21370 GE 97 OR ER21370 EQ 0 THEN ER21370=.;
  IF ER21371 GE 97 OR ER21371 EQ 0 THEN ER21371=.;
  IF ER21372 GE 8 OR ER21372 EQ 0 then ER21372=.;
  IF ER21373 GE 97 OR ER21373 EQ 0 THEN ER21373=.;
  IF ER21374 GE 97 OR ER21374 EQ 0 THEN ER21374=.;
  IF ER21375 GE 97 OR ER21375 EQ 0 THEN ER21375=.;
  IF ER21376 GE 9997 OR ER21376 EQ 0 THEN ER21376=.;
  IF ER21377 GE 8 OR ER21377 EQ 0 then ER21377=.;
  IF ER21378 GE 8 OR ER21378 EQ 0 then ER21378=.;
  IF ER21379 GE 97 OR ER21379 EQ 0 THEN ER21379=.;
  IF ER21380 GE 9997 OR ER21380 EQ 0 THEN ER21380=.;
  IF ER21381 GE 97 OR ER21381 EQ 0 THEN ER21381=.;
  IF ER21382 GE 9997 OR ER21382 EQ 0 THEN ER21382=.;
  IF ER21383 GE 8 OR ER21383 EQ 0 then ER21383=.;
  IF ER21384 GE 8 OR ER21384 EQ 0 then ER21384=.;
  IF ER21385 GE 8 OR ER21385 EQ 0 then ER21385=.;
  IF ER21386 GE 8 OR ER21386 EQ 0 then ER21386=.;
  IF ER21387 GE 8 OR ER21387 EQ 0 then ER21387=.;
  IF ER21388 GE 8 OR ER21388 EQ 0 then ER21388=.;
  IF ER21389 GE 8 OR ER21389 EQ 0 then ER21389=.;
  IF ER21390 GE 8 OR ER21390 EQ 0 then ER21390=.;
  IF ER21391 GE 8 OR ER21391 EQ 0 then ER21391=.;
  IF ER21392 GE 8 OR ER21392 EQ 0 then ER21392=.;
  IF ER21393 GE 8 OR ER21393 EQ 0 then ER21393=.;
  IF ER21394 GE 8 OR ER21394 EQ 0 then ER21394=.;
  IF ER21395 GE 997 OR ER21395 EQ 0 THEN ER21395=.;
  IF ER21396 GE 997 OR ER21396 EQ 0 THEN ER21396=.;
  IF ER21397 GE 8 OR ER21397 EQ 0 then ER21397=.;
  IF ER21398 GE 8 OR ER21398 EQ 0 then ER21398=.;
  IF ER21399 GE 8 OR ER21399 EQ 0 then ER21399=.;
  IF ER21400 GE 8 OR ER21400 EQ 0 then ER21400=.;
  IF ER21401 GE 8 OR ER21401 EQ 0 then ER21401=.;
  IF ER21402 GE 8 OR ER21402 EQ 0 then ER21402=.;
  IF ER21403 GE 9999997 OR ER21403 EQ 0 THEN ER21403=.;
  IF ER21404 GE 8 OR ER21404 EQ 0 then ER21404=.;
  IF ER21405 GE 8 OR ER21405 EQ 0 then ER21405=.;
  IF ER21406 GE 8 OR ER21406 EQ 0 then ER21406=.;
  IF ER21407 GE 9999997 OR ER21407 EQ 0 THEN ER21407=.;
  IF ER21408 GE 8 OR ER21408 EQ 0 then ER21408=.;
  IF ER21409 GE 997 OR ER21409 EQ 0 THEN ER21409=.;
  IF ER21410 GE 8 OR ER21410 EQ 0 then ER21410=.;
  IF ER21411 GE 8 OR ER21411 EQ 0 then ER21411=.;
  IF ER21412 GE 8 OR ER21412 EQ 0 then ER21412=.;
  IF ER21413 GE 9999997 OR ER21413 EQ 0 THEN ER21413=.;
  IF ER21414 GE 8 OR ER21414 EQ 0 then ER21414=.;
  IF ER21415 GE 99997 OR ER21415 EQ 0 THEN ER21415=.;
  IF ER21416 GE 8 OR ER21416 EQ 0 then ER21416=.;
  IF ER21417 GE 999999997 OR ER21417 EQ 0 THEN ER21417=.;
  IF ER21418 GE 8 OR ER21418 EQ 0 then ER21418=.;
  IF ER21419 GE 8 OR ER21419 EQ 0 then ER21419=.;
  IF ER21420 GE 999997 OR ER21420 EQ 0 THEN ER21420=.;
  IF ER21421 GE 97 OR ER21421 EQ 0 THEN ER21421=.;
  IF ER21422 GE 97 OR ER21422 EQ 0 THEN ER21422=.;
  IF ER21423 GE 97 OR ER21423 EQ 0 THEN ER21423=.;
  IF ER21424 GE 97 OR ER21424 EQ 0 THEN ER21424=.;
  IF ER21425 GE 8 OR ER21425 EQ 0 then ER21425=.;
  IF ER21426 GE 997 OR ER21426 EQ 0 THEN ER21426=.;
  IF ER21427 GE 8 OR ER21427 EQ 0 then ER21427=.;
  IF ER21428 GE 8 OR ER21428 EQ 0 then ER21428=.;
  IF ER21429 GE 9997 OR ER21429 EQ 0 THEN ER21429=.;
  IF ER21430 GE 8 OR ER21430 EQ 0 then ER21430=.;
  IF ER21431 GE 8 OR ER21431 EQ 0 then ER21431=.;
  IF ER21432 GE 9999997 OR ER21432 EQ 0 THEN ER21432=.;
  IF ER21433 GE 8 OR ER21433 EQ 0 then ER21433=.;
  IF ER21434 GE 8 OR ER21434 EQ 0 then ER21434=.;
  IF ER21435 GE 97 OR ER21435 EQ 0 THEN ER21435=.;
  IF ER21436 GE 9997 OR ER21436 EQ 0 THEN ER21436=.;
  IF ER21437 GE 97 OR ER21437 EQ 0 THEN ER21437=.;
  IF ER21438 GE 9997 OR ER21438 EQ 0 THEN ER21438=.;
  IF ER21439 GE 8 OR ER21439 EQ 0 then ER21439=.;
  IF ER21440 GE 8 OR ER21440 EQ 0 then ER21440=.;
  IF ER21441 GE 8 OR ER21441 EQ 0 then ER21441=.;
  IF ER21442 GE 8 OR ER21442 EQ 0 then ER21442=.;
  IF ER21443 GE 8 OR ER21443 EQ 0 then ER21443=.;
  IF ER21444 GE 8 OR ER21444 EQ 0 then ER21444=.;
  IF ER21445 GE 8 OR ER21445 EQ 0 then ER21445=.;
  IF ER21446 GE 8 OR ER21446 EQ 0 then ER21446=.;
  IF ER21447 GE 8 OR ER21447 EQ 0 then ER21447=.;
  IF ER21448 GE 8 OR ER21448 EQ 0 then ER21448=.;
  IF ER21449 GE 8 OR ER21449 EQ 0 then ER21449=.;
  IF ER21450 GE 8 OR ER21450 EQ 0 then ER21450=.;
  IF ER21451 GE 997 OR ER21451 EQ 0 THEN ER21451=.;
  IF ER21452 GE 997 OR ER21452 EQ 0 THEN ER21452=.;
  IF ER21453 GE 8 OR ER21453 EQ 0 then ER21453=.;
  IF ER21454 GE 8 OR ER21454 EQ 0 then ER21454=.;
  IF ER21455 GE 8 OR ER21455 EQ 0 then ER21455=.;
  IF ER21456 GE 97 OR ER21456 EQ 0 THEN ER21456=.;
  IF ER21457 GE 8 OR ER21457 EQ 0 then ER21457=.;
  IF ER21458 GE 997 OR ER21458 EQ 0 THEN ER21458=.;
  IF ER21459 GE 8 OR ER21459 EQ 0 then ER21459=.;
  IF ER21460 GE 8 OR ER21460 EQ 0 then ER21460=.;
  IF ER21461 GE 9997 OR ER21461 EQ 0 THEN ER21461=.;
  IF ER21462 GE 8 OR ER21462 EQ 0 then ER21462=.;
  IF ER21463 GE 8 OR ER21463 EQ 0 then ER21463=.;
  IF ER21464 GE 9999997 OR ER21464 EQ 0 THEN ER21464=.;
  IF ER21465 GE 8 OR ER21465 EQ 0 then ER21465=.;
  IF ER21466 GE 8 OR ER21466 EQ 0 then ER21466=.;
  IF ER21467 GE 97 OR ER21467 EQ 0 THEN ER21467=.;
  IF ER21468 GE 9997 OR ER21468 EQ 0 THEN ER21468=.;
  IF ER21469 GE 97 OR ER21469 EQ 0 THEN ER21469=.;
  IF ER21470 GE 9997 OR ER21470 EQ 0 THEN ER21470=.;
  IF ER21471 GE 8 OR ER21471 EQ 0 then ER21471=.;
  IF ER21472 GE 8 OR ER21472 EQ 0 then ER21472=.;
  IF ER21473 GE 8 OR ER21473 EQ 0 then ER21473=.;
  IF ER21474 GE 8 OR ER21474 EQ 0 then ER21474=.;
  IF ER21475 GE 8 OR ER21475 EQ 0 then ER21475=.;
  IF ER21476 GE 8 OR ER21476 EQ 0 then ER21476=.;
  IF ER21477 GE 8 OR ER21477 EQ 0 then ER21477=.;
  IF ER21478 GE 8 OR ER21478 EQ 0 then ER21478=.;
  IF ER21479 GE 8 OR ER21479 EQ 0 then ER21479=.;
  IF ER21480 GE 8 OR ER21480 EQ 0 then ER21480=.;
  IF ER21481 GE 8 OR ER21481 EQ 0 then ER21481=.;
  IF ER21482 GE 8 OR ER21482 EQ 0 then ER21482=.;
  IF ER21483 GE 997 OR ER21483 EQ 0 THEN ER21483=.;
  IF ER21484 GE 997 OR ER21484 EQ 0 THEN ER21484=.;
  IF ER21485 GE 8 OR ER21485 EQ 0 then ER21485=.;
  IF ER21486 GE 8 OR ER21486 EQ 0 then ER21486=.;
  IF ER21487 GE 8 OR ER21487 EQ 0 then ER21487=.;
  IF ER21488 GE 97 OR ER21488 EQ 0 THEN ER21488=.;
  IF ER21489 GE 8 OR ER21489 EQ 0 then ER21489=.;
  IF ER21490 GE 997 OR ER21490 EQ 0 THEN ER21490=.;
  IF ER21491 GE 8 OR ER21491 EQ 0 then ER21491=.;
  IF ER21492 GE 8 OR ER21492 EQ 0 then ER21492=.;
  IF ER21493 GE 9997 OR ER21493 EQ 0 THEN ER21493=.;
  IF ER21494 GE 8 OR ER21494 EQ 0 then ER21494=.;
  IF ER21495 GE 8 OR ER21495 EQ 0 then ER21495=.;
  IF ER21496 GE 9999997 OR ER21496 EQ 0 THEN ER21496=.;
  IF ER21497 GE 8 OR ER21497 EQ 0 then ER21497=.;
  IF ER21498 GE 8 OR ER21498 EQ 0 then ER21498=.;
  IF ER21499 GE 97 OR ER21499 EQ 0 THEN ER21499=.;
  IF ER21500 GE 9997 OR ER21500 EQ 0 THEN ER21500=.;
  IF ER21501 GE 97 OR ER21501 EQ 0 THEN ER21501=.;
  IF ER21502 GE 9997 OR ER21502 EQ 0 THEN ER21502=.;
  IF ER21503 GE 8 OR ER21503 EQ 0 then ER21503=.;
  IF ER21504 GE 8 OR ER21504 EQ 0 then ER21504=.;
  IF ER21505 GE 8 OR ER21505 EQ 0 then ER21505=.;
  IF ER21506 GE 8 OR ER21506 EQ 0 then ER21506=.;
  IF ER21507 GE 8 OR ER21507 EQ 0 then ER21507=.;
  IF ER21508 GE 8 OR ER21508 EQ 0 then ER21508=.;
  IF ER21509 GE 8 OR ER21509 EQ 0 then ER21509=.;
  IF ER21510 GE 8 OR ER21510 EQ 0 then ER21510=.;
  IF ER21511 GE 8 OR ER21511 EQ 0 then ER21511=.;
  IF ER21512 GE 8 OR ER21512 EQ 0 then ER21512=.;
  IF ER21513 GE 8 OR ER21513 EQ 0 then ER21513=.;
  IF ER21514 GE 8 OR ER21514 EQ 0 then ER21514=.;
  IF ER21515 GE 997 OR ER21515 EQ 0 THEN ER21515=.;
  IF ER21516 GE 997 OR ER21516 EQ 0 THEN ER21516=.;
  IF ER21517 GE 8 OR ER21517 EQ 0 then ER21517=.;
  IF ER21518 GE 8 OR ER21518 EQ 0 then ER21518=.;
  IF ER21519 GE 8 OR ER21519 EQ 0 then ER21519=.;
  IF ER21520 GE 97 OR ER21520 EQ 0 THEN ER21520=.;
  IF ER21521 GE 8 OR ER21521 EQ 0 then ER21521=.;
  IF ER21522 GE 997 OR ER21522 EQ 0 THEN ER21522=.;
  IF ER21523 GE 8 OR ER21523 EQ 0 then ER21523=.;
  IF ER21524 GE 8 OR ER21524 EQ 0 then ER21524=.;
  IF ER21525 GE 9997 OR ER21525 EQ 0 THEN ER21525=.;
  IF ER21526 GE 8 OR ER21526 EQ 0 then ER21526=.;
  IF ER21527 GE 8 OR ER21527 EQ 0 then ER21527=.;
  IF ER21528 GE 9999997 OR ER21528 EQ 0 THEN ER21528=.;
  IF ER21529 GE 8 OR ER21529 EQ 0 then ER21529=.;
  IF ER21530 GE 8 OR ER21530 EQ 0 then ER21530=.;
  IF ER21531 GE 8 OR ER21531 EQ 0 then ER21531=.;
  IF ER21532 GE 8 OR ER21532 EQ 0 then ER21532=.;
  IF ER21533 GE 997 OR ER21533 EQ 0 THEN ER21533=.;
  IF ER21534 GE 8 OR ER21534 EQ 0 then ER21534=.;
  IF ER21535 GE 97 OR ER21535 EQ 0 THEN ER21535=.;
  IF ER21536 GE 8 OR ER21536 EQ 0 then ER21536=.;
  IF ER21537 GE 97 OR ER21537 EQ 0 THEN ER21537=.;
  IF ER21538 GE 8 OR ER21538 EQ 0 then ER21538=.;
  IF ER21539 GE 8 OR ER21539 EQ 0 then ER21539=.;
  IF ER21540 GE 997 OR ER21540 EQ 0 THEN ER21540=.;
  IF ER21541 GE 8 OR ER21541 EQ 0 then ER21541=.;
  IF ER21542 GE 97 OR ER21542 EQ 0 THEN ER21542=.;
  IF ER21543 GE 8 OR ER21543 EQ 0 then ER21543=.;
  IF ER21544 GE 97 OR ER21544 EQ 0 THEN ER21544=.;
  IF ER21545 GE 8 OR ER21545 EQ 0 then ER21545=.;
  IF ER21546 GE 8 OR ER21546 EQ 0 then ER21546=.;
  IF ER21547 GE 997 OR ER21547 EQ 0 THEN ER21547=.;
  IF ER21548 GE 8 OR ER21548 EQ 0 then ER21548=.;
  IF ER21549 GE 97 OR ER21549 EQ 0 THEN ER21549=.;
  IF ER21550 GE 8 OR ER21550 EQ 0 then ER21550=.;
  IF ER21551 GE 97 OR ER21551 EQ 0 THEN ER21551=.;
  IF ER21552 GE 8 OR ER21552 EQ 0 then ER21552=.;
  IF ER21553 GE 8 OR ER21553 EQ 0 then ER21553=.;
  IF ER21554 GE 997 OR ER21554 EQ 0 THEN ER21554=.;
  IF ER21555 GE 8 OR ER21555 EQ 0 then ER21555=.;
  IF ER21556 GE 97 OR ER21556 EQ 0 THEN ER21556=.;
  IF ER21557 GE 8 OR ER21557 EQ 0 then ER21557=.;
  IF ER21558 GE 97 OR ER21558 EQ 0 THEN ER21558=.;
  IF ER21559 GE 8 OR ER21559 EQ 0 then ER21559=.;
  IF ER21560 GE 8 OR ER21560 EQ 0 then ER21560=.;
  IF ER21561 GE 997 OR ER21561 EQ 0 THEN ER21561=.;
  IF ER21562 GE 8 OR ER21562 EQ 0 then ER21562=.;
  IF ER21563 GE 97 OR ER21563 EQ 0 THEN ER21563=.;
  IF ER21564 GE 8 OR ER21564 EQ 0 then ER21564=.;
  IF ER21565 GE 97 OR ER21565 EQ 0 THEN ER21565=.;
  IF ER21566 GE 8 OR ER21566 EQ 0 then ER21566=.;
  IF ER21567 GE 8 OR ER21567 EQ 0 then ER21567=.;
  IF ER21568 GE 997 OR ER21568 EQ 0 THEN ER21568=.;
  IF ER21569 GE 8 OR ER21569 EQ 0 then ER21569=.;
  IF ER21570 GE 97 OR ER21570 EQ 0 THEN ER21570=.;
  IF ER21571 GE 8 OR ER21571 EQ 0 then ER21571=.;
  IF ER21572 GE 97 OR ER21572 EQ 0 THEN ER21572=.;
  IF ER21573 GE 8 OR ER21573 EQ 0 then ER21573=.;
  IF ER21574 GE 8 OR ER21574 EQ 0 then ER21574=.;
  IF ER21575 GE 8 OR ER21575 EQ 0 then ER21575=.;
  IF ER21576 GE 8 OR ER21576 EQ 0 then ER21576=.;
  IF ER21577 GE 8 OR ER21577 EQ 0 then ER21577=.;
  IF ER21578 GE 8 OR ER21578 EQ 0 then ER21578=.;
  IF ER21579 GE 8 OR ER21579 EQ 0 then ER21579=.;
  IF ER21580 GE 8 OR ER21580 EQ 0 then ER21580=.;
  IF ER21581 GE 8 OR ER21581 EQ 0 then ER21581=.;
  IF ER21582 GE 8 OR ER21582 EQ 0 then ER21582=.;
  IF ER21583 GE 8 OR ER21583 EQ 0 then ER21583=.;
  IF ER21584 GE 8 OR ER21584 EQ 0 then ER21584=.;
  IF ER21585 GE 8 OR ER21585 EQ 0 then ER21585=.;
  IF ER21586 GE 8 OR ER21586 EQ 0 then ER21586=.;
  IF ER21587 GE 997 OR ER21587 EQ 0 THEN ER21587=.;
  IF ER21588 GE 8 OR ER21588 EQ 0 then ER21588=.;
  IF ER21589 GE 97 OR ER21589 EQ 0 THEN ER21589=.;
  IF ER21590 GE 8 OR ER21590 EQ 0 then ER21590=.;
  IF ER21591 GE 97 OR ER21591 EQ 0 THEN ER21591=.;
  IF ER21592 GE 8 OR ER21592 EQ 0 then ER21592=.;
  IF ER21593 GE 8 OR ER21593 EQ 0 then ER21593=.;
  IF ER21594 GE 8 OR ER21594 EQ 0 then ER21594=.;
  IF ER21595 GE 8 OR ER21595 EQ 0 then ER21595=.;
  IF ER21596 GE 8 OR ER21596 EQ 0 then ER21596=.;
  IF ER21597 GE 8 OR ER21597 EQ 0 then ER21597=.;
  IF ER21598 GE 8 OR ER21598 EQ 0 then ER21598=.;
  IF ER21599 GE 8 OR ER21599 EQ 0 then ER21599=.;
  IF ER21600 GE 8 OR ER21600 EQ 0 then ER21600=.;
  IF ER21601 GE 8 OR ER21601 EQ 0 then ER21601=.;
  IF ER21602 GE 8 OR ER21602 EQ 0 then ER21602=.;
  IF ER21603 GE 8 OR ER21603 EQ 0 then ER21603=.;
  IF ER21604 GE 8 OR ER21604 EQ 0 then ER21604=.;
  IF ER21605 GE 97 OR ER21605 EQ 0 THEN ER21605=.;
  IF ER21606 GE 997 OR ER21606 EQ 0 THEN ER21606=.;
  IF ER21607 GE 8 OR ER21607 EQ 0 then ER21607=.;
  IF ER21608 GE 97 OR ER21608 EQ 0 THEN ER21608=.;
  IF ER21609 GE 9997 OR ER21609 EQ 0 THEN ER21609=.;
  IF ER21610 GE 8 OR ER21610 EQ 0 then ER21610=.;
  IF ER21611 GE 8 OR ER21611 EQ 0 then ER21611=.;
  IF ER21612 GE 8 OR ER21612 EQ 0 then ER21612=.;
  IF ER21613 GE 8 OR ER21613 EQ 0 then ER21613=.;
  IF ER21614 GE 8 OR ER21614 EQ 0 then ER21614=.;
  IF ER21615 GE 8 OR ER21615 EQ 0 then ER21615=.;
  IF ER21616 GE 8 OR ER21616 EQ 0 then ER21616=.;
  IF ER21617 GE 8 OR ER21617 EQ 0 then ER21617=.;
  IF ER21618 GE 8 OR ER21618 EQ 0 then ER21618=.;
  IF ER21619 GE 97 OR ER21619 EQ 0 THEN ER21619=.;
  IF ER21620 GE 97 OR ER21620 EQ 0 THEN ER21620=.;
  IF ER21621 GE 97 OR ER21621 EQ 0 THEN ER21621=.;
  IF ER21622 GE 8 OR ER21622 EQ 0 then ER21622=.;
  IF ER21623 GE 997 OR ER21623 EQ 0 THEN ER21623=.;
  IF ER21624 GE 8 OR ER21624 EQ 0 then ER21624=.;
  IF ER21625 GE 997 OR ER21625 EQ 0 THEN ER21625=.;
  IF ER21626 GE 8 OR ER21626 EQ 0 then ER21626=.;
  IF ER21627 GE 8 OR ER21627 EQ 0 then ER21627=.;
  IF ER21628 GE 999997 OR ER21628 EQ 0 THEN ER21628=.;
  IF ER21629 GE 8 OR ER21629 EQ 0 then ER21629=.;
  IF ER21630 GE 8 OR ER21630 EQ 0 then ER21630=.;
  IF ER21631 GE 8 OR ER21631 EQ 0 then ER21631=.;
  IF ER21632 GE 8 OR ER21632 EQ 0 then ER21632=.;
  IF ER21633 GE 8 OR ER21633 EQ 0 then ER21633=.;
  IF ER21634 GE 8 OR ER21634 EQ 0 then ER21634=.;
  IF ER21635 GE 999997 OR ER21635 EQ 0 THEN ER21635=.;
  IF ER21636 GE 8 OR ER21636 EQ 0 then ER21636=.;
  IF ER21637 GE 999997 OR ER21637 EQ 0 THEN ER21637=.;
  IF ER21638 GE 8 OR ER21638 EQ 0 then ER21638=.;
  IF ER21639 GE 8 OR ER21639 EQ 0 then ER21639=.;
  IF ER21640 GE 8 OR ER21640 EQ 0 then ER21640=.;
  IF ER21641 GE 8 OR ER21641 EQ 0 then ER21641=.;
  IF ER21642 GE 8 OR ER21642 EQ 0 then ER21642=.;
  IF ER21643 GE 8 OR ER21643 EQ 0 then ER21643=.;
  IF ER21644 GE 8 OR ER21644 EQ 0 then ER21644=.;
  IF ER21645 GE 8 OR ER21645 EQ 0 then ER21645=.;
  IF ER21646 GE 8 OR ER21646 EQ 0 then ER21646=.;
  IF ER21647 GE 8 OR ER21647 EQ 0 then ER21647=.;
  IF ER21648 GE 8 OR ER21648 EQ 0 then ER21648=.;
  IF ER21649 GE 8 OR ER21649 EQ 0 then ER21649=.;
  IF ER21650 GE 8 OR ER21650 EQ 0 then ER21650=.;
  IF ER21651 GE 8 OR ER21651 EQ 0 then ER21651=.;
  IF ER21652 GE 8 OR ER21652 EQ 0 then ER21652=.;
  IF ER21653 GE 999997 OR ER21653 EQ 0 THEN ER21653=.;
  IF ER21654 GE 8 OR ER21654 EQ 0 then ER21654=.;
  IF ER21655 GE 8 OR ER21655 EQ 0 then ER21655=.;
  IF ER21656 GE 8 OR ER21656 EQ 0 then ER21656=.;
  IF ER21657 GE 8 OR ER21657 EQ 0 then ER21657=.;
  IF ER21658 GE 8 OR ER21658 EQ 0 then ER21658=.;
  IF ER21659 GE 8 OR ER21659 EQ 0 then ER21659=.;
  IF ER21660 GE 8 OR ER21660 EQ 0 then ER21660=.;
  IF ER21661 GE 8 OR ER21661 EQ 0 then ER21661=.;
  IF ER21662 GE 8 OR ER21662 EQ 0 then ER21662=.;
  IF ER21663 GE 8 OR ER21663 EQ 0 then ER21663=.;
  IF ER21664 GE 8 OR ER21664 EQ 0 then ER21664=.;
  IF ER21665 GE 8 OR ER21665 EQ 0 then ER21665=.;
  IF ER21666 GE 8 OR ER21666 EQ 0 then ER21666=.;
  IF ER21667 GE 8 OR ER21667 EQ 0 then ER21667=.;
  IF ER21668 GE 8 OR ER21668 EQ 0 then ER21668=.;
  IF ER21669 GE 8 OR ER21669 EQ 0 then ER21669=.;
  IF ER21670 GE 8 OR ER21670 EQ 0 then ER21670=.;
  IF ER21671 GE 8 OR ER21671 EQ 0 then ER21671=.;
  IF ER21672 GE 8 OR ER21672 EQ 0 then ER21672=.;
  IF ER21673 GE 8 OR ER21673 EQ 0 then ER21673=.;
  IF ER21674 GE 8 OR ER21674 EQ 0 then ER21674=.;
  IF ER21675 GE 8 OR ER21675 EQ 0 then ER21675=.;
  IF ER21676 GE 8 OR ER21676 EQ 0 then ER21676=.;
  IF ER21677 GE 8 OR ER21677 EQ 0 then ER21677=.;
  IF ER21678 GE 8 OR ER21678 EQ 0 then ER21678=.;
  IF ER21679 GE 8 OR ER21679 EQ 0 then ER21679=.;
  IF ER21680 GE 8 OR ER21680 EQ 0 then ER21680=.;
  IF ER21681 GE 8 OR ER21681 EQ 0 then ER21681=.;
  IF ER21682 GE 999997 OR ER21682 EQ 0 THEN ER21682=.;
  IF ER21683 GE 8 OR ER21683 EQ 0 then ER21683=.;
  IF ER21684 GE 8 OR ER21684 EQ 0 then ER21684=.;
  IF ER21685 GE 8 OR ER21685 EQ 0 then ER21685=.;
  IF ER21686 GE 99997 OR ER21686 EQ 0 THEN ER21686=.;
  IF ER21687 GE 8 OR ER21687 EQ 0 then ER21687=.;
  IF ER21688 GE 8 OR ER21688 EQ 0 then ER21688=.;
  IF ER21689 GE 8 OR ER21689 EQ 0 then ER21689=.;
  IF ER21690 GE 99997 OR ER21690 EQ 0 THEN ER21690=.;
  IF ER21691 GE 8 OR ER21691 EQ 0 then ER21691=.;
  IF ER21692 GE 8 OR ER21692 EQ 0 then ER21692=.;
  IF ER21693 GE 99997 OR ER21693 EQ 0 THEN ER21693=.;
  IF ER21694 GE 8 OR ER21694 EQ 0 then ER21694=.;
  IF ER21695 GE 8 OR ER21695 EQ 0 then ER21695=.;
  IF ER21696 GE 99997 OR ER21696 EQ 0 THEN ER21696=.;
  IF ER21697 GE 8 OR ER21697 EQ 0 then ER21697=.;
  IF ER21698 GE 8 OR ER21698 EQ 0 then ER21698=.;
  IF ER21699 GE 8 OR ER21699 EQ 0 then ER21699=.;
  IF ER21700 GE 99997 OR ER21700 EQ 0 THEN ER21700=.;
  IF ER21701 GE 8 OR ER21701 EQ 0 then ER21701=.;
  IF ER21702 GE 8 OR ER21702 EQ 0 then ER21702=.;
  IF ER21703 GE 99997 OR ER21703 EQ 0 THEN ER21703=.;
  IF ER21704 GE 8 OR ER21704 EQ 0 then ER21704=.;
  IF ER21705 GE 8 OR ER21705 EQ 0 then ER21705=.;
  IF ER21706 GE 8 OR ER21706 EQ 0 then ER21706=.;
  IF ER21707 GE 8 OR ER21707 EQ 0 then ER21707=.;
  IF ER21708 GE 8 OR ER21708 EQ 0 then ER21708=.;
  IF ER21709 GE 8 OR ER21709 EQ 0 then ER21709=.;
  IF ER21710 GE 8 OR ER21710 EQ 0 then ER21710=.;
  IF ER21711 GE 8 OR ER21711 EQ 0 then ER21711=.;
  IF ER21712 GE 8 OR ER21712 EQ 0 then ER21712=.;
  IF ER21713 GE 8 OR ER21713 EQ 0 then ER21713=.;
  IF ER21714 GE 8 OR ER21714 EQ 0 then ER21714=.;
  IF ER21715 GE 8 OR ER21715 EQ 0 then ER21715=.;
  IF ER21716 GE 8 OR ER21716 EQ 0 then ER21716=.;
  IF ER21717 GE 8 OR ER21717 EQ 0 then ER21717=.;
  IF ER21718 GE 8 OR ER21718 EQ 0 then ER21718=.;
  IF ER21719 GE 8 OR ER21719 EQ 0 then ER21719=.;
  IF ER21720 GE 8 OR ER21720 EQ 0 then ER21720=.;
  IF ER21721 GE 8 OR ER21721 EQ 0 then ER21721=.;
  IF ER21722 GE 8 OR ER21722 EQ 0 then ER21722=.;
  IF ER21723 GE 8 OR ER21723 EQ 0 then ER21723=.;
  IF ER21724 GE 8 OR ER21724 EQ 0 then ER21724=.;
  IF ER21725 GE 8 OR ER21725 EQ 0 then ER21725=.;
  IF ER21726 GE 8 OR ER21726 EQ 0 then ER21726=.;
  IF ER21727 GE 8 OR ER21727 EQ 0 then ER21727=.;
  IF ER21728 GE 8 OR ER21728 EQ 0 then ER21728=.;
  IF ER21729 GE 8 OR ER21729 EQ 0 then ER21729=.;
  IF ER21730 GE 8 OR ER21730 EQ 0 then ER21730=.;
  IF ER21731 GE 8 OR ER21731 EQ 0 then ER21731=.;
  IF ER21732 GE 8 OR ER21732 EQ 0 then ER21732=.;
  IF ER21733 GE 8 OR ER21733 EQ 0 then ER21733=.;
  IF ER21734 GE 8 OR ER21734 EQ 0 then ER21734=.;
  IF ER21735 GE 8 OR ER21735 EQ 0 then ER21735=.;
  IF ER21736 GE 8 OR ER21736 EQ 0 then ER21736=.;
  IF ER21737 GE 8 OR ER21737 EQ 0 then ER21737=.;
  IF ER21738 GE 8 OR ER21738 EQ 0 then ER21738=.;
  IF ER21739 GE 8 OR ER21739 EQ 0 then ER21739=.;
  IF ER21740 GE 8 OR ER21740 EQ 0 then ER21740=.;
  IF ER21741 GE 8 OR ER21741 EQ 0 then ER21741=.;
  IF ER21742 GE 8 OR ER21742 EQ 0 then ER21742=.;
  IF ER21743 GE 8 OR ER21743 EQ 0 then ER21743=.;
  IF ER21744 GE 8 OR ER21744 EQ 0 then ER21744=.;
  IF ER21745 GE 8 OR ER21745 EQ 0 then ER21745=.;
  IF ER21746 GE 8 OR ER21746 EQ 0 then ER21746=.;
  IF ER21747 GE 8 OR ER21747 EQ 0 then ER21747=.;
  IF ER21748 GE 8 OR ER21748 EQ 0 then ER21748=.;
  IF ER21749 GE 8 OR ER21749 EQ 0 then ER21749=.;
  IF ER21750 GE 97 OR ER21750 EQ 0 THEN ER21750=.;
  IF ER21751 GE 97 OR ER21751 EQ 0 THEN ER21751=.;
  IF ER21752 GE 97 OR ER21752 EQ 0 THEN ER21752=.;
  IF ER21753 GE 9997 OR ER21753 EQ 0 THEN ER21753=.;
  IF ER21754 GE 8 OR ER21754 EQ 0 then ER21754=.;
  IF ER21755 GE 8 OR ER21755 EQ 0 then ER21755=.;
  IF ER21756 GE 97 OR ER21756 EQ 0 THEN ER21756=.;
  IF ER21757 GE 8 OR ER21757 EQ 0 then ER21757=.;
  IF ER21758 GE 8 OR ER21758 EQ 0 then ER21758=.;
  IF ER21759 GE 9997 OR ER21759 EQ 0 THEN ER21759=.;
  IF ER21760 GE 97 OR ER21760 EQ 0 THEN ER21760=.;
  IF ER21761 GE 8 OR ER21761 EQ 0 then ER21761=.;
  IF ER21762 GE 8 OR ER21762 EQ 0 then ER21762=.;
  IF ER21763 GE 8 OR ER21763 EQ 0 then ER21763=.;
  IF ER21764 GE 8 OR ER21764 EQ 0 then ER21764=.;
  IF ER21765 GE 999997 OR ER21765 EQ 0 THEN ER21765=.;
  IF ER21766 GE 8 OR ER21766 EQ 0 then ER21766=.;
  IF ER21767 GE 999997 OR ER21767 EQ 0 THEN ER21767=.;
  IF ER21768 GE 999997 OR ER21768 EQ 0 THEN ER21768=.;
  IF ER21769 GE 8 OR ER21769 EQ 0 then ER21769=.;
  IF ER21770 GE 999997 OR ER21770 EQ 0 THEN ER21770=.;
  IF ER21771 GE 999997 OR ER21771 EQ 0 THEN ER21771=.;
  IF ER21772 GE 8 OR ER21772 EQ 0 then ER21772=.;
  IF ER21773 GE 997 OR ER21773 EQ 0 THEN ER21773=.;
  IF ER21774 GE 997 OR ER21774 EQ 0 THEN ER21774=.;
  IF ER21775 GE 999997 OR ER21775 EQ 0 THEN ER21775=.;
  IF ER21776 GE 999997 OR ER21776 EQ 0 THEN ER21776=.;
  IF ER21777 GE 8 OR ER21777 EQ 0 then ER21777=.;
  IF ER21778 GE 997 OR ER21778 EQ 0 THEN ER21778=.;
  IF ER21779 GE 997 OR ER21779 EQ 0 THEN ER21779=.;
  IF ER21780 GE 97 OR ER21780 EQ 0 THEN ER21780=.;
  IF ER21781 GE 97 OR ER21781 EQ 0 THEN ER21781=.;
  IF ER21782 GE 9997 OR ER21782 EQ 0 THEN ER21782=.;
  IF ER21783 GE 8 OR ER21783 EQ 0 then ER21783=.;
  IF ER21784 GE 8 OR ER21784 EQ 0 then ER21784=.;
  IF ER21785 GE 97 OR ER21785 EQ 0 THEN ER21785=.;
  IF ER21786 GE 8 OR ER21786 EQ 0 then ER21786=.;
  IF ER21787 GE 8 OR ER21787 EQ 0 then ER21787=.;
  IF ER21788 GE 9997 OR ER21788 EQ 0 THEN ER21788=.;
  IF ER21789 GE 97 OR ER21789 EQ 0 THEN ER21789=.;
  IF ER21790 GE 8 OR ER21790 EQ 0 then ER21790=.;
  IF ER21791 GE 8 OR ER21791 EQ 0 then ER21791=.;
  IF ER21792 GE 8 OR ER21792 EQ 0 then ER21792=.;
  IF ER21793 GE 8 OR ER21793 EQ 0 then ER21793=.;
  IF ER21794 GE 999997 OR ER21794 EQ 0 THEN ER21794=.;
  IF ER21795 GE 8 OR ER21795 EQ 0 then ER21795=.;
  IF ER21796 GE 999997 OR ER21796 EQ 0 THEN ER21796=.;
  IF ER21797 GE 999997 OR ER21797 EQ 0 THEN ER21797=.;
  IF ER21798 GE 8 OR ER21798 EQ 0 then ER21798=.;
  IF ER21799 GE 999997 OR ER21799 EQ 0 THEN ER21799=.;
  IF ER21800 GE 999997 OR ER21800 EQ 0 THEN ER21800=.;
  IF ER21801 GE 8 OR ER21801 EQ 0 then ER21801=.;
  IF ER21802 GE 997 OR ER21802 EQ 0 THEN ER21802=.;
  IF ER21803 GE 997 OR ER21803 EQ 0 THEN ER21803=.;
  IF ER21804 GE 999997 OR ER21804 EQ 0 THEN ER21804=.;
  IF ER21805 GE 999997 OR ER21805 EQ 0 THEN ER21805=.;
  IF ER21806 GE 8 OR ER21806 EQ 0 then ER21806=.;
  IF ER21807 GE 997 OR ER21807 EQ 0 THEN ER21807=.;
  IF ER21808 GE 997 OR ER21808 EQ 0 THEN ER21808=.;
  IF ER21809 GE 97 OR ER21809 EQ 0 THEN ER21809=.;
  IF ER21810 GE 97 OR ER21810 EQ 0 THEN ER21810=.;
  IF ER21811 GE 9997 OR ER21811 EQ 0 THEN ER21811=.;
  IF ER21812 GE 8 OR ER21812 EQ 0 then ER21812=.;
  IF ER21813 GE 8 OR ER21813 EQ 0 then ER21813=.;
  IF ER21814 GE 97 OR ER21814 EQ 0 THEN ER21814=.;
  IF ER21815 GE 8 OR ER21815 EQ 0 then ER21815=.;
  IF ER21816 GE 8 OR ER21816 EQ 0 then ER21816=.;
  IF ER21817 GE 9997 OR ER21817 EQ 0 THEN ER21817=.;
  IF ER21818 GE 97 OR ER21818 EQ 0 THEN ER21818=.;
  IF ER21819 GE 8 OR ER21819 EQ 0 then ER21819=.;
  IF ER21820 GE 8 OR ER21820 EQ 0 then ER21820=.;
  IF ER21821 GE 8 OR ER21821 EQ 0 then ER21821=.;
  IF ER21822 GE 8 OR ER21822 EQ 0 then ER21822=.;
  IF ER21823 GE 999997 OR ER21823 EQ 0 THEN ER21823=.;
  IF ER21824 GE 8 OR ER21824 EQ 0 then ER21824=.;
  IF ER21825 GE 999997 OR ER21825 EQ 0 THEN ER21825=.;
  IF ER21826 GE 999997 OR ER21826 EQ 0 THEN ER21826=.;
  IF ER21827 GE 8 OR ER21827 EQ 0 then ER21827=.;
  IF ER21828 GE 999997 OR ER21828 EQ 0 THEN ER21828=.;
  IF ER21829 GE 999997 OR ER21829 EQ 0 THEN ER21829=.;
  IF ER21830 GE 8 OR ER21830 EQ 0 then ER21830=.;
  IF ER21831 GE 997 OR ER21831 EQ 0 THEN ER21831=.;
  IF ER21832 GE 997 OR ER21832 EQ 0 THEN ER21832=.;
  IF ER21833 GE 999997 OR ER21833 EQ 0 THEN ER21833=.;
  IF ER21834 GE 999997 OR ER21834 EQ 0 THEN ER21834=.;
  IF ER21835 GE 8 OR ER21835 EQ 0 then ER21835=.;
  IF ER21836 GE 997 OR ER21836 EQ 0 THEN ER21836=.;
  IF ER21837 GE 997 OR ER21837 EQ 0 THEN ER21837=.;
  IF ER21838 GE 999997 OR ER21838 EQ 0 THEN ER21838=.;
  IF ER21839 GE 8 OR ER21839 EQ 0 then ER21839=.;
  IF ER21840 GE 8 OR ER21840 EQ 0 then ER21840=.;
  IF ER21841 GE 999997 OR ER21841 EQ 0 THEN ER21841=.;
  IF ER21842 GE 99997 OR ER21842 EQ 0 THEN ER21842=.;
  IF ER21843 GE 99997 OR ER21843 EQ 0 THEN ER21843=.;
  IF ER21844 GE 99997 OR ER21844 EQ 0 THEN ER21844=.;
  IF ER21845 GE 99997 OR ER21845 EQ 0 THEN ER21845=.;
  IF ER21846 GE 99997 OR ER21846 EQ 0 THEN ER21846=.;
  IF ER21847 GE 99997 OR ER21847 EQ 0 THEN ER21847=.;
  IF ER21848 GE 8 OR ER21848 EQ 0 then ER21848=.;
  IF ER21849 GE 999997 OR ER21849 EQ 0 THEN ER21849=.;
  IF ER21850 GE 8 OR ER21850 EQ 0 then ER21850=.;
  IF ER21851 GE 999997 OR ER21851 EQ 0 THEN ER21851=.;
  IF ER21852 GE 8 OR ER21852 EQ 0 then ER21852=.;
  IF ER21853 GE 9999997 OR ER21853 EQ 0 THEN ER21853=.;
  IF ER21854 GE 9999997 OR ER21854 EQ 0 THEN ER21854=.;
  IF ER21855 GE 9999997 OR ER21855 EQ 0 THEN ER21855=.;
  IF ER21856 GE 8 OR ER21856 EQ 0 then ER21856=.;
  IF ER21857 GE 8 OR ER21857 EQ 0 then ER21857=.;
  IF ER21858 GE 97 OR ER21858 EQ 0 THEN ER21858=.;
  IF ER21859 GE 8 OR ER21859 EQ 0 then ER21859=.;
  IF ER21860 GE 8 OR ER21860 EQ 0 then ER21860=.;
  IF ER21861 GE 8 OR ER21861 EQ 0 then ER21861=.;
  IF ER21862 GE 8 OR ER21862 EQ 0 then ER21862=.;
  IF ER21863 GE 97 OR ER21863 EQ 0 THEN ER21863=.;
  IF ER21864 GE 97 OR ER21864 EQ 0 THEN ER21864=.;
  IF ER21865 GE 97 OR ER21865 EQ 0 THEN ER21865=.;
  IF ER21866 GE 97 OR ER21866 EQ 0 THEN ER21866=.;
  IF ER21867 GE 8 OR ER21867 EQ 0 then ER21867=.;
  IF ER21868 GE 9999997 OR ER21868 EQ 0 THEN ER21868=.;
  IF ER21869 GE 9999997 OR ER21869 EQ 0 THEN ER21869=.;
  IF ER21870 GE 9999997 OR ER21870 EQ 0 THEN ER21870=.;
  IF ER21871 GE 8 OR ER21871 EQ 0 then ER21871=.;
  IF ER21872 GE 97 OR ER21872 EQ 0 THEN ER21872=.;
  IF ER21873 GE 8 OR ER21873 EQ 0 then ER21873=.;
  IF ER21874 GE 8 OR ER21874 EQ 0 then ER21874=.;
  IF ER21875 GE 8 OR ER21875 EQ 0 then ER21875=.;
  IF ER21876 GE 8 OR ER21876 EQ 0 then ER21876=.;
  IF ER21877 GE 97 OR ER21877 EQ 0 THEN ER21877=.;
  IF ER21878 GE 97 OR ER21878 EQ 0 THEN ER21878=.;
  IF ER21879 GE 97 OR ER21879 EQ 0 THEN ER21879=.;
  IF ER21880 GE 97 OR ER21880 EQ 0 THEN ER21880=.;
  IF ER21881 GE 8 OR ER21881 EQ 0 then ER21881=.;
  IF ER21882 GE 9999997 OR ER21882 EQ 0 THEN ER21882=.;
  IF ER21883 GE 9999997 OR ER21883 EQ 0 THEN ER21883=.;
  IF ER21884 GE 9999997 OR ER21884 EQ 0 THEN ER21884=.;
  IF ER21885 GE 8 OR ER21885 EQ 0 then ER21885=.;
  IF ER21886 GE 97 OR ER21886 EQ 0 THEN ER21886=.;
  IF ER21887 GE 8 OR ER21887 EQ 0 then ER21887=.;
  IF ER21888 GE 8 OR ER21888 EQ 0 then ER21888=.;
  IF ER21889 GE 8 OR ER21889 EQ 0 then ER21889=.;
  IF ER21890 GE 8 OR ER21890 EQ 0 then ER21890=.;
  IF ER21891 GE 97 OR ER21891 EQ 0 THEN ER21891=.;
  IF ER21892 GE 97 OR ER21892 EQ 0 THEN ER21892=.;
  IF ER21893 GE 97 OR ER21893 EQ 0 THEN ER21893=.;
  IF ER21894 GE 97 OR ER21894 EQ 0 THEN ER21894=.;
  IF ER21895 GE 8 OR ER21895 EQ 0 then ER21895=.;
  IF ER21896 GE 9999997 OR ER21896 EQ 0 THEN ER21896=.;
  IF ER21897 GE 9999997 OR ER21897 EQ 0 THEN ER21897=.;
  IF ER21898 GE 9999997 OR ER21898 EQ 0 THEN ER21898=.;
  IF ER21899 GE 8 OR ER21899 EQ 0 then ER21899=.;
  IF ER21900 GE 97 OR ER21900 EQ 0 THEN ER21900=.;
  IF ER21901 GE 8 OR ER21901 EQ 0 then ER21901=.;
  IF ER21902 GE 8 OR ER21902 EQ 0 then ER21902=.;
  IF ER21903 GE 8 OR ER21903 EQ 0 then ER21903=.;
  IF ER21904 GE 8 OR ER21904 EQ 0 then ER21904=.;
  IF ER21905 GE 97 OR ER21905 EQ 0 THEN ER21905=.;
  IF ER21906 GE 97 OR ER21906 EQ 0 THEN ER21906=.;
  IF ER21907 GE 97 OR ER21907 EQ 0 THEN ER21907=.;
  IF ER21908 GE 97 OR ER21908 EQ 0 THEN ER21908=.;
  IF ER21909 GE 8 OR ER21909 EQ 0 then ER21909=.;
  IF ER21910 GE 9999997 OR ER21910 EQ 0 THEN ER21910=.;
  IF ER21911 GE 9999997 OR ER21911 EQ 0 THEN ER21911=.;
  IF ER21912 GE 9999997 OR ER21912 EQ 0 THEN ER21912=.;
  IF ER21913 GE 8 OR ER21913 EQ 0 then ER21913=.;
  IF ER21914 GE 97 OR ER21914 EQ 0 THEN ER21914=.;
  IF ER21915 GE 8 OR ER21915 EQ 0 then ER21915=.;
  IF ER21916 GE 8 OR ER21916 EQ 0 then ER21916=.;
  IF ER21917 GE 8 OR ER21917 EQ 0 then ER21917=.;
  IF ER21918 GE 8 OR ER21918 EQ 0 then ER21918=.;
  IF ER21919 GE 97 OR ER21919 EQ 0 THEN ER21919=.;
  IF ER21920 GE 97 OR ER21920 EQ 0 THEN ER21920=.;
  IF ER21921 GE 97 OR ER21921 EQ 0 THEN ER21921=.;
  IF ER21922 GE 97 OR ER21922 EQ 0 THEN ER21922=.;
  IF ER21923 GE 8 OR ER21923 EQ 0 then ER21923=.;
  IF ER21924 GE 9999997 OR ER21924 EQ 0 THEN ER21924=.;
  IF ER21925 GE 9999997 OR ER21925 EQ 0 THEN ER21925=.;
  IF ER21926 GE 9999997 OR ER21926 EQ 0 THEN ER21926=.;
  IF ER21927 GE 8 OR ER21927 EQ 0 then ER21927=.;
  IF ER21928 GE 8 OR ER21928 EQ 0 then ER21928=.;
  IF ER21929 GE 9999997 OR ER21929 EQ 0 THEN ER21929=.;
  IF ER21930 GE 8 OR ER21930 EQ 0 then ER21930=.;
  IF ER21931 GE 8 OR ER21931 EQ 0 then ER21931=.;
  IF ER21932 GE 8 OR ER21932 EQ 0 then ER21932=.;
  IF ER21933 GE 999997 OR ER21933 EQ 0 THEN ER21933=.;
  IF ER21934 GE 8 OR ER21934 EQ 0 then ER21934=.;
  IF ER21935 GE 8 OR ER21935 EQ 0 then ER21935=.;
  IF ER21936 GE 999997 OR ER21936 EQ 0 THEN ER21936=.;
  IF ER21937 GE 8 OR ER21937 EQ 0 then ER21937=.;
  IF ER21938 GE 8 OR ER21938 EQ 0 then ER21938=.;
  IF ER21939 GE 999997 OR ER21939 EQ 0 THEN ER21939=.;
  IF ER21940 GE 8 OR ER21940 EQ 0 then ER21940=.;
  IF ER21941 GE 8 OR ER21941 EQ 0 then ER21941=.;
  IF ER21942 GE 999997 OR ER21942 EQ 0 THEN ER21942=.;
  IF ER21943 GE 8 OR ER21943 EQ 0 then ER21943=.;
  IF ER21944 GE 8 OR ER21944 EQ 0 then ER21944=.;
  IF ER21945 GE 999997 OR ER21945 EQ 0 THEN ER21945=.;
  IF ER21946 GE 8 OR ER21946 EQ 0 then ER21946=.;
  IF ER21947 GE 8 OR ER21947 EQ 0 then ER21947=.;
  IF ER21948 GE 8 OR ER21948 EQ 0 then ER21948=.;
  IF ER21949 GE 9999997 OR ER21949 EQ 0 THEN ER21949=.;
  IF ER21950 GE 8 OR ER21950 EQ 0 then ER21950=.;
  IF ER21951 GE 8 OR ER21951 EQ 0 then ER21951=.;
  IF ER21952 GE 8 OR ER21952 EQ 0 then ER21952=.;
  IF ER21953 GE 8 OR ER21953 EQ 0 then ER21953=.;
  IF ER21954 GE 8 OR ER21954 EQ 0 then ER21954=.;
  IF ER21955 GE 8 OR ER21955 EQ 0 then ER21955=.;
  IF ER21956 GE 8 OR ER21956 EQ 0 then ER21956=.;
  IF ER21957 GE 8 OR ER21957 EQ 0 then ER21957=.;
  IF ER21958 GE 8 OR ER21958 EQ 0 then ER21958=.;
  IF ER21959 GE 8 OR ER21959 EQ 0 then ER21959=.;
  IF ER21960 GE 8 OR ER21960 EQ 0 then ER21960=.;
  IF ER21961 GE 8 OR ER21961 EQ 0 then ER21961=.;
  IF ER21962 GE 8 OR ER21962 EQ 0 then ER21962=.;
  IF ER21963 GE 8 OR ER21963 EQ 0 then ER21963=.;
  IF ER21964 GE 8 OR ER21964 EQ 0 then ER21964=.;
  IF ER21965 GE 8 OR ER21965 EQ 0 then ER21965=.;
  IF ER21966 GE 9999997 OR ER21966 EQ 0 THEN ER21966=.;
  IF ER21967 GE 8 OR ER21967 EQ 0 then ER21967=.;
  IF ER21968 GE 8 OR ER21968 EQ 0 then ER21968=.;
  IF ER21969 GE 8 OR ER21969 EQ 0 then ER21969=.;
  IF ER21970 GE 8 OR ER21970 EQ 0 then ER21970=.;
  IF ER21971 GE 8 OR ER21971 EQ 0 then ER21971=.;
  IF ER21972 GE 8 OR ER21972 EQ 0 then ER21972=.;
  IF ER21973 GE 8 OR ER21973 EQ 0 then ER21973=.;
  IF ER21974 GE 8 OR ER21974 EQ 0 then ER21974=.;
  IF ER21975 GE 8 OR ER21975 EQ 0 then ER21975=.;
  IF ER21976 GE 8 OR ER21976 EQ 0 then ER21976=.;
  IF ER21977 GE 8 OR ER21977 EQ 0 then ER21977=.;
  IF ER21978 GE 8 OR ER21978 EQ 0 then ER21978=.;
  IF ER21979 GE 8 OR ER21979 EQ 0 then ER21979=.;
  IF ER21980 GE 8 OR ER21980 EQ 0 then ER21980=.;
  IF ER21981 GE 8 OR ER21981 EQ 0 then ER21981=.;
  IF ER21982 GE 8 OR ER21982 EQ 0 then ER21982=.;
  IF ER21983 GE 9999997 OR ER21983 EQ 0 THEN ER21983=.;
  IF ER21984 GE 8 OR ER21984 EQ 0 then ER21984=.;
  IF ER21985 GE 8 OR ER21985 EQ 0 then ER21985=.;
  IF ER21986 GE 8 OR ER21986 EQ 0 then ER21986=.;
  IF ER21987 GE 8 OR ER21987 EQ 0 then ER21987=.;
  IF ER21988 GE 8 OR ER21988 EQ 0 then ER21988=.;
  IF ER21989 GE 8 OR ER21989 EQ 0 then ER21989=.;
  IF ER21990 GE 8 OR ER21990 EQ 0 then ER21990=.;
  IF ER21991 GE 8 OR ER21991 EQ 0 then ER21991=.;
  IF ER21992 GE 8 OR ER21992 EQ 0 then ER21992=.;
  IF ER21993 GE 8 OR ER21993 EQ 0 then ER21993=.;
  IF ER21994 GE 8 OR ER21994 EQ 0 then ER21994=.;
  IF ER21995 GE 8 OR ER21995 EQ 0 then ER21995=.;
  IF ER21996 GE 8 OR ER21996 EQ 0 then ER21996=.;
  IF ER21997 GE 8 OR ER21997 EQ 0 then ER21997=.;
  IF ER21998 GE 8 OR ER21998 EQ 0 then ER21998=.;
  IF ER21999 GE 8 OR ER21999 EQ 0 then ER21999=.;
  IF ER22000 GE 9999997 OR ER22000 EQ 0 THEN ER22000=.;
  IF ER22001 GE 8 OR ER22001 EQ 0 then ER22001=.;
  IF ER22002 GE 8 OR ER22002 EQ 0 then ER22002=.;
  IF ER22003 GE 999997 OR ER22003 EQ 0 THEN ER22003=.;
  IF ER22004 GE 8 OR ER22004 EQ 0 then ER22004=.;
  IF ER22005 GE 8 OR ER22005 EQ 0 then ER22005=.;
  IF ER22006 GE 8 OR ER22006 EQ 0 then ER22006=.;
  IF ER22007 GE 8 OR ER22007 EQ 0 then ER22007=.;
  IF ER22008 GE 8 OR ER22008 EQ 0 then ER22008=.;
  IF ER22009 GE 8 OR ER22009 EQ 0 then ER22009=.;
  IF ER22010 GE 8 OR ER22010 EQ 0 then ER22010=.;
  IF ER22011 GE 8 OR ER22011 EQ 0 then ER22011=.;
  IF ER22012 GE 8 OR ER22012 EQ 0 then ER22012=.;
  IF ER22013 GE 8 OR ER22013 EQ 0 then ER22013=.;
  IF ER22014 GE 8 OR ER22014 EQ 0 then ER22014=.;
  IF ER22015 GE 8 OR ER22015 EQ 0 then ER22015=.;
  IF ER22016 GE 8 OR ER22016 EQ 0 then ER22016=.;
  IF ER22017 GE 8 OR ER22017 EQ 0 then ER22017=.;
  IF ER22018 GE 8 OR ER22018 EQ 0 then ER22018=.;
  IF ER22019 GE 8 OR ER22019 EQ 0 then ER22019=.;
  IF ER22020 GE 999997 OR ER22020 EQ 0 THEN ER22020=.;
  IF ER22021 GE 8 OR ER22021 EQ 0 then ER22021=.;
  IF ER22022 GE 8 OR ER22022 EQ 0 then ER22022=.;
  IF ER22023 GE 8 OR ER22023 EQ 0 then ER22023=.;
  IF ER22024 GE 8 OR ER22024 EQ 0 then ER22024=.;
  IF ER22025 GE 8 OR ER22025 EQ 0 then ER22025=.;
  IF ER22026 GE 8 OR ER22026 EQ 0 then ER22026=.;
  IF ER22027 GE 8 OR ER22027 EQ 0 then ER22027=.;
  IF ER22028 GE 8 OR ER22028 EQ 0 then ER22028=.;
  IF ER22029 GE 8 OR ER22029 EQ 0 then ER22029=.;
  IF ER22030 GE 8 OR ER22030 EQ 0 then ER22030=.;
  IF ER22031 GE 8 OR ER22031 EQ 0 then ER22031=.;
  IF ER22032 GE 8 OR ER22032 EQ 0 then ER22032=.;
  IF ER22033 GE 8 OR ER22033 EQ 0 then ER22033=.;
  IF ER22034 GE 8 OR ER22034 EQ 0 then ER22034=.;
  IF ER22035 GE 8 OR ER22035 EQ 0 then ER22035=.;
  IF ER22036 GE 8 OR ER22036 EQ 0 then ER22036=.;
  IF ER22037 GE 999997 OR ER22037 EQ 0 THEN ER22037=.;
  IF ER22038 GE 8 OR ER22038 EQ 0 then ER22038=.;
  IF ER22039 GE 8 OR ER22039 EQ 0 then ER22039=.;
  IF ER22040 GE 8 OR ER22040 EQ 0 then ER22040=.;
  IF ER22041 GE 8 OR ER22041 EQ 0 then ER22041=.;
  IF ER22042 GE 8 OR ER22042 EQ 0 then ER22042=.;
  IF ER22043 GE 8 OR ER22043 EQ 0 then ER22043=.;
  IF ER22044 GE 8 OR ER22044 EQ 0 then ER22044=.;
  IF ER22045 GE 8 OR ER22045 EQ 0 then ER22045=.;
  IF ER22046 GE 8 OR ER22046 EQ 0 then ER22046=.;
  IF ER22047 GE 8 OR ER22047 EQ 0 then ER22047=.;
  IF ER22048 GE 8 OR ER22048 EQ 0 then ER22048=.;
  IF ER22049 GE 8 OR ER22049 EQ 0 then ER22049=.;
  IF ER22050 GE 8 OR ER22050 EQ 0 then ER22050=.;
  IF ER22051 GE 8 OR ER22051 EQ 0 then ER22051=.;
  IF ER22052 GE 8 OR ER22052 EQ 0 then ER22052=.;
  IF ER22053 GE 8 OR ER22053 EQ 0 then ER22053=.;
  IF ER22054 GE 999997 OR ER22054 EQ 0 THEN ER22054=.;
  IF ER22055 GE 8 OR ER22055 EQ 0 then ER22055=.;
  IF ER22056 GE 8 OR ER22056 EQ 0 then ER22056=.;
  IF ER22057 GE 8 OR ER22057 EQ 0 then ER22057=.;
  IF ER22058 GE 8 OR ER22058 EQ 0 then ER22058=.;
  IF ER22059 GE 8 OR ER22059 EQ 0 then ER22059=.;
  IF ER22060 GE 8 OR ER22060 EQ 0 then ER22060=.;
  IF ER22061 GE 8 OR ER22061 EQ 0 then ER22061=.;
  IF ER22062 GE 8 OR ER22062 EQ 0 then ER22062=.;
  IF ER22063 GE 8 OR ER22063 EQ 0 then ER22063=.;
  IF ER22064 GE 8 OR ER22064 EQ 0 then ER22064=.;
  IF ER22065 GE 8 OR ER22065 EQ 0 then ER22065=.;
  IF ER22066 GE 8 OR ER22066 EQ 0 then ER22066=.;
  IF ER22067 GE 8 OR ER22067 EQ 0 then ER22067=.;
  IF ER22068 GE 8 OR ER22068 EQ 0 then ER22068=.;
  IF ER22069 GE 8 OR ER22069 EQ 0 then ER22069=.;
  IF ER22070 GE 999997 OR ER22070 EQ 0 THEN ER22070=.;
  IF ER22071 GE 8 OR ER22071 EQ 0 then ER22071=.;
  IF ER22072 GE 8 OR ER22072 EQ 0 then ER22072=.;
  IF ER22073 GE 8 OR ER22073 EQ 0 then ER22073=.;
  IF ER22074 GE 8 OR ER22074 EQ 0 then ER22074=.;
  IF ER22075 GE 8 OR ER22075 EQ 0 then ER22075=.;
  IF ER22076 GE 8 OR ER22076 EQ 0 then ER22076=.;
  IF ER22077 GE 8 OR ER22077 EQ 0 then ER22077=.;
  IF ER22078 GE 8 OR ER22078 EQ 0 then ER22078=.;
  IF ER22079 GE 8 OR ER22079 EQ 0 then ER22079=.;
  IF ER22080 GE 8 OR ER22080 EQ 0 then ER22080=.;
  IF ER22081 GE 8 OR ER22081 EQ 0 then ER22081=.;
  IF ER22082 GE 8 OR ER22082 EQ 0 then ER22082=.;
  IF ER22083 GE 8 OR ER22083 EQ 0 then ER22083=.;
  IF ER22084 GE 8 OR ER22084 EQ 0 then ER22084=.;
  IF ER22085 GE 8 OR ER22085 EQ 0 then ER22085=.;
  IF ER22086 GE 8 OR ER22086 EQ 0 then ER22086=.;
  IF ER22087 GE 999997 OR ER22087 EQ 0 THEN ER22087=.;
  IF ER22088 GE 8 OR ER22088 EQ 0 then ER22088=.;
  IF ER22089 GE 8 OR ER22089 EQ 0 then ER22089=.;
  IF ER22090 GE 8 OR ER22090 EQ 0 then ER22090=.;
  IF ER22091 GE 8 OR ER22091 EQ 0 then ER22091=.;
  IF ER22092 GE 8 OR ER22092 EQ 0 then ER22092=.;
  IF ER22093 GE 8 OR ER22093 EQ 0 then ER22093=.;
  IF ER22094 GE 8 OR ER22094 EQ 0 then ER22094=.;
  IF ER22095 GE 8 OR ER22095 EQ 0 then ER22095=.;
  IF ER22096 GE 8 OR ER22096 EQ 0 then ER22096=.;
  IF ER22097 GE 8 OR ER22097 EQ 0 then ER22097=.;
  IF ER22098 GE 8 OR ER22098 EQ 0 then ER22098=.;
  IF ER22099 GE 8 OR ER22099 EQ 0 then ER22099=.;
  IF ER22100 GE 8 OR ER22100 EQ 0 then ER22100=.;
  IF ER22101 GE 8 OR ER22101 EQ 0 then ER22101=.;
  IF ER22102 GE 8 OR ER22102 EQ 0 then ER22102=.;
  IF ER22103 GE 999997 OR ER22103 EQ 0 THEN ER22103=.;
  IF ER22104 GE 8 OR ER22104 EQ 0 then ER22104=.;
  IF ER22105 GE 8 OR ER22105 EQ 0 then ER22105=.;
  IF ER22106 GE 8 OR ER22106 EQ 0 then ER22106=.;
  IF ER22107 GE 8 OR ER22107 EQ 0 then ER22107=.;
  IF ER22108 GE 8 OR ER22108 EQ 0 then ER22108=.;
  IF ER22109 GE 8 OR ER22109 EQ 0 then ER22109=.;
  IF ER22110 GE 8 OR ER22110 EQ 0 then ER22110=.;
  IF ER22111 GE 8 OR ER22111 EQ 0 then ER22111=.;
  IF ER22112 GE 8 OR ER22112 EQ 0 then ER22112=.;
  IF ER22113 GE 8 OR ER22113 EQ 0 then ER22113=.;
  IF ER22114 GE 8 OR ER22114 EQ 0 then ER22114=.;
  IF ER22115 GE 8 OR ER22115 EQ 0 then ER22115=.;
  IF ER22116 GE 8 OR ER22116 EQ 0 then ER22116=.;
  IF ER22117 GE 8 OR ER22117 EQ 0 then ER22117=.;
  IF ER22118 GE 8 OR ER22118 EQ 0 then ER22118=.;
  IF ER22119 GE 8 OR ER22119 EQ 0 then ER22119=.;
  IF ER22120 GE 999997 OR ER22120 EQ 0 THEN ER22120=.;
  IF ER22121 GE 8 OR ER22121 EQ 0 then ER22121=.;
  IF ER22122 GE 8 OR ER22122 EQ 0 then ER22122=.;
  IF ER22123 GE 8 OR ER22123 EQ 0 then ER22123=.;
  IF ER22124 GE 8 OR ER22124 EQ 0 then ER22124=.;
  IF ER22125 GE 8 OR ER22125 EQ 0 then ER22125=.;
  IF ER22126 GE 8 OR ER22126 EQ 0 then ER22126=.;
  IF ER22127 GE 8 OR ER22127 EQ 0 then ER22127=.;
  IF ER22128 GE 8 OR ER22128 EQ 0 then ER22128=.;
  IF ER22129 GE 8 OR ER22129 EQ 0 then ER22129=.;
  IF ER22130 GE 8 OR ER22130 EQ 0 then ER22130=.;
  IF ER22131 GE 8 OR ER22131 EQ 0 then ER22131=.;
  IF ER22132 GE 8 OR ER22132 EQ 0 then ER22132=.;
  IF ER22133 GE 8 OR ER22133 EQ 0 then ER22133=.;
  IF ER22134 GE 8 OR ER22134 EQ 0 then ER22134=.;
  IF ER22135 GE 8 OR ER22135 EQ 0 then ER22135=.;
  IF ER22136 GE 999997 OR ER22136 EQ 0 THEN ER22136=.;
  IF ER22137 GE 8 OR ER22137 EQ 0 then ER22137=.;
  IF ER22138 GE 8 OR ER22138 EQ 0 then ER22138=.;
  IF ER22139 GE 8 OR ER22139 EQ 0 then ER22139=.;
  IF ER22140 GE 8 OR ER22140 EQ 0 then ER22140=.;
  IF ER22141 GE 8 OR ER22141 EQ 0 then ER22141=.;
  IF ER22142 GE 8 OR ER22142 EQ 0 then ER22142=.;
  IF ER22143 GE 8 OR ER22143 EQ 0 then ER22143=.;
  IF ER22144 GE 8 OR ER22144 EQ 0 then ER22144=.;
  IF ER22145 GE 8 OR ER22145 EQ 0 then ER22145=.;
  IF ER22146 GE 8 OR ER22146 EQ 0 then ER22146=.;
  IF ER22147 GE 8 OR ER22147 EQ 0 then ER22147=.;
  IF ER22148 GE 8 OR ER22148 EQ 0 then ER22148=.;
  IF ER22149 GE 8 OR ER22149 EQ 0 then ER22149=.;
  IF ER22150 GE 8 OR ER22150 EQ 0 then ER22150=.;
  IF ER22151 GE 8 OR ER22151 EQ 0 then ER22151=.;
  IF ER22152 GE 999997 OR ER22152 EQ 0 THEN ER22152=.;
  IF ER22153 GE 8 OR ER22153 EQ 0 then ER22153=.;
  IF ER22154 GE 8 OR ER22154 EQ 0 then ER22154=.;
  IF ER22155 GE 8 OR ER22155 EQ 0 then ER22155=.;
  IF ER22156 GE 8 OR ER22156 EQ 0 then ER22156=.;
  IF ER22157 GE 8 OR ER22157 EQ 0 then ER22157=.;
  IF ER22158 GE 8 OR ER22158 EQ 0 then ER22158=.;
  IF ER22159 GE 8 OR ER22159 EQ 0 then ER22159=.;
  IF ER22160 GE 8 OR ER22160 EQ 0 then ER22160=.;
  IF ER22161 GE 8 OR ER22161 EQ 0 then ER22161=.;
  IF ER22162 GE 8 OR ER22162 EQ 0 then ER22162=.;
  IF ER22163 GE 8 OR ER22163 EQ 0 then ER22163=.;
  IF ER22164 GE 8 OR ER22164 EQ 0 then ER22164=.;
  IF ER22165 GE 8 OR ER22165 EQ 0 then ER22165=.;
  IF ER22166 GE 8 OR ER22166 EQ 0 then ER22166=.;
  IF ER22167 GE 8 OR ER22167 EQ 0 then ER22167=.;
  IF ER22168 GE 999997 OR ER22168 EQ 0 THEN ER22168=.;
  IF ER22169 GE 8 OR ER22169 EQ 0 then ER22169=.;
  IF ER22170 GE 8 OR ER22170 EQ 0 then ER22170=.;
  IF ER22171 GE 8 OR ER22171 EQ 0 then ER22171=.;
  IF ER22172 GE 8 OR ER22172 EQ 0 then ER22172=.;
  IF ER22173 GE 8 OR ER22173 EQ 0 then ER22173=.;
  IF ER22174 GE 8 OR ER22174 EQ 0 then ER22174=.;
  IF ER22175 GE 8 OR ER22175 EQ 0 then ER22175=.;
  IF ER22176 GE 8 OR ER22176 EQ 0 then ER22176=.;
  IF ER22177 GE 8 OR ER22177 EQ 0 then ER22177=.;
  IF ER22178 GE 8 OR ER22178 EQ 0 then ER22178=.;
  IF ER22179 GE 8 OR ER22179 EQ 0 then ER22179=.;
  IF ER22180 GE 8 OR ER22180 EQ 0 then ER22180=.;
  IF ER22181 GE 8 OR ER22181 EQ 0 then ER22181=.;
  IF ER22182 GE 8 OR ER22182 EQ 0 then ER22182=.;
  IF ER22183 GE 8 OR ER22183 EQ 0 then ER22183=.;
  IF ER22184 GE 8 OR ER22184 EQ 0 then ER22184=.;
  IF ER22185 GE 999997 OR ER22185 EQ 0 THEN ER22185=.;
  IF ER22186 GE 8 OR ER22186 EQ 0 then ER22186=.;
  IF ER22187 GE 8 OR ER22187 EQ 0 then ER22187=.;
  IF ER22188 GE 8 OR ER22188 EQ 0 then ER22188=.;
  IF ER22189 GE 8 OR ER22189 EQ 0 then ER22189=.;
  IF ER22190 GE 8 OR ER22190 EQ 0 then ER22190=.;
  IF ER22191 GE 8 OR ER22191 EQ 0 then ER22191=.;
  IF ER22192 GE 8 OR ER22192 EQ 0 then ER22192=.;
  IF ER22193 GE 8 OR ER22193 EQ 0 then ER22193=.;
  IF ER22194 GE 8 OR ER22194 EQ 0 then ER22194=.;
  IF ER22195 GE 8 OR ER22195 EQ 0 then ER22195=.;
  IF ER22196 GE 8 OR ER22196 EQ 0 then ER22196=.;
  IF ER22197 GE 8 OR ER22197 EQ 0 then ER22197=.;
  IF ER22198 GE 8 OR ER22198 EQ 0 then ER22198=.;
  IF ER22199 GE 8 OR ER22199 EQ 0 then ER22199=.;
  IF ER22200 GE 8 OR ER22200 EQ 0 then ER22200=.;
  IF ER22201 GE 999997 OR ER22201 EQ 0 THEN ER22201=.;
  IF ER22202 GE 8 OR ER22202 EQ 0 then ER22202=.;
  IF ER22203 GE 8 OR ER22203 EQ 0 then ER22203=.;
  IF ER22204 GE 8 OR ER22204 EQ 0 then ER22204=.;
  IF ER22205 GE 8 OR ER22205 EQ 0 then ER22205=.;
  IF ER22206 GE 8 OR ER22206 EQ 0 then ER22206=.;
  IF ER22207 GE 8 OR ER22207 EQ 0 then ER22207=.;
  IF ER22208 GE 8 OR ER22208 EQ 0 then ER22208=.;
  IF ER22209 GE 8 OR ER22209 EQ 0 then ER22209=.;
  IF ER22210 GE 8 OR ER22210 EQ 0 then ER22210=.;
  IF ER22211 GE 8 OR ER22211 EQ 0 then ER22211=.;
  IF ER22212 GE 8 OR ER22212 EQ 0 then ER22212=.;
  IF ER22213 GE 8 OR ER22213 EQ 0 then ER22213=.;
  IF ER22214 GE 8 OR ER22214 EQ 0 then ER22214=.;
  IF ER22215 GE 8 OR ER22215 EQ 0 then ER22215=.;
  IF ER22216 GE 8 OR ER22216 EQ 0 then ER22216=.;
  IF ER22217 GE 999997 OR ER22217 EQ 0 THEN ER22217=.;
  IF ER22218 GE 8 OR ER22218 EQ 0 then ER22218=.;
  IF ER22219 GE 8 OR ER22219 EQ 0 then ER22219=.;
  IF ER22220 GE 8 OR ER22220 EQ 0 then ER22220=.;
  IF ER22221 GE 8 OR ER22221 EQ 0 then ER22221=.;
  IF ER22222 GE 8 OR ER22222 EQ 0 then ER22222=.;
  IF ER22223 GE 8 OR ER22223 EQ 0 then ER22223=.;
  IF ER22224 GE 8 OR ER22224 EQ 0 then ER22224=.;
  IF ER22225 GE 8 OR ER22225 EQ 0 then ER22225=.;
  IF ER22226 GE 8 OR ER22226 EQ 0 then ER22226=.;
  IF ER22227 GE 8 OR ER22227 EQ 0 then ER22227=.;
  IF ER22228 GE 8 OR ER22228 EQ 0 then ER22228=.;
  IF ER22229 GE 8 OR ER22229 EQ 0 then ER22229=.;
  IF ER22230 GE 8 OR ER22230 EQ 0 then ER22230=.;
  IF ER22231 GE 8 OR ER22231 EQ 0 then ER22231=.;
  IF ER22232 GE 8 OR ER22232 EQ 0 then ER22232=.;
  IF ER22233 GE 999997 OR ER22233 EQ 0 THEN ER22233=.;
  IF ER22234 GE 8 OR ER22234 EQ 0 then ER22234=.;
  IF ER22235 GE 8 OR ER22235 EQ 0 then ER22235=.;
  IF ER22236 GE 8 OR ER22236 EQ 0 then ER22236=.;
  IF ER22237 GE 8 OR ER22237 EQ 0 then ER22237=.;
  IF ER22238 GE 8 OR ER22238 EQ 0 then ER22238=.;
  IF ER22239 GE 8 OR ER22239 EQ 0 then ER22239=.;
  IF ER22240 GE 8 OR ER22240 EQ 0 then ER22240=.;
  IF ER22241 GE 8 OR ER22241 EQ 0 then ER22241=.;
  IF ER22242 GE 8 OR ER22242 EQ 0 then ER22242=.;
  IF ER22243 GE 8 OR ER22243 EQ 0 then ER22243=.;
  IF ER22244 GE 8 OR ER22244 EQ 0 then ER22244=.;
  IF ER22245 GE 8 OR ER22245 EQ 0 then ER22245=.;
  IF ER22246 GE 8 OR ER22246 EQ 0 then ER22246=.;
  IF ER22247 GE 8 OR ER22247 EQ 0 then ER22247=.;
  IF ER22248 GE 8 OR ER22248 EQ 0 then ER22248=.;
  IF ER22249 GE 999997 OR ER22249 EQ 0 THEN ER22249=.;
  IF ER22250 GE 8 OR ER22250 EQ 0 then ER22250=.;
  IF ER22251 GE 8 OR ER22251 EQ 0 then ER22251=.;
  IF ER22252 GE 8 OR ER22252 EQ 0 then ER22252=.;
  IF ER22253 GE 8 OR ER22253 EQ 0 then ER22253=.;
  IF ER22254 GE 8 OR ER22254 EQ 0 then ER22254=.;
  IF ER22255 GE 8 OR ER22255 EQ 0 then ER22255=.;
  IF ER22256 GE 8 OR ER22256 EQ 0 then ER22256=.;
  IF ER22257 GE 8 OR ER22257 EQ 0 then ER22257=.;
  IF ER22258 GE 8 OR ER22258 EQ 0 then ER22258=.;
  IF ER22259 GE 8 OR ER22259 EQ 0 then ER22259=.;
  IF ER22260 GE 8 OR ER22260 EQ 0 then ER22260=.;
  IF ER22261 GE 8 OR ER22261 EQ 0 then ER22261=.;
  IF ER22262 GE 8 OR ER22262 EQ 0 then ER22262=.;
  IF ER22263 GE 8 OR ER22263 EQ 0 then ER22263=.;
  IF ER22264 GE 8 OR ER22264 EQ 0 then ER22264=.;
  IF ER22265 GE 999997 OR ER22265 EQ 0 THEN ER22265=.;
  IF ER22266 GE 8 OR ER22266 EQ 0 then ER22266=.;
  IF ER22267 GE 8 OR ER22267 EQ 0 then ER22267=.;
  IF ER22268 GE 8 OR ER22268 EQ 0 then ER22268=.;
  IF ER22269 GE 8 OR ER22269 EQ 0 then ER22269=.;
  IF ER22270 GE 8 OR ER22270 EQ 0 then ER22270=.;
  IF ER22271 GE 8 OR ER22271 EQ 0 then ER22271=.;
  IF ER22272 GE 8 OR ER22272 EQ 0 then ER22272=.;
  IF ER22273 GE 8 OR ER22273 EQ 0 then ER22273=.;
  IF ER22274 GE 8 OR ER22274 EQ 0 then ER22274=.;
  IF ER22275 GE 8 OR ER22275 EQ 0 then ER22275=.;
  IF ER22276 GE 8 OR ER22276 EQ 0 then ER22276=.;
  IF ER22277 GE 8 OR ER22277 EQ 0 then ER22277=.;
  IF ER22278 GE 8 OR ER22278 EQ 0 then ER22278=.;
  IF ER22279 GE 8 OR ER22279 EQ 0 then ER22279=.;
  IF ER22280 GE 8 OR ER22280 EQ 0 then ER22280=.;
  IF ER22281 GE 999997 OR ER22281 EQ 0 THEN ER22281=.;
  IF ER22282 GE 8 OR ER22282 EQ 0 then ER22282=.;
  IF ER22283 GE 8 OR ER22283 EQ 0 then ER22283=.;
  IF ER22284 GE 8 OR ER22284 EQ 0 then ER22284=.;
  IF ER22285 GE 8 OR ER22285 EQ 0 then ER22285=.;
  IF ER22286 GE 8 OR ER22286 EQ 0 then ER22286=.;
  IF ER22287 GE 8 OR ER22287 EQ 0 then ER22287=.;
  IF ER22288 GE 8 OR ER22288 EQ 0 then ER22288=.;
  IF ER22289 GE 8 OR ER22289 EQ 0 then ER22289=.;
  IF ER22290 GE 8 OR ER22290 EQ 0 then ER22290=.;
  IF ER22291 GE 8 OR ER22291 EQ 0 then ER22291=.;
  IF ER22292 GE 8 OR ER22292 EQ 0 then ER22292=.;
  IF ER22293 GE 8 OR ER22293 EQ 0 then ER22293=.;
  IF ER22294 GE 8 OR ER22294 EQ 0 then ER22294=.;
  IF ER22295 GE 8 OR ER22295 EQ 0 then ER22295=.;
  IF ER22296 GE 8 OR ER22296 EQ 0 then ER22296=.;
  IF ER22297 GE 8 OR ER22297 EQ 0 then ER22297=.;
  IF ER22298 GE 8 OR ER22298 EQ 0 then ER22298=.;
  IF ER22299 GE 8 OR ER22299 EQ 0 then ER22299=.;
  IF ER22300 GE 9999997 OR ER22300 EQ 0 THEN ER22300=.;
  IF ER22301 GE 8 OR ER22301 EQ 0 then ER22301=.;
  IF ER22302 GE 8 OR ER22302 EQ 0 then ER22302=.;
  IF ER22303 GE 8 OR ER22303 EQ 0 then ER22303=.;
  IF ER22304 GE 999997 OR ER22304 EQ 0 THEN ER22304=.;
  IF ER22305 GE 8 OR ER22305 EQ 0 then ER22305=.;
  IF ER22306 GE 8 OR ER22306 EQ 0 then ER22306=.;
  IF ER22307 GE 8 OR ER22307 EQ 0 then ER22307=.;
  IF ER22308 GE 8 OR ER22308 EQ 0 then ER22308=.;
  IF ER22309 GE 8 OR ER22309 EQ 0 then ER22309=.;
  IF ER22310 GE 8 OR ER22310 EQ 0 then ER22310=.;
  IF ER22311 GE 8 OR ER22311 EQ 0 then ER22311=.;
  IF ER22312 GE 8 OR ER22312 EQ 0 then ER22312=.;
  IF ER22313 GE 8 OR ER22313 EQ 0 then ER22313=.;
  IF ER22314 GE 8 OR ER22314 EQ 0 then ER22314=.;
  IF ER22315 GE 8 OR ER22315 EQ 0 then ER22315=.;
  IF ER22316 GE 8 OR ER22316 EQ 0 then ER22316=.;
  IF ER22317 GE 8 OR ER22317 EQ 0 then ER22317=.;
  IF ER22318 GE 8 OR ER22318 EQ 0 then ER22318=.;
  IF ER22319 GE 8 OR ER22319 EQ 0 then ER22319=.;
  IF ER22320 GE 999997 OR ER22320 EQ 0 THEN ER22320=.;
  IF ER22321 GE 8 OR ER22321 EQ 0 then ER22321=.;
  IF ER22322 GE 8 OR ER22322 EQ 0 then ER22322=.;
  IF ER22323 GE 8 OR ER22323 EQ 0 then ER22323=.;
  IF ER22324 GE 8 OR ER22324 EQ 0 then ER22324=.;
  IF ER22325 GE 8 OR ER22325 EQ 0 then ER22325=.;
  IF ER22326 GE 8 OR ER22326 EQ 0 then ER22326=.;
  IF ER22327 GE 8 OR ER22327 EQ 0 then ER22327=.;
  IF ER22328 GE 8 OR ER22328 EQ 0 then ER22328=.;
  IF ER22329 GE 8 OR ER22329 EQ 0 then ER22329=.;
  IF ER22330 GE 8 OR ER22330 EQ 0 then ER22330=.;
  IF ER22331 GE 8 OR ER22331 EQ 0 then ER22331=.;
  IF ER22332 GE 8 OR ER22332 EQ 0 then ER22332=.;
  IF ER22333 GE 8 OR ER22333 EQ 0 then ER22333=.;
  IF ER22334 GE 8 OR ER22334 EQ 0 then ER22334=.;
  IF ER22335 GE 8 OR ER22335 EQ 0 then ER22335=.;
  IF ER22336 GE 999997 OR ER22336 EQ 0 THEN ER22336=.;
  IF ER22337 GE 8 OR ER22337 EQ 0 then ER22337=.;
  IF ER22338 GE 8 OR ER22338 EQ 0 then ER22338=.;
  IF ER22339 GE 8 OR ER22339 EQ 0 then ER22339=.;
  IF ER22340 GE 8 OR ER22340 EQ 0 then ER22340=.;
  IF ER22341 GE 8 OR ER22341 EQ 0 then ER22341=.;
  IF ER22342 GE 8 OR ER22342 EQ 0 then ER22342=.;
  IF ER22343 GE 8 OR ER22343 EQ 0 then ER22343=.;
  IF ER22344 GE 8 OR ER22344 EQ 0 then ER22344=.;
  IF ER22345 GE 8 OR ER22345 EQ 0 then ER22345=.;
  IF ER22346 GE 8 OR ER22346 EQ 0 then ER22346=.;
  IF ER22347 GE 8 OR ER22347 EQ 0 then ER22347=.;
  IF ER22348 GE 8 OR ER22348 EQ 0 then ER22348=.;
  IF ER22349 GE 8 OR ER22349 EQ 0 then ER22349=.;
  IF ER22350 GE 8 OR ER22350 EQ 0 then ER22350=.;
  IF ER22351 GE 8 OR ER22351 EQ 0 then ER22351=.;
  IF ER22352 GE 8 OR ER22352 EQ 0 then ER22352=.;
  IF ER22353 GE 999997 OR ER22353 EQ 0 THEN ER22353=.;
  IF ER22354 GE 8 OR ER22354 EQ 0 then ER22354=.;
  IF ER22355 GE 8 OR ER22355 EQ 0 then ER22355=.;
  IF ER22356 GE 8 OR ER22356 EQ 0 then ER22356=.;
  IF ER22357 GE 8 OR ER22357 EQ 0 then ER22357=.;
  IF ER22358 GE 8 OR ER22358 EQ 0 then ER22358=.;
  IF ER22359 GE 8 OR ER22359 EQ 0 then ER22359=.;
  IF ER22360 GE 8 OR ER22360 EQ 0 then ER22360=.;
  IF ER22361 GE 8 OR ER22361 EQ 0 then ER22361=.;
  IF ER22362 GE 8 OR ER22362 EQ 0 then ER22362=.;
  IF ER22363 GE 8 OR ER22363 EQ 0 then ER22363=.;
  IF ER22364 GE 8 OR ER22364 EQ 0 then ER22364=.;
  IF ER22365 GE 8 OR ER22365 EQ 0 then ER22365=.;
  IF ER22366 GE 8 OR ER22366 EQ 0 then ER22366=.;
  IF ER22367 GE 8 OR ER22367 EQ 0 then ER22367=.;
  IF ER22368 GE 8 OR ER22368 EQ 0 then ER22368=.;
  IF ER22369 GE 8 OR ER22369 EQ 0 then ER22369=.;
  IF ER22370 GE 999997 OR ER22370 EQ 0 THEN ER22370=.;
  IF ER22371 GE 8 OR ER22371 EQ 0 then ER22371=.;
  IF ER22372 GE 8 OR ER22372 EQ 0 then ER22372=.;
  IF ER22373 GE 8 OR ER22373 EQ 0 then ER22373=.;
  IF ER22374 GE 8 OR ER22374 EQ 0 then ER22374=.;
  IF ER22375 GE 8 OR ER22375 EQ 0 then ER22375=.;
  IF ER22376 GE 8 OR ER22376 EQ 0 then ER22376=.;
  IF ER22377 GE 8 OR ER22377 EQ 0 then ER22377=.;
  IF ER22378 GE 8 OR ER22378 EQ 0 then ER22378=.;
  IF ER22379 GE 8 OR ER22379 EQ 0 then ER22379=.;
  IF ER22380 GE 8 OR ER22380 EQ 0 then ER22380=.;
  IF ER22381 GE 8 OR ER22381 EQ 0 then ER22381=.;
  IF ER22382 GE 8 OR ER22382 EQ 0 then ER22382=.;
  IF ER22383 GE 8 OR ER22383 EQ 0 then ER22383=.;
  IF ER22384 GE 8 OR ER22384 EQ 0 then ER22384=.;
  IF ER22385 GE 8 OR ER22385 EQ 0 then ER22385=.;
  IF ER22386 GE 8 OR ER22386 EQ 0 then ER22386=.;
  IF ER22387 GE 999997 OR ER22387 EQ 0 THEN ER22387=.;
  IF ER22388 GE 8 OR ER22388 EQ 0 then ER22388=.;
  IF ER22389 GE 8 OR ER22389 EQ 0 then ER22389=.;
  IF ER22390 GE 8 OR ER22390 EQ 0 then ER22390=.;
  IF ER22391 GE 8 OR ER22391 EQ 0 then ER22391=.;
  IF ER22392 GE 8 OR ER22392 EQ 0 then ER22392=.;
  IF ER22393 GE 8 OR ER22393 EQ 0 then ER22393=.;
  IF ER22394 GE 8 OR ER22394 EQ 0 then ER22394=.;
  IF ER22395 GE 8 OR ER22395 EQ 0 then ER22395=.;
  IF ER22396 GE 8 OR ER22396 EQ 0 then ER22396=.;
  IF ER22397 GE 8 OR ER22397 EQ 0 then ER22397=.;
  IF ER22398 GE 8 OR ER22398 EQ 0 then ER22398=.;
  IF ER22399 GE 8 OR ER22399 EQ 0 then ER22399=.;
  IF ER22400 GE 8 OR ER22400 EQ 0 then ER22400=.;
  IF ER22401 GE 8 OR ER22401 EQ 0 then ER22401=.;
  IF ER22402 GE 8 OR ER22402 EQ 0 then ER22402=.;
  IF ER22403 GE 8 OR ER22403 EQ 0 then ER22403=.;
  IF ER22404 GE 999997 OR ER22404 EQ 0 THEN ER22404=.;
  IF ER22405 GE 8 OR ER22405 EQ 0 then ER22405=.;
  IF ER22406 GE 8 OR ER22406 EQ 0 then ER22406=.;
  IF ER22407 GE 8 OR ER22407 EQ 0 then ER22407=.;
  IF ER22408 GE 8 OR ER22408 EQ 0 then ER22408=.;
  IF ER22409 GE 8 OR ER22409 EQ 0 then ER22409=.;
  IF ER22410 GE 8 OR ER22410 EQ 0 then ER22410=.;
  IF ER22411 GE 8 OR ER22411 EQ 0 then ER22411=.;
  IF ER22412 GE 8 OR ER22412 EQ 0 then ER22412=.;
  IF ER22413 GE 8 OR ER22413 EQ 0 then ER22413=.;
  IF ER22414 GE 8 OR ER22414 EQ 0 then ER22414=.;
  IF ER22415 GE 8 OR ER22415 EQ 0 then ER22415=.;
  IF ER22416 GE 8 OR ER22416 EQ 0 then ER22416=.;
  IF ER22417 GE 8 OR ER22417 EQ 0 then ER22417=.;
  IF ER22418 GE 8 OR ER22418 EQ 0 then ER22418=.;
  IF ER22419 GE 8 OR ER22419 EQ 0 then ER22419=.;
  IF ER22420 GE 999997 OR ER22420 EQ 0 THEN ER22420=.;
  IF ER22421 GE 8 OR ER22421 EQ 0 then ER22421=.;
  IF ER22422 GE 8 OR ER22422 EQ 0 then ER22422=.;
  IF ER22423 GE 8 OR ER22423 EQ 0 then ER22423=.;
  IF ER22424 GE 8 OR ER22424 EQ 0 then ER22424=.;
  IF ER22425 GE 8 OR ER22425 EQ 0 then ER22425=.;
  IF ER22426 GE 8 OR ER22426 EQ 0 then ER22426=.;
  IF ER22427 GE 8 OR ER22427 EQ 0 then ER22427=.;
  IF ER22428 GE 8 OR ER22428 EQ 0 then ER22428=.;
  IF ER22429 GE 8 OR ER22429 EQ 0 then ER22429=.;
  IF ER22430 GE 8 OR ER22430 EQ 0 then ER22430=.;
  IF ER22431 GE 8 OR ER22431 EQ 0 then ER22431=.;
  IF ER22432 GE 8 OR ER22432 EQ 0 then ER22432=.;
  IF ER22433 GE 8 OR ER22433 EQ 0 then ER22433=.;
  IF ER22434 GE 8 OR ER22434 EQ 0 then ER22434=.;
  IF ER22435 GE 8 OR ER22435 EQ 0 then ER22435=.;
  IF ER22436 GE 999997 OR ER22436 EQ 0 THEN ER22436=.;
  IF ER22437 GE 8 OR ER22437 EQ 0 then ER22437=.;
  IF ER22438 GE 8 OR ER22438 EQ 0 then ER22438=.;
  IF ER22439 GE 8 OR ER22439 EQ 0 then ER22439=.;
  IF ER22440 GE 8 OR ER22440 EQ 0 then ER22440=.;
  IF ER22441 GE 8 OR ER22441 EQ 0 then ER22441=.;
  IF ER22442 GE 8 OR ER22442 EQ 0 then ER22442=.;
  IF ER22443 GE 8 OR ER22443 EQ 0 then ER22443=.;
  IF ER22444 GE 8 OR ER22444 EQ 0 then ER22444=.;
  IF ER22445 GE 8 OR ER22445 EQ 0 then ER22445=.;
  IF ER22446 GE 8 OR ER22446 EQ 0 then ER22446=.;
  IF ER22447 GE 8 OR ER22447 EQ 0 then ER22447=.;
  IF ER22448 GE 8 OR ER22448 EQ 0 then ER22448=.;
  IF ER22449 GE 8 OR ER22449 EQ 0 then ER22449=.;
  IF ER22450 GE 8 OR ER22450 EQ 0 then ER22450=.;
  IF ER22451 GE 8 OR ER22451 EQ 0 then ER22451=.;
  IF ER22452 GE 999997 OR ER22452 EQ 0 THEN ER22452=.;
  IF ER22453 GE 8 OR ER22453 EQ 0 then ER22453=.;
  IF ER22454 GE 8 OR ER22454 EQ 0 then ER22454=.;
  IF ER22455 GE 8 OR ER22455 EQ 0 then ER22455=.;
  IF ER22456 GE 8 OR ER22456 EQ 0 then ER22456=.;
  IF ER22457 GE 8 OR ER22457 EQ 0 then ER22457=.;
  IF ER22458 GE 8 OR ER22458 EQ 0 then ER22458=.;
  IF ER22459 GE 8 OR ER22459 EQ 0 then ER22459=.;
  IF ER22460 GE 8 OR ER22460 EQ 0 then ER22460=.;
  IF ER22461 GE 8 OR ER22461 EQ 0 then ER22461=.;
  IF ER22462 GE 8 OR ER22462 EQ 0 then ER22462=.;
  IF ER22463 GE 8 OR ER22463 EQ 0 then ER22463=.;
  IF ER22464 GE 8 OR ER22464 EQ 0 then ER22464=.;
  IF ER22465 GE 8 OR ER22465 EQ 0 then ER22465=.;
  IF ER22466 GE 8 OR ER22466 EQ 0 then ER22466=.;
  IF ER22467 GE 8 OR ER22467 EQ 0 then ER22467=.;
  IF ER22468 GE 999997 OR ER22468 EQ 0 THEN ER22468=.;
  IF ER22469 GE 8 OR ER22469 EQ 0 then ER22469=.;
  IF ER22470 GE 8 OR ER22470 EQ 0 then ER22470=.;
  IF ER22471 GE 8 OR ER22471 EQ 0 then ER22471=.;
  IF ER22472 GE 8 OR ER22472 EQ 0 then ER22472=.;
  IF ER22473 GE 8 OR ER22473 EQ 0 then ER22473=.;
  IF ER22474 GE 8 OR ER22474 EQ 0 then ER22474=.;
  IF ER22475 GE 8 OR ER22475 EQ 0 then ER22475=.;
  IF ER22476 GE 8 OR ER22476 EQ 0 then ER22476=.;
  IF ER22477 GE 8 OR ER22477 EQ 0 then ER22477=.;
  IF ER22478 GE 8 OR ER22478 EQ 0 then ER22478=.;
  IF ER22479 GE 8 OR ER22479 EQ 0 then ER22479=.;
  IF ER22480 GE 8 OR ER22480 EQ 0 then ER22480=.;
  IF ER22481 GE 8 OR ER22481 EQ 0 then ER22481=.;
  IF ER22482 GE 8 OR ER22482 EQ 0 then ER22482=.;
  IF ER22483 GE 8 OR ER22483 EQ 0 then ER22483=.;
  IF ER22484 GE 999997 OR ER22484 EQ 0 THEN ER22484=.;
  IF ER22485 GE 8 OR ER22485 EQ 0 then ER22485=.;
  IF ER22486 GE 8 OR ER22486 EQ 0 then ER22486=.;
  IF ER22487 GE 8 OR ER22487 EQ 0 then ER22487=.;
  IF ER22488 GE 8 OR ER22488 EQ 0 then ER22488=.;
  IF ER22489 GE 8 OR ER22489 EQ 0 then ER22489=.;
  IF ER22490 GE 8 OR ER22490 EQ 0 then ER22490=.;
  IF ER22491 GE 8 OR ER22491 EQ 0 then ER22491=.;
  IF ER22492 GE 8 OR ER22492 EQ 0 then ER22492=.;
  IF ER22493 GE 8 OR ER22493 EQ 0 then ER22493=.;
  IF ER22494 GE 8 OR ER22494 EQ 0 then ER22494=.;
  IF ER22495 GE 8 OR ER22495 EQ 0 then ER22495=.;
  IF ER22496 GE 8 OR ER22496 EQ 0 then ER22496=.;
  IF ER22497 GE 8 OR ER22497 EQ 0 then ER22497=.;
  IF ER22498 GE 8 OR ER22498 EQ 0 then ER22498=.;
  IF ER22499 GE 8 OR ER22499 EQ 0 then ER22499=.;
  IF ER22500 GE 999997 OR ER22500 EQ 0 THEN ER22500=.;
  IF ER22501 GE 8 OR ER22501 EQ 0 then ER22501=.;
  IF ER22502 GE 8 OR ER22502 EQ 0 then ER22502=.;
  IF ER22503 GE 8 OR ER22503 EQ 0 then ER22503=.;
  IF ER22504 GE 8 OR ER22504 EQ 0 then ER22504=.;
  IF ER22505 GE 8 OR ER22505 EQ 0 then ER22505=.;
  IF ER22506 GE 8 OR ER22506 EQ 0 then ER22506=.;
  IF ER22507 GE 8 OR ER22507 EQ 0 then ER22507=.;
  IF ER22508 GE 8 OR ER22508 EQ 0 then ER22508=.;
  IF ER22509 GE 8 OR ER22509 EQ 0 then ER22509=.;
  IF ER22510 GE 8 OR ER22510 EQ 0 then ER22510=.;
  IF ER22511 GE 8 OR ER22511 EQ 0 then ER22511=.;
  IF ER22512 GE 8 OR ER22512 EQ 0 then ER22512=.;
  IF ER22513 GE 8 OR ER22513 EQ 0 then ER22513=.;
  IF ER22514 GE 8 OR ER22514 EQ 0 then ER22514=.;
  IF ER22515 GE 8 OR ER22515 EQ 0 then ER22515=.;
  IF ER22516 GE 99997 OR ER22516 EQ 0 THEN ER22516=.;
  IF ER22517 GE 8 OR ER22517 EQ 0 then ER22517=.;
  IF ER22518 GE 8 OR ER22518 EQ 0 then ER22518=.;
  IF ER22519 GE 8 OR ER22519 EQ 0 then ER22519=.;
  IF ER22520 GE 8 OR ER22520 EQ 0 then ER22520=.;
  IF ER22521 GE 8 OR ER22521 EQ 0 then ER22521=.;
  IF ER22522 GE 8 OR ER22522 EQ 0 then ER22522=.;
  IF ER22523 GE 8 OR ER22523 EQ 0 then ER22523=.;
  IF ER22524 GE 8 OR ER22524 EQ 0 then ER22524=.;
  IF ER22525 GE 8 OR ER22525 EQ 0 then ER22525=.;
  IF ER22526 GE 8 OR ER22526 EQ 0 then ER22526=.;
  IF ER22527 GE 8 OR ER22527 EQ 0 then ER22527=.;
  IF ER22528 GE 8 OR ER22528 EQ 0 then ER22528=.;
  IF ER22529 GE 8 OR ER22529 EQ 0 then ER22529=.;
  IF ER22530 GE 8 OR ER22530 EQ 0 then ER22530=.;
  IF ER22531 GE 8 OR ER22531 EQ 0 then ER22531=.;
  IF ER22532 GE 9999997 OR ER22532 EQ 0 THEN ER22532=.;
  IF ER22533 GE 9999997 OR ER22533 EQ 0 THEN ER22533=.;
  IF ER22534 GE 8 OR ER22534 EQ 0 then ER22534=.;
  IF ER22535 GE 999997 OR ER22535 EQ 0 THEN ER22535=.;
  IF ER22536 GE 999997 OR ER22536 EQ 0 THEN ER22536=.;
  IF ER22537 GE 8 OR ER22537 EQ 0 then ER22537=.;
  IF ER22538 GE 97 OR ER22538 EQ 0 THEN ER22538=.;
  IF ER22539 GE 97 OR ER22539 EQ 0 THEN ER22539=.;
  IF ER22540 GE 97 OR ER22540 EQ 0 THEN ER22540=.;
  IF ER22541 GE 97 OR ER22541 EQ 0 THEN ER22541=.;
  IF ER22542 GE 97 OR ER22542 EQ 0 THEN ER22542=.;
  IF ER22543 GE 97 OR ER22543 EQ 0 THEN ER22543=.;
  IF ER22544 GE 9999997 OR ER22544 EQ 0 THEN ER22544=.;
  IF ER22545 GE 8 OR ER22545 EQ 0 then ER22545=.;
  IF ER22546 GE 9999997 OR ER22546 EQ 0 THEN ER22546=.;
  IF ER22547 GE 8 OR ER22547 EQ 0 then ER22547=.;
  IF ER22548 GE 9999997 OR ER22548 EQ 0 THEN ER22548=.;
  IF ER22549 GE 8 OR ER22549 EQ 0 then ER22549=.;
  IF ER22550 GE 97 OR ER22550 EQ 0 THEN ER22550=.;
  IF ER22551 GE 8 OR ER22551 EQ 0 then ER22551=.;
  IF ER22552 GE 8 OR ER22552 EQ 0 then ER22552=.;
  IF ER22553 GE 8 OR ER22553 EQ 0 then ER22553=.;
  IF ER22554 GE 999999997 OR ER22554 EQ 0 THEN ER22554=.;
  IF ER22555 GE 8 OR ER22555 EQ 0 then ER22555=.;
  IF ER22556 GE 8 OR ER22556 EQ 0 then ER22556=.;
  IF ER22557 GE 8 OR ER22557 EQ 0 then ER22557=.;
  IF ER22558 GE 999999997 OR ER22558 EQ 0 THEN ER22558=.;
  IF ER22559 GE 8 OR ER22559 EQ 0 then ER22559=.;
  IF ER22560 GE 8 OR ER22560 EQ 0 then ER22560=.;
  IF ER22561 GE 8 OR ER22561 EQ 0 then ER22561=.;
  IF ER22562 GE 8 OR ER22562 EQ 0 then ER22562=.;
  IF ER22563 GE 999999997 OR ER22563 EQ 0 THEN ER22563=.;
  IF ER22564 GE 8 OR ER22564 EQ 0 then ER22564=.;
  IF ER22565 GE 8 OR ER22565 EQ 0 then ER22565=.;
  IF ER22566 GE 8 OR ER22566 EQ 0 then ER22566=.;
  IF ER22567 GE 8 OR ER22567 EQ 0 then ER22567=.;
  IF ER22568 GE 999999997 OR ER22568 EQ 0 THEN ER22568=.;
  IF ER22569 GE 8 OR ER22569 EQ 0 then ER22569=.;
  IF ER22570 GE 8 OR ER22570 EQ 0 then ER22570=.;
  IF ER22571 GE 8 OR ER22571 EQ 0 then ER22571=.;
  IF ER22572 GE 8 OR ER22572 EQ 0 then ER22572=.;
  IF ER22573 GE 8 OR ER22573 EQ 0 then ER22573=.;
  IF ER22574 GE 999997 OR ER22574 EQ 0 THEN ER22574=.;
  IF ER22575 GE 8 OR ER22575 EQ 0 then ER22575=.;
  IF ER22576 GE 8 OR ER22576 EQ 0 then ER22576=.;
  IF ER22577 GE 8 OR ER22577 EQ 0 then ER22577=.;
  IF ER22578 GE 8 OR ER22578 EQ 0 then ER22578=.;
  IF ER22579 GE 8 OR ER22579 EQ 0 then ER22579=.;
  IF ER22580 GE 8 OR ER22580 EQ 0 then ER22580=.;
  IF ER22581 GE 8 OR ER22581 EQ 0 then ER22581=.;
  IF ER22582 GE 8 OR ER22582 EQ 0 then ER22582=.;
  IF ER22583 GE 8 OR ER22583 EQ 0 then ER22583=.;
  IF ER22584 GE 8 OR ER22584 EQ 0 then ER22584=.;
  IF ER22585 GE 8 OR ER22585 EQ 0 then ER22585=.;
  IF ER22586 GE 8 OR ER22586 EQ 0 then ER22586=.;
  IF ER22587 GE 8 OR ER22587 EQ 0 then ER22587=.;
  IF ER22588 GE 8 OR ER22588 EQ 0 then ER22588=.;
  IF ER22589 GE 8 OR ER22589 EQ 0 then ER22589=.;
  IF ER22590 GE 999999997 OR ER22590 EQ 0 THEN ER22590=.;
  IF ER22591 GE 8 OR ER22591 EQ 0 then ER22591=.;
  IF ER22592 GE 8 OR ER22592 EQ 0 then ER22592=.;
  IF ER22593 GE 8 OR ER22593 EQ 0 then ER22593=.;
  IF ER22594 GE 8 OR ER22594 EQ 0 then ER22594=.;
  IF ER22595 GE 8 OR ER22595 EQ 0 then ER22595=.;
  IF ER22596 GE 999999997 OR ER22596 EQ 0 THEN ER22596=.;
  IF ER22597 GE 8 OR ER22597 EQ 0 then ER22597=.;
  IF ER22598 GE 8 OR ER22598 EQ 0 then ER22598=.;
  IF ER22599 GE 8 OR ER22599 EQ 0 then ER22599=.;
  IF ER22600 GE 8 OR ER22600 EQ 0 then ER22600=.;
  IF ER22601 GE 999997 OR ER22601 EQ 0 THEN ER22601=.;
  IF ER22602 GE 8 OR ER22602 EQ 0 then ER22602=.;
  IF ER22603 GE 8 OR ER22603 EQ 0 then ER22603=.;
  IF ER22604 GE 8 OR ER22604 EQ 0 then ER22604=.;
  IF ER22605 GE 8 OR ER22605 EQ 0 then ER22605=.;
  IF ER22606 GE 8 OR ER22606 EQ 0 then ER22606=.;
  IF ER22607 GE 8 OR ER22607 EQ 0 then ER22607=.;
  IF ER22608 GE 8 OR ER22608 EQ 0 then ER22608=.;
  IF ER22609 GE 8 OR ER22609 EQ 0 then ER22609=.;
  IF ER22610 GE 8 OR ER22610 EQ 0 then ER22610=.;
  IF ER22611 GE 8 OR ER22611 EQ 0 then ER22611=.;
  IF ER22612 GE 8 OR ER22612 EQ 0 then ER22612=.;
  IF ER22613 GE 8 OR ER22613 EQ 0 then ER22613=.;
  IF ER22614 GE 8 OR ER22614 EQ 0 then ER22614=.;
  IF ER22615 GE 8 OR ER22615 EQ 0 then ER22615=.;
  IF ER22616 GE 8 OR ER22616 EQ 0 then ER22616=.;
  IF ER22617 GE 999999997 OR ER22617 EQ 0 THEN ER22617=.;
  IF ER22618 GE 8 OR ER22618 EQ 0 then ER22618=.;
  IF ER22619 GE 8 OR ER22619 EQ 0 then ER22619=.;
  IF ER22620 GE 8 OR ER22620 EQ 0 then ER22620=.;
  IF ER22621 GE 8 OR ER22621 EQ 0 then ER22621=.;
  IF ER22622 GE 999999997 OR ER22622 EQ 0 THEN ER22622=.;
  IF ER22623 GE 8 OR ER22623 EQ 0 then ER22623=.;
  IF ER22624 GE 8 OR ER22624 EQ 0 then ER22624=.;
  IF ER22625 GE 8 OR ER22625 EQ 0 then ER22625=.;
  IF ER22626 GE 8 OR ER22626 EQ 0 then ER22626=.;
  IF ER22627 GE 999999997 OR ER22627 EQ 0 THEN ER22627=.;
  IF ER22628 GE 8 OR ER22628 EQ 0 then ER22628=.;
  IF ER22629 GE 8 OR ER22629 EQ 0 then ER22629=.;
  IF ER22630 GE 8 OR ER22630 EQ 0 then ER22630=.;
  IF ER22631 GE 8 OR ER22631 EQ 0 then ER22631=.;
  IF ER22632 GE 999999997 OR ER22632 EQ 0 THEN ER22632=.;
  IF ER22633 GE 8 OR ER22633 EQ 0 then ER22633=.;
  IF ER22634 GE 8 OR ER22634 EQ 0 then ER22634=.;
  IF ER22635 GE 8 OR ER22635 EQ 0 then ER22635=.;
  IF ER22636 GE 8 OR ER22636 EQ 0 then ER22636=.;
  IF ER22637 GE 8 OR ER22637 EQ 0 then ER22637=.;
  IF ER22638 GE 999999997 OR ER22638 EQ 0 THEN ER22638=.;
  IF ER22639 GE 8 OR ER22639 EQ 0 then ER22639=.;
  IF ER22640 GE 8 OR ER22640 EQ 0 then ER22640=.;
  IF ER22641 GE 8 OR ER22641 EQ 0 then ER22641=.;
  IF ER22642 GE 8 OR ER22642 EQ 0 then ER22642=.;
  IF ER22643 GE 999999997 OR ER22643 EQ 0 THEN ER22643=.;
  IF ER22644 GE 8 OR ER22644 EQ 0 then ER22644=.;
  IF ER22645 GE 8 OR ER22645 EQ 0 then ER22645=.;
  IF ER22646 GE 8 OR ER22646 EQ 0 then ER22646=.;
  IF ER22647 GE 8 OR ER22647 EQ 0 then ER22647=.;
  IF ER22648 GE 999999997 OR ER22648 EQ 0 THEN ER22648=.;
  IF ER22649 GE 8 OR ER22649 EQ 0 then ER22649=.;
  IF ER22650 GE 8 OR ER22650 EQ 0 then ER22650=.;
  IF ER22651 GE 8 OR ER22651 EQ 0 then ER22651=.;
  IF ER22652 GE 8 OR ER22652 EQ 0 then ER22652=.;
  IF ER22653 GE 999999997 OR ER22653 EQ 0 THEN ER22653=.;
  IF ER22654 GE 8 OR ER22654 EQ 0 then ER22654=.;
  IF ER22655 GE 8 OR ER22655 EQ 0 then ER22655=.;
  IF ER22656 GE 8 OR ER22656 EQ 0 then ER22656=.;
  IF ER22657 GE 999999997 OR ER22657 EQ 0 THEN ER22657=.;
  IF ER22658 GE 8 OR ER22658 EQ 0 then ER22658=.;
  IF ER22659 GE 8 OR ER22659 EQ 0 then ER22659=.;
  IF ER22660 GE 8 OR ER22660 EQ 0 then ER22660=.;
  IF ER22661 GE 8 OR ER22661 EQ 0 then ER22661=.;
  IF ER22662 GE 999999997 OR ER22662 EQ 0 THEN ER22662=.;
  IF ER22663 GE 8 OR ER22663 EQ 0 then ER22663=.;
  IF ER22664 GE 8 OR ER22664 EQ 0 then ER22664=.;
  IF ER22665 GE 8 OR ER22665 EQ 0 then ER22665=.;
  IF ER22666 GE 8 OR ER22666 EQ 0 then ER22666=.;
  IF ER22667 GE 8 OR ER22667 EQ 0 then ER22667=.;
  IF ER22668 GE 8 OR ER22668 EQ 0 then ER22668=.;
  IF ER22669 GE 999999997 OR ER22669 EQ 0 THEN ER22669=.;
  IF ER22670 GE 8 OR ER22670 EQ 0 then ER22670=.;
  IF ER22671 GE 8 OR ER22671 EQ 0 then ER22671=.;
  IF ER22672 GE 8 OR ER22672 EQ 0 then ER22672=.;
  IF ER22673 GE 8 OR ER22673 EQ 0 then ER22673=.;
  IF ER22674 GE 999999997 OR ER22674 EQ 0 THEN ER22674=.;
  IF ER22675 GE 8 OR ER22675 EQ 0 then ER22675=.;
  IF ER22676 GE 8 OR ER22676 EQ 0 then ER22676=.;
  IF ER22677 GE 8 OR ER22677 EQ 0 then ER22677=.;
  IF ER22678 GE 8 OR ER22678 EQ 0 then ER22678=.;
  IF ER22679 GE 8 OR ER22679 EQ 0 then ER22679=.;
  IF ER22680 GE 999999997 OR ER22680 EQ 0 THEN ER22680=.;
  IF ER22681 GE 8 OR ER22681 EQ 0 then ER22681=.;
  IF ER22682 GE 8 OR ER22682 EQ 0 then ER22682=.;
  IF ER22683 GE 8 OR ER22683 EQ 0 then ER22683=.;
  IF ER22684 GE 8 OR ER22684 EQ 0 then ER22684=.;
  IF ER22685 GE 8 OR ER22685 EQ 0 then ER22685=.;
  IF ER22686 GE 999999997 OR ER22686 EQ 0 THEN ER22686=.;
  IF ER22687 GE 8 OR ER22687 EQ 0 then ER22687=.;
  IF ER22688 GE 8 OR ER22688 EQ 0 then ER22688=.;
  IF ER22689 GE 8 OR ER22689 EQ 0 then ER22689=.;
  IF ER22690 GE 8 OR ER22690 EQ 0 then ER22690=.;
  IF ER22691 GE 999999997 OR ER22691 EQ 0 THEN ER22691=.;
  IF ER22692 GE 8 OR ER22692 EQ 0 then ER22692=.;
  IF ER22693 GE 8 OR ER22693 EQ 0 then ER22693=.;
  IF ER22694 GE 8 OR ER22694 EQ 0 then ER22694=.;
  IF ER22695 GE 8 OR ER22695 EQ 0 then ER22695=.;
  IF ER22696 GE 8 OR ER22696 EQ 0 then ER22696=.;
  IF ER22697 GE 999999997 OR ER22697 EQ 0 THEN ER22697=.;
  IF ER22698 GE 8 OR ER22698 EQ 0 then ER22698=.;
  IF ER22699 GE 8 OR ER22699 EQ 0 then ER22699=.;
  IF ER22700 GE 8 OR ER22700 EQ 0 then ER22700=.;
  IF ER22701 GE 8 OR ER22701 EQ 0 then ER22701=.;
  IF ER22702 GE 999999997 OR ER22702 EQ 0 THEN ER22702=.;
  IF ER22703 GE 8 OR ER22703 EQ 0 then ER22703=.;
  IF ER22704 GE 8 OR ER22704 EQ 0 then ER22704=.;
  IF ER22705 GE 8 OR ER22705 EQ 0 then ER22705=.;
  IF ER22706 GE 8 OR ER22706 EQ 0 then ER22706=.;
  IF ER22707 GE 9997 OR ER22707 EQ 0 THEN ER22707=.;
  IF ER22708 GE 999999997 OR ER22708 EQ 0 THEN ER22708=.;
  IF ER22709 GE 8 OR ER22709 EQ 0 then ER22709=.;
  IF ER22710 GE 8 OR ER22710 EQ 0 then ER22710=.;
  IF ER22711 GE 8 OR ER22711 EQ 0 then ER22711=.;
  IF ER22712 GE 9997 OR ER22712 EQ 0 THEN ER22712=.;
  IF ER22713 GE 999999997 OR ER22713 EQ 0 THEN ER22713=.;
  IF ER22714 GE 8 OR ER22714 EQ 0 then ER22714=.;
  IF ER22715 GE 8 OR ER22715 EQ 0 then ER22715=.;
  IF ER22716 GE 8 OR ER22716 EQ 0 then ER22716=.;
  IF ER22717 GE 9997 OR ER22717 EQ 0 THEN ER22717=.;
  IF ER22718 GE 999999997 OR ER22718 EQ 0 THEN ER22718=.;
  IF ER22719 GE 8 OR ER22719 EQ 0 then ER22719=.;
  IF ER22720 GE 8 OR ER22720 EQ 0 then ER22720=.;
  IF ER22721 GE 8 OR ER22721 EQ 0 then ER22721=.;
  IF ER22722 GE 8 OR ER22722 EQ 0 then ER22722=.;
  IF ER22723 GE 97 OR ER22723 EQ 0 THEN ER22723=.;
  IF ER22724 GE 9997 OR ER22724 EQ 0 THEN ER22724=.;
  IF ER22725 GE 8 OR ER22725 EQ 0 then ER22725=.;
  IF ER22726 GE 997 OR ER22726 EQ 0 THEN ER22726=.;
  IF ER22727 GE 8 OR ER22727 EQ 0 then ER22727=.;
  IF ER22728 GE 997 OR ER22728 EQ 0 THEN ER22728=.;
  IF ER22729 GE 8 OR ER22729 EQ 0 then ER22729=.;
  IF ER22730 GE 8 OR ER22730 EQ 0 then ER22730=.;
  IF ER22731 GE 9999997 OR ER22731 EQ 0 THEN ER22731=.;
  IF ER22732 GE 8 OR ER22732 EQ 0 then ER22732=.;
  IF ER22733 GE 997 OR ER22733 EQ 0 THEN ER22733=.;
  IF ER22734 GE 8 OR ER22734 EQ 0 then ER22734=.;
  IF ER22735 GE 9999997 OR ER22735 EQ 0 THEN ER22735=.;
  IF ER22736 GE 8 OR ER22736 EQ 0 then ER22736=.;
  IF ER22737 GE 997 OR ER22737 EQ 0 THEN ER22737=.;
  IF ER22738 GE 8 OR ER22738 EQ 0 then ER22738=.;
  IF ER22739 GE 8 OR ER22739 EQ 0 then ER22739=.;
  IF ER22740 GE 9999997 OR ER22740 EQ 0 THEN ER22740=.;
  IF ER22741 GE 8 OR ER22741 EQ 0 then ER22741=.;
  IF ER22742 GE 997 OR ER22742 EQ 0 THEN ER22742=.;
  IF ER22743 GE 997 OR ER22743 EQ 0 THEN ER22743=.;
  IF ER22744 GE 999999997 OR ER22744 EQ 0 THEN ER22744=.;
  IF ER22745 GE 8 OR ER22745 EQ 0 then ER22745=.;
  IF ER22746 GE 999999997 OR ER22746 EQ 0 THEN ER22746=.;
  IF ER22747 GE 8 OR ER22747 EQ 0 then ER22747=.;
  IF ER22748 GE 997 OR ER22748 EQ 0 THEN ER22748=.;
  IF ER22749 GE 8 OR ER22749 EQ 0 then ER22749=.;
  IF ER22750 GE 8 OR ER22750 EQ 0 then ER22750=.;
  IF ER22751 GE 997 OR ER22751 EQ 0 THEN ER22751=.;
  IF ER22752 GE 997 OR ER22752 EQ 0 THEN ER22752=.;
  IF ER22753 GE 997 OR ER22753 EQ 0 THEN ER22753=.;
  IF ER22754 GE 997 OR ER22754 EQ 0 THEN ER22754=.;
  IF ER22755 GE 8 OR ER22755 EQ 0 then ER22755=.;
  IF ER22756 GE 8 OR ER22756 EQ 0 then ER22756=.;
  IF ER22757 GE 997 OR ER22757 EQ 0 THEN ER22757=.;
  IF ER22758 GE 997 OR ER22758 EQ 0 THEN ER22758=.;
  IF ER22759 GE 997 OR ER22759 EQ 0 THEN ER22759=.;
  IF ER22760 GE 997 OR ER22760 EQ 0 THEN ER22760=.;
  IF ER22761 GE 997 OR ER22761 EQ 0 THEN ER22761=.;
  IF ER22762 GE 8 OR ER22762 EQ 0 then ER22762=.;
  IF ER22763 GE 9999997 OR ER22763 EQ 0 THEN ER22763=.;
  IF ER22764 GE 8 OR ER22764 EQ 0 then ER22764=.;
  IF ER22765 GE 997 OR ER22765 EQ 0 THEN ER22765=.;
  IF ER22766 GE 999999997 OR ER22766 EQ 0 THEN ER22766=.;
  IF ER22767 GE 8 OR ER22767 EQ 0 then ER22767=.;
  IF ER22768 GE 8 OR ER22768 EQ 0 then ER22768=.;
  IF ER22769 GE 8 OR ER22769 EQ 0 then ER22769=.;
  IF ER22770 GE 8 OR ER22770 EQ 0 then ER22770=.;
  IF ER22771 GE 97 OR ER22771 EQ 0 THEN ER22771=.;
  IF ER22772 GE 97 OR ER22772 EQ 0 THEN ER22772=.;
  IF ER22773 GE 997 OR ER22773 EQ 0 THEN ER22773=.;
  IF ER22774 GE 9997 OR ER22774 EQ 0 THEN ER22774=.;
  IF ER22775 GE 997 OR ER22775 EQ 0 THEN ER22775=.;
  IF ER22776 GE 9997 OR ER22776 EQ 0 THEN ER22776=.;
  IF ER22777 GE 8 OR ER22777 EQ 0 then ER22777=.;
  IF ER22778 GE 8 OR ER22778 EQ 0 then ER22778=.;
  IF ER22779 GE 9999997 OR ER22779 EQ 0 THEN ER22779=.;
  IF ER22780 GE 8 OR ER22780 EQ 0 then ER22780=.;
  IF ER22781 GE 997 OR ER22781 EQ 0 THEN ER22781=.;
  IF ER22782 GE 8 OR ER22782 EQ 0 then ER22782=.;
  IF ER22783 GE 8 OR ER22783 EQ 0 then ER22783=.;
  IF ER22784 GE 99999997 OR ER22784 EQ 0 THEN ER22784=.;
  IF ER22785 GE 8 OR ER22785 EQ 0 then ER22785=.;
  IF ER22786 GE 99999997 OR ER22786 EQ 0 THEN ER22786=.;
  IF ER22787 GE 97 OR ER22787 EQ 0 THEN ER22787=.;
  IF ER22788 GE 9999997 OR ER22788 EQ 0 THEN ER22788=.;
  IF ER22789 GE 8 OR ER22789 EQ 0 then ER22789=.;
  IF ER22790 GE 8 OR ER22790 EQ 0 then ER22790=.;
  IF ER22791 GE 8 OR ER22791 EQ 0 then ER22791=.;
  IF ER22792 GE 8 OR ER22792 EQ 0 then ER22792=.;
  IF ER22793 GE 8 OR ER22793 EQ 0 then ER22793=.;
  IF ER22794 GE 8 OR ER22794 EQ 0 then ER22794=.;
  IF ER22795 GE 8 OR ER22795 EQ 0 then ER22795=.;
  IF ER22796 GE 97 OR ER22796 EQ 0 THEN ER22796=.;
  IF ER22797 GE 9997 OR ER22797 EQ 0 THEN ER22797=.;
  IF ER22798 GE 9999997 OR ER22798 EQ 0 THEN ER22798=.;
  IF ER22799 GE 8 OR ER22799 EQ 0 then ER22799=.;
  IF ER22800 GE 8 OR ER22800 EQ 0 then ER22800=.;
  IF ER22801 GE 8 OR ER22801 EQ 0 then ER22801=.;
  IF ER22802 GE 9999997 OR ER22802 EQ 0 THEN ER22802=.;
  IF ER22803 GE 8 OR ER22803 EQ 0 then ER22803=.;
  IF ER22804 GE 8 OR ER22804 EQ 0 then ER22804=.;
  IF ER22805 GE 8 OR ER22805 EQ 0 then ER22805=.;
  IF ER22806 GE 8 OR ER22806 EQ 0 then ER22806=.;
  IF ER22807 GE 8 OR ER22807 EQ 0 then ER22807=.;
  IF ER22808 GE 8 OR ER22808 EQ 0 then ER22808=.;
  IF ER22809 GE 9999997 OR ER22809 EQ 0 THEN ER22809=.;
  IF ER22810 GE 97 OR ER22810 EQ 0 THEN ER22810=.;
  IF ER22811 GE 97 OR ER22811 EQ 0 THEN ER22811=.;
  IF ER22812 GE 999997 OR ER22812 EQ 0 THEN ER22812=.;
  IF ER22813 GE 8 OR ER22813 EQ 0 then ER22813=.;
  IF ER22814 GE 997 OR ER22814 EQ 0 THEN ER22814=.;
  IF ER22815 GE 99999997 OR ER22815 EQ 0 THEN ER22815=.;
  IF ER22816 GE 9999997 OR ER22816 EQ 0 THEN ER22816=.;
  IF ER22817 GE 8 OR ER22817 EQ 0 then ER22817=.;
  IF ER22818 GE 99999997 OR ER22818 EQ 0 THEN ER22818=.;
  IF ER22819 GE 97 OR ER22819 EQ 0 THEN ER22819=.;
  IF ER22820 GE 9999997 OR ER22820 EQ 0 THEN ER22820=.;
  IF ER22821 GE 8 OR ER22821 EQ 0 then ER22821=.;
  IF ER22822 GE 97 OR ER22822 EQ 0 THEN ER22822=.;
  IF ER22823 GE 8 OR ER22823 EQ 0 then ER22823=.;
  IF ER22824 GE 8 OR ER22824 EQ 0 then ER22824=.;
  IF ER22825 GE 99999997 OR ER22825 EQ 0 THEN ER22825=.;
  IF ER22826 GE 8 OR ER22826 EQ 0 then ER22826=.;
  IF ER22827 GE 99999997 OR ER22827 EQ 0 THEN ER22827=.;
  IF ER22828 GE 97 OR ER22828 EQ 0 THEN ER22828=.;
  IF ER22829 GE 9999997 OR ER22829 EQ 0 THEN ER22829=.;
  IF ER22830 GE 8 OR ER22830 EQ 0 then ER22830=.;
  IF ER22831 GE 8 OR ER22831 EQ 0 then ER22831=.;
  IF ER22832 GE 8 OR ER22832 EQ 0 then ER22832=.;
  IF ER22833 GE 8 OR ER22833 EQ 0 then ER22833=.;
  IF ER22834 GE 8 OR ER22834 EQ 0 then ER22834=.;
  IF ER22835 GE 8 OR ER22835 EQ 0 then ER22835=.;
  IF ER22836 GE 8 OR ER22836 EQ 0 then ER22836=.;
  IF ER22837 GE 97 OR ER22837 EQ 0 THEN ER22837=.;
  IF ER22838 GE 9997 OR ER22838 EQ 0 THEN ER22838=.;
  IF ER22839 GE 9999997 OR ER22839 EQ 0 THEN ER22839=.;
  IF ER22840 GE 8 OR ER22840 EQ 0 then ER22840=.;
  IF ER22841 GE 8 OR ER22841 EQ 0 then ER22841=.;
  IF ER22842 GE 8 OR ER22842 EQ 0 then ER22842=.;
  IF ER22843 GE 9999997 OR ER22843 EQ 0 THEN ER22843=.;
  IF ER22844 GE 8 OR ER22844 EQ 0 then ER22844=.;
  IF ER22845 GE 8 OR ER22845 EQ 0 then ER22845=.;
  IF ER22846 GE 8 OR ER22846 EQ 0 then ER22846=.;
  IF ER22847 GE 8 OR ER22847 EQ 0 then ER22847=.;
  IF ER22848 GE 8 OR ER22848 EQ 0 then ER22848=.;
  IF ER22849 GE 8 OR ER22849 EQ 0 then ER22849=.;
  IF ER22850 GE 9999997 OR ER22850 EQ 0 THEN ER22850=.;
  IF ER22851 GE 97 OR ER22851 EQ 0 THEN ER22851=.;
  IF ER22852 GE 97 OR ER22852 EQ 0 THEN ER22852=.;
  IF ER22853 GE 999997 OR ER22853 EQ 0 THEN ER22853=.;
  IF ER22854 GE 8 OR ER22854 EQ 0 then ER22854=.;
  IF ER22855 GE 997 OR ER22855 EQ 0 THEN ER22855=.;
  IF ER22856 GE 99999997 OR ER22856 EQ 0 THEN ER22856=.;
  IF ER22857 GE 9999997 OR ER22857 EQ 0 THEN ER22857=.;
  IF ER22858 GE 8 OR ER22858 EQ 0 then ER22858=.;
  IF ER22859 GE 99999997 OR ER22859 EQ 0 THEN ER22859=.;
  IF ER22860 GE 97 OR ER22860 EQ 0 THEN ER22860=.;
  IF ER22861 GE 9999997 OR ER22861 EQ 0 THEN ER22861=.;
  IF ER22862 GE 8 OR ER22862 EQ 0 then ER22862=.;
  IF ER22863 GE 97 OR ER22863 EQ 0 THEN ER22863=.;
  IF ER22864 GE 8 OR ER22864 EQ 0 then ER22864=.;
  IF ER22865 GE 8 OR ER22865 EQ 0 then ER22865=.;
  IF ER22866 GE 8 OR ER22866 EQ 0 then ER22866=.;
  IF ER22867 GE 97 OR ER22867 EQ 0 THEN ER22867=.;
  IF ER22868 GE 9997 OR ER22868 EQ 0 THEN ER22868=.;
  IF ER22869 GE 8 OR ER22869 EQ 0 then ER22869=.;
  IF ER22870 GE 997 OR ER22870 EQ 0 THEN ER22870=.;
  IF ER22871 GE 8 OR ER22871 EQ 0 then ER22871=.;
  IF ER22872 GE 997 OR ER22872 EQ 0 THEN ER22872=.;
  IF ER22873 GE 8 OR ER22873 EQ 0 then ER22873=.;
  IF ER22874 GE 8 OR ER22874 EQ 0 then ER22874=.;
  IF ER22875 GE 9999997 OR ER22875 EQ 0 THEN ER22875=.;
  IF ER22876 GE 8 OR ER22876 EQ 0 then ER22876=.;
  IF ER22877 GE 997 OR ER22877 EQ 0 THEN ER22877=.;
  IF ER22878 GE 8 OR ER22878 EQ 0 then ER22878=.;
  IF ER22879 GE 9999997 OR ER22879 EQ 0 THEN ER22879=.;
  IF ER22880 GE 8 OR ER22880 EQ 0 then ER22880=.;
  IF ER22881 GE 997 OR ER22881 EQ 0 THEN ER22881=.;
  IF ER22882 GE 8 OR ER22882 EQ 0 then ER22882=.;
  IF ER22883 GE 8 OR ER22883 EQ 0 then ER22883=.;
  IF ER22884 GE 9999997 OR ER22884 EQ 0 THEN ER22884=.;
  IF ER22885 GE 8 OR ER22885 EQ 0 then ER22885=.;
  IF ER22886 GE 997 OR ER22886 EQ 0 THEN ER22886=.;
  IF ER22887 GE 997 OR ER22887 EQ 0 THEN ER22887=.;
  IF ER22888 GE 999999997 OR ER22888 EQ 0 THEN ER22888=.;
  IF ER22889 GE 8 OR ER22889 EQ 0 then ER22889=.;
  IF ER22890 GE 999999997 OR ER22890 EQ 0 THEN ER22890=.;
  IF ER22891 GE 8 OR ER22891 EQ 0 then ER22891=.;
  IF ER22892 GE 997 OR ER22892 EQ 0 THEN ER22892=.;
  IF ER22893 GE 8 OR ER22893 EQ 0 then ER22893=.;
  IF ER22894 GE 8 OR ER22894 EQ 0 then ER22894=.;
  IF ER22895 GE 997 OR ER22895 EQ 0 THEN ER22895=.;
  IF ER22896 GE 997 OR ER22896 EQ 0 THEN ER22896=.;
  IF ER22897 GE 997 OR ER22897 EQ 0 THEN ER22897=.;
  IF ER22898 GE 997 OR ER22898 EQ 0 THEN ER22898=.;
  IF ER22899 GE 8 OR ER22899 EQ 0 then ER22899=.;
  IF ER22900 GE 8 OR ER22900 EQ 0 then ER22900=.;
  IF ER22901 GE 997 OR ER22901 EQ 0 THEN ER22901=.;
  IF ER22902 GE 997 OR ER22902 EQ 0 THEN ER22902=.;
  IF ER22903 GE 997 OR ER22903 EQ 0 THEN ER22903=.;
  IF ER22904 GE 997 OR ER22904 EQ 0 THEN ER22904=.;
  IF ER22905 GE 997 OR ER22905 EQ 0 THEN ER22905=.;
  IF ER22906 GE 8 OR ER22906 EQ 0 then ER22906=.;
  IF ER22907 GE 9999997 OR ER22907 EQ 0 THEN ER22907=.;
  IF ER22908 GE 8 OR ER22908 EQ 0 then ER22908=.;
  IF ER22909 GE 997 OR ER22909 EQ 0 THEN ER22909=.;
  IF ER22910 GE 999999997 OR ER22910 EQ 0 THEN ER22910=.;
  IF ER22911 GE 8 OR ER22911 EQ 0 then ER22911=.;
  IF ER22912 GE 8 OR ER22912 EQ 0 then ER22912=.;
  IF ER22913 GE 8 OR ER22913 EQ 0 then ER22913=.;
  IF ER22914 GE 8 OR ER22914 EQ 0 then ER22914=.;
  IF ER22915 GE 97 OR ER22915 EQ 0 THEN ER22915=.;
  IF ER22916 GE 97 OR ER22916 EQ 0 THEN ER22916=.;
  IF ER22917 GE 997 OR ER22917 EQ 0 THEN ER22917=.;
  IF ER22918 GE 9997 OR ER22918 EQ 0 THEN ER22918=.;
  IF ER22919 GE 997 OR ER22919 EQ 0 THEN ER22919=.;
  IF ER22920 GE 9997 OR ER22920 EQ 0 THEN ER22920=.;
  IF ER22921 GE 8 OR ER22921 EQ 0 then ER22921=.;
  IF ER22922 GE 8 OR ER22922 EQ 0 then ER22922=.;
  IF ER22923 GE 9999997 OR ER22923 EQ 0 THEN ER22923=.;
  IF ER22924 GE 8 OR ER22924 EQ 0 then ER22924=.;
  IF ER22925 GE 997 OR ER22925 EQ 0 THEN ER22925=.;
  IF ER22926 GE 8 OR ER22926 EQ 0 then ER22926=.;
  IF ER22927 GE 8 OR ER22927 EQ 0 then ER22927=.;
  IF ER22928 GE 99999997 OR ER22928 EQ 0 THEN ER22928=.;
  IF ER22929 GE 8 OR ER22929 EQ 0 then ER22929=.;
  IF ER22930 GE 99999997 OR ER22930 EQ 0 THEN ER22930=.;
  IF ER22931 GE 97 OR ER22931 EQ 0 THEN ER22931=.;
  IF ER22932 GE 9999997 OR ER22932 EQ 0 THEN ER22932=.;
  IF ER22933 GE 8 OR ER22933 EQ 0 then ER22933=.;
  IF ER22934 GE 8 OR ER22934 EQ 0 then ER22934=.;
  IF ER22935 GE 8 OR ER22935 EQ 0 then ER22935=.;
  IF ER22936 GE 8 OR ER22936 EQ 0 then ER22936=.;
  IF ER22937 GE 8 OR ER22937 EQ 0 then ER22937=.;
  IF ER22938 GE 8 OR ER22938 EQ 0 then ER22938=.;
  IF ER22939 GE 8 OR ER22939 EQ 0 then ER22939=.;
  IF ER22940 GE 97 OR ER22940 EQ 0 THEN ER22940=.;
  IF ER22941 GE 9997 OR ER22941 EQ 0 THEN ER22941=.;
  IF ER22942 GE 9999997 OR ER22942 EQ 0 THEN ER22942=.;
  IF ER22943 GE 8 OR ER22943 EQ 0 then ER22943=.;
  IF ER22944 GE 8 OR ER22944 EQ 0 then ER22944=.;
  IF ER22945 GE 8 OR ER22945 EQ 0 then ER22945=.;
  IF ER22946 GE 9999997 OR ER22946 EQ 0 THEN ER22946=.;
  IF ER22947 GE 8 OR ER22947 EQ 0 then ER22947=.;
  IF ER22948 GE 8 OR ER22948 EQ 0 then ER22948=.;
  IF ER22949 GE 8 OR ER22949 EQ 0 then ER22949=.;
  IF ER22950 GE 8 OR ER22950 EQ 0 then ER22950=.;
  IF ER22951 GE 8 OR ER22951 EQ 0 then ER22951=.;
  IF ER22952 GE 8 OR ER22952 EQ 0 then ER22952=.;
  IF ER22953 GE 9999997 OR ER22953 EQ 0 THEN ER22953=.;
  IF ER22954 GE 97 OR ER22954 EQ 0 THEN ER22954=.;
  IF ER22955 GE 97 OR ER22955 EQ 0 THEN ER22955=.;
  IF ER22956 GE 999997 OR ER22956 EQ 0 THEN ER22956=.;
  IF ER22957 GE 8 OR ER22957 EQ 0 then ER22957=.;
  IF ER22958 GE 997 OR ER22958 EQ 0 THEN ER22958=.;
  IF ER22959 GE 99999997 OR ER22959 EQ 0 THEN ER22959=.;
  IF ER22960 GE 9999997 OR ER22960 EQ 0 THEN ER22960=.;
  IF ER22961 GE 8 OR ER22961 EQ 0 then ER22961=.;
  IF ER22962 GE 99999997 OR ER22962 EQ 0 THEN ER22962=.;
  IF ER22963 GE 97 OR ER22963 EQ 0 THEN ER22963=.;
  IF ER22964 GE 9999997 OR ER22964 EQ 0 THEN ER22964=.;
  IF ER22965 GE 8 OR ER22965 EQ 0 then ER22965=.;
  IF ER22966 GE 97 OR ER22966 EQ 0 THEN ER22966=.;
  IF ER22967 GE 8 OR ER22967 EQ 0 then ER22967=.;
  IF ER22968 GE 8 OR ER22968 EQ 0 then ER22968=.;
  IF ER22969 GE 99999997 OR ER22969 EQ 0 THEN ER22969=.;
  IF ER22970 GE 8 OR ER22970 EQ 0 then ER22970=.;
  IF ER22971 GE 99999997 OR ER22971 EQ 0 THEN ER22971=.;
  IF ER22972 GE 97 OR ER22972 EQ 0 THEN ER22972=.;
  IF ER22973 GE 9999997 OR ER22973 EQ 0 THEN ER22973=.;
  IF ER22974 GE 8 OR ER22974 EQ 0 then ER22974=.;
  IF ER22975 GE 8 OR ER22975 EQ 0 then ER22975=.;
  IF ER22976 GE 8 OR ER22976 EQ 0 then ER22976=.;
  IF ER22977 GE 8 OR ER22977 EQ 0 then ER22977=.;
  IF ER22978 GE 8 OR ER22978 EQ 0 then ER22978=.;
  IF ER22979 GE 8 OR ER22979 EQ 0 then ER22979=.;
  IF ER22980 GE 8 OR ER22980 EQ 0 then ER22980=.;
  IF ER22981 GE 97 OR ER22981 EQ 0 THEN ER22981=.;
  IF ER22982 GE 9997 OR ER22982 EQ 0 THEN ER22982=.;
  IF ER22983 GE 9999997 OR ER22983 EQ 0 THEN ER22983=.;
  IF ER22984 GE 8 OR ER22984 EQ 0 then ER22984=.;
  IF ER22985 GE 8 OR ER22985 EQ 0 then ER22985=.;
  IF ER22986 GE 8 OR ER22986 EQ 0 then ER22986=.;
  IF ER22987 GE 9999997 OR ER22987 EQ 0 THEN ER22987=.;
  IF ER22988 GE 8 OR ER22988 EQ 0 then ER22988=.;
  IF ER22989 GE 8 OR ER22989 EQ 0 then ER22989=.;
  IF ER22990 GE 8 OR ER22990 EQ 0 then ER22990=.;
  IF ER22991 GE 8 OR ER22991 EQ 0 then ER22991=.;
  IF ER22992 GE 8 OR ER22992 EQ 0 then ER22992=.;
  IF ER22993 GE 8 OR ER22993 EQ 0 then ER22993=.;
  IF ER22994 GE 9999997 OR ER22994 EQ 0 THEN ER22994=.;
  IF ER22995 GE 97 OR ER22995 EQ 0 THEN ER22995=.;
  IF ER22996 GE 97 OR ER22996 EQ 0 THEN ER22996=.;
  IF ER22997 GE 999997 OR ER22997 EQ 0 THEN ER22997=.;
  IF ER22998 GE 8 OR ER22998 EQ 0 then ER22998=.;
  IF ER22999 GE 997 OR ER22999 EQ 0 THEN ER22999=.;
  IF ER23000 GE 99999997 OR ER23000 EQ 0 THEN ER23000=.;
  IF ER23001 GE 9999997 OR ER23001 EQ 0 THEN ER23001=.;
  IF ER23002 GE 8 OR ER23002 EQ 0 then ER23002=.;
  IF ER23003 GE 99999997 OR ER23003 EQ 0 THEN ER23003=.;
  IF ER23004 GE 97 OR ER23004 EQ 0 THEN ER23004=.;
  IF ER23005 GE 9999997 OR ER23005 EQ 0 THEN ER23005=.;
  IF ER23006 GE 8 OR ER23006 EQ 0 then ER23006=.;
  IF ER23007 GE 97 OR ER23007 EQ 0 THEN ER23007=.;
  IF ER23008 GE 8 OR ER23008 EQ 0 then ER23008=.;
  IF ER23009 GE 8 OR ER23009 EQ 0 then ER23009=.;
  IF ER23010 GE 8 OR ER23010 EQ 0 then ER23010=.;
  IF ER23011 GE 8 OR ER23011 EQ 0 then ER23011=.;
  IF ER23012 GE 8 OR ER23012 EQ 0 then ER23012=.;
  IF ER23013 GE 8 OR ER23013 EQ 0 then ER23013=.;
  IF ER23014 GE 8 OR ER23014 EQ 0 then ER23014=.;
  IF ER23015 GE 8 OR ER23015 EQ 0 then ER23015=.;
  IF ER23016 GE 8 OR ER23016 EQ 0 then ER23016=.;
  IF ER23017 GE 8 OR ER23017 EQ 0 then ER23017=.;
  IF ER23018 GE 97 OR ER23018 EQ 0 THEN ER23018=.;
  IF ER23019 GE 97 OR ER23019 EQ 0 THEN ER23019=.;
  IF ER23020 GE 97 OR ER23020 EQ 0 THEN ER23020=.;
  IF ER23021 GE 97 OR ER23021 EQ 0 THEN ER23021=.;
  IF ER23022 GE 8 OR ER23022 EQ 0 then ER23022=.;
  IF ER23023 GE 8 OR ER23023 EQ 0 then ER23023=.;
  IF ER23024 GE 97 OR ER23024 EQ 0 THEN ER23024=.;
  IF ER23025 GE 97 OR ER23025 EQ 0 THEN ER23025=.;
  IF ER23026 GE 97 OR ER23026 EQ 0 THEN ER23026=.;
  IF ER23027 GE 97 OR ER23027 EQ 0 THEN ER23027=.;
  IF ER23028 GE 8 OR ER23028 EQ 0 then ER23028=.;
  IF ER23029 GE 8 OR ER23029 EQ 0 then ER23029=.;
  IF ER23030 GE 97 OR ER23030 EQ 0 THEN ER23030=.;
  IF ER23031 GE 97 OR ER23031 EQ 0 THEN ER23031=.;
  IF ER23032 GE 97 OR ER23032 EQ 0 THEN ER23032=.;
  IF ER23033 GE 97 OR ER23033 EQ 0 THEN ER23033=.;
  IF ER23034 GE 8 OR ER23034 EQ 0 then ER23034=.;
  IF ER23035 GE 8 OR ER23035 EQ 0 then ER23035=.;
  IF ER23036 GE 97 OR ER23036 EQ 0 THEN ER23036=.;
  IF ER23037 GE 97 OR ER23037 EQ 0 THEN ER23037=.;
  IF ER23038 GE 97 OR ER23038 EQ 0 THEN ER23038=.;
  IF ER23039 GE 97 OR ER23039 EQ 0 THEN ER23039=.;
  IF ER23040 GE 8 OR ER23040 EQ 0 then ER23040=.;
  IF ER23041 GE 8 OR ER23041 EQ 0 then ER23041=.;
  IF ER23042 GE 97 OR ER23042 EQ 0 THEN ER23042=.;
  IF ER23043 GE 97 OR ER23043 EQ 0 THEN ER23043=.;
  IF ER23044 GE 97 OR ER23044 EQ 0 THEN ER23044=.;
  IF ER23045 GE 97 OR ER23045 EQ 0 THEN ER23045=.;
  IF ER23046 GE 8 OR ER23046 EQ 0 then ER23046=.;
  IF ER23047 GE 8 OR ER23047 EQ 0 then ER23047=.;
  IF ER23048 GE 97 OR ER23048 EQ 0 THEN ER23048=.;
  IF ER23049 GE 97 OR ER23049 EQ 0 THEN ER23049=.;
  IF ER23050 GE 97 OR ER23050 EQ 0 THEN ER23050=.;
  IF ER23051 GE 97 OR ER23051 EQ 0 THEN ER23051=.;
  IF ER23052 GE 8 OR ER23052 EQ 0 then ER23052=.;
  IF ER23053 GE 8 OR ER23053 EQ 0 then ER23053=.;
  IF ER23054 GE 97 OR ER23054 EQ 0 THEN ER23054=.;
  IF ER23055 GE 97 OR ER23055 EQ 0 THEN ER23055=.;
  IF ER23056 GE 97 OR ER23056 EQ 0 THEN ER23056=.;
  IF ER23057 GE 97 OR ER23057 EQ 0 THEN ER23057=.;
  IF ER23058 GE 8 OR ER23058 EQ 0 then ER23058=.;
  IF ER23059 GE 8 OR ER23059 EQ 0 then ER23059=.;
  IF ER23060 GE 97 OR ER23060 EQ 0 THEN ER23060=.;
  IF ER23061 GE 97 OR ER23061 EQ 0 THEN ER23061=.;
  IF ER23062 GE 97 OR ER23062 EQ 0 THEN ER23062=.;
  IF ER23063 GE 97 OR ER23063 EQ 0 THEN ER23063=.;
  IF ER23064 GE 8 OR ER23064 EQ 0 then ER23064=.;
  IF ER23065 GE 8 OR ER23065 EQ 0 then ER23065=.;
  IF ER23066 GE 97 OR ER23066 EQ 0 THEN ER23066=.;
  IF ER23067 GE 97 OR ER23067 EQ 0 THEN ER23067=.;
  IF ER23068 GE 97 OR ER23068 EQ 0 THEN ER23068=.;
  IF ER23069 GE 97 OR ER23069 EQ 0 THEN ER23069=.;
  IF ER23070 GE 8 OR ER23070 EQ 0 then ER23070=.;
  IF ER23071 GE 8 OR ER23071 EQ 0 then ER23071=.;
  IF ER23072 GE 97 OR ER23072 EQ 0 THEN ER23072=.;
  IF ER23073 GE 97 OR ER23073 EQ 0 THEN ER23073=.;
  IF ER23074 GE 97 OR ER23074 EQ 0 THEN ER23074=.;
  IF ER23075 GE 97 OR ER23075 EQ 0 THEN ER23075=.;
  IF ER23076 GE 8 OR ER23076 EQ 0 then ER23076=.;
  IF ER23077 GE 8 OR ER23077 EQ 0 then ER23077=.;
  IF ER23078 GE 97 OR ER23078 EQ 0 THEN ER23078=.;
  IF ER23079 GE 97 OR ER23079 EQ 0 THEN ER23079=.;
  IF ER23080 GE 97 OR ER23080 EQ 0 THEN ER23080=.;
  IF ER23081 GE 97 OR ER23081 EQ 0 THEN ER23081=.;
  IF ER23082 GE 8 OR ER23082 EQ 0 then ER23082=.;
  IF ER23083 GE 8 OR ER23083 EQ 0 then ER23083=.;
  IF ER23084 GE 97 OR ER23084 EQ 0 THEN ER23084=.;
  IF ER23085 GE 97 OR ER23085 EQ 0 THEN ER23085=.;
  IF ER23086 GE 97 OR ER23086 EQ 0 THEN ER23086=.;
  IF ER23087 GE 97 OR ER23087 EQ 0 THEN ER23087=.;
  IF ER23088 GE 8 OR ER23088 EQ 0 then ER23088=.;
  IF ER23089 GE 8 OR ER23089 EQ 0 then ER23089=.;
  IF ER23090 GE 997 OR ER23090 EQ 0 THEN ER23090=.;
  IF ER23091 GE 97 OR ER23091 EQ 0 THEN ER23091=.;
  IF ER23092 GE 8 OR ER23092 EQ 0 then ER23092=.;
  IF ER23093 GE 8 OR ER23093 EQ 0 then ER23093=.;
  IF ER23094 GE 8 OR ER23094 EQ 0 then ER23094=.;
  IF ER23095 GE 8 OR ER23095 EQ 0 then ER23095=.;
  IF ER23096 GE 8 OR ER23096 EQ 0 then ER23096=.;
  IF ER23097 GE 8 OR ER23097 EQ 0 then ER23097=.;
  IF ER23098 GE 8 OR ER23098 EQ 0 then ER23098=.;
  IF ER23099 GE 8 OR ER23099 EQ 0 then ER23099=.;
  IF ER23100 GE 8 OR ER23100 EQ 0 then ER23100=.;
  IF ER23101 GE 8 OR ER23101 EQ 0 then ER23101=.;
  IF ER23102 GE 8 OR ER23102 EQ 0 then ER23102=.;
  IF ER23103 GE 8 OR ER23103 EQ 0 then ER23103=.;
  IF ER23104 GE 8 OR ER23104 EQ 0 then ER23104=.;
  IF ER23105 GE 8 OR ER23105 EQ 0 then ER23105=.;
  IF ER23106 GE 8 OR ER23106 EQ 0 then ER23106=.;
  IF ER23107 GE 8 OR ER23107 EQ 0 then ER23107=.;
  IF ER23108 GE 8 OR ER23108 EQ 0 then ER23108=.;
  IF ER23109 GE 8 OR ER23109 EQ 0 then ER23109=.;
  IF ER23110 GE 8 OR ER23110 EQ 0 then ER23110=.;
  IF ER23111 GE 8 OR ER23111 EQ 0 then ER23111=.;
  IF ER23112 GE 8 OR ER23112 EQ 0 then ER23112=.;
  IF ER23113 GE 8 OR ER23113 EQ 0 then ER23113=.;
  IF ER23114 GE 8 OR ER23114 EQ 0 then ER23114=.;
  IF ER23115 GE 8 OR ER23115 EQ 0 then ER23115=.;
  IF ER23116 GE 8 OR ER23116 EQ 0 then ER23116=.;
  IF ER23117 GE 8 OR ER23117 EQ 0 then ER23117=.;
  IF ER23118 GE 997 OR ER23118 EQ 0 THEN ER23118=.;
  IF ER23119 GE 8 OR ER23119 EQ 0 then ER23119=.;
  IF ER23120 GE 997 OR ER23120 EQ 0 THEN ER23120=.;
  IF ER23121 GE 8 OR ER23121 EQ 0 then ER23121=.;
  IF ER23122 GE 8 OR ER23122 EQ 0 then ER23122=.;
  IF ER23123 GE 8 OR ER23123 EQ 0 then ER23123=.;
  IF ER23124 GE 997 OR ER23124 EQ 0 THEN ER23124=.;
  IF ER23125 GE 97 OR ER23125 EQ 0 THEN ER23125=.;
  IF ER23126 GE 8 OR ER23126 EQ 0 then ER23126=.;
  IF ER23127 GE 997 OR ER23127 EQ 0 THEN ER23127=.;
  IF ER23128 GE 97 OR ER23128 EQ 0 THEN ER23128=.;
  IF ER23129 GE 97 OR ER23129 EQ 0 THEN ER23129=.;
  IF ER23130 GE 8 OR ER23130 EQ 0 then ER23130=.;
  IF ER23131 GE 8 OR ER23131 EQ 0 then ER23131=.;
  IF ER23132 GE 997 OR ER23132 EQ 0 THEN ER23132=.;
  IF ER23133 GE 8 OR ER23133 EQ 0 then ER23133=.;
  IF ER23134 GE 97 OR ER23134 EQ 0 THEN ER23134=.;
  IF ER23135 GE 8 OR ER23135 EQ 0 then ER23135=.;
  IF ER23136 GE 8 OR ER23136 EQ 0 then ER23136=.;
  IF ER23137 GE 8 OR ER23137 EQ 0 then ER23137=.;
  IF ER23138 GE 8 OR ER23138 EQ 0 then ER23138=.;
  IF ER23139 GE 8 OR ER23139 EQ 0 then ER23139=.;
  IF ER23140 GE 8 OR ER23140 EQ 0 then ER23140=.;
  IF ER23141 GE 8 OR ER23141 EQ 0 then ER23141=.;
  IF ER23142 GE 8 OR ER23142 EQ 0 then ER23142=.;
  IF ER23143 GE 8 OR ER23143 EQ 0 then ER23143=.;
  IF ER23144 GE 8 OR ER23144 EQ 0 then ER23144=.;
  IF ER23145 GE 97 OR ER23145 EQ 0 THEN ER23145=.;
  IF ER23146 GE 97 OR ER23146 EQ 0 THEN ER23146=.;
  IF ER23147 GE 97 OR ER23147 EQ 0 THEN ER23147=.;
  IF ER23148 GE 97 OR ER23148 EQ 0 THEN ER23148=.;
  IF ER23149 GE 8 OR ER23149 EQ 0 then ER23149=.;
  IF ER23150 GE 8 OR ER23150 EQ 0 then ER23150=.;
  IF ER23151 GE 97 OR ER23151 EQ 0 THEN ER23151=.;
  IF ER23152 GE 97 OR ER23152 EQ 0 THEN ER23152=.;
  IF ER23153 GE 97 OR ER23153 EQ 0 THEN ER23153=.;
  IF ER23154 GE 97 OR ER23154 EQ 0 THEN ER23154=.;
  IF ER23155 GE 8 OR ER23155 EQ 0 then ER23155=.;
  IF ER23156 GE 8 OR ER23156 EQ 0 then ER23156=.;
  IF ER23157 GE 97 OR ER23157 EQ 0 THEN ER23157=.;
  IF ER23158 GE 97 OR ER23158 EQ 0 THEN ER23158=.;
  IF ER23159 GE 97 OR ER23159 EQ 0 THEN ER23159=.;
  IF ER23160 GE 97 OR ER23160 EQ 0 THEN ER23160=.;
  IF ER23161 GE 8 OR ER23161 EQ 0 then ER23161=.;
  IF ER23162 GE 8 OR ER23162 EQ 0 then ER23162=.;
  IF ER23163 GE 97 OR ER23163 EQ 0 THEN ER23163=.;
  IF ER23164 GE 97 OR ER23164 EQ 0 THEN ER23164=.;
  IF ER23165 GE 97 OR ER23165 EQ 0 THEN ER23165=.;
  IF ER23166 GE 97 OR ER23166 EQ 0 THEN ER23166=.;
  IF ER23167 GE 8 OR ER23167 EQ 0 then ER23167=.;
  IF ER23168 GE 8 OR ER23168 EQ 0 then ER23168=.;
  IF ER23169 GE 97 OR ER23169 EQ 0 THEN ER23169=.;
  IF ER23170 GE 97 OR ER23170 EQ 0 THEN ER23170=.;
  IF ER23171 GE 97 OR ER23171 EQ 0 THEN ER23171=.;
  IF ER23172 GE 97 OR ER23172 EQ 0 THEN ER23172=.;
  IF ER23173 GE 8 OR ER23173 EQ 0 then ER23173=.;
  IF ER23174 GE 8 OR ER23174 EQ 0 then ER23174=.;
  IF ER23175 GE 97 OR ER23175 EQ 0 THEN ER23175=.;
  IF ER23176 GE 97 OR ER23176 EQ 0 THEN ER23176=.;
  IF ER23177 GE 97 OR ER23177 EQ 0 THEN ER23177=.;
  IF ER23178 GE 97 OR ER23178 EQ 0 THEN ER23178=.;
  IF ER23179 GE 8 OR ER23179 EQ 0 then ER23179=.;
  IF ER23180 GE 8 OR ER23180 EQ 0 then ER23180=.;
  IF ER23181 GE 97 OR ER23181 EQ 0 THEN ER23181=.;
  IF ER23182 GE 97 OR ER23182 EQ 0 THEN ER23182=.;
  IF ER23183 GE 97 OR ER23183 EQ 0 THEN ER23183=.;
  IF ER23184 GE 97 OR ER23184 EQ 0 THEN ER23184=.;
  IF ER23185 GE 8 OR ER23185 EQ 0 then ER23185=.;
  IF ER23186 GE 8 OR ER23186 EQ 0 then ER23186=.;
  IF ER23187 GE 97 OR ER23187 EQ 0 THEN ER23187=.;
  IF ER23188 GE 97 OR ER23188 EQ 0 THEN ER23188=.;
  IF ER23189 GE 97 OR ER23189 EQ 0 THEN ER23189=.;
  IF ER23190 GE 97 OR ER23190 EQ 0 THEN ER23190=.;
  IF ER23191 GE 8 OR ER23191 EQ 0 then ER23191=.;
  IF ER23192 GE 8 OR ER23192 EQ 0 then ER23192=.;
  IF ER23193 GE 97 OR ER23193 EQ 0 THEN ER23193=.;
  IF ER23194 GE 97 OR ER23194 EQ 0 THEN ER23194=.;
  IF ER23195 GE 97 OR ER23195 EQ 0 THEN ER23195=.;
  IF ER23196 GE 97 OR ER23196 EQ 0 THEN ER23196=.;
  IF ER23197 GE 8 OR ER23197 EQ 0 then ER23197=.;
  IF ER23198 GE 8 OR ER23198 EQ 0 then ER23198=.;
  IF ER23199 GE 97 OR ER23199 EQ 0 THEN ER23199=.;
  IF ER23200 GE 97 OR ER23200 EQ 0 THEN ER23200=.;
  IF ER23201 GE 97 OR ER23201 EQ 0 THEN ER23201=.;
  IF ER23202 GE 97 OR ER23202 EQ 0 THEN ER23202=.;
  IF ER23203 GE 8 OR ER23203 EQ 0 then ER23203=.;
  IF ER23204 GE 8 OR ER23204 EQ 0 then ER23204=.;
  IF ER23205 GE 97 OR ER23205 EQ 0 THEN ER23205=.;
  IF ER23206 GE 97 OR ER23206 EQ 0 THEN ER23206=.;
  IF ER23207 GE 97 OR ER23207 EQ 0 THEN ER23207=.;
  IF ER23208 GE 97 OR ER23208 EQ 0 THEN ER23208=.;
  IF ER23209 GE 8 OR ER23209 EQ 0 then ER23209=.;
  IF ER23210 GE 8 OR ER23210 EQ 0 then ER23210=.;
  IF ER23211 GE 97 OR ER23211 EQ 0 THEN ER23211=.;
  IF ER23212 GE 97 OR ER23212 EQ 0 THEN ER23212=.;
  IF ER23213 GE 97 OR ER23213 EQ 0 THEN ER23213=.;
  IF ER23214 GE 97 OR ER23214 EQ 0 THEN ER23214=.;
  IF ER23215 GE 8 OR ER23215 EQ 0 then ER23215=.;
  IF ER23216 GE 8 OR ER23216 EQ 0 then ER23216=.;
  IF ER23217 GE 997 OR ER23217 EQ 0 THEN ER23217=.;
  IF ER23218 GE 97 OR ER23218 EQ 0 THEN ER23218=.;
  IF ER23219 GE 8 OR ER23219 EQ 0 then ER23219=.;
  IF ER23220 GE 8 OR ER23220 EQ 0 then ER23220=.;
  IF ER23221 GE 8 OR ER23221 EQ 0 then ER23221=.;
  IF ER23222 GE 8 OR ER23222 EQ 0 then ER23222=.;
  IF ER23223 GE 8 OR ER23223 EQ 0 then ER23223=.;
  IF ER23224 GE 8 OR ER23224 EQ 0 then ER23224=.;
  IF ER23225 GE 8 OR ER23225 EQ 0 then ER23225=.;
  IF ER23226 GE 8 OR ER23226 EQ 0 then ER23226=.;
  IF ER23227 GE 8 OR ER23227 EQ 0 then ER23227=.;
  IF ER23228 GE 8 OR ER23228 EQ 0 then ER23228=.;
  IF ER23229 GE 8 OR ER23229 EQ 0 then ER23229=.;
  IF ER23230 GE 8 OR ER23230 EQ 0 then ER23230=.;
  IF ER23231 GE 8 OR ER23231 EQ 0 then ER23231=.;
  IF ER23232 GE 8 OR ER23232 EQ 0 then ER23232=.;
  IF ER23233 GE 8 OR ER23233 EQ 0 then ER23233=.;
  IF ER23234 GE 8 OR ER23234 EQ 0 then ER23234=.;
  IF ER23235 GE 8 OR ER23235 EQ 0 then ER23235=.;
  IF ER23236 GE 8 OR ER23236 EQ 0 then ER23236=.;
  IF ER23237 GE 8 OR ER23237 EQ 0 then ER23237=.;
  IF ER23238 GE 8 OR ER23238 EQ 0 then ER23238=.;
  IF ER23239 GE 8 OR ER23239 EQ 0 then ER23239=.;
  IF ER23240 GE 8 OR ER23240 EQ 0 then ER23240=.;
  IF ER23241 GE 8 OR ER23241 EQ 0 then ER23241=.;
  IF ER23242 GE 8 OR ER23242 EQ 0 then ER23242=.;
  IF ER23243 GE 8 OR ER23243 EQ 0 then ER23243=.;
  IF ER23244 GE 8 OR ER23244 EQ 0 then ER23244=.;
  IF ER23245 GE 997 OR ER23245 EQ 0 THEN ER23245=.;
  IF ER23246 GE 8 OR ER23246 EQ 0 then ER23246=.;
  IF ER23247 GE 997 OR ER23247 EQ 0 THEN ER23247=.;
  IF ER23248 GE 8 OR ER23248 EQ 0 then ER23248=.;
  IF ER23249 GE 8 OR ER23249 EQ 0 then ER23249=.;
  IF ER23250 GE 8 OR ER23250 EQ 0 then ER23250=.;
  IF ER23251 GE 997 OR ER23251 EQ 0 THEN ER23251=.;
  IF ER23252 GE 97 OR ER23252 EQ 0 THEN ER23252=.;
  IF ER23253 GE 8 OR ER23253 EQ 0 then ER23253=.;
  IF ER23254 GE 997 OR ER23254 EQ 0 THEN ER23254=.;
  IF ER23255 GE 97 OR ER23255 EQ 0 THEN ER23255=.;
  IF ER23256 GE 97 OR ER23256 EQ 0 THEN ER23256=.;
  IF ER23257 GE 8 OR ER23257 EQ 0 then ER23257=.;
  IF ER23258 GE 8 OR ER23258 EQ 0 then ER23258=.;
  IF ER23259 GE 997 OR ER23259 EQ 0 THEN ER23259=.;
  IF ER23260 GE 8 OR ER23260 EQ 0 then ER23260=.;
  IF ER23261 GE 97 OR ER23261 EQ 0 THEN ER23261=.;
  IF ER23262 GE 8 OR ER23262 EQ 0 then ER23262=.;
  IF ER23263 GE 8 OR ER23263 EQ 0 then ER23263=.;
  IF ER23264 GE 8 OR ER23264 EQ 0 then ER23264=.;
  IF ER23265 GE 8 OR ER23265 EQ 0 then ER23265=.;
  IF ER23266 GE 8 OR ER23266 EQ 0 then ER23266=.;
  IF ER23267 GE 8 OR ER23267 EQ 0 then ER23267=.;
  IF ER23268 GE 97 OR ER23268 EQ 0 THEN ER23268=.;
  IF ER23269 GE 8 OR ER23269 EQ 0 then ER23269=.;
  IF ER23270 GE 8 OR ER23270 EQ 0 then ER23270=.;
  IF ER23271 GE 8 OR ER23271 EQ 0 then ER23271=.;
  IF ER23272 GE 8 OR ER23272 EQ 0 then ER23272=.;
  IF ER23273 GE 97 OR ER23273 EQ 0 THEN ER23273=.;
  IF ER23274 GE 97 OR ER23274 EQ 0 THEN ER23274=.;
  IF ER23275 GE 8 OR ER23275 EQ 0 then ER23275=.;
  IF ER23276 GE 8 OR ER23276 EQ 0 then ER23276=.;
  IF ER23277 GE 8 OR ER23277 EQ 0 then ER23277=.;
  IF ER23278 GE 999997 OR ER23278 EQ 0 THEN ER23278=.;
  IF ER23279 GE 999997 OR ER23279 EQ 0 THEN ER23279=.;
  IF ER23280 GE 8 OR ER23280 EQ 0 then ER23280=.;
  IF ER23281 GE 8 OR ER23281 EQ 0 then ER23281=.;
  IF ER23282 GE 8 OR ER23282 EQ 0 then ER23282=.;
  IF ER23283 GE 8 OR ER23283 EQ 0 then ER23283=.;
  IF ER23284 GE 8 OR ER23284 EQ 0 then ER23284=.;
  IF ER23285 GE 9999997 OR ER23285 EQ 0 THEN ER23285=.;
  IF ER23286 GE 8 OR ER23286 EQ 0 then ER23286=.;
  IF ER23287 GE 8 OR ER23287 EQ 0 then ER23287=.;
  IF ER23288 GE 8 OR ER23288 EQ 0 then ER23288=.;
  IF ER23289 GE 8 OR ER23289 EQ 0 then ER23289=.;
  IF ER23290 GE 8 OR ER23290 EQ 0 then ER23290=.;
  IF ER23291 GE 9999997 OR ER23291 EQ 0 THEN ER23291=.;
  IF ER23292 GE 8 OR ER23292 EQ 0 then ER23292=.;
  IF ER23293 GE 8 OR ER23293 EQ 0 then ER23293=.;
  IF ER23294 GE 8 OR ER23294 EQ 0 then ER23294=.;
  IF ER23295 GE 8 OR ER23295 EQ 0 then ER23295=.;
  IF ER23296 GE 8 OR ER23296 EQ 0 then ER23296=.;
  IF ER23297 GE 99999997 OR ER23297 EQ 0 THEN ER23297=.;
  IF ER23298 GE 8 OR ER23298 EQ 0 then ER23298=.;
  IF ER23299 GE 8 OR ER23299 EQ 0 then ER23299=.;
  IF ER23300 GE 8 OR ER23300 EQ 0 then ER23300=.;
  IF ER23301 GE 8 OR ER23301 EQ 0 then ER23301=.;
  IF ER23302 GE 8 OR ER23302 EQ 0 then ER23302=.;
  IF ER23303 GE 8 OR ER23303 EQ 0 then ER23303=.;
  IF ER23304 GE 97 OR ER23304 EQ 0 THEN ER23304=.;
  IF ER23305 GE 97 OR ER23305 EQ 0 THEN ER23305=.;
  IF ER23306 GE 8 OR ER23306 EQ 0 then ER23306=.;
  IF ER23307 GE 97 OR ER23307 EQ 0 THEN ER23307=.;
  IF ER23308 GE 8 OR ER23308 EQ 0 then ER23308=.;
  IF ER23309 GE 8 OR ER23309 EQ 0 then ER23309=.;
  IF ER23310 GE 97 OR ER23310 EQ 0 THEN ER23310=.;
  IF ER23311 GE 997 OR ER23311 EQ 0 THEN ER23311=.;
  IF ER23312 GE 997 OR ER23312 EQ 0 THEN ER23312=.;
  IF ER23313 GE 97 OR ER23313 EQ 0 THEN ER23313=.;
  IF ER23314 GE 97 OR ER23314 EQ 0 THEN ER23314=.;
  IF ER23315 GE 8 OR ER23315 EQ 0 then ER23315=.;
  IF ER23316 GE 97 OR ER23316 EQ 0 THEN ER23316=.;
  IF ER23317 GE 8 OR ER23317 EQ 0 then ER23317=.;
  IF ER23318 GE 8 OR ER23318 EQ 0 then ER23318=.;
  IF ER23319 GE 97 OR ER23319 EQ 0 THEN ER23319=.;
  IF ER23320 GE 997 OR ER23320 EQ 0 THEN ER23320=.;
  IF ER23321 GE 997 OR ER23321 EQ 0 THEN ER23321=.;
  IF ER23322 GE 8 OR ER23322 EQ 0 then ER23322=.;
  IF ER23323 GE 97 OR ER23323 EQ 0 THEN ER23323=.;
  IF ER23324 GE 8 OR ER23324 EQ 0 then ER23324=.;
  IF ER23325 GE 8 OR ER23325 EQ 0 then ER23325=.;
  IF ER23326 GE 97 OR ER23326 EQ 0 THEN ER23326=.;
  IF ER23327 GE 8 OR ER23327 EQ 0 then ER23327=.;
  IF ER23328 GE 8 OR ER23328 EQ 0 then ER23328=.;
  IF ER23329 GE 97 OR ER23329 EQ 0 THEN ER23329=.;
  IF ER23330 GE 8 OR ER23330 EQ 0 then ER23330=.;
  IF ER23331 GE 8 OR ER23331 EQ 0 then ER23331=.;
  IF ER23332 GE 97 OR ER23332 EQ 0 THEN ER23332=.;
  IF ER23333 GE 8 OR ER23333 EQ 0 then ER23333=.;
  IF ER23334 GE 8 OR ER23334 EQ 0 then ER23334=.;
  IF ER23335 GE 8 OR ER23335 EQ 0 then ER23335=.;
  IF ER23336 GE 8 OR ER23336 EQ 0 then ER23336=.;
  IF ER23337 GE 8 OR ER23337 EQ 0 then ER23337=.;
  IF ER23338 GE 8 OR ER23338 EQ 0 then ER23338=.;
  IF ER23339 GE 97 OR ER23339 EQ 0 THEN ER23339=.;
  IF ER23340 GE 97 OR ER23340 EQ 0 THEN ER23340=.;
  IF ER23341 GE 8 OR ER23341 EQ 0 then ER23341=.;
  IF ER23342 GE 8 OR ER23342 EQ 0 then ER23342=.;
  IF ER23343 GE 8 OR ER23343 EQ 0 then ER23343=.;
  IF ER23344 GE 97 OR ER23344 EQ 0 THEN ER23344=.;
  IF ER23345 GE 9997 OR ER23345 EQ 0 THEN ER23345=.;
  IF ER23346 GE 97 OR ER23346 EQ 0 THEN ER23346=.;
  IF ER23347 GE 97 OR ER23347 EQ 0 THEN ER23347=.;
  IF ER23348 GE 9997 OR ER23348 EQ 0 THEN ER23348=.;
  IF ER23349 GE 97 OR ER23349 EQ 0 THEN ER23349=.;
  IF ER23350 GE 9997 OR ER23350 EQ 0 THEN ER23350=.;
  IF ER23351 GE 97 OR ER23351 EQ 0 THEN ER23351=.;
  IF ER23352 GE 97 OR ER23352 EQ 0 THEN ER23352=.;
  IF ER23353 GE 9997 OR ER23353 EQ 0 THEN ER23353=.;
  IF ER23354 GE 8 OR ER23354 EQ 0 then ER23354=.;
  IF ER23355 GE 97 OR ER23355 EQ 0 THEN ER23355=.;
  IF ER23356 GE 9997 OR ER23356 EQ 0 THEN ER23356=.;
  IF ER23357 GE 8 OR ER23357 EQ 0 then ER23357=.;
  IF ER23358 GE 8 OR ER23358 EQ 0 then ER23358=.;
  IF ER23359 GE 97 OR ER23359 EQ 0 THEN ER23359=.;
  IF ER23360 GE 97 OR ER23360 EQ 0 THEN ER23360=.;
  IF ER23361 GE 9997 OR ER23361 EQ 0 THEN ER23361=.;
  IF ER23362 GE 97 OR ER23362 EQ 0 THEN ER23362=.;
  IF ER23363 GE 8 OR ER23363 EQ 0 then ER23363=.;
  IF ER23364 GE 8 OR ER23364 EQ 0 then ER23364=.;
  IF ER23365 GE 97 OR ER23365 EQ 0 THEN ER23365=.;
  IF ER23366 GE 97 OR ER23366 EQ 0 THEN ER23366=.;
  IF ER23367 GE 97 OR ER23367 EQ 0 THEN ER23367=.;
  IF ER23368 GE 9997 OR ER23368 EQ 0 THEN ER23368=.;
  IF ER23369 GE 8 OR ER23369 EQ 0 then ER23369=.;
  IF ER23370 GE 8 OR ER23370 EQ 0 then ER23370=.;
  IF ER23371 GE 97 OR ER23371 EQ 0 THEN ER23371=.;
  IF ER23372 GE 97 OR ER23372 EQ 0 THEN ER23372=.;
  IF ER23373 GE 97 OR ER23373 EQ 0 THEN ER23373=.;
  IF ER23374 GE 9997 OR ER23374 EQ 0 THEN ER23374=.;
  IF ER23375 GE 8 OR ER23375 EQ 0 then ER23375=.;
  IF ER23376 GE 8 OR ER23376 EQ 0 then ER23376=.;
  IF ER23377 GE 97 OR ER23377 EQ 0 THEN ER23377=.;
  IF ER23378 GE 97 OR ER23378 EQ 0 THEN ER23378=.;
  IF ER23379 GE 97 OR ER23379 EQ 0 THEN ER23379=.;
  IF ER23380 GE 9997 OR ER23380 EQ 0 THEN ER23380=.;
  IF ER23381 GE 8 OR ER23381 EQ 0 then ER23381=.;
  IF ER23382 GE 97 OR ER23382 EQ 0 THEN ER23382=.;
  IF ER23383 GE 97 OR ER23383 EQ 0 THEN ER23383=.;
  IF ER23384 GE 97 OR ER23384 EQ 0 THEN ER23384=.;
  IF ER23385 GE 97 OR ER23385 EQ 0 THEN ER23385=.;
  IF ER23386 GE 997 OR ER23386 EQ 0 THEN ER23386=.;
  IF ER23387 GE 997 OR ER23387 EQ 0 THEN ER23387=.;
  IF ER23388 GE 8 OR ER23388 EQ 0 then ER23388=.;
  IF ER23389 GE 97 OR ER23389 EQ 0 THEN ER23389=.;
  IF ER23390 GE 97 OR ER23390 EQ 0 THEN ER23390=.;
  IF ER23391 GE 8 OR ER23391 EQ 0 then ER23391=.;
  IF ER23392 GE 97 OR ER23392 EQ 0 THEN ER23392=.;
  IF ER23393 GE 8 OR ER23393 EQ 0 then ER23393=.;
  IF ER23394 GE 8 OR ER23394 EQ 0 then ER23394=.;
  IF ER23395 GE 97 OR ER23395 EQ 0 THEN ER23395=.;
  IF ER23396 GE 997 OR ER23396 EQ 0 THEN ER23396=.;
  IF ER23397 GE 997 OR ER23397 EQ 0 THEN ER23397=.;
  IF ER23398 GE 97 OR ER23398 EQ 0 THEN ER23398=.;
  IF ER23399 GE 97 OR ER23399 EQ 0 THEN ER23399=.;
  IF ER23400 GE 8 OR ER23400 EQ 0 then ER23400=.;
  IF ER23401 GE 97 OR ER23401 EQ 0 THEN ER23401=.;
  IF ER23402 GE 8 OR ER23402 EQ 0 then ER23402=.;
  IF ER23403 GE 8 OR ER23403 EQ 0 then ER23403=.;
  IF ER23404 GE 97 OR ER23404 EQ 0 THEN ER23404=.;
  IF ER23405 GE 997 OR ER23405 EQ 0 THEN ER23405=.;
  IF ER23406 GE 997 OR ER23406 EQ 0 THEN ER23406=.;
  IF ER23407 GE 8 OR ER23407 EQ 0 then ER23407=.;
  IF ER23408 GE 97 OR ER23408 EQ 0 THEN ER23408=.;
  IF ER23409 GE 8 OR ER23409 EQ 0 then ER23409=.;
  IF ER23410 GE 8 OR ER23410 EQ 0 then ER23410=.;
  IF ER23411 GE 97 OR ER23411 EQ 0 THEN ER23411=.;
  IF ER23412 GE 8 OR ER23412 EQ 0 then ER23412=.;
  IF ER23413 GE 8 OR ER23413 EQ 0 then ER23413=.;
  IF ER23414 GE 97 OR ER23414 EQ 0 THEN ER23414=.;
  IF ER23415 GE 8 OR ER23415 EQ 0 then ER23415=.;
  IF ER23416 GE 8 OR ER23416 EQ 0 then ER23416=.;
  IF ER23417 GE 97 OR ER23417 EQ 0 THEN ER23417=.;
  IF ER23418 GE 8 OR ER23418 EQ 0 then ER23418=.;
  IF ER23419 GE 8 OR ER23419 EQ 0 then ER23419=.;
  IF ER23420 GE 97 OR ER23420 EQ 0 THEN ER23420=.;
  IF ER23421 GE 8 OR ER23421 EQ 0 then ER23421=.;
  IF ER23422 GE 8 OR ER23422 EQ 0 then ER23422=.;
  IF ER23423 GE 8 OR ER23423 EQ 0 then ER23423=.;
  IF ER23424 GE 8 OR ER23424 EQ 0 then ER23424=.;
  IF ER23425 GE 8 OR ER23425 EQ 0 then ER23425=.;
  IF ER23426 GE 8 OR ER23426 EQ 0 then ER23426=.;
  IF ER23427 GE 8 OR ER23427 EQ 0 then ER23427=.;
  IF ER23428 GE 8 OR ER23428 EQ 0 then ER23428=.;
  IF ER23429 GE 8 OR ER23429 EQ 0 then ER23429=.;
  IF ER23430 GE 8 OR ER23430 EQ 0 then ER23430=.;
  IF ER23431 GE 97 OR ER23431 EQ 0 THEN ER23431=.;
  IF ER23432 GE 97 OR ER23432 EQ 0 THEN ER23432=.;
  IF ER23433 GE 8 OR ER23433 EQ 0 then ER23433=.;
  IF ER23434 GE 8 OR ER23434 EQ 0 then ER23434=.;
  IF ER23435 GE 8 OR ER23435 EQ 0 then ER23435=.;
  IF ER23436 GE 97 OR ER23436 EQ 0 THEN ER23436=.;
  IF ER23437 GE 9997 OR ER23437 EQ 0 THEN ER23437=.;
  IF ER23438 GE 97 OR ER23438 EQ 0 THEN ER23438=.;
  IF ER23439 GE 97 OR ER23439 EQ 0 THEN ER23439=.;
  IF ER23440 GE 9997 OR ER23440 EQ 0 THEN ER23440=.;
  IF ER23441 GE 97 OR ER23441 EQ 0 THEN ER23441=.;
  IF ER23442 GE 9997 OR ER23442 EQ 0 THEN ER23442=.;
  IF ER23443 GE 97 OR ER23443 EQ 0 THEN ER23443=.;
  IF ER23444 GE 97 OR ER23444 EQ 0 THEN ER23444=.;
  IF ER23445 GE 9997 OR ER23445 EQ 0 THEN ER23445=.;
  IF ER23446 GE 8 OR ER23446 EQ 0 then ER23446=.;
  IF ER23447 GE 97 OR ER23447 EQ 0 THEN ER23447=.;
  IF ER23448 GE 9997 OR ER23448 EQ 0 THEN ER23448=.;
  IF ER23449 GE 8 OR ER23449 EQ 0 then ER23449=.;
  IF ER23450 GE 8 OR ER23450 EQ 0 then ER23450=.;
  IF ER23451 GE 97 OR ER23451 EQ 0 THEN ER23451=.;
  IF ER23452 GE 97 OR ER23452 EQ 0 THEN ER23452=.;
  IF ER23453 GE 9997 OR ER23453 EQ 0 THEN ER23453=.;
  IF ER23454 GE 97 OR ER23454 EQ 0 THEN ER23454=.;
  IF ER23455 GE 8 OR ER23455 EQ 0 then ER23455=.;
  IF ER23456 GE 8 OR ER23456 EQ 0 then ER23456=.;
  IF ER23457 GE 97 OR ER23457 EQ 0 THEN ER23457=.;
  IF ER23458 GE 97 OR ER23458 EQ 0 THEN ER23458=.;
  IF ER23459 GE 97 OR ER23459 EQ 0 THEN ER23459=.;
  IF ER23460 GE 9997 OR ER23460 EQ 0 THEN ER23460=.;
  IF ER23461 GE 8 OR ER23461 EQ 0 then ER23461=.;
  IF ER23462 GE 8 OR ER23462 EQ 0 then ER23462=.;
  IF ER23463 GE 97 OR ER23463 EQ 0 THEN ER23463=.;
  IF ER23464 GE 97 OR ER23464 EQ 0 THEN ER23464=.;
  IF ER23465 GE 97 OR ER23465 EQ 0 THEN ER23465=.;
  IF ER23466 GE 9997 OR ER23466 EQ 0 THEN ER23466=.;
  IF ER23467 GE 8 OR ER23467 EQ 0 then ER23467=.;
  IF ER23468 GE 8 OR ER23468 EQ 0 then ER23468=.;
  IF ER23469 GE 97 OR ER23469 EQ 0 THEN ER23469=.;
  IF ER23470 GE 97 OR ER23470 EQ 0 THEN ER23470=.;
  IF ER23471 GE 97 OR ER23471 EQ 0 THEN ER23471=.;
  IF ER23472 GE 9997 OR ER23472 EQ 0 THEN ER23472=.;
  IF ER23473 GE 8 OR ER23473 EQ 0 then ER23473=.;
  IF ER23474 GE 97 OR ER23474 EQ 0 THEN ER23474=.;
  IF ER23475 GE 97 OR ER23475 EQ 0 THEN ER23475=.;
  IF ER23476 GE 97 OR ER23476 EQ 0 THEN ER23476=.;
  IF ER23477 GE 97 OR ER23477 EQ 0 THEN ER23477=.;
  IF ER23478 GE 997 OR ER23478 EQ 0 THEN ER23478=.;
  IF ER23479 GE 997 OR ER23479 EQ 0 THEN ER23479=.;
  IF ER23480 GE 8 OR ER23480 EQ 0 then ER23480=.;
  IF ER23481 GE 8 OR ER23481 EQ 0 then ER23481=.;
  IF ER23482 GE 8 OR ER23482 EQ 0 then ER23482=.;
  IF ER23483 GE 999997 OR ER23483 EQ 0 THEN ER23483=.;
  IF ER23484 GE 8 OR ER23484 EQ 0 then ER23484=.;
  IF ER23485 GE 8 OR ER23485 EQ 0 then ER23485=.;
  IF ER23486 GE 8 OR ER23486 EQ 0 then ER23486=.;
  IF ER23487 GE 8 OR ER23487 EQ 0 then ER23487=.;
  IF ER23488 GE 8 OR ER23488 EQ 0 then ER23488=.;
  IF ER23489 GE 999997 OR ER23489 EQ 0 THEN ER23489=.;
  IF ER23490 GE 8 OR ER23490 EQ 0 then ER23490=.;
  IF ER23491 GE 8 OR ER23491 EQ 0 then ER23491=.;
  IF ER23492 GE 8 OR ER23492 EQ 0 then ER23492=.;
  IF ER23493 GE 8 OR ER23493 EQ 0 then ER23493=.;
  IF ER23494 GE 8 OR ER23494 EQ 0 then ER23494=.;
  IF ER23495 GE 99997 OR ER23495 EQ 0 THEN ER23495=.;
  IF ER23496 GE 8 OR ER23496 EQ 0 then ER23496=.;
  IF ER23497 GE 8 OR ER23497 EQ 0 then ER23497=.;
  IF ER23498 GE 8 OR ER23498 EQ 0 then ER23498=.;
  IF ER23499 GE 8 OR ER23499 EQ 0 then ER23499=.;
  IF ER23500 GE 8 OR ER23500 EQ 0 then ER23500=.;
  IF ER23501 GE 99997 OR ER23501 EQ 0 THEN ER23501=.;
  IF ER23502 GE 8 OR ER23502 EQ 0 then ER23502=.;
  IF ER23503 GE 8 OR ER23503 EQ 0 then ER23503=.;
  IF ER23504 GE 8 OR ER23504 EQ 0 then ER23504=.;
  IF ER23505 GE 8 OR ER23505 EQ 0 then ER23505=.;
  IF ER23506 GE 8 OR ER23506 EQ 0 then ER23506=.;
  IF ER23507 GE 99997 OR ER23507 EQ 0 THEN ER23507=.;
  IF ER23508 GE 8 OR ER23508 EQ 0 then ER23508=.;
  IF ER23509 GE 8 OR ER23509 EQ 0 then ER23509=.;
  IF ER23510 GE 8 OR ER23510 EQ 0 then ER23510=.;
  IF ER23511 GE 8 OR ER23511 EQ 0 then ER23511=.;
  IF ER23512 GE 8 OR ER23512 EQ 0 then ER23512=.;
  IF ER23513 GE 99997 OR ER23513 EQ 0 THEN ER23513=.;
  IF ER23514 GE 8 OR ER23514 EQ 0 then ER23514=.;
  IF ER23515 GE 8 OR ER23515 EQ 0 then ER23515=.;
  IF ER23516 GE 8 OR ER23516 EQ 0 then ER23516=.;
  IF ER23517 GE 8 OR ER23517 EQ 0 then ER23517=.;
  IF ER23518 GE 8 OR ER23518 EQ 0 then ER23518=.;
  IF ER23519 GE 99997 OR ER23519 EQ 0 THEN ER23519=.;
  IF ER23520 GE 8 OR ER23520 EQ 0 then ER23520=.;
  IF ER23521 GE 8 OR ER23521 EQ 0 then ER23521=.;
  IF ER23522 GE 8 OR ER23522 EQ 0 then ER23522=.;
  IF ER23523 GE 8 OR ER23523 EQ 0 then ER23523=.;
  IF ER23524 GE 8 OR ER23524 EQ 0 then ER23524=.;
  IF ER23525 GE 99997 OR ER23525 EQ 0 THEN ER23525=.;
  IF ER23526 GE 8 OR ER23526 EQ 0 then ER23526=.;
  IF ER23527 GE 8 OR ER23527 EQ 0 then ER23527=.;
  IF ER23528 GE 8 OR ER23528 EQ 0 then ER23528=.;
  IF ER23529 GE 8 OR ER23529 EQ 0 then ER23529=.;
  IF ER23530 GE 8 OR ER23530 EQ 0 then ER23530=.;
  IF ER23531 GE 99997 OR ER23531 EQ 0 THEN ER23531=.;
  IF ER23532 GE 8 OR ER23532 EQ 0 then ER23532=.;
  IF ER23533 GE 8 OR ER23533 EQ 0 then ER23533=.;
  IF ER23534 GE 8 OR ER23534 EQ 0 then ER23534=.;
  IF ER23535 GE 8 OR ER23535 EQ 0 then ER23535=.;
  IF ER23536 GE 8 OR ER23536 EQ 0 then ER23536=.;
  IF ER23537 GE 99997 OR ER23537 EQ 0 THEN ER23537=.;
  IF ER23538 GE 8 OR ER23538 EQ 0 then ER23538=.;
  IF ER23539 GE 8 OR ER23539 EQ 0 then ER23539=.;
  IF ER23540 GE 8 OR ER23540 EQ 0 then ER23540=.;
  IF ER23541 GE 8 OR ER23541 EQ 0 then ER23541=.;
  IF ER23542 GE 8 OR ER23542 EQ 0 then ER23542=.;
  IF ER23543 GE 99997 OR ER23543 EQ 0 THEN ER23543=.;
  IF ER23544 GE 8 OR ER23544 EQ 0 then ER23544=.;
  IF ER23545 GE 8 OR ER23545 EQ 0 then ER23545=.;
  IF ER23546 GE 8 OR ER23546 EQ 0 then ER23546=.;
  IF ER23547 GE 8 OR ER23547 EQ 0 then ER23547=.;
  IF ER23548 GE 8 OR ER23548 EQ 0 then ER23548=.;
  IF ER23549 GE 8 OR ER23549 EQ 0 then ER23549=.;
  IF ER23550 GE 8 OR ER23550 EQ 0 then ER23550=.;
  IF ER23551 GE 8 OR ER23551 EQ 0 then ER23551=.;
  IF ER23552 GE 8 OR ER23552 EQ 0 then ER23552=.;
  IF ER23553 GE 8 OR ER23553 EQ 0 then ER23553=.;
  IF ER23554 GE 97 OR ER23554 EQ 0 THEN ER23554=.;
  IF ER23555 GE 8 OR ER23555 EQ 0 then ER23555=.;
  IF ER23556 GE 8 OR ER23556 EQ 0 then ER23556=.;
  IF ER23557 GE 97 OR ER23557 EQ 0 THEN ER23557=.;
  IF ER23558 GE 97 OR ER23558 EQ 0 THEN ER23558=.;
  IF ER23559 GE 99997 OR ER23559 EQ 0 THEN ER23559=.;
  IF ER23560 GE 8 OR ER23560 EQ 0 then ER23560=.;
  IF ER23561 GE 99997 OR ER23561 EQ 0 THEN ER23561=.;
  IF ER23562 GE 8 OR ER23562 EQ 0 then ER23562=.;
  IF ER23563 GE 99997 OR ER23563 EQ 0 THEN ER23563=.;
  IF ER23564 GE 97 OR ER23564 EQ 0 THEN ER23564=.;
  IF ER23565 GE 8 OR ER23565 EQ 0 then ER23565=.;
  IF ER23566 GE 8 OR ER23566 EQ 0 then ER23566=.;
  IF ER23567 GE 97 OR ER23567 EQ 0 THEN ER23567=.;
  IF ER23568 GE 97 OR ER23568 EQ 0 THEN ER23568=.;
  IF ER23569 GE 99997 OR ER23569 EQ 0 THEN ER23569=.;
  IF ER23570 GE 8 OR ER23570 EQ 0 then ER23570=.;
  IF ER23571 GE 99997 OR ER23571 EQ 0 THEN ER23571=.;
  IF ER23572 GE 8 OR ER23572 EQ 0 then ER23572=.;
  IF ER23573 GE 99997 OR ER23573 EQ 0 THEN ER23573=.;
  IF ER23574 GE 97 OR ER23574 EQ 0 THEN ER23574=.;
  IF ER23575 GE 8 OR ER23575 EQ 0 then ER23575=.;
  IF ER23576 GE 97 OR ER23576 EQ 0 THEN ER23576=.;
  IF ER23577 GE 97 OR ER23577 EQ 0 THEN ER23577=.;
  IF ER23578 GE 99997 OR ER23578 EQ 0 THEN ER23578=.;
  IF ER23579 GE 8 OR ER23579 EQ 0 then ER23579=.;
  IF ER23580 GE 99997 OR ER23580 EQ 0 THEN ER23580=.;
  IF ER23581 GE 8 OR ER23581 EQ 0 then ER23581=.;
  IF ER23582 GE 99997 OR ER23582 EQ 0 THEN ER23582=.;
  IF ER23583 GE 97 OR ER23583 EQ 0 THEN ER23583=.;
  IF ER23584 GE 8 OR ER23584 EQ 0 then ER23584=.;
  IF ER23585 GE 97 OR ER23585 EQ 0 THEN ER23585=.;
  IF ER23586 GE 97 OR ER23586 EQ 0 THEN ER23586=.;
  IF ER23587 GE 99997 OR ER23587 EQ 0 THEN ER23587=.;
  IF ER23588 GE 8 OR ER23588 EQ 0 then ER23588=.;
  IF ER23589 GE 99997 OR ER23589 EQ 0 THEN ER23589=.;
  IF ER23590 GE 8 OR ER23590 EQ 0 then ER23590=.;
  IF ER23591 GE 99997 OR ER23591 EQ 0 THEN ER23591=.;
  IF ER23592 GE 97 OR ER23592 EQ 0 THEN ER23592=.;
  IF ER23593 GE 8 OR ER23593 EQ 0 then ER23593=.;
  IF ER23594 GE 97 OR ER23594 EQ 0 THEN ER23594=.;
  IF ER23595 GE 97 OR ER23595 EQ 0 THEN ER23595=.;
  IF ER23596 GE 99997 OR ER23596 EQ 0 THEN ER23596=.;
  IF ER23597 GE 8 OR ER23597 EQ 0 then ER23597=.;
  IF ER23598 GE 99997 OR ER23598 EQ 0 THEN ER23598=.;
  IF ER23599 GE 8 OR ER23599 EQ 0 then ER23599=.;
  IF ER23600 GE 99997 OR ER23600 EQ 0 THEN ER23600=.;
  IF ER23601 GE 97 OR ER23601 EQ 0 THEN ER23601=.;
  IF ER23602 GE 8 OR ER23602 EQ 0 then ER23602=.;
  IF ER23603 GE 97 OR ER23603 EQ 0 THEN ER23603=.;
  IF ER23604 GE 97 OR ER23604 EQ 0 THEN ER23604=.;
  IF ER23605 GE 99997 OR ER23605 EQ 0 THEN ER23605=.;
  IF ER23606 GE 8 OR ER23606 EQ 0 then ER23606=.;
  IF ER23607 GE 99997 OR ER23607 EQ 0 THEN ER23607=.;
  IF ER23608 GE 8 OR ER23608 EQ 0 then ER23608=.;
  IF ER23609 GE 99997 OR ER23609 EQ 0 THEN ER23609=.;
  IF ER23610 GE 97 OR ER23610 EQ 0 THEN ER23610=.;
  IF ER23611 GE 8 OR ER23611 EQ 0 then ER23611=.;
  IF ER23612 GE 97 OR ER23612 EQ 0 THEN ER23612=.;
  IF ER23613 GE 97 OR ER23613 EQ 0 THEN ER23613=.;
  IF ER23614 GE 99997 OR ER23614 EQ 0 THEN ER23614=.;
  IF ER23615 GE 8 OR ER23615 EQ 0 then ER23615=.;
  IF ER23616 GE 99997 OR ER23616 EQ 0 THEN ER23616=.;
  IF ER23617 GE 8 OR ER23617 EQ 0 then ER23617=.;
  IF ER23618 GE 99997 OR ER23618 EQ 0 THEN ER23618=.;
  IF ER23619 GE 97 OR ER23619 EQ 0 THEN ER23619=.;
  IF ER23620 GE 8 OR ER23620 EQ 0 then ER23620=.;
  IF ER23621 GE 97 OR ER23621 EQ 0 THEN ER23621=.;
  IF ER23622 GE 97 OR ER23622 EQ 0 THEN ER23622=.;
  IF ER23623 GE 99997 OR ER23623 EQ 0 THEN ER23623=.;
  IF ER23624 GE 8 OR ER23624 EQ 0 then ER23624=.;
  IF ER23625 GE 99997 OR ER23625 EQ 0 THEN ER23625=.;
  IF ER23626 GE 8 OR ER23626 EQ 0 then ER23626=.;
  IF ER23627 GE 99997 OR ER23627 EQ 0 THEN ER23627=.;
  IF ER23628 GE 97 OR ER23628 EQ 0 THEN ER23628=.;
  IF ER23629 GE 8 OR ER23629 EQ 0 then ER23629=.;
  IF ER23630 GE 97 OR ER23630 EQ 0 THEN ER23630=.;
  IF ER23631 GE 97 OR ER23631 EQ 0 THEN ER23631=.;
  IF ER23632 GE 99997 OR ER23632 EQ 0 THEN ER23632=.;
  IF ER23633 GE 8 OR ER23633 EQ 0 then ER23633=.;
  IF ER23634 GE 99997 OR ER23634 EQ 0 THEN ER23634=.;
  IF ER23635 GE 8 OR ER23635 EQ 0 then ER23635=.;
  IF ER23636 GE 99997 OR ER23636 EQ 0 THEN ER23636=.;
  IF ER23637 GE 97 OR ER23637 EQ 0 THEN ER23637=.;
  IF ER23638 GE 8 OR ER23638 EQ 0 then ER23638=.;
  IF ER23639 GE 97 OR ER23639 EQ 0 THEN ER23639=.;
  IF ER23640 GE 97 OR ER23640 EQ 0 THEN ER23640=.;
  IF ER23641 GE 99997 OR ER23641 EQ 0 THEN ER23641=.;
  IF ER23642 GE 8 OR ER23642 EQ 0 then ER23642=.;
  IF ER23643 GE 99997 OR ER23643 EQ 0 THEN ER23643=.;
  IF ER23644 GE 8 OR ER23644 EQ 0 then ER23644=.;
  IF ER23645 GE 99997 OR ER23645 EQ 0 THEN ER23645=.;
  IF ER23646 GE 97 OR ER23646 EQ 0 THEN ER23646=.;
  IF ER23647 GE 8 OR ER23647 EQ 0 then ER23647=.;
  IF ER23648 GE 97 OR ER23648 EQ 0 THEN ER23648=.;
  IF ER23649 GE 97 OR ER23649 EQ 0 THEN ER23649=.;
  IF ER23650 GE 99997 OR ER23650 EQ 0 THEN ER23650=.;
  IF ER23651 GE 8 OR ER23651 EQ 0 then ER23651=.;
  IF ER23652 GE 99997 OR ER23652 EQ 0 THEN ER23652=.;
  IF ER23653 GE 8 OR ER23653 EQ 0 then ER23653=.;
  IF ER23654 GE 99997 OR ER23654 EQ 0 THEN ER23654=.;
  IF ER23655 GE 97 OR ER23655 EQ 0 THEN ER23655=.;
  IF ER23656 GE 8 OR ER23656 EQ 0 then ER23656=.;
  IF ER23657 GE 97 OR ER23657 EQ 0 THEN ER23657=.;
  IF ER23658 GE 97 OR ER23658 EQ 0 THEN ER23658=.;
  IF ER23659 GE 99997 OR ER23659 EQ 0 THEN ER23659=.;
  IF ER23660 GE 8 OR ER23660 EQ 0 then ER23660=.;
  IF ER23661 GE 99997 OR ER23661 EQ 0 THEN ER23661=.;
  IF ER23662 GE 8 OR ER23662 EQ 0 then ER23662=.;
  IF ER23663 GE 99997 OR ER23663 EQ 0 THEN ER23663=.;
  IF ER23664 GE 8 OR ER23664 EQ 0 then ER23664=.;
  IF ER23665 GE 97 OR ER23665 EQ 0 THEN ER23665=.;
  IF ER23666 GE 8 OR ER23666 EQ 0 then ER23666=.;
  IF ER23667 GE 97 OR ER23667 EQ 0 THEN ER23667=.;
  IF ER23668 GE 97 OR ER23668 EQ 0 THEN ER23668=.;
  IF ER23669 GE 99997 OR ER23669 EQ 0 THEN ER23669=.;
  IF ER23670 GE 8 OR ER23670 EQ 0 then ER23670=.;
  IF ER23671 GE 99997 OR ER23671 EQ 0 THEN ER23671=.;
  IF ER23672 GE 8 OR ER23672 EQ 0 then ER23672=.;
  IF ER23673 GE 99997 OR ER23673 EQ 0 THEN ER23673=.;
  IF ER23674 GE 8 OR ER23674 EQ 0 then ER23674=.;
  IF ER23675 GE 97 OR ER23675 EQ 0 THEN ER23675=.;
  IF ER23676 GE 8 OR ER23676 EQ 0 then ER23676=.;
  IF ER23677 GE 97 OR ER23677 EQ 0 THEN ER23677=.;
  IF ER23678 GE 97 OR ER23678 EQ 0 THEN ER23678=.;
  IF ER23679 GE 99997 OR ER23679 EQ 0 THEN ER23679=.;
  IF ER23680 GE 8 OR ER23680 EQ 0 then ER23680=.;
  IF ER23681 GE 99997 OR ER23681 EQ 0 THEN ER23681=.;
  IF ER23682 GE 8 OR ER23682 EQ 0 then ER23682=.;
  IF ER23683 GE 99997 OR ER23683 EQ 0 THEN ER23683=.;
  IF ER23684 GE 8 OR ER23684 EQ 0 then ER23684=.;
  IF ER23685 GE 8 OR ER23685 EQ 0 then ER23685=.;
  IF ER23686 GE 99997 OR ER23686 EQ 0 THEN ER23686=.;
  IF ER23687 GE 8 OR ER23687 EQ 0 then ER23687=.;
  IF ER23688 GE 99997 OR ER23688 EQ 0 THEN ER23688=.;
  IF ER23689 GE 8 OR ER23689 EQ 0 then ER23689=.;
  IF ER23690 GE 99997 OR ER23690 EQ 0 THEN ER23690=.;
  IF ER23691 GE 8 OR ER23691 EQ 0 then ER23691=.;
  IF ER23692 GE 99997 OR ER23692 EQ 0 THEN ER23692=.;
  IF ER23693 GE 8 OR ER23693 EQ 0 then ER23693=.;
  IF ER23694 GE 99997 OR ER23694 EQ 0 THEN ER23694=.;
  IF ER23695 GE 8 OR ER23695 EQ 0 then ER23695=.;
  IF ER23696 GE 99997 OR ER23696 EQ 0 THEN ER23696=.;
  IF ER23697 GE 8 OR ER23697 EQ 0 then ER23697=.;
  IF ER23698 GE 99997 OR ER23698 EQ 0 THEN ER23698=.;
  IF ER23699 GE 97 OR ER23699 EQ 0 THEN ER23699=.;
  IF ER23700 GE 8 OR ER23700 EQ 0 then ER23700=.;
  IF ER23701 GE 97 OR ER23701 EQ 0 THEN ER23701=.;
  IF ER23702 GE 8 OR ER23702 EQ 0 then ER23702=.;
  IF ER23703 GE 8 OR ER23703 EQ 0 then ER23703=.;
  IF ER23704 GE 9999997 OR ER23704 EQ 0 THEN ER23704=.;
  IF ER23705 GE 8 OR ER23705 EQ 0 then ER23705=.;
  IF ER23706 GE 8 OR ER23706 EQ 0 then ER23706=.;
  IF ER23707 GE 8 OR ER23707 EQ 0 then ER23707=.;
  IF ER23708 GE 8 OR ER23708 EQ 0 then ER23708=.;
  IF ER23709 GE 8 OR ER23709 EQ 0 then ER23709=.;
  IF ER23710 GE 8 OR ER23710 EQ 0 then ER23710=.;
  IF ER23711 GE 8 OR ER23711 EQ 0 then ER23711=.;
  IF ER23712 GE 8 OR ER23712 EQ 0 then ER23712=.;
  IF ER23713 GE 8 OR ER23713 EQ 0 then ER23713=.;
  IF ER23714 GE 8 OR ER23714 EQ 0 then ER23714=.;
  IF ER23715 GE 8 OR ER23715 EQ 0 then ER23715=.;
  IF ER23716 GE 8 OR ER23716 EQ 0 then ER23716=.;
  IF ER23717 GE 8 OR ER23717 EQ 0 then ER23717=.;
  IF ER23718 GE 8 OR ER23718 EQ 0 then ER23718=.;
  IF ER23719 GE 8 OR ER23719 EQ 0 then ER23719=.;
  IF ER23720 GE 9999997 OR ER23720 EQ 0 THEN ER23720=.;
  IF ER23721 GE 8 OR ER23721 EQ 0 then ER23721=.;
  IF ER23722 GE 8 OR ER23722 EQ 0 then ER23722=.;
  IF ER23723 GE 8 OR ER23723 EQ 0 then ER23723=.;
  IF ER23724 GE 8 OR ER23724 EQ 0 then ER23724=.;
  IF ER23725 GE 8 OR ER23725 EQ 0 then ER23725=.;
  IF ER23726 GE 8 OR ER23726 EQ 0 then ER23726=.;
  IF ER23727 GE 8 OR ER23727 EQ 0 then ER23727=.;
  IF ER23728 GE 8 OR ER23728 EQ 0 then ER23728=.;
  IF ER23729 GE 8 OR ER23729 EQ 0 then ER23729=.;
  IF ER23730 GE 8 OR ER23730 EQ 0 then ER23730=.;
  IF ER23731 GE 8 OR ER23731 EQ 0 then ER23731=.;
  IF ER23732 GE 8 OR ER23732 EQ 0 then ER23732=.;
  IF ER23733 GE 8 OR ER23733 EQ 0 then ER23733=.;
  IF ER23734 GE 8 OR ER23734 EQ 0 then ER23734=.;
  IF ER23735 GE 9999997 OR ER23735 EQ 0 THEN ER23735=.;
  IF ER23736 GE 8 OR ER23736 EQ 0 then ER23736=.;
  IF ER23737 GE 8 OR ER23737 EQ 0 then ER23737=.;
  IF ER23738 GE 8 OR ER23738 EQ 0 then ER23738=.;
  IF ER23739 GE 8 OR ER23739 EQ 0 then ER23739=.;
  IF ER23740 GE 8 OR ER23740 EQ 0 then ER23740=.;
  IF ER23741 GE 8 OR ER23741 EQ 0 then ER23741=.;
  IF ER23742 GE 8 OR ER23742 EQ 0 then ER23742=.;
  IF ER23743 GE 8 OR ER23743 EQ 0 then ER23743=.;
  IF ER23744 GE 8 OR ER23744 EQ 0 then ER23744=.;
  IF ER23745 GE 8 OR ER23745 EQ 0 then ER23745=.;
  IF ER23746 GE 8 OR ER23746 EQ 0 then ER23746=.;
  IF ER23747 GE 8 OR ER23747 EQ 0 then ER23747=.;
  IF ER23748 GE 8 OR ER23748 EQ 0 then ER23748=.;
  IF ER23749 GE 8 OR ER23749 EQ 0 then ER23749=.;
  IF ER23750 GE 9999997 OR ER23750 EQ 0 THEN ER23750=.;
  IF ER23751 GE 8 OR ER23751 EQ 0 then ER23751=.;
  IF ER23752 GE 8 OR ER23752 EQ 0 then ER23752=.;
  IF ER23753 GE 8 OR ER23753 EQ 0 then ER23753=.;
  IF ER23754 GE 8 OR ER23754 EQ 0 then ER23754=.;
  IF ER23755 GE 8 OR ER23755 EQ 0 then ER23755=.;
  IF ER23756 GE 8 OR ER23756 EQ 0 then ER23756=.;
  IF ER23757 GE 8 OR ER23757 EQ 0 then ER23757=.;
  IF ER23758 GE 8 OR ER23758 EQ 0 then ER23758=.;
  IF ER23759 GE 8 OR ER23759 EQ 0 then ER23759=.;
  IF ER23760 GE 8 OR ER23760 EQ 0 then ER23760=.;
  IF ER23761 GE 8 OR ER23761 EQ 0 then ER23761=.;
  IF ER23762 GE 8 OR ER23762 EQ 0 then ER23762=.;
  IF ER23763 GE 8 OR ER23763 EQ 0 then ER23763=.;
  IF ER23764 GE 999999997 OR ER23764 EQ 0 THEN ER23764=.;
  IF ER23765 GE 8 OR ER23765 EQ 0 then ER23765=.;
  IF ER23766 GE 8 OR ER23766 EQ 0 then ER23766=.;
  IF ER23767 GE 8 OR ER23767 EQ 0 then ER23767=.;
  IF ER23768 GE 8 OR ER23768 EQ 0 then ER23768=.;
  IF ER23769 GE 8 OR ER23769 EQ 0 then ER23769=.;
  IF ER23770 GE 8 OR ER23770 EQ 0 then ER23770=.;
  IF ER23771 GE 8 OR ER23771 EQ 0 then ER23771=.;
  IF ER23772 GE 8 OR ER23772 EQ 0 then ER23772=.;
  IF ER23773 GE 8 OR ER23773 EQ 0 then ER23773=.;
  IF ER23774 GE 8 OR ER23774 EQ 0 then ER23774=.;
  IF ER23775 GE 8 OR ER23775 EQ 0 then ER23775=.;
  IF ER23776 GE 8 OR ER23776 EQ 0 then ER23776=.;
  IF ER23777 GE 8 OR ER23777 EQ 0 then ER23777=.;
  IF ER23778 GE 8 OR ER23778 EQ 0 then ER23778=.;
  IF ER23779 GE 8 OR ER23779 EQ 0 then ER23779=.;
  IF ER23780 GE 8 OR ER23780 EQ 0 then ER23780=.;
  IF ER23781 GE 8 OR ER23781 EQ 0 then ER23781=.;
  IF ER23782 GE 8 OR ER23782 EQ 0 then ER23782=.;
  IF ER23783 GE 8 OR ER23783 EQ 0 then ER23783=.;
  IF ER23784 GE 8 OR ER23784 EQ 0 then ER23784=.;
  IF ER23785 GE 8 OR ER23785 EQ 0 then ER23785=.;
  IF ER23786 GE 8 OR ER23786 EQ 0 then ER23786=.;
  IF ER23787 GE 8 OR ER23787 EQ 0 then ER23787=.;
  IF ER23788 GE 8 OR ER23788 EQ 0 then ER23788=.;
  IF ER23789 GE 8 OR ER23789 EQ 0 then ER23789=.;
  IF ER23790 GE 8 OR ER23790 EQ 0 then ER23790=.;
  IF ER23791 GE 8 OR ER23791 EQ 0 then ER23791=.;
  IF ER23792 GE 8 OR ER23792 EQ 0 then ER23792=.;
  IF ER23793 GE 8 OR ER23793 EQ 0 then ER23793=.;
  IF ER23794 GE 8 OR ER23794 EQ 0 then ER23794=.;
  IF ER23795 GE 8 OR ER23795 EQ 0 then ER23795=.;
  IF ER23796 GE 8 OR ER23796 EQ 0 then ER23796=.;
  IF ER23797 GE 8 OR ER23797 EQ 0 then ER23797=.;
  IF ER23798 GE 8 OR ER23798 EQ 0 then ER23798=.;
  IF ER23799 GE 8 OR ER23799 EQ 0 then ER23799=.;
  IF ER23800 GE 8 OR ER23800 EQ 0 then ER23800=.;
  IF ER23801 GE 8 OR ER23801 EQ 0 then ER23801=.;
  IF ER23802 GE 8 OR ER23802 EQ 0 then ER23802=.;
  IF ER23803 GE 8 OR ER23803 EQ 0 then ER23803=.;
  IF ER23804 GE 8 OR ER23804 EQ 0 then ER23804=.;
  IF ER23805 GE 8 OR ER23805 EQ 0 then ER23805=.;
  IF ER23806 GE 8 OR ER23806 EQ 0 then ER23806=.;
  IF ER23807 GE 8 OR ER23807 EQ 0 then ER23807=.;
  IF ER23808 GE 8 OR ER23808 EQ 0 then ER23808=.;
  IF ER23809 GE 8 OR ER23809 EQ 0 then ER23809=.;
  IF ER23810 GE 8 OR ER23810 EQ 0 then ER23810=.;
  IF ER23811 GE 8 OR ER23811 EQ 0 then ER23811=.;
  IF ER23812 GE 8 OR ER23812 EQ 0 then ER23812=.;
  IF ER23813 GE 8 OR ER23813 EQ 0 then ER23813=.;
  IF ER23814 GE 8 OR ER23814 EQ 0 then ER23814=.;
  IF ER23815 GE 8 OR ER23815 EQ 0 then ER23815=.;
  IF ER23816 GE 8 OR ER23816 EQ 0 then ER23816=.;
  IF ER23817 GE 8 OR ER23817 EQ 0 then ER23817=.;
  IF ER23818 GE 8 OR ER23818 EQ 0 then ER23818=.;
  IF ER23819 GE 8 OR ER23819 EQ 0 then ER23819=.;
  IF ER23820 GE 8 OR ER23820 EQ 0 then ER23820=.;
  IF ER23821 GE 8 OR ER23821 EQ 0 then ER23821=.;
  IF ER23822 GE 8 OR ER23822 EQ 0 then ER23822=.;
  IF ER23823 GE 8 OR ER23823 EQ 0 then ER23823=.;
  IF ER23824 GE 8 OR ER23824 EQ 0 then ER23824=.;
  IF ER23825 GE 8 OR ER23825 EQ 0 then ER23825=.;
  IF ER23826 GE 8 OR ER23826 EQ 0 then ER23826=.;
  IF ER23827 GE 8 OR ER23827 EQ 0 then ER23827=.;
  IF ER23828 GE 8 OR ER23828 EQ 0 then ER23828=.;
  IF ER23829 GE 8 OR ER23829 EQ 0 then ER23829=.;
  IF ER23830 GE 8 OR ER23830 EQ 0 then ER23830=.;
  IF ER23831 GE 8 OR ER23831 EQ 0 then ER23831=.;
  IF ER23832 GE 8 OR ER23832 EQ 0 then ER23832=.;
  IF ER23833 GE 8 OR ER23833 EQ 0 then ER23833=.;
  IF ER23834 GE 8 OR ER23834 EQ 0 then ER23834=.;
  IF ER23835 GE 8 OR ER23835 EQ 0 then ER23835=.;
  IF ER23836 GE 8 OR ER23836 EQ 0 then ER23836=.;
  IF ER23837 GE 8 OR ER23837 EQ 0 then ER23837=.;
  IF ER23838 GE 8 OR ER23838 EQ 0 then ER23838=.;
  IF ER23839 GE 8 OR ER23839 EQ 0 then ER23839=.;
  IF ER23840 GE 8 OR ER23840 EQ 0 then ER23840=.;
  IF ER23841 GE 8 OR ER23841 EQ 0 then ER23841=.;
  IF ER23842 GE 8 OR ER23842 EQ 0 then ER23842=.;
  IF ER23843 GE 8 OR ER23843 EQ 0 then ER23843=.;
  IF ER23844 GE 8 OR ER23844 EQ 0 then ER23844=.;
  IF ER23845 GE 8 OR ER23845 EQ 0 then ER23845=.;
  IF ER23846 GE 8 OR ER23846 EQ 0 then ER23846=.;
  IF ER23847 GE 8 OR ER23847 EQ 0 then ER23847=.;
  IF ER23848 GE 8 OR ER23848 EQ 0 then ER23848=.;
  IF ER23849 GE 8 OR ER23849 EQ 0 then ER23849=.;
  IF ER23850 GE 8 OR ER23850 EQ 0 then ER23850=.;
  IF ER23851 GE 8 OR ER23851 EQ 0 then ER23851=.;
  IF ER23852 GE 8 OR ER23852 EQ 0 then ER23852=.;
  IF ER23853 GE 8 OR ER23853 EQ 0 then ER23853=.;
  IF ER23854 GE 8 OR ER23854 EQ 0 then ER23854=.;
  IF ER23855 GE 8 OR ER23855 EQ 0 then ER23855=.;
  IF ER23856 GE 8 OR ER23856 EQ 0 then ER23856=.;
  IF ER23857 GE 8 OR ER23857 EQ 0 then ER23857=.;
  IF ER23858 GE 8 OR ER23858 EQ 0 then ER23858=.;
  IF ER23859 GE 8 OR ER23859 EQ 0 then ER23859=.;
  IF ER23860 GE 8 OR ER23860 EQ 0 then ER23860=.;
  IF ER23861 GE 8 OR ER23861 EQ 0 then ER23861=.;
  IF ER23862 GE 8 OR ER23862 EQ 0 then ER23862=.;
  IF ER23863 GE 8 OR ER23863 EQ 0 then ER23863=.;
  IF ER23864 GE 8 OR ER23864 EQ 0 then ER23864=.;
  IF ER23865 GE 8 OR ER23865 EQ 0 then ER23865=.;
  IF ER23866 GE 8 OR ER23866 EQ 0 then ER23866=.;
  IF ER23867 GE 8 OR ER23867 EQ 0 then ER23867=.;
  IF ER23868 GE 8 OR ER23868 EQ 0 then ER23868=.;
  IF ER23869 GE 8 OR ER23869 EQ 0 then ER23869=.;
  IF ER23870 GE 8 OR ER23870 EQ 0 then ER23870=.;
  IF ER23871 GE 8 OR ER23871 EQ 0 then ER23871=.;
  IF ER23872 GE 8 OR ER23872 EQ 0 then ER23872=.;
  IF ER23873 GE 8 OR ER23873 EQ 0 then ER23873=.;
  IF ER23874 GE 8 OR ER23874 EQ 0 then ER23874=.;
  IF ER23875 GE 8 OR ER23875 EQ 0 then ER23875=.;
  IF ER23876 GE 8 OR ER23876 EQ 0 then ER23876=.;
  IF ER23877 GE 8 OR ER23877 EQ 0 then ER23877=.;
  IF ER23878 GE 8 OR ER23878 EQ 0 then ER23878=.;
  IF ER23879 GE 8 OR ER23879 EQ 0 then ER23879=.;
  IF ER23880 GE 8 OR ER23880 EQ 0 then ER23880=.;
  IF ER23881 GE 8 OR ER23881 EQ 0 then ER23881=.;
  IF ER23882 GE 8 OR ER23882 EQ 0 then ER23882=.;
  IF ER23883 GE 8 OR ER23883 EQ 0 then ER23883=.;
  IF ER23884 GE 8 OR ER23884 EQ 0 then ER23884=.;
  IF ER23885 GE 8 OR ER23885 EQ 0 then ER23885=.;
  IF ER23886 GE 8 OR ER23886 EQ 0 then ER23886=.;
  IF ER23887 GE 8 OR ER23887 EQ 0 then ER23887=.;
  IF ER23888 GE 8 OR ER23888 EQ 0 then ER23888=.;
  IF ER23889 GE 8 OR ER23889 EQ 0 then ER23889=.;
  IF ER23890 GE 8 OR ER23890 EQ 0 then ER23890=.;
  IF ER23891 GE 8 OR ER23891 EQ 0 then ER23891=.;
  IF ER23892 GE 8 OR ER23892 EQ 0 then ER23892=.;
  IF ER23893 GE 8 OR ER23893 EQ 0 then ER23893=.;
  IF ER23894 GE 8 OR ER23894 EQ 0 then ER23894=.;
  IF ER23895 GE 8 OR ER23895 EQ 0 then ER23895=.;
  IF ER23896 GE 8 OR ER23896 EQ 0 then ER23896=.;
  IF ER23897 GE 8 OR ER23897 EQ 0 then ER23897=.;
  IF ER23898 GE 8 OR ER23898 EQ 0 then ER23898=.;
  IF ER23899 GE 8 OR ER23899 EQ 0 then ER23899=.;
  IF ER23900 GE 8 OR ER23900 EQ 0 then ER23900=.;
  IF ER23901 GE 8 OR ER23901 EQ 0 then ER23901=.;
  IF ER23902 GE 8 OR ER23902 EQ 0 then ER23902=.;
  IF ER23903 GE 8 OR ER23903 EQ 0 then ER23903=.;
  IF ER23904 GE 8 OR ER23904 EQ 0 then ER23904=.;
  IF ER23905 GE 8 OR ER23905 EQ 0 then ER23905=.;
  IF ER23906 GE 8 OR ER23906 EQ 0 then ER23906=.;
  IF ER23907 GE 8 OR ER23907 EQ 0 then ER23907=.;
  IF ER23908 GE 8 OR ER23908 EQ 0 then ER23908=.;
  IF ER23909 GE 8 OR ER23909 EQ 0 then ER23909=.;
  IF ER23910 GE 8 OR ER23910 EQ 0 then ER23910=.;
  IF ER23911 GE 8 OR ER23911 EQ 0 then ER23911=.;
  IF ER23912 GE 8 OR ER23912 EQ 0 then ER23912=.;
  IF ER23913 GE 8 OR ER23913 EQ 0 then ER23913=.;
  IF ER23914 GE 8 OR ER23914 EQ 0 then ER23914=.;
  IF ER23915 GE 8 OR ER23915 EQ 0 then ER23915=.;
  IF ER23916 GE 8 OR ER23916 EQ 0 then ER23916=.;
  IF ER23917 GE 8 OR ER23917 EQ 0 then ER23917=.;
  IF ER23918 GE 8 OR ER23918 EQ 0 then ER23918=.;
  IF ER23919 GE 8 OR ER23919 EQ 0 then ER23919=.;
  IF ER23920 GE 8 OR ER23920 EQ 0 then ER23920=.;
  IF ER23921 GE 8 OR ER23921 EQ 0 then ER23921=.;
  IF ER23922 GE 8 OR ER23922 EQ 0 then ER23922=.;
  IF ER23923 GE 8 OR ER23923 EQ 0 then ER23923=.;
  IF ER23924 GE 8 OR ER23924 EQ 0 then ER23924=.;
  IF ER23925 GE 8 OR ER23925 EQ 0 then ER23925=.;
  IF ER23926 GE 8 OR ER23926 EQ 0 then ER23926=.;
  IF ER23927 GE 8 OR ER23927 EQ 0 then ER23927=.;
  IF ER23928 GE 8 OR ER23928 EQ 0 then ER23928=.;
  IF ER23929 GE 8 OR ER23929 EQ 0 then ER23929=.;
  IF ER23930 GE 8 OR ER23930 EQ 0 then ER23930=.;
  IF ER23931 GE 8 OR ER23931 EQ 0 then ER23931=.;
  IF ER23932 GE 8 OR ER23932 EQ 0 then ER23932=.;
  IF ER23933 GE 8 OR ER23933 EQ 0 then ER23933=.;
  IF ER23934 GE 8 OR ER23934 EQ 0 then ER23934=.;
  IF ER23935 GE 8 OR ER23935 EQ 0 then ER23935=.;
  IF ER23936 GE 8 OR ER23936 EQ 0 then ER23936=.;
  IF ER23937 GE 8 OR ER23937 EQ 0 then ER23937=.;
  IF ER23938 GE 8 OR ER23938 EQ 0 then ER23938=.;
  IF ER23939 GE 8 OR ER23939 EQ 0 then ER23939=.;
  IF ER23940 GE 8 OR ER23940 EQ 0 then ER23940=.;
  IF ER23941 GE 8 OR ER23941 EQ 0 then ER23941=.;
  IF ER23942 GE 8 OR ER23942 EQ 0 then ER23942=.;
  IF ER23943 GE 8 OR ER23943 EQ 0 then ER23943=.;
  IF ER23944 GE 8 OR ER23944 EQ 0 then ER23944=.;
  IF ER23945 GE 8 OR ER23945 EQ 0 then ER23945=.;
  IF ER23946 GE 8 OR ER23946 EQ 0 then ER23946=.;
  IF ER23947 GE 8 OR ER23947 EQ 0 then ER23947=.;
  IF ER23948 GE 8 OR ER23948 EQ 0 then ER23948=.;
  IF ER23949 GE 8 OR ER23949 EQ 0 then ER23949=.;
  IF ER23950 GE 8 OR ER23950 EQ 0 then ER23950=.;
  IF ER23951 GE 8 OR ER23951 EQ 0 then ER23951=.;
  IF ER23952 GE 8 OR ER23952 EQ 0 then ER23952=.;
  IF ER23953 GE 8 OR ER23953 EQ 0 then ER23953=.;
  IF ER23954 GE 8 OR ER23954 EQ 0 then ER23954=.;
  IF ER23955 GE 8 OR ER23955 EQ 0 then ER23955=.;
  IF ER23956 GE 8 OR ER23956 EQ 0 then ER23956=.;
  IF ER23957 GE 8 OR ER23957 EQ 0 then ER23957=.;
  IF ER23958 GE 8 OR ER23958 EQ 0 then ER23958=.;
  IF ER23959 GE 8 OR ER23959 EQ 0 then ER23959=.;
  IF ER23960 GE 8 OR ER23960 EQ 0 then ER23960=.;
  IF ER23961 GE 8 OR ER23961 EQ 0 then ER23961=.;
  IF ER23962 GE 8 OR ER23962 EQ 0 then ER23962=.;
  IF ER23963 GE 8 OR ER23963 EQ 0 then ER23963=.;
  IF ER23964 GE 8 OR ER23964 EQ 0 then ER23964=.;
  IF ER23965 GE 8 OR ER23965 EQ 0 then ER23965=.;
  IF ER23966 GE 8 OR ER23966 EQ 0 then ER23966=.;
  IF ER23967 GE 8 OR ER23967 EQ 0 then ER23967=.;
  IF ER23968 GE 8 OR ER23968 EQ 0 then ER23968=.;
  IF ER23969 GE 8 OR ER23969 EQ 0 then ER23969=.;
  IF ER23970 GE 8 OR ER23970 EQ 0 then ER23970=.;
  IF ER23971 GE 8 OR ER23971 EQ 0 then ER23971=.;
  IF ER23972 GE 8 OR ER23972 EQ 0 then ER23972=.;
  IF ER23973 GE 8 OR ER23973 EQ 0 then ER23973=.;
  IF ER23974 GE 8 OR ER23974 EQ 0 then ER23974=.;
  IF ER23975 GE 8 OR ER23975 EQ 0 then ER23975=.;
  IF ER23976 GE 8 OR ER23976 EQ 0 then ER23976=.;
  IF ER23977 GE 8 OR ER23977 EQ 0 then ER23977=.;
  IF ER23978 GE 8 OR ER23978 EQ 0 then ER23978=.;
  IF ER23979 GE 8 OR ER23979 EQ 0 then ER23979=.;
  IF ER23980 GE 8 OR ER23980 EQ 0 then ER23980=.;
  IF ER23981 GE 8 OR ER23981 EQ 0 then ER23981=.;
  IF ER23982 GE 8 OR ER23982 EQ 0 then ER23982=.;
  IF ER23983 GE 8 OR ER23983 EQ 0 then ER23983=.;
  IF ER23984 GE 8 OR ER23984 EQ 0 then ER23984=.;
  IF ER23985 GE 8 OR ER23985 EQ 0 then ER23985=.;
  IF ER23986 GE 8 OR ER23986 EQ 0 then ER23986=.;
  IF ER23987 GE 8 OR ER23987 EQ 0 then ER23987=.;
  IF ER23988 GE 8 OR ER23988 EQ 0 then ER23988=.;
  IF ER23989 GE 8 OR ER23989 EQ 0 then ER23989=.;
  IF ER23990 GE 8 OR ER23990 EQ 0 then ER23990=.;
  IF ER23991 GE 8 OR ER23991 EQ 0 then ER23991=.;
  IF ER23992 GE 8 OR ER23992 EQ 0 then ER23992=.;
  IF ER23993 GE 8 OR ER23993 EQ 0 then ER23993=.;
  IF ER23994 GE 8 OR ER23994 EQ 0 then ER23994=.;
  IF ER23995 GE 8 OR ER23995 EQ 0 then ER23995=.;
  IF ER23996 GE 8 OR ER23996 EQ 0 then ER23996=.;
  IF ER23997 GE 8 OR ER23997 EQ 0 then ER23997=.;
  IF ER23998 GE 8 OR ER23998 EQ 0 then ER23998=.;
  IF ER23999 GE 8 OR ER23999 EQ 0 then ER23999=.;
  IF ER24000 GE 8 OR ER24000 EQ 0 then ER24000=.;
  IF ER24001 GE 8 OR ER24001 EQ 0 then ER24001=.;
  IF ER24002 GE 8 OR ER24002 EQ 0 then ER24002=.;
  IF ER24003 GE 8 OR ER24003 EQ 0 then ER24003=.;
  IF ER24004 GE 8 OR ER24004 EQ 0 then ER24004=.;
  IF ER24005 GE 8 OR ER24005 EQ 0 then ER24005=.;
  IF ER24006 GE 8 OR ER24006 EQ 0 then ER24006=.;
  IF ER24007 GE 8 OR ER24007 EQ 0 then ER24007=.;
  IF ER24008 GE 8 OR ER24008 EQ 0 then ER24008=.;
  IF ER24009 GE 8 OR ER24009 EQ 0 then ER24009=.;
  IF ER24010 GE 8 OR ER24010 EQ 0 then ER24010=.;
  IF ER24011 GE 8 OR ER24011 EQ 0 then ER24011=.;
  IF ER24012 GE 8 OR ER24012 EQ 0 then ER24012=.;
  IF ER24013 GE 8 OR ER24013 EQ 0 then ER24013=.;
  IF ER24014 GE 8 OR ER24014 EQ 0 then ER24014=.;
  IF ER24015 GE 8 OR ER24015 EQ 0 then ER24015=.;
  IF ER24016 GE 8 OR ER24016 EQ 0 then ER24016=.;
  IF ER24017 GE 8 OR ER24017 EQ 0 then ER24017=.;
  IF ER24018 GE 8 OR ER24018 EQ 0 then ER24018=.;
  IF ER24019 GE 8 OR ER24019 EQ 0 then ER24019=.;
  IF ER24020 GE 8 OR ER24020 EQ 0 then ER24020=.;
  IF ER24021 GE 8 OR ER24021 EQ 0 then ER24021=.;
  IF ER24022 GE 8 OR ER24022 EQ 0 then ER24022=.;
  IF ER24023 GE 8 OR ER24023 EQ 0 then ER24023=.;
  IF ER24024 GE 8 OR ER24024 EQ 0 then ER24024=.;
  IF ER24025 GE 8 OR ER24025 EQ 0 then ER24025=.;
  IF ER24026 GE 8 OR ER24026 EQ 0 then ER24026=.;
  IF ER24027 GE 8 OR ER24027 EQ 0 then ER24027=.;
  IF ER24028 GE 8 OR ER24028 EQ 0 then ER24028=.;
  IF ER24029 GE 8 OR ER24029 EQ 0 then ER24029=.;
  IF ER24030 GE 8 OR ER24030 EQ 0 then ER24030=.;
  IF ER24031 GE 8 OR ER24031 EQ 0 then ER24031=.;
  IF ER24032 GE 8 OR ER24032 EQ 0 then ER24032=.;
  IF ER24033 GE 8 OR ER24033 EQ 0 then ER24033=.;
  IF ER24034 GE 8 OR ER24034 EQ 0 then ER24034=.;
  IF ER24035 GE 8 OR ER24035 EQ 0 then ER24035=.;
  IF ER24036 GE 8 OR ER24036 EQ 0 then ER24036=.;
  IF ER24037 GE 8 OR ER24037 EQ 0 then ER24037=.;
  IF ER24038 GE 8 OR ER24038 EQ 0 then ER24038=.;
  IF ER24039 GE 8 OR ER24039 EQ 0 then ER24039=.;
  IF ER24040 GE 8 OR ER24040 EQ 0 then ER24040=.;
  IF ER24041 GE 8 OR ER24041 EQ 0 then ER24041=.;
  IF ER24042 GE 8 OR ER24042 EQ 0 then ER24042=.;
  IF ER24043 GE 8 OR ER24043 EQ 0 then ER24043=.;
  IF ER24044 GE 8 OR ER24044 EQ 0 then ER24044=.;
  IF ER24045 GE 8 OR ER24045 EQ 0 then ER24045=.;
  IF ER24046 GE 8 OR ER24046 EQ 0 then ER24046=.;
  IF ER24047 GE 8 OR ER24047 EQ 0 then ER24047=.;
  IF ER24048 GE 8 OR ER24048 EQ 0 then ER24048=.;
  IF ER24049 GE 8 OR ER24049 EQ 0 then ER24049=.;
  IF ER24050 GE 8 OR ER24050 EQ 0 then ER24050=.;
  IF ER24051 GE 8 OR ER24051 EQ 0 then ER24051=.;
  IF ER24052 GE 8 OR ER24052 EQ 0 then ER24052=.;
  IF ER24053 GE 8 OR ER24053 EQ 0 then ER24053=.;
  IF ER24054 GE 8 OR ER24054 EQ 0 then ER24054=.;
  IF ER24055 GE 8 OR ER24055 EQ 0 then ER24055=.;
  IF ER24056 GE 8 OR ER24056 EQ 0 then ER24056=.;
  IF ER24057 GE 8 OR ER24057 EQ 0 then ER24057=.;
  IF ER24058 GE 8 OR ER24058 EQ 0 then ER24058=.;
  IF ER24059 GE 8 OR ER24059 EQ 0 then ER24059=.;
  IF ER24060 GE 8 OR ER24060 EQ 0 then ER24060=.;
  IF ER24061 GE 8 OR ER24061 EQ 0 then ER24061=.;
  IF ER24062 GE 8 OR ER24062 EQ 0 then ER24062=.;
  IF ER24063 GE 8 OR ER24063 EQ 0 then ER24063=.;
  IF ER24064 GE 8 OR ER24064 EQ 0 then ER24064=.;
  IF ER24065 GE 8 OR ER24065 EQ 0 then ER24065=.;
  IF ER24066 GE 8 OR ER24066 EQ 0 then ER24066=.;
  IF ER24067 GE 8 OR ER24067 EQ 0 then ER24067=.;
  IF ER24068 GE 8 OR ER24068 EQ 0 then ER24068=.;
  IF ER24069 GE 8 OR ER24069 EQ 0 then ER24069=.;
  IF ER24070 GE 8 OR ER24070 EQ 0 then ER24070=.;
  IF ER24071 GE 8 OR ER24071 EQ 0 then ER24071=.;
  IF ER24072 GE 8 OR ER24072 EQ 0 then ER24072=.;
  IF ER24073 GE 8 OR ER24073 EQ 0 then ER24073=.;
  IF ER24074 GE 997 OR ER24074 EQ 0 THEN ER24074=.;
  IF ER24075 GE 8 OR ER24075 EQ 0 then ER24075=.;
  IF ER24076 GE 97 OR ER24076 EQ 0 THEN ER24076=.;
  IF ER24077 GE 97 OR ER24077 EQ 0 THEN ER24077=.;
  IF ER24078 GE 997 OR ER24078 EQ 0 THEN ER24078=.;
  IF ER24079 GE 9997 OR ER24079 EQ 0 THEN ER24079=.;
  IF ER24080 GE 9997 OR ER24080 EQ 0 THEN ER24080=.;
  IF ER24081 GE 97 OR ER24081 EQ 0 THEN ER24081=.;
  IF ER24082 GE 97 OR ER24082 EQ 0 THEN ER24082=.;
  IF ER24083 GE 97 OR ER24083 EQ 0 THEN ER24083=.;
  IF ER24084 GE 97 OR ER24084 EQ 0 THEN ER24084=.;
  IF ER24085 GE 97 OR ER24085 EQ 0 THEN ER24085=.;
  IF ER24086 GE 97 OR ER24086 EQ 0 THEN ER24086=.;
  IF ER24087 GE 97 OR ER24087 EQ 0 THEN ER24087=.;
  IF ER24088 GE 97 OR ER24088 EQ 0 THEN ER24088=.;
  IF ER24089 GE 997 OR ER24089 EQ 0 THEN ER24089=.;
  IF ER24090 GE 9997 OR ER24090 EQ 0 THEN ER24090=.;
  IF ER24091 GE 9997 OR ER24091 EQ 0 THEN ER24091=.;
  IF ER24092 GE 97 OR ER24092 EQ 0 THEN ER24092=.;
  IF ER24093 GE 97 OR ER24093 EQ 0 THEN ER24093=.;
  IF ER24094 GE 97 OR ER24094 EQ 0 THEN ER24094=.;
  IF ER24095 GE 97 OR ER24095 EQ 0 THEN ER24095=.;
  IF ER24096 GE 97 OR ER24096 EQ 0 THEN ER24096=.;
  IF ER24097 GE 97 OR ER24097 EQ 0 THEN ER24097=.;
  IF ER24098 GE 97 OR ER24098 EQ 0 THEN ER24098=.;
  IF ER24099 GE 9999997 OR ER24099 EQ 0 THEN ER24099=.;
  IF ER24100 GE 9999997 OR ER24100 EQ 0 THEN ER24100=.;
  IF ER24101 GE 9999997 OR ER24101 EQ 0 THEN ER24101=.;
  IF ER24102 GE 9999997 OR ER24102 EQ 0 THEN ER24102=.;
  IF ER24103 GE 999997 OR ER24103 EQ 0 THEN ER24103=.;
  IF ER24104 GE 999997 OR ER24104 EQ 0 THEN ER24104=.;
  IF ER24105 GE 999997 OR ER24105 EQ 0 THEN ER24105=.;
  IF ER24106 GE 8 OR ER24106 EQ 0 then ER24106=.;
  IF ER24107 GE 9999997 OR ER24107 EQ 0 THEN ER24107=.;
  IF ER24108 GE 8 OR ER24108 EQ 0 then ER24108=.;
  IF ER24109 GE 999997 OR ER24109 EQ 0 THEN ER24109=.;
  IF ER24110 GE 9999997 OR ER24110 EQ 0 THEN ER24110=.;
  IF ER24111 GE 999997 OR ER24111 EQ 0 THEN ER24111=.;
  IF ER24112 GE 9999997 OR ER24112 EQ 0 THEN ER24112=.;
  IF ER24113 GE 8 OR ER24113 EQ 0 then ER24113=.;
  IF ER24114 GE 8 OR ER24114 EQ 0 then ER24114=.;
  IF ER24115 GE 8 OR ER24115 EQ 0 then ER24115=.;
  IF ER24116 GE 9999997 OR ER24116 EQ 0 THEN ER24116=.;
  IF ER24117 GE 9999997 OR ER24117 EQ 0 THEN ER24117=.;
  IF ER24118 GE 8 OR ER24118 EQ 0 then ER24118=.;
  IF ER24119 GE 999997 OR ER24119 EQ 0 THEN ER24119=.;
  IF ER24120 GE 8 OR ER24120 EQ 0 then ER24120=.;
  IF ER24121 GE 999997 OR ER24121 EQ 0 THEN ER24121=.;
  IF ER24122 GE 8 OR ER24122 EQ 0 then ER24122=.;
  IF ER24123 GE 999997 OR ER24123 EQ 0 THEN ER24123=.;
  IF ER24124 GE 8 OR ER24124 EQ 0 then ER24124=.;
  IF ER24125 GE 999997 OR ER24125 EQ 0 THEN ER24125=.;
  IF ER24126 GE 8 OR ER24126 EQ 0 then ER24126=.;
  IF ER24127 GE 9999997 OR ER24127 EQ 0 THEN ER24127=.;
  IF ER24128 GE 8 OR ER24128 EQ 0 then ER24128=.;
  IF ER24129 GE 9999997 OR ER24129 EQ 0 THEN ER24129=.;
  IF ER24130 GE 8 OR ER24130 EQ 0 then ER24130=.;
  IF ER24131 GE 9999997 OR ER24131 EQ 0 THEN ER24131=.;
  IF ER24132 GE 8 OR ER24132 EQ 0 then ER24132=.;
  IF ER24133 GE 999997 OR ER24133 EQ 0 THEN ER24133=.;
  IF ER24134 GE 8 OR ER24134 EQ 0 then ER24134=.;
  IF ER24135 GE 9999997 OR ER24135 EQ 0 THEN ER24135=.;
  IF ER24136 GE 8 OR ER24136 EQ 0 then ER24136=.;
  IF ER24137 GE 997 OR ER24137 EQ 0 THEN ER24137=.;
  IF ER24138 GE 997 OR ER24138 EQ 0 THEN ER24138=.;
  IF ER24139 GE 99997 OR ER24139 EQ 0 THEN ER24139=.;
  IF ER24140 GE 99997 OR ER24140 EQ 0 THEN ER24140=.;
  IF ER24141 GE 99997 OR ER24141 EQ 0 THEN ER24141=.;
  IF ER24142 GE 99997 OR ER24142 EQ 0 THEN ER24142=.;
  IF ER24143 GE 8 OR ER24143 EQ 0 then ER24143=.;
  IF ER24144 GE 97 OR ER24144 EQ 0 THEN ER24144=.;
  IF ER24145 GE 8 OR ER24145 EQ 0 then ER24145=.;
  IF ER24146 GE 8 OR ER24146 EQ 0 then ER24146=.;
  IF ER24147 GE 8 OR ER24147 EQ 0 then ER24147=.;
  IF ER24148 GE 97 OR ER24148 EQ 0 THEN ER24148=.;
  IF ER24149 GE 97 OR ER24149 EQ 0 THEN ER24149=.;
  IF ER24150 GE 8 OR ER24150 EQ 0 then ER24150=.;
  IF ER24151 GE 8 OR ER24151 EQ 0 then ER24151=.;
  IF ER24152 GE 8 OR ER24152 EQ 0 then ER24152=.;
  IF ER24153 GE 9997 OR ER24153 EQ 0 THEN ER24153=.;
  IF ER24154 GE 9997 OR ER24154 EQ 0 THEN ER24154=.;
  IF ER24155 GE 8 OR ER24155 EQ 0 then ER24155=.;
  IF ER24156 GE 8 OR ER24156 EQ 0 then ER24156=.;
  IF ER24157 GE 99997 OR ER24157 EQ 0 THEN ER24157=.;
  IF ER24158 GE 99997 OR ER24158 EQ 0 THEN ER24158=.;
  IF ER24159 GE 8 OR ER24159 EQ 0 then ER24159=.;
  IF ER24160 GE 97 OR ER24160 EQ 0 THEN ER24160=.;
  IF ER24161 GE 99997 OR ER24161 EQ 0 THEN ER24161=.;
  IF ER24162 GE 8 OR ER24162 EQ 0 then ER24162=.;
  IF ER24163 GE 97 OR ER24163 EQ 0 THEN ER24163=.;
  IF ER24164 GE 99997 OR ER24164 EQ 0 THEN ER24164=.;
  IF ER24165 GE 8 OR ER24165 EQ 0 then ER24165=.;
  IF ER24166 GE 97 OR ER24166 EQ 0 THEN ER24166=.;
  IF ER24167 GE 99997 OR ER24167 EQ 0 THEN ER24167=.;
  IF ER24168 GE 8 OR ER24168 EQ 0 then ER24168=.;
  IF ER24169 GE 97 OR ER24169 EQ 0 THEN ER24169=.;
  IF ER24170 GE 99997 OR ER24170 EQ 0 THEN ER24170=.;
  IF ER24171 GE 8 OR ER24171 EQ 0 then ER24171=.;
  IF ER24172 GE 8 OR ER24172 EQ 0 then ER24172=.;
  IF ER24173 GE 8 OR ER24173 EQ 0 then ER24173=.;
  IF ER24174 GE 8 OR ER24174 EQ 0 then ER24174=.;
  IF ER24175 GE 8 OR ER24175 EQ 0 then ER24175=.;
  IF ER24176 GE 8 OR ER24176 EQ 0 then ER24176=.;
  IF ER24177 GE 8 OR ER24177 EQ 0 then ER24177=.;
  IF ER24178 GE 8 OR ER24178 EQ 0 then ER24178=.;
  IF ER24179 GE 97 OR ER24179 EQ 0 THEN ER24179=.;

  file rawdat lrecl=6038;
  put    
ER21002
ER21003
ER21007
ER21009
ER21012
ER21013
ER21014
ER21016
ER21017
ER21018
ER21019
ER21023
ER21042
ER21043
ER21044
ER21045
ER21046
ER21047
ER21048
ER21049
ER21050
ER21051
ER21052
ER21053
ER21054
ER21055
ER21056
ER21057
ER21058
ER21059
ER21060
ER21061
ER21062
ER21063
ER21064
ER21065
ER21066
ER21067
ER21068
ER21069
ER21072
ER21073
ER21074
ER21117
ER21118
ER21119
ER21120
ER21123
ER21124
ER21125
ER21147
ER21171
ER21172
ER21173
ER21184
ER21369
ER21370
ER21371
ER21373
ER21374
ER21375
ER21377
ER21397
ER21421
ER21422
ER21423
ER21434
ER21619
ER21620
ER21621
ER21653
ER21654
ER21684
ER21686
ER21687
ER21688
ER21690
ER21691
ER21692
ER21693
ER21694
ER21695
ER21696
ER21697
ER21698
ER21700
ER21701
ER21702
ER21703
ER21704
ER21705
ER21750
ER21751
ER21754
ER21757
ER21758
ER21759
ER21765
ER21768
ER21769
ER21770
ER21771
ER21772
ER21773
ER21774
ER21776
ER21777
ER21780
ER21783
ER21786
ER21787
ER21788
ER21794
ER21797
ER21798
ER21799
ER21800
ER21801
ER21802
ER21803
ER21805
ER21806
ER21809
ER21812
ER21815
ER21816
ER21817
ER21823
ER21826
ER21827
ER21828
ER21829
ER21830
ER21831
ER21832
ER21834
ER21835
ER21838
ER21839
ER21841
ER21842
ER21843
ER21844
ER21845
ER21846
ER21847
ER21849
ER21851
ER21853
ER21857
ER22003
ER22004
ER22020
ER22021
ER22352
ER22353
ER22354
ER22532
ER22538
ER22554
ER22558
ER22563
ER22568
ER22588
ER22589
ER22590
ER22596
ER22617
ER22622
ER22653
ER22691
ER22702
ER23014
ER23343
ER23351
ER23354
ER23358
ER23388
ER23426
ER23435
ER23443
ER23446
ER23450
ER24077
ER24078
ER24079
ER24080
ER24081
ER24082
ER24088
ER24089
ER24090
ER24091
ER24092
ER24093
ER24099
ER24100
ER24101
ER24102
ER24103
ER24104
ER24109
ER24111
ER24116
ER24118
ER24120
ER24122
ER24124
ER24126
ER24128
ER24130
ER24132
ER24134
ER24135
ER24136
ER24139
ER24143
ER24179
;

proc means;
run;

PROC PRINTTO PRINT=PRINT;
RUN; 

PROC PRINTTO LOG=LOG;
RUN; 
